/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.codegen.lite;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.codegen.gmfgen.GMFGenPackage;
import org.eclipse.gmf.codegen.gmfgen.GenApplication;
import org.eclipse.gmf.codegen.gmfgen.GenChildLabelNode;
import org.eclipse.gmf.codegen.gmfgen.GenChildSideAffixedNode;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.gmf.codegen.gmfgen.GenContainerBase;
import org.eclipse.gmf.codegen.gmfgen.GenCustomPropertyTab;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.gmf.codegen.gmfgen.GenExpressionInterpreter;
import org.eclipse.gmf.codegen.gmfgen.GenExpressionProviderBase;
import org.eclipse.gmf.codegen.gmfgen.GenExpressionProviderContainer;
import org.eclipse.gmf.codegen.gmfgen.GenLanguage;
import org.eclipse.gmf.codegen.gmfgen.GenLink;
import org.eclipse.gmf.codegen.gmfgen.GenLinkLabel;
import org.eclipse.gmf.codegen.gmfgen.GenNavigatorChildReference;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.gmf.codegen.gmfgen.GenNodeLabel;
import org.eclipse.gmf.codegen.gmfgen.GenPreferencePage;
import org.eclipse.gmf.codegen.gmfgen.GenPropertyTab;
import org.eclipse.gmf.codegen.gmfgen.GenStandardPreferencePage;
import org.eclipse.gmf.codegen.gmfgen.OpenDiagramBehaviour;
import org.eclipse.gmf.common.UnexpectedBehaviourException;
import org.eclipse.gmf.common.codegen.ImportAssistant;
import org.eclipse.gmf.internal.codegen.lite.Activator;
import org.eclipse.gmf.internal.codegen.lite.CodegenEmitters;
import org.eclipse.gmf.internal.common.codegen.GeneratorBase;
import org.eclipse.gmf.internal.common.codegen.TextEmitter;
import org.eclipse.gmf.internal.common.codegen.TextMerger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Generator
extends GeneratorBase
implements Runnable {
    private final GenEditorGenerator myEditorGen;
    private final GenDiagram myDiagram;
    private final CodegenEmitters myEmitters;

    public Generator(GenEditorGenerator genModel) {
        this(genModel, Activator.getInstance().getEmitters(genModel));
    }

    public Generator(GenEditorGenerator genModel, CodegenEmitters emitters) {
        assert (genModel != null && emitters != null);
        this.myDiagram = genModel.getDiagram();
        this.myEditorGen = genModel;
        this.myEmitters = emitters;
    }

    protected TextMerger createMergeService() {
        return this.myEmitters.createMergeService();
    }

    protected void customRun() throws InterruptedException, UnexpectedBehaviourException {
        String pluginID = this.myEditorGen.getPlugin().getID();
        Path examplaryLocation = new Path(this.myEditorGen.getDomainGenModel().getModelDirectory());
        this.initializeEditorProject(pluginID, this.guessNewProjectLocation(examplaryLocation, pluginID));
        this.doGenerateFile(this.myEmitters.getManifestGenerator(), (IPath)new Path("META-INF/MANIFEST.MF"), new Object[]{this.myEditorGen.getPlugin()});
        this.doGenerateFile(this.myEmitters.getBuildPropertiesGenerator(), (IPath)new Path("build.properties"), new Object[]{this.myEditorGen.getPlugin()});
        this.doGenerateFile(this.myEmitters.getPluginXML(), (IPath)new Path("plugin.xml"), new Object[]{this.myEditorGen.getPlugin()});
        this.doGenerateFile(this.myEmitters.getPluginPropertiesGenerator(), (IPath)new Path("plugin.properties"), new Object[]{this.myEditorGen.getPlugin()});
        this.internalGenerateJavaClass(this.myEmitters.getCreationWizardGenerator(), this.myDiagram.getCreationWizardQualifiedClassName(), (Object)this.myDiagram);
        this.internalGenerateJavaClass(this.myEmitters.getCreationWizardPageGenerator(), this.myDiagram.getCreationWizardPageQualifiedClassName(), (Object)this.myDiagram);
        this.internalGenerateJavaClass(this.myEmitters.getPluginGenerator(), this.myEditorGen.getPlugin().getActivatorQualifiedClassName(), (Object)this.myEditorGen.getPlugin());
        this.internalGenerateJavaClass(this.myEmitters.getInitDiagramFileActionGenerator(), this.myDiagram.getInitDiagramFileActionQualifiedClassName(), (Object)this.myDiagram);
        this.internalGenerateJavaClass(this.myEmitters.getModelElementSelectionPageEmitter(), this.myEmitters.getModelElementSelectionPageQualifiedNameEmitter(), (Object)this.myDiagram);
        this.internalGenerateJavaClass(this.myEmitters.getNewDiagramFileWizardGenerator(), this.myDiagram.getNewDiagramFileWizardQualifiedClassName(), (Object)this.myDiagram);
        if (this.myEditorGen.getApplication() != null) {
            this.internalGenerateJavaClass(this.myEmitters.getURISelectorPageGenerator(), this.myEmitters.getURISelectorPageQualifiedClassNameGenerator(), (Object)this.myDiagram);
        }
        if (this.myDiagram.generateCreateShortcutAction()) {
            this.internalGenerateJavaClass(this.myEmitters.getCreateShortcutActionEmitter(), this.myDiagram.getCreateShortcutActionQualifiedClassName(), (Object)this.myDiagram);
            if (this.myEditorGen.getApplication() != null) {
                this.internalGenerateJavaClass(this.myEmitters.getShortcutCreationWizardEmitter(), this.myEmitters.getShortcutCreationWizardQualifiedClassNameEmitter(), (Object)this.myDiagram);
            } else {
                this.internalGenerateJavaClass(this.myEmitters.getElementChooserEmitter(), this.myDiagram.getElementChooserQualifiedClassName(), (Object)this.myDiagram);
            }
        }
        if (this.myDiagram.generateShortcutIcon()) {
            this.internalGenerateJavaClass(this.myEmitters.getShortcutProviderEmitter(), this.myEmitters.getShortcutProviderQualifiedClassNameEmitter(), (Object)this.myDiagram);
            this.internalGenerateJavaClass(this.myEmitters.getCreateShortcutNodeCommandEmitter(), this.myEmitters.getCreateShortcutNodeCommandQualifiedClassNameEmitter(), (Object)this.myDiagram);
            this.internalGenerateJavaClass(this.myEmitters.getCreateShortcutEdgeCommandEmitter(), this.myEmitters.getCreateShortcutEdgeCommandQualifiedClassNameEmitter(), (Object)this.myDiagram);
            this.generateShortcutIcon();
            if (this.myEditorGen.getApplication() == null) {
                this.internalGenerateJavaClass(this.myEmitters.getShortcutPropertyTesterEmitter(), this.myDiagram.getShortcutPropertyTesterQualifiedClassName(), (Object)this.myDiagram);
            }
        }
        this.internalGenerateJavaClass(this.myEmitters.getLoadResourceActionGenerator(), this.myDiagram.getLoadResourceActionQualifiedClassName(), (Object)this.myDiagram);
        this.internalGenerateJavaClass(this.myEmitters.getElementTypesGenerator(), this.myDiagram.getElementTypesQualifiedClassName(), (Object)this.myDiagram);
        this.internalGenerateJavaClass(this.myEmitters.getActionBarContributorGenerator(), this.myEditorGen.getEditor().getActionBarContributorQualifiedClassName(), (Object)this.myEditorGen.getEditor());
        this.internalGenerateJavaClass(this.myEmitters.getDiagramEditorUtilGenerator(), this.myDiagram.getDiagramEditorUtilQualifiedClassName(), (Object)this.myDiagram);
        this.internalGenerateJavaClass(this.myEmitters.getEditorGenerator(), this.myEditorGen.getEditor().getQualifiedClassName(), (Object)this.myEditorGen.getEditor());
        if (this.myEditorGen.getEditor().isEclipseEditor()) {
            this.internalGenerateJavaClass(this.myEmitters.getMatchingStrategyEmitter(), this.myDiagram.getMatchingStrategyQualifiedClassName(), (Object)this.myDiagram);
        }
        if (this.myEditorGen.getApplication() == null && !this.myEditorGen.getEditor().isEclipseEditor()) {
            this.internalGenerateJavaClass(this.myEmitters.getOpenDiagramInViewActionGenerator(), this.myEmitters.getOpenDiagramInViewActionQualifiedClassNameGenerator(), (Object)this.myEditorGen.getEditor());
        }
        if (this.myDiagram.getPalette() != null) {
            this.internalGenerateJavaClass(this.myEmitters.getPaletteFactoryGenerator(), this.myDiagram.getPalette().getFactoryQualifiedClassName(), (Object)this.myDiagram.getPalette());
        }
        this.internalGenerateJavaClass(this.myEmitters.getEditPartFactoryGenerator(), this.myDiagram.getEditPartFactoryQualifiedClassName(), (Object)this.myDiagram);
        this.internalGenerateJavaClass(this.myEmitters.getDiagramEditPartGenerator(), this.myDiagram.getEditPartQualifiedClassName(), (Object)this.myDiagram);
        HashSet<OpenDiagramBehaviour> openDiagramBehaviors = new HashSet<OpenDiagramBehaviour>();
        this.generateBehaviors((GenCommonBase)this.myDiagram, openDiagramBehaviors);
        this.generateLayoutEditPolicy((GenContainerBase)this.myDiagram);
        if (this.myDiagram.isValidationEnabled() || this.myEditorGen.hasAudits()) {
            this.generateValidationProvider();
            if (this.myDiagram.getEditorGen().getApplication() == null) {
                this.generateMarkerNavigationProvider();
            }
        }
        if (this.myDiagram.getEditorGen().getMetrics() != null) {
            this.generateMetricProvider();
        }
        for (GenNode next : this.myDiagram.getAllNodes()) {
            if (!(next instanceof GenChildLabelNode)) {
                this.internalGenerateJavaClass(this.myEmitters.getNodeEditPartGenerator(), next.getEditPartQualifiedClassName(), (Object)next);
                this.generateGraphicalEditPolicy(next);
                for (GenNodeLabel label : next.getLabels()) {
                    this.internalGenerateJavaClass(this.myEmitters.getNodeLabelEditPartGenerator(), label.getEditPartQualifiedClassName(), (Object)label);
                    this.internalGenerateJavaClass(this.myEmitters.getViewFactoryGenerator(), label.getNotationViewFactoryQualifiedClassName(), (Object)label);
                }
            } else {
                this.internalGenerateJavaClass(this.myEmitters.getChildNodeEditPartGenerator(), next.getEditPartQualifiedClassName(), (Object)next);
            }
            this.internalGenerateJavaClass(this.myEmitters.getViewFactoryGenerator(), next.getNotationViewFactoryQualifiedClassName(), (Object)next);
            this.generateBehaviors((GenCommonBase)next, openDiagramBehaviors);
            this.generateCommands(next);
            this.generateComponentEditPolicy((GenCommonBase)next);
            boolean shouldGenerateLayoutEditPolicy = false;
            boolean shouldGenerateSideAffixedLayoutEditPolicy = false;
            for (GenNode nextChild : next.getChildNodes()) {
                if (nextChild instanceof GenChildSideAffixedNode) {
                    shouldGenerateSideAffixedLayoutEditPolicy = true;
                    continue;
                }
                shouldGenerateLayoutEditPolicy = true;
            }
            if (shouldGenerateLayoutEditPolicy) {
                this.generateLayoutEditPolicy((GenContainerBase)next);
            }
            if (!shouldGenerateSideAffixedLayoutEditPolicy) continue;
            this.generateSideAffixedLayoutEditPolicy(next);
        }
        for (GenNode next : this.myDiagram.getLinks()) {
            this.internalGenerateJavaClass(this.myEmitters.getLinkEditPartGenerator(), next.getEditPartQualifiedClassName(), (Object)next);
            this.generateGraphicalEditPolicy((GenLink)next);
            if (next.getLabels().size() > 0) {
                this.generateConnectionEndpointEditPolicy((GenLink)next);
            }
            for (GenLinkLabel label : next.getLabels()) {
                this.internalGenerateJavaClass(this.myEmitters.getLinkLabelEditPartGenerator(), label.getEditPartQualifiedClassName(), (Object)label);
                this.internalGenerateJavaClass(this.myEmitters.getViewFactoryGenerator(), label.getNotationViewFactoryQualifiedClassName(), (Object)label);
            }
            this.internalGenerateJavaClass(this.myEmitters.getViewFactoryGenerator(), next.getNotationViewFactoryQualifiedClassName(), (Object)next);
            this.generateBehaviors((GenCommonBase)next, openDiagramBehaviors);
            this.generateCommands((GenLink)next);
            this.generateComponentEditPolicy((GenCommonBase)next);
        }
        for (GenCompartment next : this.myDiagram.getCompartments()) {
            this.internalGenerateJavaClass(this.myEmitters.getCompartmentEditPartGenerator(), next.getEditPartQualifiedClassName(), (Object)next);
            this.internalGenerateJavaClass(this.myEmitters.getViewFactoryGenerator(), next.getNotationViewFactoryQualifiedClassName(), (Object)next);
            this.generateLayoutEditPolicy((GenContainerBase)next);
        }
        this.internalGenerateJavaClass(this.myEmitters.getViewFactoryGenerator(), this.myDiagram.getNotationViewFactoryQualifiedClassName(), (Object)this.myDiagram);
        this.internalGenerateJavaClass(this.myEmitters.getDomainElementInitializerGenerator(), this.myEmitters.getDomainElementInitializerQualifiedNameGenerator(), (Object)this.myDiagram);
        this.internalGenerateJavaClass(this.myEmitters.getVisualIDRegistryGenerator(), this.myDiagram.getVisualIDRegistryQualifiedClassName(), (Object)this.myDiagram);
        if (this.myDiagram.getEditorGen().getExpressionProviders() != null) {
            this.generateExpressionProviders();
        }
        if (Generator.isPathInsideGenerationTarget(this.myDiagram.getCreationWizardIconPathX())) {
            this.generateDiagramIcon(this.myDiagram.getCreationWizardIconPathX());
        }
        if (Generator.isPathInsideGenerationTarget(this.myEditorGen.getEditor().getIconPathX())) {
            this.generateDiagramIcon(this.myEditorGen.getEditor().getIconPathX());
        }
        this.generateWizardBanner();
        if (this.myEditorGen.getApplication() == null && this.myEditorGen.getNavigator() != null) {
            this.generateNavigatorContentProvider();
            this.generateNavigatorLabelProvider();
            this.generateNavigatorLinkHelper();
            this.generateNavigatorSorter();
            this.generateNavigatorActionProvider();
            this.generateAbstractNavigatorItem();
            this.generateNavigatorGroup();
            this.generateNavigatorItem();
            this.generateNavigatorGroupIcons();
            if (this.myEditorGen.getDomainGenModel() != null && this.myEditorGen.getNavigator().isGenerateDomainModelNavigator()) {
                this.generateDomainNavigatorContentProvider();
                this.generateDomainNavigatorLabelProvider();
                this.generateDomainNavigatorItem();
                this.generateDomainModelElementTester();
                this.generateURIEditorInputTester();
            }
        }
        if (this.myEditorGen.getPropertySheet() != null) {
            this.generatePropertySheetSections();
        }
        this.generateApplication();
        this.generatePreferences();
        this.generateExternalizationSupport();
    }

    private static boolean isPathInsideGenerationTarget(String path) {
        assert (path != null);
        Path p = new Path(path);
        return !p.isAbsolute() && !p.segment(0).equals("..");
    }

    private void generateExpressionProviders() throws UnexpectedBehaviourException, InterruptedException {
        GenExpressionProviderContainer providerContainer = this.myEditorGen.getExpressionProviders();
        this.internalGenerateJavaClass(this.myEmitters.getAbstractExpressionEmitter(), providerContainer.getExpressionsPackageName(), providerContainer.getAbstractExpressionClassName(), this.myDiagram);
        for (GenExpressionProviderBase nextProvider : providerContainer.getProviders()) {
            if (!(nextProvider instanceof GenExpressionInterpreter)) continue;
            TextEmitter providerEmitter = null;
            if (GenLanguage.OCL_LITERAL.equals((Object)nextProvider.getLanguage())) {
                providerEmitter = this.myEmitters.getOCLExpressionFactoryEmitter();
            } else if (GenLanguage.REGEXP_LITERAL.equals((Object)nextProvider.getLanguage()) || GenLanguage.NREGEXP_LITERAL.equals((Object)nextProvider.getLanguage())) {
                providerEmitter = this.myEmitters.getRegexpExpressionFactoryEmitter();
            }
            GenExpressionInterpreter interpreter = (GenExpressionInterpreter)nextProvider;
            if (providerEmitter == null) continue;
            this.internalGenerateJavaClass(providerEmitter, providerContainer.getExpressionsPackageName(), interpreter.getClassName(), interpreter);
        }
    }

    private void generateShortcutIcon() throws UnexpectedBehaviourException, InterruptedException {
        this.doGenerateBinaryFile(this.myEmitters.getShortcutImageEmitter(), new Path("icons/shortcut.gif"), null);
    }

    private void generateDiagramIcon(String path) throws UnexpectedBehaviourException, InterruptedException {
        Object[] args = new Object[]{this.myDiagram.getDomainDiagramElement() == null ? this.myEditorGen.getDiagramFileExtension() : this.myDiagram.getDomainDiagramElement().getGenPackage().getPrefix()};
        this.doGenerateBinaryFile(this.myEmitters.getDiagramIconEmitter(), new Path(path), args);
    }

    private void generateWizardBanner() throws UnexpectedBehaviourException, InterruptedException {
        try {
            Object[] args = new Object[]{this.myEmitters.getWizardBannerStemEmitter().generate((IProgressMonitor)new NullProgressMonitor(), new Object[]{this.myDiagram})};
            String path = this.myEmitters.getWizardBannerLocationEmitter().generate((IProgressMonitor)new NullProgressMonitor(), new Object[]{this.myDiagram});
            this.doGenerateBinaryFile(this.myEmitters.getWizardBannerImageEmitter(), new Path(path), args);
        }
        catch (InvocationTargetException e) {
            this.handleException(e);
        }
    }

    private void generateBehaviors(GenCommonBase element, HashSet<OpenDiagramBehaviour> generatedBehaviors) throws UnexpectedBehaviourException, InterruptedException {
        for (OpenDiagramBehaviour behaviour : element.getBehaviour(OpenDiagramBehaviour.class)) {
            if (generatedBehaviors.contains(behaviour)) continue;
            generatedBehaviors.add(behaviour);
            this.generateOpenDiagramEditPolicy(behaviour);
        }
    }

    private void generateValidationProvider() throws UnexpectedBehaviourException, InterruptedException {
        this.internalGenerateJavaClass(this.myEmitters.getValidationProviderGenerator(), this.myDiagram.getProvidersPackageName(), this.myDiagram.getValidationProviderClassName(), this.myDiagram);
        this.internalGenerateJavaClass(this.myEmitters.getValidateActionGenerator(), this.myEmitters.getValidateActionQualifiedNameGenerator(), (Object)this.myDiagram);
    }

    private void generateMarkerNavigationProvider() throws UnexpectedBehaviourException, InterruptedException {
        this.internalGenerateJavaClass(this.myEmitters.getMarkerNavigationProviderEmitter(), this.myDiagram.getProvidersPackageName(), this.myDiagram.getMarkerNavigationProviderClassName(), this.myDiagram);
    }

    private void generateMetricProvider() throws UnexpectedBehaviourException, InterruptedException {
        this.internalGenerateJavaClass(this.myEmitters.getMetricProviderEmitter(), this.myDiagram.getProvidersPackageName(), this.myDiagram.getMetricProviderClassName(), this.myDiagram);
        this.internalGenerateJavaClass(this.myEmitters.getMetricsActionEmitter(), this.myEmitters.getMetricsActionQualifiedNameEmitter(), (Object)this.myDiagram);
    }

    private void generateOpenDiagramEditPolicy(OpenDiagramBehaviour behaviour) throws UnexpectedBehaviourException, InterruptedException {
        this.internalGenerateJavaClass(this.myEmitters.getOpenDiagramEditPolicyEmitter(), behaviour.getEditPolicyQualifiedClassName(), (Object)behaviour);
    }

    private void generateCommands(GenNode genNode) throws UnexpectedBehaviourException, InterruptedException {
        if (!genNode.getDomainMetaClass().isAbstract()) {
            this.internalGenerateJavaClass(this.myEmitters.getCreateNodeCommandEmitter(), this.myEmitters.getCreateNodeCommandQualifiedClassNameEmitter(), (Object)genNode);
        }
        this.internalGenerateJavaClass(this.myEmitters.getAddNodeCommandEmitter(), this.myEmitters.getAddNodeCommandQualifiedClassNameEmitter(), (Object)genNode);
        this.internalGenerateJavaClass(this.myEmitters.getCloneNodeCommandEmitter(), this.myEmitters.getCloneNodeCommandQualifiedClassNameEmitter(), (Object)genNode);
    }

    private void generateCommands(GenLink genLink) throws UnexpectedBehaviourException, InterruptedException {
        if (!genLink.isViewDirectionAlignedWithModel()) {
            return;
        }
        this.internalGenerateJavaClass(this.myEmitters.getCreateLinkStartCommandEmitter(), this.myEmitters.getCreateLinkStartCommandQualifiedClassNameEmitter(), (Object)genLink);
        this.internalGenerateJavaClass(this.myEmitters.getCreateLinkCompleteCommandEmitter(), this.myEmitters.getCreateLinkCompleteCommandQualifiedClassNameEmitter(), (Object)genLink);
        this.internalGenerateJavaClass(this.myEmitters.getReconnectLinkSourceCommandEmitter(), this.myEmitters.getReconnectLinkSourceCommandQualifiedClassNameEmitter(), (Object)genLink);
        this.internalGenerateJavaClass(this.myEmitters.getReconnectLinkTargetCommandEmitter(), this.myEmitters.getReconnectLinkTargetCommandQualifiedClassNameEmitter(), (Object)genLink);
    }

    private void generateLayoutEditPolicy(GenContainerBase containerBase) throws InterruptedException, UnexpectedBehaviourException {
        this.internalGenerateJavaClass(this.myEmitters.getLayoutEditPolicyEmitter(), this.myEmitters.getLayoutEditPolicyQualifiedClassNameEmitter(), (Object)containerBase);
    }

    private void generateSideAffixedLayoutEditPolicy(GenNode node) throws InterruptedException, UnexpectedBehaviourException {
        this.internalGenerateJavaClass(this.myEmitters.getSideAffixedLayoutEditPolicyEmitter(), this.myEmitters.getSideAffixedLayoutEditPolicyQualifiedClassNameEmitter(), (Object)node);
    }

    private void generateGraphicalEditPolicy(GenNode genNode) throws InterruptedException, UnexpectedBehaviourException {
        this.internalGenerateJavaClass(this.myEmitters.getGraphicalEditPolicyEmitter(), genNode.getGraphicalNodeEditPolicyQualifiedClassName(), (Object)genNode);
    }

    private void generateGraphicalEditPolicy(GenLink genLink) throws InterruptedException, UnexpectedBehaviourException {
        this.internalGenerateJavaClass(this.myEmitters.getGraphicalEditPolicyEmitter(), this.myEmitters.getGraphicalEditPolicyQualifiedClassNameEmitter(), (Object)genLink);
    }

    private void generateComponentEditPolicy(GenCommonBase genElement) throws InterruptedException, UnexpectedBehaviourException {
        this.internalGenerateJavaClass(this.myEmitters.getComponentEditPolicyEmitter(), this.myEmitters.getComponentEditPolicyQualifiedClassNameEmitter(), (Object)genElement);
    }

    private void generateConnectionEndpointEditPolicy(GenLink genLink) throws InterruptedException, UnexpectedBehaviourException {
        this.internalGenerateJavaClass(this.myEmitters.getConnectionEndpointEditPolicyEmitter(), this.myEmitters.getConnectionEndpointEditPolicyQualifiedClassNameEmitter(), (Object)genLink);
    }

    private void generateNavigatorContentProvider() throws InterruptedException {
        this.internalGenerateJavaClass(this.myEmitters.getNavigatorContentProviderEmitter(), this.myEditorGen.getNavigator().getPackageName(), this.myEditorGen.getNavigator().getContentProviderClassName(), this.myEditorGen.getNavigator());
    }

    private void generateDomainNavigatorContentProvider() throws InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getDomainNavigatorContentProviderEmitter(), this.myEditorGen.getNavigator().getDomainContentProviderQualifiedClassName(), new Object[]{this.myEditorGen.getNavigator()});
    }

    private void generateDomainNavigatorLabelProvider() throws InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getDomainNavigatorLabelProviderEmitter(), this.myEditorGen.getNavigator().getDomainLabelProviderQualifiedClassName(), new Object[]{this.myEditorGen.getNavigator()});
    }

    private void generateDomainNavigatorItem() throws InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getDomainNavigatorItemEmitter(), this.myEditorGen.getNavigator().getDomainNavigatorItemQualifiedClassName(), new Object[]{this.myEditorGen.getNavigator()});
    }

    private void generateDomainModelElementTester() throws InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getDomainModelElementTesterEmitter(), this.myEditorGen.getNavigator().getDomainModelElementTesterQualifiedClassName(), new Object[]{this.myEditorGen.getNavigator()});
    }

    private void generateURIEditorInputTester() throws InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getURIEditorInputTesterEmitter(), this.myEditorGen.getNavigator().getUriInputTesterQualifiedClassName(), new Object[]{this.myEditorGen.getNavigator()});
    }

    private void generateNavigatorLabelProvider() throws InterruptedException, UnexpectedBehaviourException {
        this.internalGenerateJavaClass(this.myEmitters.getNavigatorLabelProviderEmitter(), this.myEditorGen.getNavigator().getPackageName(), this.myEditorGen.getNavigator().getLabelProviderClassName(), this.myEditorGen.getNavigator());
    }

    private void generateNavigatorLinkHelper() throws InterruptedException {
        if (!this.myEditorGen.getEditor().isEclipseEditor()) {
            return;
        }
        this.internalGenerateJavaClass(this.myEmitters.getNavigatorLinkHelperEmitter(), this.myEditorGen.getNavigator().getPackageName(), this.myEditorGen.getNavigator().getLinkHelperClassName(), this.myEditorGen.getNavigator());
    }

    private void generateNavigatorSorter() throws InterruptedException, UnexpectedBehaviourException {
        this.internalGenerateJavaClass(this.myEmitters.getNavigatorSorterEmitter(), this.myEditorGen.getNavigator().getPackageName(), this.myEditorGen.getNavigator().getSorterClassName(), this.myEditorGen.getNavigator());
    }

    private void generateNavigatorActionProvider() throws InterruptedException, UnexpectedBehaviourException {
        this.internalGenerateJavaClass(this.myEmitters.getNavigatorActionProviderEmitter(), this.myEditorGen.getNavigator().getPackageName(), this.myEditorGen.getNavigator().getActionProviderClassName(), this.myEditorGen.getNavigator());
    }

    private void generateAbstractNavigatorItem() throws InterruptedException, UnexpectedBehaviourException {
        this.doGenerateJavaClass(this.myEmitters.getAbstractNavigatorItemEmitter(), this.myEditorGen.getNavigator().getPackageName(), this.myEditorGen.getNavigator().getAbstractNavigatorItemClassName(), new Object[]{this.myEditorGen.getNavigator()});
    }

    private void generateNavigatorGroup() throws InterruptedException {
        this.internalGenerateJavaClass(this.myEmitters.getNavigatorGroupEmitter(), this.myEditorGen.getNavigator().getPackageName(), this.myEditorGen.getNavigator().getNavigatorGroupClassName(), this.myEditorGen.getNavigator());
    }

    private void generateNavigatorItem() throws InterruptedException {
        this.internalGenerateJavaClass(this.myEmitters.getNavigatorItemEmitter(), this.myEditorGen.getNavigator().getPackageName(), this.myEditorGen.getNavigator().getNavigatorItemClassName(), this.myEditorGen.getNavigator());
    }

    private void generateNavigatorGroupIcons() throws InterruptedException, UnexpectedBehaviourException {
        HashSet<String> groupIcons = new HashSet<String>();
        for (GenNavigatorChildReference nextReference : this.myEditorGen.getNavigator().getChildReferences()) {
            if (nextReference.getGroupIcon() == null || nextReference.getGroupIcon().length() <= 0) continue;
            groupIcons.add(nextReference.getGroupIcon());
        }
        for (String iconPath : groupIcons) {
            this.generateGroupIcon(new Path(iconPath));
        }
    }

    private void generateGroupIcon(Path groupIconPath) throws InterruptedException, UnexpectedBehaviourException {
        this.doGenerateBinaryFile(this.myEmitters.getGroupIconEmitter(), groupIconPath, null);
    }

    protected void generatePropertySheetSections() throws UnexpectedBehaviourException, InterruptedException {
        if (this.myEditorGen.getPropertySheet().isNeedsCaption()) {
            this.doGenerateJavaClass(this.myEmitters.getPropertySheetLabelProviderEmitter(), this.myEditorGen.getPropertySheet().getLabelProviderQualifiedClassName(), new Object[]{this.myEditorGen.getPropertySheet()});
        }
        for (GenPropertyTab tab : this.myEditorGen.getPropertySheet().getTabs()) {
            if (!(tab instanceof GenCustomPropertyTab)) continue;
            this.doGenerateJavaClass(this.myEmitters.getPropertySectionEmitter(), ((GenCustomPropertyTab)tab).getQualifiedClassName(), new Object[]{tab});
        }
    }

    private void generateApplication() throws UnexpectedBehaviourException, InterruptedException {
        GenApplication application = this.myEditorGen.getApplication();
        if (application != null) {
            this.doGenerateJavaClass(this.myEmitters.getApplicationEmitter(), application.getQualifiedClassName(), new Object[]{application});
            this.doGenerateJavaClass(this.myEmitters.getActionBarAdvisorEmitter(), application.getActionBarAdvisorQualifiedClassName(), new Object[]{application});
            this.doGenerateJavaClass(this.myEmitters.getPerspectiveEmitter(), application.getPerspectiveQualifiedClassName(), new Object[]{application});
            this.doGenerateJavaClass(this.myEmitters.getWorkbenchAdvisorEmitter(), application.getWorkbenchAdvisorQualifiedClassName(), new Object[]{application});
            this.doGenerateJavaClass(this.myEmitters.getWorkbenchWindowAdvisorEmitter(), application.getWorkbenchWindowAdvisorQualifiedClassName(), new Object[]{application});
        }
    }

    private void generatePreferences() throws UnexpectedBehaviourException, InterruptedException {
        this.generatePreferences((EList<GenPreferencePage>)this.myDiagram.getPreferencePages());
    }

    private void generatePreferences(EList<GenPreferencePage> pages) throws UnexpectedBehaviourException, InterruptedException {
        for (GenPreferencePage preferencePage : pages) {
            if (preferencePage instanceof GenStandardPreferencePage) {
                this.generatePreferencePage((GenStandardPreferencePage)preferencePage);
            }
            this.generatePreferences((EList<GenPreferencePage>)preferencePage.getChildren());
        }
    }

    private void generatePreferencePage(GenStandardPreferencePage preferencePage) throws UnexpectedBehaviourException, InterruptedException {
        switch (preferencePage.getKind()) {
            case APPEARANCE_LITERAL: {
                this.internalGenerateJavaClass(this.myEmitters.getAppearancePreferencePageEmitter(), this.myEmitters.getAppearancePreferencePageQualifiedClassNameEmitter(), (Object)this.myDiagram);
                break;
            }
            case GENERAL_LITERAL: {
                this.internalGenerateJavaClass(this.myEmitters.getGeneralPreferencePageEmitter(), this.myEmitters.getGeneralPreferencePageQualifiedClassNameEmitter(), (Object)this.myDiagram);
            }
        }
    }

    private void generateExternalizationSupport() throws UnexpectedBehaviourException, InterruptedException {
        String packageName = this.myEditorGen.getEditor().getPackageName();
        String messagesClassName = "Messages";
        this.doGenerateJavaClass(this.myEmitters.getExternalizeEmitter(), packageName, messagesClassName, new Object[]{this.myEditorGen});
        this.doGenerateFile(this.myEmitters.getMessagesEmitter(), (IPath)new Path(String.valueOf(messagesClassName.toLowerCase()) + ".properties"), new Object[]{this.myEditorGen});
    }

    private void internalGenerateJavaClass(TextEmitter emitter, String qualifiedClassName, Object argument) throws InterruptedException {
        this.internalGenerateJavaClass(emitter, CodeGenUtil.getPackageName((String)qualifiedClassName), CodeGenUtil.getSimpleClassName((String)qualifiedClassName), argument);
    }

    private void internalGenerateJavaClass(TextEmitter emitter, TextEmitter qualifiedClassNameEmitter, Object argument) throws InterruptedException {
        String qualifiedClassName = null;
        try {
            qualifiedClassName = qualifiedClassNameEmitter.generate((IProgressMonitor)new NullProgressMonitor(), new Object[]{argument});
        }
        catch (InvocationTargetException e) {
            this.handleException(e);
        }
        catch (UnexpectedBehaviourException e) {
            this.handleException(e);
        }
        this.internalGenerateJavaClass(emitter, qualifiedClassName, argument);
    }

    private void internalGenerateJavaClass(TextEmitter emitter, String packageName, String className, Object argument) throws InterruptedException {
        ImportAssistant importUtil = this.createImportAssistant(packageName, className);
        this.doGenerateJavaClass(emitter, packageName, className, new Object[]{argument, importUtil});
    }

    protected void setupProgressMonitor() {
        GeneratorBase.Counter c = new GeneratorBase.Counter();
        c.registerFactor(GMFGenPackage.eINSTANCE.getGenNode(), 2);
        c.registerFactor(GMFGenPackage.eINSTANCE.getGenCompartment(), 2);
        c.registerFactor(GMFGenPackage.eINSTANCE.getGenLink(), 2);
        c.registerFactor(GMFGenPackage.eINSTANCE.getGenNodeLabel(), 2);
        c.registerFactor(GMFGenPackage.eINSTANCE.getGenLinkLabel(), 2);
        int total = c.getTotal((EObject)this.myDiagram);
        ++total;
        total += 4;
        this.setupProgressMonitor(null, total += 15);
    }
}

