/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.ecore.internal.replace.provisional;

import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.search.core.engine.IModelSearchQuery;
import org.eclipse.emf.search.core.internal.replace.provisional.AbstractModelSearchTransformation;
import org.eclipse.emf.search.ecore.engine.EcoreModelSearchQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcoreRegexReplaceTransformation
extends AbstractModelSearchTransformation<EObject, IModelSearchQuery, String, String> {
    public EcoreRegexReplaceTransformation(ENamedElement element, IModelSearchQuery query, String valuation) {
        super((Object)element, (Object)query, (Object)valuation);
    }

    public boolean isValid() {
        return this.getModifiedElement() instanceof ENamedElement;
    }

    public IStatus perform() {
        try {
            if (this.getQuery() instanceof EcoreModelSearchQuery) {
                EcoreModelSearchQuery query = (EcoreModelSearchQuery)((Object)this.getQuery());
                String input = ((ENamedElement)this.getModifiedElement()).getName();
                String expr = ((IModelSearchQuery)this.getQuery()).getQueryExpression();
                switch (query.getKind()) {
                    case REGULAR_EXPRESSION: {
                        Pattern pattern = Pattern.compile(expr);
                        String newValue = pattern.matcher(input).replaceFirst((String)this.getValuation());
                        ((ENamedElement)this.getModifiedElement()).setName(newValue);
                        break;
                    }
                    case CASE_SENSITIVE: 
                    case NORMAL_TEXT: {
                        ((ENamedElement)this.getModifiedElement()).setName((String)this.getValuation());
                    }
                    default: {
                        break;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    public String getResult() {
        return ((ENamedElement)this.getModifiedElement()).getName();
    }
}

