/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mint.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.mint.CodeGenStatus;
import org.eclipse.emf.mint.IMemberAnnotationListener;
import org.eclipse.emf.mint.IMemberAnnotationManager;
import org.eclipse.emf.mint.MemberAnnotationChangedEvent;
import org.eclipse.emf.mint.MintCore;
import org.eclipse.emf.mint.internal.Debug;
import org.eclipse.emf.mint.internal.Messages;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemberAnnotationManager
implements IMemberAnnotationManager,
IElementChangedListener {
    private static final Debug debug = new Debug("MemberAnnotationManager");
    private static final Debug debugCleaner = new Debug("MemberAnnotationManager/CacheCleaner");
    private static final Pattern GENERATED = Pattern.compile("@generated([\\s]+(?i)NOT)?");
    private final ListenerList listeners = new ListenerList();
    private final Map<IMember, CodeGenStatus> statusCache = new HashMap<IMember, CodeGenStatus>();
    private final CacheCleaner cacheCleaner = new CacheCleaner();

    public MemberAnnotationManager() {
        JavaCore.addElementChangedListener((IElementChangedListener)this);
    }

    @Override
    public void addMemberAnnotationListener(IMemberAnnotationListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeMemberAnnotationListener(IMemberAnnotationListener listener) {
        this.listeners.remove((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CodeGenStatus getCodeGenStatus(IMember member) {
        Map<IMember, CodeGenStatus> map = this.statusCache;
        synchronized (map) {
            CodeGenStatus status = this.statusCache.get(member);
            if (status == null) {
                status = this.getCodeGenStatusChecked(member);
                this.cacheStatus(member, status);
            }
            return status;
        }
    }

    private CodeGenStatus getCodeGenStatusChecked(IMember member) {
        CodeGenStatus value = CodeGenStatus.NONE;
        try {
            value = this.computeCodeGenStatus(member);
        }
        catch (JavaModelException e) {
            MintCore.getInstance().logError(Messages.MemberAnnotationManager_ErrorCodegenStatus, e);
        }
        catch (IOException e) {
            MintCore.getInstance().logError(Messages.MemberAnnotationManager_ErrorCodegenStatus, e);
        }
        return value;
    }

    public void elementChanged(ElementChangedEvent event) {
        int flags;
        IJavaElementDelta delta = event.getDelta();
        this.uncacheRemovedElements(delta);
        if (event.getType() == 1) {
            return;
        }
        if ((delta.getKind() & 4) == 0) {
            return;
        }
        IJavaElement element = delta.getElement();
        if (element instanceof ICompilationUnit && ((flags = delta.getFlags()) & 0x80000) != 0) {
            ArrayList<IMember> members = new ArrayList<IMember>();
            this.collectMembers(element, members);
            HashMap<IMember, CodeGenStatus> changes = new HashMap<IMember, CodeGenStatus>();
            this.computeChanges(members, changes);
            if (!changes.isEmpty()) {
                this.fireMemberAnnotationChangedEvent(new MemberAnnotationChangedEvent(this, changes));
                if (MemberAnnotationManager.debug.enabled) {
                    debug.trace("changes: %s", changes);
                }
            }
        }
    }

    private void uncacheRemovedElements(IJavaElementDelta delta) {
        switch (delta.getKind()) {
            case 4: {
                if ((delta.getFlags() & 0x400) != 0) {
                    this.cacheCleaner.schedule();
                    break;
                }
                IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
                int n = iJavaElementDeltaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElementDelta childDelta = iJavaElementDeltaArray[n2];
                    this.uncacheRemovedElements(childDelta);
                    ++n2;
                }
                break;
            }
            case 2: {
                this.cacheCleaner.schedule();
            }
        }
    }

    private void collectMembers(IJavaElement element, Collection<IMember> collector) {
        IJavaElement[] children;
        if (element instanceof IMember) {
            collector.add((IMember)element);
        }
        if (!(element instanceof IParent)) {
            return;
        }
        try {
            children = ((IParent)element).getChildren();
        }
        catch (JavaModelException e) {
            MintCore.getInstance().logError(Messages.MemberAnnotationManager_ErrorJavaModel, e);
            return;
        }
        IJavaElement[] iJavaElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement child = iJavaElementArray[n2];
            if (!(child instanceof IInitializer)) {
                this.collectMembers(child, collector);
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeChanges(Collection<IMember> members, Map<IMember, CodeGenStatus> changes) {
        Map<IMember, CodeGenStatus> map = this.statusCache;
        synchronized (map) {
            for (IMember member : members) {
                CodeGenStatus status;
                CodeGenStatus oldStatus = this.statusCache.get(member);
                if (oldStatus == null || (status = this.getCodeGenStatusChecked(member)) == oldStatus) continue;
                changes.put(member, status);
                this.cacheStatus(member, status);
            }
        }
    }

    private void fireMemberAnnotationChangedEvent(final MemberAnnotationChangedEvent event) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            final IMemberAnnotationListener listener = (IMemberAnnotationListener)obj;
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    listener.memberAnnotationChanged(event);
                }

                public void handleException(Throwable e) {
                    MintCore.getInstance().logError(Messages.MemberAnnotationManager_ErrorNotifyListener, e);
                }
            });
            ++n2;
        }
    }

    private CodeGenStatus computeCodeGenStatus(IMember member) throws JavaModelException, IOException {
        CodeGenStatus result = CodeGenStatus.NONE;
        if (!member.exists()) {
            return result;
        }
        String javadoc = this.getJavadoc(member);
        if (javadoc == null) {
            return result;
        }
        Matcher m = GENERATED.matcher(javadoc);
        if (m.find()) {
            result = m.group(1) == null ? CodeGenStatus.GENERATED : CodeGenStatus.GENERATED_NOT;
        }
        return result;
    }

    private String getJavadoc(IMember member) throws JavaModelException {
        IOpenable openable = member.getOpenable();
        if (openable == null) {
            return null;
        }
        IBuffer buf = openable.getBuffer();
        if (buf == null) {
            return null;
        }
        ISourceRange range = member.getJavadocRange();
        if (range != null) {
            return buf.getText(range.getOffset(), range.getLength());
        }
        return null;
    }

    private void cacheStatus(IMember member, CodeGenStatus status) {
        if (!member.isReadOnly()) {
            this.statusCache.put(member, status);
            if (MemberAnnotationManager.debug.enabled) {
                debug.trace("cached %s (%s)", new Object[]{member, status});
            }
        }
    }

    public void dispose() {
        this.cacheCleaner.cancel();
        JavaCore.removeElementChangedListener((IElementChangedListener)this);
        this.listeners.clear();
    }

    private class CacheCleaner
    extends Job {
        public CacheCleaner() {
            super(Messages.MemberAnnotationManager_JobCacheCleaner);
            this.setSystem(true);
            this.setPriority(50);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            Map map = MemberAnnotationManager.this.statusCache;
            synchronized (map) {
                Iterator i = MemberAnnotationManager.this.statusCache.keySet().iterator();
                while (i.hasNext()) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    IMember member = (IMember)i.next();
                    if (member.exists()) continue;
                    i.remove();
                    if (!debugCleaner.enabled) continue;
                    debugCleaner.trace("removed %s", member);
                }
            }
            return Status.OK_STATUS;
        }
    }
}

