/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.editor;

import agg.attribute.AttrType;
import agg.attribute.AttrVariableTuple;
import agg.attribute.facade.impl.DefaultEditorFacade;
import agg.attribute.gui.AttrTopEditor;
import agg.attribute.gui.AttrTupleEditor;
import agg.attribute.gui.impl.BasicTupleEditor;
import agg.attribute.gui.impl.TopEditor;
import agg.attribute.gui.impl.TupleTableModel;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.CondMember;
import agg.attribute.view.impl.MaskedViewSetting;
import agg.attribute.view.impl.OpenViewSetting;
import agg.cons.AtomApplCond;
import agg.cons.AtomConstraint;
import agg.editor.impl.EdArc;
import agg.editor.impl.EdAtomApplCond;
import agg.editor.impl.EdAtomic;
import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdGraphObject;
import agg.editor.impl.EdNAC;
import agg.editor.impl.EdNestedApplCond;
import agg.editor.impl.EdNode;
import agg.editor.impl.EdPAC;
import agg.editor.impl.EdRule;
import agg.editor.impl.EdRuleScheme;
import agg.editor.impl.EdType;
import agg.editor.impl.EditUndoManager;
import agg.gui.AGGAppl;
import agg.gui.AGGToolBar;
import agg.gui.animation.NodeAnimation;
import agg.gui.cons.TwoMorphs;
import agg.gui.editor.DialogWithCheckBoxAndTwoButtons;
import agg.gui.editor.EditorConstants;
import agg.gui.editor.GraGraEditorActionAdapter;
import agg.gui.editor.GraGraEditorKeyAdapter;
import agg.gui.editor.GraGraEditorMouseAdapter;
import agg.gui.editor.GraphEditor;
import agg.gui.editor.GraphPanel;
import agg.gui.editor.RuleEditor;
import agg.gui.event.EditEvent;
import agg.gui.event.EditEventListener;
import agg.gui.event.TransformEvent;
import agg.gui.event.TransformEventListener;
import agg.gui.event.TreeViewEvent;
import agg.gui.event.TreeViewEventListener;
import agg.gui.event.TypeEvent;
import agg.gui.event.TypeEventListener;
import agg.gui.icons.CompletionIcon;
import agg.gui.icons.DeselectAllIcon;
import agg.gui.icons.IdenticNestedACIcon;
import agg.gui.icons.MatchIcon;
import agg.gui.icons.SelectAllIcon;
import agg.gui.icons.SelectArcTypeIcon;
import agg.gui.icons.SelectNodeTypeIcon;
import agg.gui.icons.StartIcon;
import agg.gui.icons.StepBackIcon;
import agg.gui.icons.StepIcon;
import agg.gui.icons.StopIcon;
import agg.gui.icons.TextIcon;
import agg.gui.options.GraTraMatchOptionGUI;
import agg.gui.options.GraTraOptionGUI;
import agg.gui.options.GraphLayouterOptionGUI;
import agg.gui.popupmenu.EditPopupMenu;
import agg.gui.popupmenu.EditSelPopupMenu;
import agg.gui.popupmenu.GraGraPopupMenu;
import agg.gui.popupmenu.ModePopupMenu;
import agg.gui.saveload.GraphicsExportJPEG;
import agg.gui.trafo.GraGraTransform;
import agg.gui.trafo.TransformInterpret;
import agg.gui.trafo.TransformLayered;
import agg.gui.trafo.TransformRuleSequences;
import agg.gui.treeview.GraGraTreeView;
import agg.gui.treeview.nodedata.GraGraTreeNodeData;
import agg.gui.typeeditor.ArcTypePropertyEditor;
import agg.gui.typeeditor.NodeTypePropertyEditor;
import agg.gui.typeeditor.TypeEditor;
import agg.layout.GraphLayouts;
import agg.layout.ZestGraphLayout;
import agg.layout.evolutionary.EvolutionaryGraphLayout;
import agg.layout.evolutionary.LayoutMetrics;
import agg.util.Pair;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Match;
import agg.xt_basis.MorphCompletionStrategy;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import agg.xt_basis.Type;
import agg.xt_basis.agt.AmalgamatedRule;
import agg.xt_basis.agt.KernelRule;
import agg.xt_basis.agt.MultiRule;
import agg.xt_basis.agt.RuleScheme;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class GraGraEditor
extends JPanel
implements TreeModelListener,
TableModelListener,
TreeViewEventListener,
TransformEventListener,
TypeEventListener {
    protected GraphLayouts graphLayouts;
    protected final EvolutionaryGraphLayout evolutionaryLayouter = new EvolutionaryGraphLayout(100, null);
    private final GraphLayouterOptionGUI evolutionaryLayouterOptionGUI = new GraphLayouterOptionGUI(this.evolutionaryLayouter);
    private final Hashtable<Object, Integer> dividerLocationSet = new Hashtable();
    private final TwoMorphs pacMorphs = new TwoMorphs();
    private final ModePopupMenu modePopupMenu = new ModePopupMenu();
    private final EditPopupMenu editPopupMenu = new EditPopupMenu();
    private final EditSelPopupMenu editSelPopupMenu = new EditSelPopupMenu();
    private final Vector<JMenu> mainMenus = new Vector();
    private final JMenu edit = new JMenu("Edit", true);
    private final JMenu mode = new JMenu("Mode", true);
    private final JMenu transform = new JMenu("Transform", true);
    private final Vector<JButton> editModeButtons = new Vector(6);
    private final Vector<JButton> transformButtons = new Vector(6);
    private final Vector<EditEventListener> editEventListeners = new Vector();
    private final AGGToolBar toolBar = new AGGToolBar(0);
    protected final GraGraEditorActionAdapter actionAdapter;
    protected final GraGraEditorMouseAdapter mouseAdapter;
    private final GraGraEditorKeyAdapter keyAdapter;
    private boolean scaleGraphOnly = true;
    private final JButton buttonIdenticNAC;
    private final JButton buttonIdenticPAC;
    private final JButton buttonIdenticNestedAC;
    private final JButton buttonMatch;
    private final JButton buttonCompletion;
    private final JButton buttonStep;
    private final JButton buttonStart;
    private final JButton buttonStop;
    private final JButton buttonUndoStep;
    private final JButton buttonT;
    protected final JButton buttonUndo;
    protected final JButton buttonRedo;
    protected final JButton buttonLayout;
    protected final JButton buttonLayoutMenu;
    protected final Dimension freeSpace = new Dimension(20, 20);
    private int indxIdenticNestedAC;
    private final Color bgc = new Color(238, 238, 238);
    int trafoEventKey;
    private EdGraGra gra;
    private EdGraph graph;
    private EdRule rule;
    private EdNAC nac;
    private EdPAC pac;
    private EdNestedApplCond ac;
    private EdAtomic atomicConstr;
    private EdAtomApplCond postApplCond;
    private boolean resetGraGra;
    private boolean wasPostAtomApplCond;
    protected final JFrame applFrame;
    protected final JSplitPane splitPane0;
    protected final JSplitPane splitPane;
    protected final JSplitPane splitPane1;
    protected int editmode = -1;
    private int lasteditmode = 11;
    protected final TypeEditor typeEditor;
    protected boolean typesAlwaysOn;
    protected final RuleEditor ruleEditor;
    protected final GraphEditor graphEditor;
    protected AttrTopEditor attrEditor;
    private AttrTupleEditor inputParameterEditor;
    private boolean attrEditorExists;
    protected EdGraphObject graphObjectOfAttrInstance;
    protected boolean attrTypeChanged;
    protected boolean attrChanged;
    protected boolean attrTypeCreated;
    private int attrMemberCount;
    protected int dividerLocation;
    protected int dividerLocation1;
    protected int dividerLocation2;
    protected GraphPanel activePanel;
    private boolean isPostAtomApplCond;
    private boolean iconable;
    private GraGraTreeNodeData treeNodeData;
    protected EdGraGra gragra;
    private EdGraph graphToCopy;
    private boolean nacExists;
    private boolean pacExists;
    private boolean acExists;
    private final GraGraTransform gragraTransform;
    private TransformInterpret interpreter;
    private boolean interpreting;
    protected TransformLayered layeredTransform;
    private boolean layering;
    private boolean continueLayeredTransformLoop;
    protected int layeredRuns;
    protected boolean noMoreStopBeforeResetGraph;
    private TransformRuleSequences transformRuleSequences;
    private boolean sequences;
    private boolean errMsg;
    private Thread tmpTransformThread;
    private boolean animationThread;
    private boolean nodeToAnimateOnfront;
    private boolean sleep;
    private GraphicsExportJPEG exportJPEG;
    private String jpgPath;
    private Vector<String> metricvalues;
    private boolean staticNodePositionForGraphLayouter;
    private int stepCounter;
    protected final NodeAnimation nodeAnimation;
    protected EditUndoManager undoManager;
    protected String graphLayoutAlgorithmName;

    public GraGraEditor(JFrame aggappl) {
        super(new BorderLayout());
        this.applFrame = aggappl;
        this.keyAdapter = new GraGraEditorKeyAdapter(this);
        this.mouseAdapter = new GraGraEditorMouseAdapter(this);
        this.actionAdapter = new GraGraEditorActionAdapter(this);
        this.createMainMenus();
        this.buttonIdenticNAC = this.toolBar.createTool("textable", "IN", "Identic NAC (Negative Application Condition)", "identicNAC", this.actionAdapter, false);
        this.buttonIdenticPAC = this.toolBar.createTool("textable", "IP", "Identic PAC (Positive Application Condition)", "identicPAC", this.actionAdapter, false);
        this.buttonIdenticNestedAC = this.toolBar.createButton(new IdenticNestedACIcon("IGAC", false), "Identic GAC (General Application Condition)", "identicAC", this.actionAdapter, false);
        this.buttonMatch = this.toolBar.createTool("iconable", "MatchIcon", "Interactive match mode", "match", this.actionAdapter, false);
        this.buttonCompletion = this.toolBar.createTool("iconable", "CompletionIcon", "Next Completion", "completion", this.actionAdapter, false);
        this.buttonStep = this.toolBar.createTool("iconable", "StepIcon", "Transformation Step", "step", this.actionAdapter, false);
        this.buttonStart = this.toolBar.createTool("iconable", "StartIcon", "Start Transformation", "start", this.actionAdapter, false);
        this.buttonStop = this.toolBar.createTool("iconable", "StopIcon", "Stop Transformation", "stop", this.actionAdapter, false);
        this.buttonUndoStep = this.toolBar.createTool("iconable", "StepBackIcon", "Undo Step", "undoStep", this.actionAdapter, false);
        this.buttonT = this.toolBar.createTool("textable", "NT", "Transformation by applying rules non-deterministically (default)", "", this.actionAdapter, false);
        this.buttonUndo = this.toolBar.createTool("imageable", "undo16x16", "Undo Last Edit", "undo", this.actionAdapter, false);
        this.buttonRedo = this.toolBar.createTool("imageable", "redo16x16", "Redo Last Edit", "redo", this.actionAdapter, false);
        this.buttonLayout = this.toolBar.createTool("imageable", "layout", " repeatedly graph layout ", "graphlayout", this.actionAdapter, true);
        this.buttonLayoutMenu = this.toolBar.createTool("imageable", "layoutmenu16x16", " Graph Layout Algorithm menu ", "graphlayoutmenu", this.actionAdapter, true);
        this.buttonLayoutMenu.addMouseListener(this.mouseAdapter);
        this.fillToolBar();
        this.typeEditor = new TypeEditor(aggappl, this);
        this.typeEditor.addTypeEventListener(this);
        this.graphEditor = new GraphEditor(this);
        this.ruleEditor = new RuleEditor(this);
        this.splitPane = new JSplitPane(0, this.ruleEditor, this.graphEditor);
        this.splitPane.setDividerSize(15);
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane0 = new JSplitPane(0, null, this.splitPane);
        this.splitPane0.setDividerSize(0);
        this.splitPane0.setContinuousLayout(true);
        this.splitPane0.setOneTouchExpandable(true);
        this.splitPane1 = new JSplitPane(1, this.splitPane0, null);
        this.splitPane1.setContinuousLayout(true);
        this.splitPane1.setOneTouchExpandable(true);
        this.splitPane1.setDividerSize(15);
        this.add((Component)this.splitPane1, "Center");
        this.modePopupMenu.setLabel("Edit Mode");
        this.modePopupMenu.setEditor(this);
        this.modePopupMenu.setMainModeMenu(this.mode);
        this.editPopupMenu.setLabel("Edit");
        this.editPopupMenu.setEditor(this);
        this.editPopupMenu.setParentFrame(this.applFrame);
        this.editPopupMenu.setGraphLayouter(this.evolutionaryLayouter);
        this.editPopupMenu.setParentFrame(this.applFrame);
        this.editSelPopupMenu.setLabel("Edit");
        this.editSelPopupMenu.setEditor(this);
        this.editSelPopupMenu.setParentFrame(this.applFrame);
        this.ruleEditor.setModePopupMenu(this.modePopupMenu);
        this.ruleEditor.setEditPopupMenu(this.editPopupMenu);
        this.ruleEditor.setEditSelPopupMenu(this.editSelPopupMenu);
        this.graphEditor.setModePopupMenu(this.modePopupMenu);
        this.graphEditor.setEditPopupMenu(this.editPopupMenu);
        this.graphEditor.setEditSelPopupMenu(this.editSelPopupMenu);
        this.ruleEditor.setEditCursor(new Cursor(0));
        this.graphEditor.setEditCursor(new Cursor(0));
        this.gragraTransform = new GraGraTransform(this);
        this.gragraTransform.addTransformEventListener(this);
        this.gragraTransform.getOptionGUI().addActionListener(this.actionAdapter);
        this.gragraTransform.getGeneralOptionGUI().addActionListener("waitAfterStep", this.actionAdapter);
        this.resetEnabledOfMenus(null, false);
        this.resetEnabledOfToolBarItems(null, false);
        this.ruleEditor.getLeftPanel().getCanvas().addMouseListener(this.mouseAdapter);
        this.ruleEditor.getRightPanel().getCanvas().addMouseListener(this.mouseAdapter);
        this.ruleEditor.getNACPanel().getCanvas().addMouseListener(this.mouseAdapter);
        this.graphEditor.getGraphPanel().getCanvas().addMouseListener(this.mouseAdapter);
        this.typeEditor.getTypePalette().getEditNodeTypeButton().addMouseListener(this.mouseAdapter);
        this.typeEditor.getTypePalette().getNewNodeTypeButton().addMouseListener(this.mouseAdapter);
        this.typeEditor.getTypePalette().getDeleteNodeTypeButton().addMouseListener(this.mouseAdapter);
        this.typeEditor.getTypePalette().getEditArcTypeButton().addMouseListener(this.mouseAdapter);
        this.typeEditor.getTypePalette().getNewArcTypeButton().addMouseListener(this.mouseAdapter);
        this.typeEditor.getTypePalette().getDeleteArcTypeButton().addMouseListener(this.mouseAdapter);
        this.nodeAnimation = new NodeAnimation();
        ComponentAdapter cl = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (GraGraEditor.this.typesAlwaysOn) {
                    GraGraEditor.this.splitPane1.setDividerLocation(GraGraEditor.this.splitPane1.getWidth() - 200);
                } else {
                    GraGraEditor.this.splitPane1.setDividerLocation(GraGraEditor.this.splitPane1.getWidth());
                }
            }
        };
        this.addComponentListener(cl);
        this.createGraphLayouters();
    }

    private void createGraphLayouters() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GraGraEditor.this.graphLayouts = new GraphLayouts();
                GraGraEditor.this.graphLayouts.addActionListener(GraGraEditor.this.actionAdapter);
                GraGraEditor.this.setGraphLayoutAlgorithmName("Default ( Spring based )");
            }
        });
    }

    public GraGraEditorMouseAdapter getMouseAdapter() {
        return this.mouseAdapter;
    }

    public ActionListener getActionListener() {
        return this.actionAdapter;
    }

    public int getDividerLocationOfEditorAndTypeEditor() {
        return this.dividerLocation2;
    }

    public void setDividerLocationOfEditorAndTypeEditor(int location) {
        this.dividerLocation2 = location;
    }

    public void setDividerLocation(int location) {
        this.dividerLocation = location;
        this.splitPane.setDividerLocation(this.dividerLocation);
    }

    public void showOptionGUI() {
        if (this.applFrame instanceof AGGAppl) {
            ((AGGAppl)this.applFrame).getPreferences().showOptionGUI(1);
        }
    }

    public void showRuleSequenceGUI(String seqName) {
        this.gragraTransform.getOptionGUI().showRuleSequenceGUI(seqName);
    }

    public JSplitPane getMainSplitPane() {
        return this.splitPane1;
    }

    public boolean typesAlwaysOn() {
        return this.typesAlwaysOn;
    }

    public void setTypesAlwaysOn(boolean b) {
        this.typesAlwaysOn = b;
    }

    private void setAttrEditor() {
        this.attrEditor = DefaultEditorFacade.self().getTopEditor();
        this.inputParameterEditor = DefaultEditorFacade.self().getInputParameterEditor();
        ((TopEditor)this.attrEditor).getAttrInstanceEditor().getTableModel().addTableModelListener(this);
        ((TopEditor)this.attrEditor).getContextEditor().getConditionEditor().getTableModel().addTableModelListener(this);
        ((BasicTupleEditor)this.inputParameterEditor).getTableModel().addTableModelListener(this);
        this.ruleEditor.setAttrEditor(this.attrEditor);
        if (this.exportJPEG != null) {
            ((TopEditor)this.attrEditor).setExportJPEG(this.exportJPEG);
        }
        this.attrEditorExists = true;
    }

    public boolean isTransformationRunning() {
        return this.interpreting || this.layering || this.sequences;
    }

    public boolean isLayeredTransformationRunning() {
        return this.layering;
    }

    public boolean isDefaultTransformationRunning() {
        return this.interpreting;
    }

    public boolean isRuleSequencesTransformationRunning() {
        return this.sequences;
    }

    public synchronized void addEditEventListener(EditEventListener l) {
        if (!this.editEventListeners.contains(l)) {
            this.editEventListeners.addElement(l);
        }
    }

    public synchronized void removeEditEventListener(EditEventListener l) {
        if (this.editEventListeners.contains(l)) {
            this.editEventListeners.removeElement(l);
        }
    }

    public synchronized void fireEditEvent(EditEvent e) {
        int i = 0;
        while (i < this.editEventListeners.size()) {
            this.editEventListeners.elementAt(i).editEventOccurred(e);
            ++i;
        }
    }

    @Override
    public void treeViewEventOccurred(TreeViewEvent e) {
        if (e.getMsg() == 999) {
            this.setGraGra(null);
            return;
        }
        if (e.getMsg() == 24) {
            if (e.getObject() instanceof KeyEvent) {
                this.keyAdapter.performShortKeyEvent((KeyEvent)e.getObject(), false);
            }
        } else if (e.getMsg() == 19) {
            this.graphEditor.updateGraphics();
        } else if (e.getMsg() == 25) {
            if (this.hasAttrEditorOnTop()) {
                if (this.isLastAttrDeclValid()) {
                    this.refreshTypeUser();
                    if (this.activePanel != null) {
                        this.updateUndoButtonAfterAttrEdit(this.activePanel);
                    }
                    this.resetRuleEditor();
                    if (this.getEditMode() == 114) {
                        this.resetMoveEditMode();
                    }
                }
            } else if (this.hasAttrEditorOnBottom() && this.isLastAttrDeclValid()) {
                this.refreshTypeUser();
                if (this.activePanel != null) {
                    this.updateUndoButtonAfterAttrEdit(this.activePanel);
                }
                this.resetGraphEditor();
                if (this.getEditMode() == 114) {
                    this.lasteditmode = 13;
                    this.setEditMode(this.lasteditmode);
                    this.forwardModeCommand("Move");
                }
            }
        } else if (e.getMsg() == 6) {
            int multiplicityError;
            if (this.editmode == 42) {
                this.resetEditModeAfterMapping(this.lasteditmode);
            } else if (this.graphEditor.getGraph() != null && this.graphEditor.getGraph().isTypeGraph() && (multiplicityError = this.getGraGra().getBasisGraGra().getMultiplicityErrorKind()) != -1) {
                this.fireEditEvent(new EditEvent(this, -13, this.getGraGra(), String.valueOf(multiplicityError)));
            }
        } else if (e.getMsg() == 61) {
            if (this.interpreting || this.layering || this.sequences) {
                return;
            }
            this.treeNodeData = e.getData();
            if (this.treeNodeData.isGraGra() && this.getGraGra() != null) {
                this.getGraGra().getBasisGraGra().storeUsedClassPackages();
            }
            if (this.hasAttrEditorOnTop() || this.hasAttrEditorOnBottom()) {
                if (!this.isLastAttrDeclValid()) {
                    return;
                }
                this.refreshTypeUser();
                if (this.undoManager != null && this.undoManager.isEnabled()) {
                    if (!this.attrChanged) {
                        if (this.activePanel != null && this.activePanel.getGraph() != null) {
                            this.activePanel.getGraph().undoManagerLastEditDie();
                        }
                    } else if (this.activePanel != null && this.activePanel.getGraph() != null) {
                        this.activePanel.getGraph().undoManagerEndEdit();
                    }
                    this.attrChanged = false;
                    this.updateUndoButton();
                }
                if (this.activePanel != null) {
                    this.updateUndoButtonAfterAttrEdit(this.activePanel);
                }
                if (this.hasAttrEditorOnTop()) {
                    if (this.editmode != 114) {
                        this.resetRuleEditor();
                    }
                } else if (this.hasAttrEditorOnBottom() && this.editmode != 114) {
                    this.resetGraphEditor();
                }
            }
            if (this.treeNodeData.isRuleSequence()) {
                if (this.getGraGra() != null && this.getGraGra().getBasisGraGra() == this.treeNodeData.getRuleSequence().getGraGra()) {
                    this.getGraGra().getBasisGraGra().setCurrentRuleSequence(this.treeNodeData.getRuleSequence());
                    if (this.getGraGra().getBasisGraGra().getCurrentRuleSequence() != null && this.getGraGra().getBasisGraGra().getCurrentRuleSequence().isEmpty()) {
                        this.getGraGra().getBasisGraGra().getCurrentRuleSequence().setGraph(this.getGraGra().getBasisGraGra().getGraph());
                    }
                    this.fireEditEvent(new EditEvent((Object)this, -1, this.treeNodeData.getRuleSequence().getName().concat(" :   ").concat(this.treeNodeData.getRuleSequence().getToolTipText())));
                    this.getGraGraTransform().getOptionGUI().doClick("ruleSequence");
                    this.gragraTransform.getOptionGUI().setRulesOfRuleSequenceGUI(this.getGraGra().getEnabledRules());
                    this.gragraTransform.getOptionGUI().setRuleSequences(this.treeNodeData.getRuleSequence().getSubSequenceList());
                    if (this.treeNodeData.getRuleSequence().getSubSequenceList().isEmpty()) {
                        this.gragraTransform.getOptionGUI().showRuleSequenceGUI(this.treeNodeData.getRuleSequence().getName());
                    }
                    return;
                }
                return;
            }
            this.fireEditEvent(new EditEvent((Object)this, -1, ""));
            this.loadDataInEditor(this.treeNodeData);
            if (this.getGraGra() != null) {
                if (this.treeNodeData.isGraGra()) {
                    this.gragraTransform.getOptionGUI().closeRuleSequenceGUI();
                    this.nacExists = false;
                    this.resetButtonIdenticNAC(this.nacExists);
                    this.pacExists = false;
                    this.resetButtonIdenticPAC(this.pacExists);
                    this.acExists = false;
                    this.resetButtonIdenticNestedAC(this.acExists);
                    this.getGraGra().getBasisGraGra().setUsedClassPackages();
                } else if (this.treeNodeData.isRule()) {
                    this.nacExists = true;
                    this.resetButtonIdenticNAC(this.nacExists);
                    this.pacExists = true;
                    this.resetButtonIdenticPAC(this.pacExists);
                    this.acExists = true;
                    this.resetButtonIdenticNestedAC(this.acExists);
                    if (this.treeNodeData.getRule().getMatch() != null) {
                        this.treeNodeData.getRule().update();
                        this.graphEditor.getGraph().update();
                        this.updateGraphics();
                    }
                } else if (this.treeNodeData.isNAC()) {
                    this.nacExists = true;
                    this.resetButtonIdenticNAC(this.nacExists);
                } else if (this.treeNodeData.isPAC()) {
                    this.pacExists = true;
                    this.resetButtonIdenticPAC(this.pacExists);
                } else if (this.treeNodeData.isNestedAC()) {
                    this.acExists = true;
                    this.resetButtonIdenticNestedAC(this.acExists);
                }
                if (this.getEditMode() == 11) {
                    this.resetSelectEditMode();
                }
            }
        } else if (e.getMsg() == 7) {
            this.treeNodeData = e.getData();
            if (this.treeNodeData != null) {
                this.deleteDataFromEditor(this.treeNodeData);
                if (this.gragra == null) {
                    this.nacExists = false;
                    this.pacExists = false;
                    this.splitPane1.setRightComponent(null);
                    this.resetEnabledOfToolBarItems(null, false);
                }
                this.resetEnabledOfMenus(null, false);
                if (this.hasAttrEditorOnTop()) {
                    this.resetRuleEditor();
                } else if (this.hasAttrEditorOnBottom()) {
                    this.resetGraphEditor();
                }
            }
        } else if (e.getMsg() == 72) {
            if (this.gragra != null) {
                this.gragraTransform.setRuleSequences(this.gragra.getEnabledRules(), this.gragra.getBasisGraGra().getRuleSequenceList());
                if (this.gragra.getRules().isEmpty()) {
                    this.ruleEditor.setRule(null);
                }
            }
        } else if (e.getMsg() == 73) {
            if (this.gragra != null) {
                this.gragraTransform.setRuleSequences(this.gragra.getEnabledRules(), this.gragra.getBasisGraGra().getRuleSequenceList());
            }
        } else if (e.getMsg() == 32) {
            if (this.gragra != null && this.gragra.getBasisGraGra().getRuleSequences().isEmpty()) {
                this.gragraTransform.setRuleSequences(this.gragra.getEnabledRules(), null);
            }
        } else if (e.getMsg() == 29) {
            this.resetGraTraGUI(this.gragra);
        } else if (e.getMsg() == 2) {
            this.resetEditModeAfterMapping(this.lasteditmode);
        } else if (e.getMsg() == 4) {
            this.setEditMode(13);
            this.forwardModeCommand("Move");
        } else if (e.getMsg() == 1) {
            if (this.ruleEditor.isObjMapping()) {
                this.ruleEditor.resetEditModeAfterMapping();
            }
            this.updateGraphics();
            if (this.gragra != null) {
                boolean xyattr = this.gragra.getBasisGraGra().getGraTraOptions().contains("xyPosAttribute");
                this.gragra.getBasisGraGra().setGraTraOptions(this.gragraTransform.getGraTraOptionsList());
                if (xyattr) {
                    this.gragra.getBasisGraGra().getGraTraOptions().add("xyPosAttribute");
                }
            }
        } else if (e.getMsg() == 21) {
            this.updateGraphics();
        } else if (e.getMsg() == 211) {
            this.updateGraphics();
        } else if (e.getMsg() == 16) {
            this.gragraTransform.destroyMatch();
            this.graphEditor.updateGraphics();
            this.fireEditEvent(new EditEvent((Object)this, -1, "        "));
        } else if (e.getMsg() == 160) {
            this.treeNodeData = e.getData();
            if (this.treeNodeData.isGraGra() && this.treeNodeData.getGraGra() == this.gragra || this.treeNodeData.isGraph() && this.treeNodeData.getGraph().getGraGra() == this.gragra) {
                this.graphEditor.setGraph(this.gragra.getGraph());
                this.graphEditor.updateGraphics();
                if (this.gragraTransform.checkRuleApplicabilityEnabled()) {
                    this.gragraTransform.getApplicableRules(this.gragra);
                }
                if (this.continueLayeredTransformLoop) {
                    this.continueLayeredTransformLoop = false;
                    this.buttonStart.doClick();
                } else {
                    this.noMoreStopBeforeResetGraph = false;
                }
            }
        } else if (e.getMsg() == 17) {
            this.gragraTransform.destroyMatch();
            this.graphEditor.updateGraphics();
            this.fireEditEvent(new EditEvent((Object)this, -1, "        "));
        } else if (e.getMsg() == 170) {
            this.typeEditor.refreshTypes();
            this.evolutionaryLayouterOptionGUI.setGraGra(this.gragra);
            if (this.graphEditor.getGraph().isTypeGraph()) {
                this.graphEditor.setGraph(this.gragra.getTypeGraph());
                this.graphEditor.updateGraphics();
            }
            if (this.getGraGra().getTypeSet().getTypeGraph() != null && !this.getGraGra().getTypeSet().getTypeGraph().getSelectedObjs().isEmpty()) {
                this.forwardModeCommand("Move");
                this.setEditMode(13);
            }
        } else if (e.getMsg() == 171) {
            this.typeEditor.refreshTypes();
            this.evolutionaryLayouterOptionGUI.setGraGra(this.gragra);
            if (!this.graphEditor.getGraph().isTypeGraph()) {
                this.graphEditor.setGraph(this.gragra.getGraph());
                this.graphEditor.updateGraphics();
            }
            if (this.getGraGra().getTypeSet().getTypeGraph() != null && !this.getGraGra().getTypeSet().getTypeGraph().getSelectedObjs().isEmpty()) {
                this.forwardModeCommand("Move");
                this.setEditMode(13);
            }
            if (this.gragraTransform.checkRuleApplicabilityEnabled()) {
                this.gragraTransform.getApplicableRules(this.gragra);
            }
        } else if (e.getMsg() == 172) {
            this.typeEditor.refreshTypes();
            this.evolutionaryLayouterOptionGUI.setGraGra(this.gragra);
        } else if (e.getMsg() == 173) {
            this.typeEditor.refreshTypes();
            this.evolutionaryLayouterOptionGUI.setGraGra(this.gragra);
            if (this.graphEditor.getGraph().isTypeGraph()) {
                this.graphEditor.setGraph(this.gragra.getTypeGraph());
                this.graphEditor.updateGraphics();
            }
            if (this.getGraGra().getTypeSet().getTypeGraph() != null && !this.getGraGra().getTypeSet().getTypeGraph().getSelectedObjs().isEmpty()) {
                this.forwardModeCommand("Move");
                this.setEditMode(13);
            }
        } else if (e.getMsg() == 18) {
            this.getGraGra().getApplicableRules(this.gragraTransform.getStrategy());
            if (e.getSource() instanceof GraGraTreeView || e.getSource() instanceof GraGraPopupMenu) {
                ((GraGraTreeView)e.getSource()).getTree().treeDidChange();
            }
        } else if (e.getMsg() == 181) {
            this.getGraGra().dismissRuleApplicability();
            if (e.getSource() instanceof GraGraTreeView || e.getSource() instanceof GraGraPopupMenu) {
                ((GraGraTreeView)e.getSource()).getTree().treeDidChange();
            }
        } else if (e.getMsg() == 22) {
            this.typeEditor.refreshTypes();
        } else if (e.getMsg() == 23) {
            this.saveGraphJPEG();
        } else if (e.getMsg() == 28) {
            if (e.getObject() instanceof Rule) {
                this.setInputParameter((Rule)e.getObject());
            }
        } else if (e.getMsg() == 30) {
            this.getGraGraTransform().getOptionGUI().doClick("ruleSequence");
        }
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
        TreePath path = e.getTreePath();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        GraGraTreeNodeData data = (GraGraTreeNodeData)node.getUserObject();
        String name = data.string();
        if (this.treeNodeData != null && this.getGraGra() != null) {
            data = this.treeNodeData;
            name = data.string();
            if (data.isGraGra() && data.getGraGra() != null && data.getGraGra().equals(this.getGraGra()) && data.getGraGra() == this.getGraGra()) {
                if (this.ruleEditor.getAtomic() != null) {
                    this.ruleEditor.setAtomicTitle(this.ruleEditor.getAtomic().getBasisAtomic().getName(), this.ruleEditor.getAtomic().getBasisAtomic().getAtomicName());
                } else if (this.ruleEditor.getRule() != null) {
                    this.ruleEditor.setRuleTitle(this.ruleEditor.getRule().getBasisRule().getName(), name);
                } else {
                    this.ruleEditor.setRuleTitle("", name);
                }
                this.graphEditor.setTitle(data.getGraGra().getGraph().getBasisGraph().getName(), name);
            } else if (data.isTypeGraph() && data.getGraph() != null && data.getGraph().equals(this.graphEditor.getGraph())) {
                this.graphEditor.setTitle(data.getGraph().getBasisGraph().getName(), this.getGraGra().getName());
            } else if (data.isGraph() && data.getGraph() != null && data.getGraph().equals(this.graphEditor.getGraph())) {
                this.graphEditor.setTitle(data.getGraph().getBasisGraph().getName(), this.getGraGra().getName());
            } else if (data.isRule() && data.getRule() != null && data.getRule().equals(this.ruleEditor.getRule())) {
                this.ruleEditor.setRuleTitle(name, this.getGraGra().getName());
            } else if (data.isNAC() && data.getNAC() != null && data.getNAC().equals(this.ruleEditor.getNAC())) {
                this.ruleEditor.setNACTitle(name);
            } else if (data.isAtomic() && data.getAtomic() != null && this.ruleEditor.getAtomic() != null && data.getAtomic().getParent() == this.ruleEditor.getAtomic().getParent()) {
                this.ruleEditor.setAtomicTitle(this.ruleEditor.getAtomic().getMorphism().getName(), name);
            } else if (data.isConclusion() && data.getConclusion() != null && data.getConclusion().equals(this.ruleEditor.getAtomic())) {
                this.ruleEditor.setAtomicTitle(name, data.getConclusion().getBasisAtomic().getAtomicName());
            }
        }
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
    }

    @Override
    public void transformEventOccurred(TransformEvent e) {
        this.trafoEventKey = e.getMsg();
        switch (this.trafoEventKey) {
            case 21: {
                this.requestFocusInWindow();
                JOptionPane.showMessageDialog(this.applFrame, "Sorry.\nConsistency check will be ignored, because it isn`t yet\nimplemented for grammars with node type inheritance.", "Warning", 2);
                break;
            }
            case 9: {
                this.fireEditEvent(new EditEvent((Object)this, -1, "Transformation of  <" + this.getGraGra().getName() + ">  ..."));
                break;
            }
            case 27: {
                EdRule er;
                if (e.getRule() == null || !this.gragraTransform.waitAfterStepEnabled() || (er = this.gragra.getRule(e.getRule().getName())) == null) break;
                this.ruleEditor.setRule(er);
                break;
            }
            case 16: {
                if (!this.interpreting && !this.layering && !this.sequences) break;
                this.fireEditEvent(new EditEvent((Object)this, -1, "Transform ... " + e.getMessage()));
                break;
            }
            case 17: {
                if (this.interpreting || this.layering || this.sequences) {
                    if (this.undoManager != null && this.undoManager.isEnabled()) {
                        this.undoManager.setUndoEndOfTransformStepAllowed(true);
                    }
                    if (!e.getMatch().getRule().isWaitBeforeApplyEnabled()) break;
                    this.sleep = true;
                    this.requestFocusInWindow();
                    if (e.getMatch().getRule().getRuleScheme() == null) {
                        if (this.getRuleEditor().getRule().getBasisRule() != e.getMatch().getRule()) {
                            this.setRule(this.getGraGra().getRule(e.getMatch().getRule()));
                        }
                        this.getRuleEditor().getRule().updateMatch();
                        this.updateGraphics();
                    } else {
                        AmalgamatedRule amalgRule;
                        EdRuleScheme rs = this.getGraGra().getRuleScheme(e.getMatch().getRule());
                        if (rs != null && (amalgRule = rs.getBasisRuleScheme().getAmalgamatedRule()) != null) {
                            this.setRule(rs.getKernelRule());
                            rs.updateMatch(amalgRule.getMatch(), this.graphEditor.getGraph());
                            this.graphEditor.getGraphPanel().updateGraphics(false);
                        }
                    }
                    this.fireEditEvent(new EditEvent((Object)this, -1, String.valueOf(e.getMessage()) + "     <<<   PRESS ANY KEY TO CONTINUE   >>>"));
                    try {
                        while (this.sleep) {
                            Thread.sleep(100L);
                        }
                    }
                    catch (InterruptedException rs) {}
                    break;
                }
                this.updateGraphics();
                break;
            }
            case 22: {
                if (!this.layering) break;
                if (this.gragraTransform.stopLayerAndWaitEnabled()) {
                    this.sleep = true;
                    this.requestFocusInWindow();
                    this.fireEditEvent(new EditEvent((Object)this, -1, String.valueOf(e.getMessage()) + "     <<<   PRESS ANY KEY TO CONTINUE   >>>"));
                    try {
                        while (this.sleep) {
                            Thread.sleep(100L);
                        }
                    }
                    catch (InterruptedException rs) {
                        // empty catch block
                    }
                    this.layeredTransform.nextLayer();
                    break;
                }
                if (!this.gragraTransform.showGraphAfterStepEnabled()) {
                    this.graphEditor.updateGraphics();
                }
                this.layeredTransform.nextLayer();
                break;
            }
            case 10: {
                this.getGraGra().getGraph().setTransformChangeEnabled(false);
                if (this.interpreting || this.layering || this.sequences) {
                    this.sleep = false;
                    this.resetIconsIfTransformInterpret(true);
                    this.resetMoveEditMode();
                    this.disableStopMenuItem();
                    this.buttonT.setEnabled(true);
                    this.buttonLayout.setEnabled(true);
                    if (this.layering) {
                        this.removeEditEventListener(this.layeredTransform);
                        this.layeredTransform.dispose();
                        this.layering = false;
                    } else if (this.interpreting) {
                        this.removeEditEventListener(this.interpreter);
                        this.interpreter.dispose();
                        this.interpreting = false;
                    } else if (this.sequences) {
                        this.removeEditEventListener(this.transformRuleSequences);
                        this.transformRuleSequences.dispose();
                        this.sequences = false;
                    }
                    this.addEditEventListener(this.gragraTransform.getTransformDebugger());
                    if (this.gragraTransform.checkRuleApplicabilityEnabled()) {
                        this.gragraTransform.getApplicableRules(this.getGraGra());
                    }
                    this.graphEditor.updateGraphics(true);
                    this.fireEditEvent(new EditEvent((Object)this, -1, "Transformation of  <" + this.getGraGra().getName() + ">  " + e.getMessage()));
                }
                this.selectToolBarTransformItem("");
                this.typeEditor.setEnabled(true);
                if (this.undoManager != null && this.undoManager.isEnabled() && this.undoManager.canUndo()) {
                    this.buttonUndo.setEnabled(true);
                    if (this.undoManager.canRedo()) {
                        this.buttonRedo.setEnabled(true);
                    }
                    this.setUndoStepButtonEnabled(true);
                }
                if (this.getGraGra().isAnimated()) {
                    this.undoManager.setEnabled(true);
                }
                if (this.applFrame instanceof AGGAppl) {
                    ((AGGAppl)this.applFrame).getGraGraTreeView().getTree().treeDidChange();
                }
                if (this.evolutionaryLayouter.getWriteMetricValues() && this.jpgPath != null && !this.jpgPath.equals("")) {
                    this.writeMetricValues(String.valueOf(this.jpgPath) + File.separator + this.getGraGra().getFileName() + "_metrics.log");
                }
                this.setActivePanel(this.graphEditor.getGraphPanel());
                break;
            }
            case 11: {
                if (this.ruleEditor.isObjMapping()) {
                    this.ruleEditor.resetEditModeAfterMapping();
                }
                this.setEditMode(42);
                break;
            }
            case 23: {
                break;
            }
            case 12: {
                if (this.lasteditmode != 13) {
                    this.lasteditmode = 13;
                    this.setEditMode(this.lasteditmode);
                    this.forwardModeCommand("Move");
                }
                this.graphEditor.updateGraphics();
                this.fireEditEvent(new EditEvent((Object)this, -1, "Transform ...  Next Completion ... Please wait. "));
                break;
            }
            case 15: {
                if (this.interpreting || this.layering || this.sequences) break;
                this.getGraGra().getGraph().setTransformChangeEnabled(false);
                this.setEditMode(this.lasteditmode);
                JOptionPane.showMessageDialog(this.applFrame, "Cannot match\n" + e.getMessage(), "Cannot match", 0);
                this.fireEditEvent(new EditEvent((Object)this, -1, "Transform ...  Match failed. "));
                break;
            }
            case 13: {
                this.fireEditEvent(new EditEvent((Object)this, -1, "Transform ...  Step ... Please wait. "));
                break;
            }
            case 1: {
                if (!this.setInputParameter(e)) break;
                this.fireEditEvent(new EditEvent((Object)this, -1, "Transform ... Please set value of the input parameter(s)."));
                break;
            }
            case 18: {
                this.getGraGra().getGraph().setTransformChangeEnabled(false);
                JOptionPane.showMessageDialog(this.applFrame, "Not ready to transform!\n" + e.getMessage(), "Cannot transform", 0);
                this.setEditMode(this.lasteditmode);
                this.selectToolBarTransformItem("");
                this.fireEditEvent(new EditEvent((Object)this, -1, "Transform ...  Not ready to transform. "));
                break;
            }
            case 4: {
                if (!(this.interpreting || this.layering || this.sequences)) {
                    this.getGraGra().getGraph().setTransformChangeEnabled(false);
                    if (e.getMessage().length() > 0) {
                        JOptionPane.showMessageDialog(this.applFrame, "Cannot transform.\n" + e.getMessage(), "Cannot transform", 0);
                        this.fireEditEvent(new EditEvent((Object)this, -1, "Transform ...  failed. "));
                    }
                } else if (e.getMessage().length() > 0) {
                    JOptionPane.showMessageDialog(this.applFrame, "Cannot transform.\n" + e.getMessage(), "Cannot transform", 0);
                    this.fireEditEvent(new EditEvent((Object)this, -1, "Transform ... " + e.getMessage()));
                }
                this.setEditMode(this.lasteditmode);
                this.selectToolBarTransformItem("");
                break;
            }
            case 5: {
                this.updateGraphics();
                this.fireEditEvent(new EditEvent((Object)this, -1, "Please define a new match."));
                break;
            }
            case 6: {
                this.fireEditEvent(new EditEvent((Object)this, -1, ""));
                break;
            }
            case 7: {
                this.getGraph().unsetNodeNumberChanged();
                if (this.gragraTransform.selectMatchObjectsEnabled()) {
                    this.getGraph().updateAlongMorph(e.getMatch());
                }
                this.updateGraphics();
                this.updateUndoButton();
                this.fireEditEvent(new EditEvent((Object)this, -1, "Transform ... Match is complete."));
                this.selectToolBarTransformItem("");
                this.setActivePanel(this.graphEditor.getGraphPanel());
                break;
            }
            case 25: {
                this.setNodeAnimation(e.getMatch());
                break;
            }
            case 2: {
                ++this.stepCounter;
                if (this.interpreting || this.layering || this.sequences) {
                    if (this.gragraTransform.showGraphAfterStepEnabled()) {
                        if (this.stepCounter == 1) {
                            this.getGraph().addMovedToUndo(this.getGraph().getGraphObjects());
                        }
                        this.runAnimationThread();
                        this.graphEditor.getGraphPanel().updateGraphics();
                    }
                    if (this.gragraTransform.checkRuleApplicabilityEnabled()) {
                        this.gragraTransform.getApplicableRules(this.gragra);
                    }
                    if (this.gragraTransform.waitAfterStepEnabled()) {
                        this.requestFocusInWindow();
                        this.sleep = true;
                        this.fireEditEvent(new EditEvent((Object)this, -1, String.valueOf(e.getMessage()) + "     <<<   PRESS ANY KEY TO CONTINUE   >>>"));
                        try {
                            while (this.sleep) {
                                Thread.sleep(100L);
                            }
                        }
                        catch (InterruptedException rs) {
                            // empty catch block
                        }
                        if (!this.gragraTransform.checkRuleApplicabilityEnabled()) break;
                        this.gragraTransform.getApplicableRules(this.gragra, true);
                        break;
                    }
                    this.fireEditEvent(new EditEvent((Object)this, -1, "Transform ... " + e.getMessage()));
                    break;
                }
                this.getGraGra().getGraph().setTransformChangeEnabled(false);
                this.runAnimationThread();
                this.graphEditor.getGraphPanel().updateGraphics();
                if (this.ruleEditor.getRule().getBasisRule() instanceof AmalgamatedRule || this.ruleEditor.getRule().getBasisRule() instanceof KernelRule || this.ruleEditor.getRule().getBasisRule() instanceof MultiRule) {
                    this.fireEditEvent(new EditEvent((Object)this, -14, this.ruleEditor.getRule()));
                }
                if (e.getMatch() == null) {
                    this.fireEditEvent(new EditEvent((Object)this, -1, "Transform ... Step is completed."));
                    if (this.gragraTransform.checkRuleApplicabilityEnabled()) {
                        this.fireEditEvent(new EditEvent((Object)this, -1, " Checking applicability of rules ... Please wait. "));
                        this.gragraTransform.getApplicableRules(this.getGraGra());
                        this.fireEditEvent(new EditEvent((Object)this, -1, " Step is done.     Checking applicability of rules is done."));
                    } else {
                        this.gragraTransform.getApplicableRules(this.getGraGra(), true);
                        this.fireEditEvent(new EditEvent((Object)this, -1, " Step is done. "));
                    }
                }
                this.selectToolBarTransformItem("");
                if (this.undoManager != null && this.undoManager.isEnabled() && this.undoManager.canUndo()) {
                    this.setUndoButtonEnabled(true);
                }
                this.setActivePanel(this.graphEditor.getGraphPanel());
                break;
            }
            case 3: {
                if (this.interpreting || this.layering || this.sequences) break;
                this.getGraGra().getGraph().setTransformChangeEnabled(false);
                this.updateGraphics();
                JOptionPane.showMessageDialog(this.applFrame, "No match completion found.\n" + e.getMessage(), "No completion", 0);
                this.selectToolBarTransformItem("");
                this.fireEditEvent(new EditEvent((Object)this, -1, "Transform ... No match completion found."));
                break;
            }
            case 14: {
                if (this.interpreting || this.layering || this.sequences) break;
                this.getGraGra().getGraph().setTransformChangeEnabled(false);
                this.updateGraphics();
                JOptionPane.showMessageDialog(this.applFrame, "Match is not valid.", "Not valid", 0);
                this.fireEditEvent(new EditEvent((Object)this, -1, "Transform ... Match was not valid."));
                break;
            }
            case 8: {
                if (this.interpreting || this.layering || this.sequences) {
                    this.fireEditEvent(new EditEvent((Object)this, -1, "Transform ...  was cancelled. "));
                } else {
                    this.getGraGra().getGraph().setTransformChangeEnabled(false);
                    this.fireEditEvent(new EditEvent((Object)this, -1, "Transform ... Last action was cancelled. "));
                }
                this.setEditMode(this.lasteditmode);
                this.selectToolBarTransformItem("");
                break;
            }
            case 19: {
                if (!(this.interpreting || this.layering || this.sequences)) {
                    this.getGraGra().getGraph().setTransformChangeEnabled(false);
                    this.setEditMode(this.lasteditmode);
                    this.selectToolBarTransformItem("");
                }
                if (this.layering && this.noMoreStopBeforeResetGraph) break;
                JOptionPane.showMessageDialog(this.applFrame, e.getMessage(), "Graph Inconsistency", 0);
                this.fireEditEvent(new EditEvent((Object)this, -1, "Transform ...  Graph inconsistency "));
                break;
            }
            case 24: {
                if (this.gragra == null) break;
                this.gragra.getBasisGraGra().setSubsequencesOfCurrentRuleSequence(this.gragraTransform.getRuleSequences());
                break;
            }
            case 26: {
                boolean showDialog = true;
                if (this.noMoreStopBeforeResetGraph) {
                    ++this.layeredRuns;
                    if (this.layeredRuns > TransformLayered.MAX_LAYERED_RUNS) {
                        this.layeredRuns = 0;
                    } else {
                        this.continueLayeredTransformLoop = true;
                        this.fireEditEvent(new EditEvent((Object)this, -12, this.graphEditor.getGraph()));
                        return;
                    }
                }
                if (!showDialog) break;
                Object[] options = new Object[]{"OK", "Cancel"};
                DialogWithCheckBoxAndTwoButtons dialog = new DialogWithCheckBoxAndTwoButtons(this.applFrame, "Reset Graph", " Do you want to reset graph for next loop of layered graph transformation?", options, options[0], " loop ( max " + String.valueOf(TransformLayered.MAX_LAYERED_RUNS) + " times ) over all layers without asking for confirmation");
                dialog.setVisible(true);
                int answer = dialog.getAnswer();
                if (answer != 0) break;
                this.continueLayeredTransformLoop = true;
                this.noMoreStopBeforeResetGraph = dialog.isCheckSelected();
                this.fireEditEvent(new EditEvent((Object)this, -12, this.graphEditor.getGraph()));
            }
        }
    }

    protected boolean setInputParameter(TransformEvent e) {
        if (e.getMatch() != null) {
            return this.setInputParameter(e.getMatch());
        }
        if (e.getRule() != null) {
            return this.setInputParameter(e.getRule());
        }
        return false;
    }

    protected boolean setInputParameter(Match m) {
        if (m != null) {
            AttrVariableTuple avt = m.getAttrContext().getVariables();
            this.inputParameterEditor.setTuple(avt);
            ((OpenViewSetting)((MaskedViewSetting)this.inputParameterEditor.getViewSetting()).getOpenView()).removeFormat(avt.getType());
            this.setInputParameterEditorOnTop(this.inputParameterEditor.getComponent(), m.getRule());
            if (this.ruleEditor.getRule().getBasisRule() != m.getRule()) {
                this.setRule(this.gragra.getRule(m.getRule()));
            }
            return true;
        }
        return false;
    }

    protected boolean setInputParameter(Rule r) {
        if (r != null) {
            AttrVariableTuple avt = r.getAttrContext().getVariables();
            this.inputParameterEditor.setTuple(avt);
            ((OpenViewSetting)((MaskedViewSetting)this.inputParameterEditor.getViewSetting()).getOpenView()).removeFormat(avt.getType());
            this.setInputParameterEditorOnTop(this.inputParameterEditor.getComponent(), r);
            return true;
        }
        return false;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        AttrVariableTuple avt = (AttrVariableTuple)((BasicTupleEditor)this.inputParameterEditor).getTuple();
        if (e.getColumn() == -1 && avt != null && avt.areInputParametersSet()) {
            this.unsetInputParameterEditor();
            this.inputParameterEditor.setTuple(null);
            this.fireEditEvent(new EditEvent(this, -3));
            return;
        }
        if (!this.hasAttrEditorOnTop() && !this.hasAttrEditorOnBottom()) {
            return;
        }
        boolean needFullUpdate = false;
        this.attrTypeChanged = false;
        this.attrChanged = false;
        this.attrTypeCreated = false;
        if (((TopEditor)this.attrEditor).getTitleOfSelectedEditor().equals("Current Attribute") && this.attrMemberCount != ((TupleTableModel)e.getSource()).getRowCount() - 1) {
            this.attrChanged = true;
            needFullUpdate = true;
            this.attrTypeCreated = true;
            if (this.graphObjectOfAttrInstance != null) {
                this.gragra.getTypeSet().setAttrTypeChanged(this.graphObjectOfAttrInstance.getBasisObject().getType(), true);
            }
        } else if (((TupleTableModel)e.getSource()).getColumnName(((TupleTableModel)e.getSource()).getChangedColumn()).equals("Shown")) {
            if (((TupleTableModel)e.getSource()).isColumnValueChanged()) {
                needFullUpdate = true;
            }
        } else if (((TupleTableModel)e.getSource()).getColumnName(((TupleTableModel)e.getSource()).getChangedColumn()).equals("Expression")) {
            if (((TopEditor)this.attrEditor).getTitleOfSelectedEditor().equals("Attribute Context")) {
                if (this.ruleEditor.getAtomic() != null) {
                    this.fireEditEvent(new EditEvent(this, -8, this.ruleEditor.getAtomic(), ""));
                } else if (this.ruleEditor.getRule() != null) {
                    this.fireEditEvent(new EditEvent(this, -8, this.ruleEditor.getRule(), ""));
                }
            } else if (((TopEditor)this.attrEditor).getTitleOfSelectedEditor().equals("Current Attribute")) {
                this.attrChanged = true;
                if (this.graphObjectOfAttrInstance != null) {
                    if (this.graphObjectOfAttrInstance.getBasisObject().getContext().getKind().equals("LHS")) {
                        if (!this.compareLHSAttrsWithTarObjs(this.graphObjectOfAttrInstance.getBasisObject())) {
                            needFullUpdate = true;
                        }
                    } else if (this.graphObjectOfAttrInstance.getBasisObject().getContext().getKind().equals("NAC")) {
                        this.compareAttrsWithSourceObjectOfNAC(this.graphObjectOfAttrInstance.getBasisObject());
                    } else if (this.graphObjectOfAttrInstance.getBasisObject().getContext().getKind().equals("PAC")) {
                        this.compareAttrsWithSourceObjectOfPAC(this.graphObjectOfAttrInstance.getBasisObject());
                    } else if (this.graphObjectOfAttrInstance.getBasisObject().getContext().getKind().equals("GAC")) {
                        this.compareAttrsWithSourceObjectOfGAC(this.graphObjectOfAttrInstance.getBasisObject());
                    }
                }
            }
        } else if (((TupleTableModel)e.getSource()).getColumnName(((TupleTableModel)e.getSource()).getChangedColumn()).equals("Type")) {
            if (((TupleTableModel)e.getSource()).isColumnValueChanged()) {
                this.attrTypeChanged = true;
                this.attrChanged = true;
                needFullUpdate = true;
            }
        } else if (((TupleTableModel)e.getSource()).getColumnName(((TupleTableModel)e.getSource()).getChangedColumn()).equals("Name") && ((TupleTableModel)e.getSource()).isColumnValueChanged()) {
            this.attrChanged = true;
            needFullUpdate = true;
        }
        if (this.attrChanged) {
            if (needFullUpdate) {
                if (this.hasAttrEditorOnTop()) {
                    this.graphEditor.updateGraphics();
                } else {
                    this.ruleEditor.updateGraphics();
                }
            } else {
                this.activePanel.updateGraphics();
            }
        }
    }

    private void attrTypeChangedWarning() {
        if (this.attrTypeChanged) {
            JOptionPane.showMessageDialog(this.applFrame, "Attribute type declaration has changed.\nAlready set attribute values may be not more valid.\nPlease check these values.", "Attribute Type changed", 2);
            this.attrTypeChanged = false;
        }
    }

    protected boolean isLastAttrDeclValid() {
        if (this.attrEditor.getTuple() != null && !this.attrEditor.getTuple().getTupleType().isDefined()) {
            JOptionPane.showMessageDialog(this.applFrame, "An attribute member declaration failed! \nPlease correct or delete it.", "Attribute failed", 0);
            return false;
        }
        return true;
    }

    protected boolean compareAttrsWithSourceObjectOfNAC(GraphObject nacObj) {
        if (this.activePanel != null && this.activePanel.getParentEditor() instanceof RuleEditor && nacObj.getAttribute() != null && this.ruleEditor.getNAC() != null) {
            Enumeration<GraphObject> inverse = this.ruleEditor.getNAC().getMorphism().getInverseImage(nacObj);
            while (inverse.hasMoreElements()) {
                GraphObject lhsObj = inverse.nextElement();
                if (this.ruleEditor.getRule().getBasisRule().compareConstAttrValueOfMapObjs(lhsObj, nacObj)) continue;
                JOptionPane.showMessageDialog(this.applFrame, "NAC attribute value failed!\nThe value of an attribute of a NAC\nhas to be equal to the correspondent \nattribute value of the LHS of a rule.", "Attribute value changed", 0);
                return false;
            }
        }
        return true;
    }

    protected boolean compareAttrsWithSourceObjectOfPAC(GraphObject pacObj) {
        if (this.activePanel != null && this.activePanel.getParentEditor() instanceof RuleEditor && pacObj.getAttribute() != null && this.ruleEditor.getPAC() != null && this.ruleEditor.getPAC().getMorphism().getInverseImage(pacObj).hasMoreElements()) {
            Enumeration<GraphObject> inverse = this.ruleEditor.getPAC().getMorphism().getInverseImage(pacObj);
            while (inverse.hasMoreElements()) {
                GraphObject lhsObj = inverse.nextElement();
                if (this.ruleEditor.getRule().getBasisRule().compareConstAttrValueOfMapObjs(lhsObj, pacObj)) continue;
                JOptionPane.showMessageDialog(this.applFrame, "PAC attribute value failed!\nThe value of an attribute of a PAC \nhas to be equal to the correspondent \nattribute value of the LHS of a rule.", "Attribute value changed", 0);
                return false;
            }
        }
        return true;
    }

    protected boolean compareAttrsWithSourceObjectOfGAC(GraphObject acObj) {
        if (this.activePanel != null && this.activePanel.getParentEditor() instanceof RuleEditor && acObj.getAttribute() != null && this.ruleEditor.getNestedAC() != null && this.ruleEditor.getNestedAC().getMorphism().getInverseImage(acObj).hasMoreElements()) {
            Enumeration<GraphObject> inverse = this.ruleEditor.getNestedAC().getMorphism().getInverseImage(acObj);
            while (inverse.hasMoreElements()) {
                GraphObject lhsObj = inverse.nextElement();
                if (this.ruleEditor.getRule().getBasisRule().compareConstAttrValueOfMapObjs(lhsObj, acObj)) continue;
                JOptionPane.showMessageDialog(this.applFrame, "GAC attribute value failed!\nThe value of an attribute of a GAC \nhas to be equal to the correspondent \nattribute value of the LHS of a rule.", "Attribute value changed", 0);
                return false;
            }
        }
        return true;
    }

    protected boolean compareLHSAttrsWithTarObjs(GraphObject lhsObj) {
        boolean result = true;
        if (this.activePanel != null && this.activePanel.getParentEditor() instanceof RuleEditor && lhsObj.getAttribute() != null) {
            Rule brule = this.ruleEditor.getRule().getBasisRule();
            List<OrdinaryMorphism> nacs = brule.getNACsList();
            result = this.compareLHSAttrsWithTarObjOfCond(brule, lhsObj, nacs, "NAC");
            List<OrdinaryMorphism> pacs = brule.getPACsList();
            result = this.compareLHSAttrsWithTarObjOfCond(brule, lhsObj, pacs, "PAC");
            List<OrdinaryMorphism> acs = brule.getNestedACsList();
            result = this.compareLHSAttrsWithTarObjOfCond(brule, lhsObj, acs, "GAC");
        }
        return result;
    }

    protected boolean compareLHSAttrsWithTarObjOfCond(Rule r, GraphObject lhsObj, List<OrdinaryMorphism> conds, String what) {
        boolean result = true;
        int l = 0;
        while (l < conds.size()) {
            OrdinaryMorphism cond = conds.get(l);
            GraphObject go = cond.getImage(lhsObj);
            if (go != null && !r.compareConstAttrValueOfMapObjs(lhsObj, go)) {
                result = false;
                JOptionPane.showMessageDialog(this.applFrame, String.valueOf(what) + " attribute value failed!" + "\nThe value of the correspondent attribute " + "\nof the " + what + " ( " + cond.getName() + " )  failed." + "\nIt has to be equal to the attribute value  " + "\nof the LHS of a rule." + "\n" + what + " attribute value will be unset.", "Attribute value changed", 0);
            }
            ++l;
        }
        return result;
    }

    @Override
    public void typeEventOccurred(TypeEvent e) {
        int typeMsg = e.getMsg();
        switch (typeMsg) {
            case 12: {
                if (e.getSource() instanceof ArcTypePropertyEditor) {
                    this.evolutionaryLayouterOptionGUI.updateEdgeTypeComboBox((EdType)e.getUsedObject(), e.getIndexOfObject(), e.getMsg());
                } else if (e.getSource() instanceof NodeTypePropertyEditor) {
                    this.evolutionaryLayouterOptionGUI.updateNodeTypeComboBox((EdType)e.getUsedObject(), e.getIndexOfObject(), e.getMsg());
                }
                this.gragra.update();
                this.updateGraphics();
                break;
            }
            case 13: {
                if (e.getSource() instanceof ArcTypePropertyEditor) {
                    this.evolutionaryLayouterOptionGUI.updateEdgeTypeComboBox((EdType)e.getUsedObject(), e.getIndexOfObject(), e.getMsg());
                    break;
                }
                if (!(e.getSource() instanceof NodeTypePropertyEditor)) break;
                this.evolutionaryLayouterOptionGUI.updateNodeTypeComboBox((EdType)e.getUsedObject(), e.getIndexOfObject(), e.getMsg());
                break;
            }
            case 14: {
                if (e.getSource() instanceof ArcTypePropertyEditor) {
                    this.evolutionaryLayouterOptionGUI.updateEdgeTypeComboBox((EdType)e.getUsedObject(), e.getIndexOfObject(), e.getMsg());
                } else if (e.getSource() instanceof NodeTypePropertyEditor) {
                    this.evolutionaryLayouterOptionGUI.updateNodeTypeComboBox((EdType)e.getUsedObject(), e.getIndexOfObject(), e.getMsg());
                }
                this.gragra.update();
                this.updateGraphics();
                break;
            }
            case 9: {
                this.updateGraphics();
                break;
            }
            case 10: {
                this.updateGraphics();
                break;
            }
            case 11: {
                this.typeEditor.refreshTypes();
                break;
            }
            case 17: {
                this.gragra.resetAnimated(true);
            }
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(100, 100);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(600, 550);
    }

    public Enumeration<JMenu> getMenus() {
        return this.mainMenus.elements();
    }

    public JFrame getParentFrame() {
        return this.applFrame;
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public JMenu getEditMenu() {
        return this.edit;
    }

    public JMenu getModeMenu() {
        return this.mode;
    }

    public JMenu getTransformMenu() {
        return this.transform;
    }

    public EvolutionaryGraphLayout getGraphLayouter() {
        return this.evolutionaryLayouter;
    }

    public GraphLayouterOptionGUI getGraphLayouterOptionGUI() {
        return this.evolutionaryLayouterOptionGUI;
    }

    public void setInputParameterEditorOnTop(Component paramEditor, Rule r) {
        if (this.splitPane0.getTopComponent() == null) {
            JPanel p = new JPanel(new BorderLayout());
            p.setBorder(new TitledBorder("  Rule: " + r.getName() + " -  Please set value of the input parameter(s)  "));
            p.setBackground(new Color(255, 204, 102));
            p.add(paramEditor, "Center");
            p.add((Component)new JLabel("   "), "South");
            int h = paramEditor.getHeight() + 50;
            p.setPreferredSize(new Dimension(500, h));
            this.splitPane0.setTopComponent(p);
            this.splitPane0.setDividerSize(15);
        }
    }

    public void unsetInputParameterEditor() {
        if (this.splitPane0.getTopComponent() != null) {
            this.splitPane0.setTopComponent(null);
            this.splitPane0.setDividerSize(0);
        }
    }

    public void setAttrEditorOnTop(Component attrEditorComponent) {
        if (!(this.splitPane.getTopComponent() instanceof AttrTupleEditor)) {
            ((TopEditor)this.attrEditor).selectAttributeEditor(true);
            this.dividerLocation = this.splitPane.getDividerLocation();
            this.splitPane.setTopComponent(attrEditorComponent);
            this.splitPane.setDividerLocation(this.dividerLocation);
            if (this.editmode == 11 || this.editmode == -1) {
                this.resetMoveEditMode();
            }
        }
    }

    public void setAttrEditorOnBottom(Component attrEditorComponent) {
        if (!(this.splitPane.getBottomComponent() instanceof AttrTupleEditor)) {
            ((TopEditor)this.attrEditor).selectAttributeEditor(true);
            this.dividerLocation = this.splitPane.getDividerLocation();
            this.splitPane.setBottomComponent(attrEditorComponent);
            this.splitPane.setDividerLocation(this.dividerLocation);
            this.ruleEditor.getLeftPanel().setAttrEditorActivated(true);
            this.ruleEditor.getRightPanel().setAttrEditorActivated(true);
            if (this.ruleEditor.getLeftCondPanel() != null) {
                this.ruleEditor.getLeftCondPanel().setAttrEditorActivated(true);
            }
            if (this.editmode == 11 || this.editmode == -1) {
                this.resetMoveEditMode();
            }
        }
    }

    public boolean hasAttrEditorOnTop() {
        if (this.splitPane.getTopComponent() instanceof RuleEditor && this.splitPane.getBottomComponent() instanceof GraphEditor) {
            return false;
        }
        return this.splitPane.getBottomComponent() instanceof GraphEditor;
    }

    public boolean hasAttrEditorOnBottom() {
        if (this.splitPane.getTopComponent() instanceof RuleEditor && this.splitPane.getBottomComponent() instanceof GraphEditor) {
            return false;
        }
        return this.splitPane.getTopComponent() instanceof RuleEditor;
    }

    public void resetRuleEditor() {
        if (this.graphObjectOfAttrInstance != null && this.graphObjectOfAttrInstance.getContext() != null) {
            this.graphObjectOfAttrInstance.setWeakselected(false);
            if (this.graphObjectOfAttrInstance.isSelected()) {
                this.graphObjectOfAttrInstance.getContext().deselect(this.graphObjectOfAttrInstance);
            }
        }
        this.dividerLocation = this.splitPane.getDividerLocation();
        if (this.isPostAtomApplCond) {
            this.splitPane.setTopComponent(this.pacMorphs);
            this.splitPane.setDividerLocation(this.dividerLocation);
        } else {
            this.splitPane.setTopComponent(this.ruleEditor);
            this.splitPane.setDividerLocation(this.dividerLocation);
        }
    }

    public void resetGraphEditor() {
        if (!(this.splitPane.getBottomComponent() instanceof GraphEditor)) {
            if (this.graphObjectOfAttrInstance != null && this.graphObjectOfAttrInstance.getContext() != null) {
                this.graphObjectOfAttrInstance.setWeakselected(false);
                if (this.graphObjectOfAttrInstance.isSelected()) {
                    this.graphObjectOfAttrInstance.getContext().deselect(this.graphObjectOfAttrInstance);
                }
            }
            this.splitPane.setBottomComponent(this.graphEditor);
            this.splitPane.setDividerLocation(this.dividerLocation);
            this.ruleEditor.getLeftPanel().setAttrEditorActivated(false);
            this.ruleEditor.getRightPanel().setAttrEditorActivated(false);
            if (this.ruleEditor.getNACPanel() != null) {
                this.ruleEditor.getNACPanel().setAttrEditorActivated(false);
            }
        }
    }

    public void resetEditor() {
        if (this.hasAttrEditorOnTop()) {
            this.resetRuleEditor();
        } else if (this.hasAttrEditorOnBottom()) {
            this.resetGraphEditor();
        }
    }

    private void refreshTypeUser() {
        if (this.attrTypeCreated) {
            this.gragra.getTypeSet().refreshTypeUsersAfterAttrTypeChanged();
            this.attrTypeCreated = false;
        }
    }

    public final EditUndoManager getUndoManager() {
        return this.undoManager;
    }

    public final JButton getUndoButton() {
        return this.buttonUndo;
    }

    public final JButton getUndoStepButton() {
        return this.buttonUndoStep;
    }

    public final JButton getRedoButton() {
        return this.buttonRedo;
    }

    public final JButton getStepButton() {
        return this.buttonStep;
    }

    public final JButton getMatchButton() {
        return this.buttonMatch;
    }

    public final JButton getMatchCompletionButton() {
        return this.buttonCompletion;
    }

    public final JButton getStartButton() {
        return this.buttonStart;
    }

    public final JButton getStopButton() {
        return this.buttonStop;
    }

    public void setSleep(boolean b) {
        this.sleep = b;
    }

    public boolean isSleeping() {
        return this.sleep;
    }

    public JButton getTransformationKindButton() {
        return this.buttonT;
    }

    public final TypeEditor getTypeEditor() {
        return this.typeEditor;
    }

    public final RuleEditor getRuleEditor() {
        return this.ruleEditor;
    }

    public final GraphEditor getGraphEditor() {
        return this.graphEditor;
    }

    public int getTypePanelDividerLocation() {
        return this.typeEditor.getTypePalette().getWidthOfPalette();
    }

    public int getTypePanelLastDividerLocation() {
        return this.splitPane1.getLastDividerLocation();
    }

    public void setTypePanelDividerLocation(int l) {
        this.splitPane1.setDividerLocation(this.splitPane1.getWidth() - l);
    }

    public void resetTypePanelWidth() {
        if (this.typesAlwaysOn) {
            this.splitPane1.setDividerLocation(this.splitPane1.getWidth() - 200);
        } else {
            this.splitPane1.setDividerLocation(this.splitPane1.getWidth());
        }
    }

    public GraTraOptionGUI getTransformOptionGUI() {
        return this.gragraTransform.getOptionGUI();
    }

    public GraTraMatchOptionGUI getGeneralTransformOptionGUI() {
        return this.gragraTransform.getGeneralOptionGUI();
    }

    public GraphPanel getActivePanel() {
        return this.activePanel;
    }

    public GraphPanel setActivePanel(GraphPanel gp) {
        this.activePanel = gp;
        return this.activePanel;
    }

    public GraphPanel getPanelOfGraph(EdGraph g) {
        if (g == null) {
            return null;
        }
        GraphPanel gp = this.ruleEditor.getPanelOf(g);
        if (gp == null && g == this.graphEditor.getGraphPanel().getGraph()) {
            gp = this.graphEditor.getGraphPanel();
        }
        return gp;
    }

    public GraphPanel getPanelOfLocationOnScreen(Point p) {
        if (p == null) {
            return null;
        }
        GraphPanel gp = this.ruleEditor.getPanelOfLocationOnScreen(p);
        if (gp == null) {
            gp = this.graphEditor.getPanelOfLocationOnScreen(p);
        }
        return gp;
    }

    public final EdGraGra getGraGra() {
        return this.gragra;
    }

    public final EdRule getRule() {
        return this.ruleEditor.getRule();
    }

    public final EdGraph getGraph() {
        return this.graphEditor.getGraph();
    }

    public final EdNAC getNAC() {
        return this.ruleEditor.getNAC();
    }

    public final EdPAC getPAC() {
        return this.ruleEditor.getPAC();
    }

    private void resetUndoManager(EdGraGra gg) {
        if (gg.getUndoManager() != null) {
            this.undoManager = (EditUndoManager)gg.getUndoManager();
        } else {
            this.undoManager = new EditUndoManager("Undo last edit");
            this.undoManager.setLimit(1000);
            this.typeEditor.setUndoManager(this.undoManager);
            gg.setUndoManager(this.undoManager);
            this.undoManager.setEnabled(gg.isUndoManagerEnabled());
        }
    }

    public void enableUndoManager(boolean enable) {
        this.undoManager.setEnabled(enable);
        if (!enable) {
            this.buttonUndo.setEnabled(false);
            this.buttonRedo.setEnabled(false);
        }
    }

    public void setGraGra(EdGraGra gra) {
        if (this.gragra != null) {
            this.gragra.getTypeSet().removeTypeEventListener(this);
            if (this.graphEditor.getGraphPanel().getCanvas().hasChanged() || this.ruleEditor.getLeftPanel().getCanvas().hasChanged() || this.ruleEditor.getRightPanel().getCanvas().hasChanged() || this.ruleEditor.getNACPanel().getCanvas().hasChanged()) {
                this.gragra.setChanged(true);
            }
        }
        if (gra == null) {
            this.gragra = null;
            this.typeEditor.setGraGra(null);
            this.evolutionaryLayouterOptionGUI.setGraGra(null);
            this.gragraTransform.setRuleSequences(null, null);
            this.gragraTransform.unsetTransformDebug();
            return;
        }
        this.gragra = gra;
        if (!this.attrEditorExists) {
            this.setAttrEditor();
        }
        this.resetUndoManager(this.gragra);
        this.gragra.getTypeSet().setNodeIconable(this.iconable);
        this.gragra.getTypeSet().addTypeEventListener(this);
        this.resetGraTraGUI(this.gragra);
        this.noMoreStopBeforeResetGraph = false;
        this.evolutionaryLayouterOptionGUI.setGraGra(this.gragra);
        this.nodeToAnimateOnfront = false;
        if (this.applFrame instanceof AGGAppl) {
            ((AGGAppl)this.applFrame).addToFrameTitle(this.gragra.getDirName(), this.gragra.getFileName());
        }
        if (this.modePopupMenu.miUndoManager.getText().equals("Disable Undo Manager") && !((EditUndoManager)this.gragra.getUndoManager()).isEnabled()) {
            this.modePopupMenu.miUndoManager.doClick();
        }
        if (!this.modePopupMenu.miStaticNodePosition.isSelected()) {
            this.modePopupMenu.miStaticNodePosition.doClick();
        }
    }

    protected void resetGraTraGUI(EdGraGra gg) {
        if (gg.getBasisGraGra().getGraTraOptions().isEmpty()) {
            Vector<String> defaultOpts = new Vector<String>();
            defaultOpts.addElement("CSP");
            defaultOpts.addElement("injective");
            defaultOpts.addElement("dangling");
            defaultOpts.addElement("identification");
            defaultOpts.addElement("NACs");
            defaultOpts.addElement("PACs");
            defaultOpts.addElement("GACs");
            this.gragraTransform.updateGraTraOptionGUI(defaultOpts);
            gg.getBasisGraGra().setGraTraOptions(this.gragraTransform.getStrategy());
            this.gragraTransform.setRuleSequences(null, null);
        } else {
            this.gragraTransform.updateGraTraOptionGUI(gg.getBasisGraGra().getGraTraOptions());
            this.gragraTransform.setRuleSequences(gg.getEnabledRules(), gg.getBasisGraGra().getRuleSequenceList());
            if (gg.getBasisGraGra().getMorphismCompletionStrategy() == null) {
                gg.getBasisGraGra().setGraTraOptions(this.gragraTransform.getStrategy());
            }
            if (this.gragraTransform.layeredEnabled()) {
                this.resetTransformationKindIcon(this.gragraTransform.layeredEnabled(), "LT");
            } else if (this.gragraTransform.priorityEnabled()) {
                this.resetTransformationKindIcon(this.gragraTransform.priorityEnabled(), "PT");
            } else if (this.gragraTransform.ruleSequenceEnabled()) {
                this.resetTransformationKindIcon(this.gragraTransform.ruleSequenceEnabled(), "ST");
            } else {
                this.resetTransformationKindIcon(false, "NT");
            }
        }
        this.gragraTransform.getTransformDebugger().refreshAsGraTraListener();
    }

    public void setRule(EdRule r) {
        if (r != null && this.gragra == r.getGraGra()) {
            this.ruleEditor.setRule(r);
        }
    }

    public void setGraph(EdGraph g) {
        if (this.gragra == g.getGraGra()) {
            this.graphEditor.setGraph(g);
            this.nodeToAnimateOnfront = false;
        }
    }

    public void setNAC(EdNAC nac) {
        if (this.ruleEditor.getRule() == nac.getRule()) {
            this.ruleEditor.setNAC(nac);
        }
    }

    public void setPAC(EdPAC pac) {
        if (this.ruleEditor.getRule() == pac.getRule()) {
            this.ruleEditor.setPAC(pac);
        }
    }

    public void setAtomic(EdAtomic a) {
        if (this.gragra == a.getGraGra()) {
            this.ruleEditor.setAtomic(a);
            this.ruleEditor.updateGraphics();
        }
    }

    public void setAtomApplCond(AtomApplCond c) {
        if (this.gragra == this.pacMorphs.getGraGra()) {
            this.pacMorphs.setAtomApplCond(c);
        }
    }

    public final int getEditMode() {
        return this.editmode;
    }

    public final int getLastEditMode() {
        return this.lasteditmode;
    }

    public void setEditMode(int mode) {
        if (this.gragra == null || this.getGraGra().getTypeSet().isEmpty()) {
            return;
        }
        this.editmode = mode;
        switch (this.editmode) {
            case 11: {
                this.drawModeProc();
                break;
            }
            case 12: {
                this.selectModeProc();
                break;
            }
            case 13: {
                this.moveModeProc();
                break;
            }
            case 114: {
                this.attributesModeProc();
                break;
            }
            case 42: {
                this.matchDefModeProc();
                break;
            }
            case 115: {
                this.mapModeProc();
                break;
            }
            case 116: {
                this.unmapModeProc();
                break;
            }
            case 117: {
                this.mapselModeProc();
                break;
            }
            case 118: {
                this.unmapselModeProc();
                break;
            }
            case 9: {
                this.viewModeProc();
                break;
            }
            default: {
                this.drawModeProc();
            }
        }
        this.fireEditEvent(new EditEvent(this, mode));
    }

    public void enableMagicEdgeSupport(boolean b) {
        this.ruleEditor.getLeftPanel().getCanvas().setMagicEdgeSupportEnabled(b);
        this.ruleEditor.getRightPanel().getCanvas().setMagicEdgeSupportEnabled(b);
        this.ruleEditor.getLeftCondPanel().getCanvas().setMagicEdgeSupportEnabled(b);
        this.graphEditor.getGraphPanel().getCanvas().setMagicEdgeSupportEnabled(b);
    }

    private void drawModeProc() {
        this.ruleEditor.setEditMode(11);
        this.graphEditor.setEditMode(11);
        this.lasteditmode = 11;
    }

    private void selectModeProc() {
        this.ruleEditor.setEditMode(12);
        this.graphEditor.setEditMode(12);
        this.lasteditmode = 12;
    }

    private void moveModeProc() {
        this.ruleEditor.setEditMode(13);
        this.graphEditor.setEditMode(13);
        this.lasteditmode = 13;
    }

    private void attributesModeProc() {
        this.ruleEditor.setEditMode(114);
        this.graphEditor.setEditMode(114);
        this.lasteditmode = 114;
    }

    private void matchDefModeProc() {
        this.ruleEditor.setEditMode(42);
        this.lasteditmode = 42;
    }

    private void mapModeProc() {
        this.ruleEditor.setEditMode(115);
        this.graphEditor.setEditMode(115);
        this.lasteditmode = 115;
    }

    private void unmapModeProc() {
        this.ruleEditor.setEditMode(116);
        this.graphEditor.setEditMode(116);
        this.lasteditmode = 116;
    }

    private void mapselModeProc() {
        this.ruleEditor.setEditMode(117);
        this.graphEditor.setEditMode(117);
    }

    private void unmapselModeProc() {
        this.ruleEditor.setEditMode(118);
        this.graphEditor.setEditMode(118);
    }

    private void viewModeProc() {
        this.ruleEditor.setEditMode(9);
        this.graphEditor.setEditMode(9);
    }

    public void attrsProc() {
        if (this.editmode == 9 || this.ruleEditor.getRule() == null && this.graphEditor.getGraph() == null || !this.getGraGra().getGraph().isEditable()) {
            return;
        }
        if (!this.graphEditor.hasSelection() && !this.ruleEditor.hasSelection()) {
            JOptionPane.showMessageDialog(this.applFrame, "There isn't any object selected.");
            this.errMsg = true;
            return;
        }
        if (this.errMsg) {
            this.fireEditEvent(new EditEvent((Object)this, -1, ""));
        }
        this.errMsg = false;
        if (this.ruleEditor.hasOneSelection() && !this.graphEditor.hasSelection()) {
            EdGraphObject ego = null;
            if (this.ruleEditor.getRule().getLeft().hasOneSelection()) {
                ego = this.ruleEditor.getRule().getLeft().getSelectedObjs().firstElement();
            } else if (this.ruleEditor.getRule().getRight().hasOneSelection()) {
                ego = this.ruleEditor.getRule().getRight().getSelectedObjs().firstElement();
            } else if (this.ruleEditor.getNAC().hasOneSelection()) {
                ego = this.ruleEditor.getNAC().getSelectedObjs().firstElement();
            } else if (this.ruleEditor.getPAC().hasOneSelection()) {
                ego = this.ruleEditor.getPAC().getSelectedObjs().firstElement();
            } else if (this.ruleEditor.getNestedAC().hasOneSelection()) {
                ego = this.ruleEditor.getNestedAC().getSelectedObjs().firstElement();
            }
            if (ego != null) {
                if (this.getAttrEditor(ego) != null) {
                    this.attrEditor.enableContextEditor(true);
                    this.setAttrEditorOnBottom(this.attrEditor.getComponent());
                    this.fireEditEvent(new EditEvent((Object)this, -1, "To activate the graph editor do click on the background anywhere."));
                }
            } else {
                JOptionPane.showMessageDialog(this.applFrame, "There isn't any object selected.");
                this.errMsg = true;
            }
        } else if (this.graphEditor.hasOneSelection() && !this.ruleEditor.hasSelection()) {
            if (this.getAttrEditor(this.graphEditor.getGraph().getSelectedObjs().firstElement()) != null) {
                this.attrEditor.enableContextEditor(false);
                this.setAttrEditorOnTop(this.attrEditor.getComponent());
                this.fireEditEvent(new EditEvent((Object)this, -1, "To activate the rule editor do click on the background anywhere."));
            }
        } else {
            JOptionPane.showMessageDialog(this.applFrame, "Too many selections.\nPlease select one object only.");
            this.errMsg = true;
        }
    }

    public boolean deleteProc() {
        if (this.editmode == 9 || !this.getGraGra().isEditable() || !this.graphEditor.hasSelection() && !this.ruleEditor.hasSelection()) {
            return false;
        }
        this.errMsg = false;
        int answer = this.removeWarning("Do you want really to delete \n selected object(s) ?");
        if (answer == 0) {
            this.ruleEditor.deleteProc();
            if (this.graphEditor.deleteProc()) {
                this.ruleEditor.getRule().update();
            }
            this.resetEditor();
        }
        return true;
    }

    public void copyProc() {
        if (this.editmode == 9 || this.ruleEditor.getRule() == null && this.graphEditor.getGraph() == null || !this.getGraGra().isEditable()) {
            return;
        }
        this.errMsg = false;
        if (this.splitPane.getTopComponent() instanceof RuleEditor && this.splitPane.getBottomComponent() instanceof GraphEditor) {
            if (!this.graphEditor.hasSelection() && !this.ruleEditor.hasSelection()) {
                JOptionPane.showMessageDialog(this.applFrame, "There isn't any object selected.");
                this.errMsg = true;
                return;
            }
            if (this.ruleEditor.hasSelection() && !this.ruleEditor.hasOneSelection()) {
                JOptionPane.showMessageDialog(this.applFrame, "Too many selections. \nExpected selected objects of the same graph only.");
                this.errMsg = true;
                return;
            }
            if (this.ruleEditor.hasSelection() && this.graphEditor.hasSelection()) {
                JOptionPane.showMessageDialog(this.applFrame, "Too many selections. \nExpected selected objects of the same graph only.");
                this.errMsg = true;
                return;
            }
            EdGraph gCopy = this.ruleEditor.getSelectedAsGraph();
            if (gCopy != null) {
                this.ruleEditor.setGraphToCopy(gCopy);
                this.graphEditor.setGraphToCopy(gCopy);
                this.graphEditor.setSourceOfCopy(this.ruleEditor.getSourceOfCopy());
            } else {
                gCopy = this.graphEditor.getSelectedAsGraph();
                if (gCopy != null) {
                    this.ruleEditor.setGraphToCopy(gCopy);
                    this.ruleEditor.setSourceOfCopy(this.graphEditor.getGraph());
                    this.graphEditor.setGraphToCopy(gCopy);
                }
            }
            if (gCopy != null) {
                this.graphToCopy = gCopy;
                this.fireEditEvent(new EditEvent((Object)this, -1, "To place a copy click on the background of the panel and then the Paste button or <Ctrl+V>."));
                this.lasteditmode = this.editmode;
                this.ruleEditor.setEditMode(15);
                this.graphEditor.setEditMode(15);
                AGGAppl.getInstance().setCursor(new Cursor(1));
            } else {
                JOptionPane.showMessageDialog(this.applFrame, "Bad selection. \nPlease check selected edges.\nSource and target nodes should be selected, too.");
                this.errMsg = true;
            }
        }
    }

    public void pasteProc() {
        if (this.editmode == 9 || this.ruleEditor.getRule() == null && this.graphEditor.getGraph() == null || !this.getGraGra().isEditable()) {
            return;
        }
        this.errMsg = false;
        if (this.splitPane.getTopComponent() instanceof RuleEditor && this.splitPane.getBottomComponent() instanceof GraphEditor) {
            if (this.graphToCopy != null) {
                GraphPanel gp;
                GraphPanel activegp = this.getActivePanel();
                activegp.getGraph().setGraphToCopy(this.graphToCopy);
                this.ruleEditor.setEditMode(152);
                this.graphEditor.setEditMode(152);
                this.getActivePanel().getCanvas().pasteCopy();
                if (this.graphEditor.getSourceOfCopy() != null && !activegp.getGraph().equals(this.graphEditor.getSourceOfCopy()) && (gp = this.getPanelOfGraph(this.graphEditor.getSourceOfCopy())) != null) {
                    gp.getGraph().deselectAll();
                    gp.repaint();
                }
                this.resetSelectEditMode();
            } else {
                JOptionPane.showMessageDialog(this.applFrame, "1. Select some objects and click on the Copy button or <Ctrl+C>. \n2. Click on the background of a graph panel and then the Paste button or <Ctrl+V> ", "         To Copy and Paste", 1);
            }
        }
    }

    public void resetAfterCopy() {
        this.ruleEditor.setSourceOfCopy(null);
        this.ruleEditor.setGraphToCopy(null);
        this.graphEditor.setGraphToCopy(null);
        this.graphEditor.setSourceOfCopy(null);
    }

    public void selectAllProc() {
        if (this.editmode != 12) {
            this.forwardModeCommand(EditorConstants.getModeOfID(12));
            this.setEditMode(12);
        }
        if (this.errMsg) {
            this.fireEditEvent(new EditEvent((Object)this, -1, ""));
        }
        this.errMsg = false;
        if (this.activePanel != null) {
            this.activePanel.selectAll();
        } else {
            if (this.splitPane.getTopComponent() instanceof RuleEditor) {
                this.ruleEditor.selectAllProc();
            }
            if (this.splitPane.getBottomComponent() instanceof GraphEditor) {
                this.graphEditor.selectAllProc();
            }
        }
        this.fireEditEvent(new EditEvent((Object)this, -1, ""));
    }

    public void selectNodeTypeProc() {
        if (this.editmode != 12) {
            this.forwardModeCommand(EditorConstants.getModeOfID(12));
            this.setEditMode(12);
        }
        if (this.errMsg) {
            this.fireEditEvent(new EditEvent((Object)this, -1, ""));
        }
        this.errMsg = false;
        if (this.activePanel != null) {
            this.activePanel.selectNodesOfSelectedNodeType();
        } else {
            if (this.splitPane.getTopComponent() instanceof RuleEditor) {
                this.ruleEditor.selectNodeTypeProc();
            }
            if (this.splitPane.getBottomComponent() instanceof GraphEditor) {
                this.graphEditor.selectNodeTypeProc();
            }
        }
        this.fireEditEvent(new EditEvent((Object)this, -1, ""));
    }

    public void selectArcTypeProc() {
        if (this.editmode != 12) {
            this.forwardModeCommand(EditorConstants.getModeOfID(12));
            this.setEditMode(12);
        }
        if (this.errMsg) {
            this.fireEditEvent(new EditEvent((Object)this, -1, ""));
        }
        this.errMsg = false;
        if (this.activePanel != null) {
            this.activePanel.selectArcsOfSelectedArcType();
        } else {
            if (this.splitPane.getTopComponent() instanceof RuleEditor) {
                this.ruleEditor.selectArcTypeProc();
            }
            if (this.splitPane.getBottomComponent() instanceof GraphEditor) {
                this.graphEditor.selectArcTypeProc();
            }
        }
        this.fireEditEvent(new EditEvent((Object)this, -1, ""));
    }

    public void deselectAllProc() {
        if (this.errMsg) {
            this.fireEditEvent(new EditEvent((Object)this, -1, ""));
        }
        this.errMsg = false;
        if (this.activePanel != null) {
            this.activePanel.deselectAll();
        } else {
            if (this.splitPane.getTopComponent() instanceof RuleEditor) {
                this.ruleEditor.deselectAllProc();
            }
            if (this.splitPane.getBottomComponent() instanceof GraphEditor) {
                this.graphEditor.deselectAllProc();
            }
        }
        this.fireEditEvent(new EditEvent((Object)this, -1, ""));
    }

    public void doStraightenArcsProc() {
        if (this.editmode == 9) {
            return;
        }
        if (this.ruleEditor.getRule() == null && this.graphEditor.getGraph() == null) {
            return;
        }
        if (!this.getGraGra().getGraph().isEditable()) {
            return;
        }
        if (!this.graphEditor.hasSelection() && !this.ruleEditor.hasSelection()) {
            boolean answer = false;
            if (!answer && this.splitPane.getBottomComponent() instanceof GraphEditor) {
                this.graphEditor.setStraightenArcs(true);
                this.graphEditor.updateGraphics();
            }
            return;
        }
        if (this.errMsg) {
            this.fireEditEvent(new EditEvent((Object)this, -1, ""));
        }
        this.errMsg = false;
        if (this.splitPane.getTopComponent() instanceof RuleEditor) {
            this.ruleEditor.setStraightenArcs(false);
            this.ruleEditor.straightenArcsProc();
        }
        if (this.splitPane.getBottomComponent() instanceof GraphEditor) {
            this.graphEditor.setStraightenArcs(false);
            this.graphEditor.straightenArcsProc();
        }
    }

    public void doIdenticRule() {
        if (this.editmode == 9 || this.ruleEditor.getRule() == null || !this.getGraGra().getGraph().isEditable()) {
            return;
        }
        if (this.errMsg) {
            this.fireEditEvent(new EditEvent((Object)this, -1, ""));
        }
        this.errMsg = false;
        this.ruleEditor.doIdenticRule();
        if (!this.ruleEditor.getMsg().equals("")) {
            this.fireEditEvent(new EditEvent((Object)this, -1, this.ruleEditor.getMsg()));
        }
    }

    public void doIdenticNAC() {
        if (this.editmode == 9 || this.ruleEditor.getRule() == null || !this.getGraGra().getGraph().isEditable()) {
            return;
        }
        if (this.errMsg) {
            this.fireEditEvent(new EditEvent((Object)this, -1, ""));
        }
        this.errMsg = false;
        this.ruleEditor.doIdenticNAC();
        if (!this.ruleEditor.getMsg().equals("")) {
            this.fireEditEvent(new EditEvent((Object)this, -1, this.ruleEditor.getMsg()));
        }
    }

    public void doIdenticPAC() {
        if (this.editmode == 9 || this.ruleEditor.getRule() == null || !this.getGraGra().getGraph().isEditable()) {
            return;
        }
        if (this.errMsg) {
            this.fireEditEvent(new EditEvent((Object)this, -1, ""));
        }
        this.errMsg = false;
        this.ruleEditor.doIdenticPAC();
        if (!this.ruleEditor.getMsg().equals("")) {
            this.fireEditEvent(new EditEvent((Object)this, -1, this.ruleEditor.getMsg()));
        }
    }

    public void doIdenticGAC() {
        if (this.editmode == 9 || this.ruleEditor.getRule() == null || !this.getGraGra().getGraph().isEditable()) {
            return;
        }
        if (this.errMsg) {
            this.fireEditEvent(new EditEvent((Object)this, -1, ""));
        }
        this.errMsg = false;
        this.ruleEditor.doIdenticGAC();
        if (!this.ruleEditor.getMsg().equals("")) {
            this.fireEditEvent(new EditEvent((Object)this, -1, this.ruleEditor.getMsg()));
        }
    }

    public void doNACDuetoRHS() {
        if (this.editmode == 9 || this.ruleEditor.getRule() == null || !this.getGraGra().getGraph().isEditable()) {
            return;
        }
        if (this.errMsg) {
            this.fireEditEvent(new EditEvent((Object)this, -1, ""));
        }
        this.errMsg = false;
        this.ruleEditor.doNACDuetoRHS();
        if (!this.ruleEditor.getMsg().equals("")) {
            this.fireEditEvent(new EditEvent((Object)this, -1, this.ruleEditor.getMsg()));
        }
    }

    public void doGACDuetoRHS() {
        if (this.editmode == 9 || this.ruleEditor.getRule() == null || !this.getGraGra().getGraph().isEditable()) {
            return;
        }
        if (this.errMsg) {
            this.fireEditEvent(new EditEvent((Object)this, -1, ""));
        }
        this.errMsg = false;
        this.ruleEditor.doGACDuetoRHS();
        if (!this.ruleEditor.getMsg().equals("")) {
            this.fireEditEvent(new EditEvent((Object)this, -1, this.ruleEditor.getMsg()));
        }
    }

    public void setInterpreting(boolean enable) {
        this.interpreting = enable;
    }

    public void setLayering(boolean enable) {
        this.layering = enable;
    }

    public void setTransformRuleSequences(boolean enable) {
        this.sequences = enable;
    }

    public void doView(String command) {
        this.setEditMode(9);
        this.resetModeMenu(null);
        this.modePopupMenu.deselectAll();
        this.fireEditEvent(new EditEvent(this, 9));
    }

    public void doPreferencesProc(String command) {
        if (command.equals("bold")) {
            this.setFontStyle(1);
        } else if (command.equals("italic")) {
            this.setFontStyle(2);
        } else if (command.equals("plain")) {
            this.setFontStyle(0);
        } else if (command.equals("tiny")) {
            this.setFontSize(0);
        } else if (command.equals("small")) {
            this.setFontSize(8);
        } else if (command.equals("large")) {
            this.setFontSize(10);
        } else if (command.equals("LARGE")) {
            this.setFontSize(12);
        } else if (command.equals("0.2")) {
            this.setScale(0.2);
        } else if (command.equals("0.3")) {
            this.setScale(0.3);
        } else if (command.equals("0.5")) {
            this.setScale(0.5);
        } else if (command.equals("0.7")) {
            this.setScale(0.7);
        } else if (command.equals("1.0")) {
            this.setScale(1.0);
        } else if (command.equals("1.5")) {
            this.setScale(1.5);
        } else if (command.equals("2.0")) {
            this.setScale(2.0);
        }
    }

    public void setScalingGraphOnly(boolean b) {
        this.scaleGraphOnly = b;
    }

    private void setFontStyle(int fstyle) {
        this.ruleEditor.getLeftPanel().getCanvas().setFontStyle(fstyle);
        this.ruleEditor.getRightPanel().getCanvas().setFontStyle(fstyle);
        this.ruleEditor.getNACPanel().getCanvas().setFontStyle(fstyle);
        this.graphEditor.getGraphPanel().getCanvas().setFontStyle(fstyle);
        this.updateGraphics();
        this.fireEditEvent(new EditEvent((Object)this, -4, fstyle));
    }

    private void setFontSize(int fsize) {
        this.ruleEditor.getLeftPanel().getCanvas().setFontSize(fsize);
        this.ruleEditor.getRightPanel().getCanvas().setFontSize(fsize);
        this.ruleEditor.getNACPanel().getCanvas().setFontSize(fsize);
        this.graphEditor.getGraphPanel().getCanvas().setFontSize(fsize);
        this.updateGraphics();
        this.fireEditEvent(new EditEvent((Object)this, -5, fsize));
    }

    public void setScale(double scale) {
        if (!this.scaleGraphOnly) {
            this.ruleEditor.getLeftPanel().getCanvas().setScale(scale);
            this.ruleEditor.getRightPanel().getCanvas().setScale(scale);
            this.ruleEditor.getNACPanel().getCanvas().setScale(scale);
            this.graphEditor.getGraphPanel().getCanvas().setScale(scale);
            this.updateGraphics();
        } else {
            this.graphEditor.getGraphPanel().getCanvas().setScale(scale);
            this.graphEditor.updateGraphics();
        }
        this.fireEditEvent(new EditEvent((Object)this, -6, scale));
    }

    public final AttrTopEditor setAttrEditorOnTopForGraphObject(EdGraphObject ego) {
        this.attrEditor.enableContextEditor(false);
        if (this.getAttrEditor(ego) != null) {
            this.setAttrEditorOnTop(this.attrEditor.getComponent());
            return this.attrEditor;
        }
        return null;
    }

    public final AttrTopEditor setAttrEditorOnBottomForGraphObject(EdGraphObject ego) {
        this.attrEditor.enableContextEditor(true);
        if (this.getAttrEditor(ego) != null) {
            this.setAttrEditorOnBottom(this.attrEditor.getComponent());
            return this.attrEditor;
        }
        return null;
    }

    public final AttrTopEditor setAttrEditorOnTopForType(Type aType) {
        AttrType anAttrTuple = aType.getAttrType();
        if (anAttrTuple == null) {
            aType.createAttributeType();
            anAttrTuple = aType.getAttrType();
        }
        this.attrEditor.enableContextEditor(false);
        this.attrEditor.setTuple(anAttrTuple);
        ((TopEditor)this.attrEditor).setTitleText("   Type Name :   " + aType.getName());
        if (!(this.splitPane.getBottomComponent() instanceof GraphEditor)) {
            this.resetGraphEditor();
        }
        this.setAttrEditorOnTop(this.attrEditor.getComponent());
        return this.attrEditor;
    }

    private boolean canChangeAttr(EdGraphObject ego) {
        RuleScheme rs;
        MultiRule r;
        Graph g = ego.getContext().getBasisGraph();
        EdRule er = this.ruleEditor.getRule();
        if (er != null && er.getBasisRule() != null && er.getBasisRule().getRuleScheme() != null && er.getBasisRule().isElement(g) && (r = (rs = er.getBasisRule().getRuleScheme()).getMultiRule(g)) != null && (r.getEmbeddingLeft().getCodomainObjects().contains(ego.getBasisObject()) || r.getEmbeddingRight().getCodomainObjects().contains(ego.getBasisObject()))) {
            String what = ego.isNode() ? "node" : "edge";
            JOptionPane.showMessageDialog(this.applFrame, "Cannot modify this " + what + " . It should be changed from its kernel rule.", "Attribute of Graph Object", 0);
            return false;
        }
        return true;
    }

    public AttrTopEditor getAttrEditor() {
        return this.attrEditor;
    }

    private final AttrTopEditor getAttrEditor(EdGraphObject ego) {
        EdArc ea;
        if (!this.canChangeAttr(ego)) {
            return null;
        }
        if (ego.isNode()) {
            EdNode en = (EdNode)ego;
            if (en.getBasisNode() != null) {
                Vector<EdGraphObject> vec;
                if (en.getBasisNode().getAttribute() == null) {
                    en.createAttributeInstance();
                }
                this.graphObjectOfAttrInstance = en;
                this.attrEditor.setTuple(en.getBasisNode().getAttribute());
                ((TopEditor)this.attrEditor).setTitleText("   Node:Type  Name  -   " + en.getBasisNode().getObjectName() + ":" + en.getBasisNode().getType().getName());
                en.setAttrViewSetting(this.attrEditor.getViewSetting());
                en.setGraphPanel(this.activePanel);
                this.attrMemberCount = en.getBasisObject().getNumberOfAttributes();
                if (this.undoManager != null && this.undoManager.isEnabled() && !(vec = this.getGraGra().getGraphObjectsOfType(en.getType(), true)).isEmpty()) {
                    this.getActivePanel().getGraph().addChangedAttributeToUndo(vec);
                }
            }
        } else if (ego.isArc() && (ea = (EdArc)ego).getBasisArc() != null) {
            Vector<EdGraphObject> vec;
            if (ea.getBasisArc().getAttribute() == null) {
                ea.createAttributeInstance();
            }
            this.graphObjectOfAttrInstance = ea;
            this.attrEditor.setTuple(ea.getBasisArc().getAttribute());
            ((TopEditor)this.attrEditor).setTitleText("   Edge:Type  Name  -   " + ea.getBasisArc().getObjectName() + ":" + ea.getBasisArc().getType().getName());
            ea.setAttrViewSetting(this.attrEditor.getViewSetting());
            ea.setGraphPanel(this.activePanel);
            if (this.undoManager != null && this.undoManager.isEnabled() && !(vec = new Vector<EdGraphObject>(this.getGraGra().getTypeSet().getTypeUsers(ea.getType()))).isEmpty()) {
                int i = 0;
                while (i < vec.size()) {
                    EdGraphObject go = vec.get(i);
                    if (go.getContext().getGraGra() == null) {
                        System.out.println(String.valueOf(go.getContext().getName()) + "   " + go.getBasisObject() + "       GraGra NULL");
                    }
                    ++i;
                }
                this.activePanel.getGraph().addChangedAttributeToUndo(vec);
            }
        }
        return this.attrEditor;
    }

    public GraGraTransform getGraGraTransform() {
        return this.gragraTransform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGraphics() {
        GraGraEditor graGraEditor = this;
        synchronized (graGraEditor) {
            this.ruleEditor.getLeftPanel().updateGraphics();
            this.ruleEditor.getRightPanel().updateGraphics();
            this.ruleEditor.getLeftCondPanel().updateGraphics();
            this.graphEditor.getGraphPanel().updateGraphics(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateGraphics(boolean resizeGraphPanelIfNeeded) {
        GraGraEditor graGraEditor = this;
        synchronized (graGraEditor) {
            this.ruleEditor.getLeftPanel().updateGraphics();
            this.ruleEditor.getRightPanel().updateGraphics();
            this.ruleEditor.getLeftCondPanel().updateGraphics();
            this.graphEditor.getGraphPanel().updateGraphics(resizeGraphPanelIfNeeded);
        }
    }

    protected void refreshAfterWaitBeforeApplyRule() {
        if (this.trafoEventKey == 17 && this.ruleEditor.getRule().getBasisRule().isWaitBeforeApplyEnabled()) {
            this.graphEditor.getGraph().clearMarks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ruleEditorUpdateGraphics() {
        GraGraEditor graGraEditor = this;
        synchronized (graGraEditor) {
            this.ruleEditor.getLeftPanel().updateGraphics();
            this.ruleEditor.getRightPanel().updateGraphics();
            this.ruleEditor.getNACPanel().updateGraphics();
        }
    }

    protected void graphEditorUpdateGraphics(boolean resizeGraphPanelIfNeeded) {
        this.graphEditor.getGraphPanel().updateGraphics(resizeGraphPanelIfNeeded);
    }

    public void clear() {
        this.typeEditor.removeAll();
        this.setGraGra(null);
        this.graphEditor.setGraph(null);
        this.ruleEditor.setNAC(null);
        this.ruleEditor.setPAC(null);
        this.ruleEditor.setRule(null);
        this.pacMorphs.setGraGra(null);
        this.pacMorphs.setAtomApplCond(null);
        this.nodeAnimation.dispose();
        this.updateGraphics();
        this.fireEditEvent(new EditEvent((Object)this, -7, ""));
    }

    public void setNodeIconable(boolean iconable) {
        this.iconable = iconable;
        if (this.gragra != null) {
            this.gragra.getTypeSet().setNodeIconable(iconable);
            this.updateGraphics();
        }
    }

    public void resetEnabled(boolean enable) {
        this.setEnabled(enable);
        this.edit.setEnabled(enable);
        this.mode.setEnabled(enable);
        this.transform.setEnabled(enable);
    }

    public void setMsg(String s) {
        this.fireEditEvent(new EditEvent((Object)this, -1, s));
    }

    public void setExportJPEG(GraphicsExportJPEG jpg) {
        this.exportJPEG = jpg;
        this.modePopupMenu.setExportJPEG(jpg);
        this.ruleEditor.setExportJPEG(jpg);
        this.graphEditor.setExportJPEG(jpg);
        this.pacMorphs.setExportJPEG(jpg);
        if (this.attrEditorExists) {
            ((TopEditor)this.attrEditor).setExportJPEG(jpg);
        }
    }

    public MorphCompletionStrategy getMorphCompletionStrategy() {
        return this.gragraTransform.getStrategy();
    }

    public void startLayeredTransform() {
        this.layeredTransform = this.gragraTransform.createRuleLayerTransform();
        this.layering = true;
        this.gragraTransform.startTransformLayered(this.getGraGra());
    }

    public void startInterpreterTransform() {
        if (this.gragraTransform.priorityEnabled()) {
            this.interpreter = this.gragraTransform.createRulePriorityTransform();
            this.interpreting = true;
            this.gragraTransform.startRulePriorityTransformInterpreter(this.getGraGra());
        } else {
            this.interpreter = this.gragraTransform.createInterpreterTransform();
            this.interpreting = true;
            this.gragraTransform.startTransformInterpreter(this.getGraGra());
        }
    }

    public void startRuleSequenceTransform() {
        if (this.gragra.getBasisGraGra().getCurrentRuleSequence() != null) {
            if (this.gragra.getBasisGraGra().getCurrentRuleSequence().isGraphUsedInObjFlow() && this.gragra.getBasisGraGra().getGraph() != this.gragra.getBasisGraGra().getCurrentRuleSequence().getGraph()) {
                JOptionPane.showMessageDialog(this.applFrame, "The current graph and the graph of output objects \nof the object flow of the current sequence must be the same.\nPlease select the graph : " + this.gragra.getBasisGraGra().getCurrentRuleSequence().getGraph().getName(), "Cannot transform!", 0);
                this.brakeTrafoRS();
                return;
            }
            if (!this.gragra.getBasisGraGra().getCurrentRuleSequence().isObjFlowValid()) {
                String error = "";
                if (this.gragra.getBasisGraGra().getCurrentRuleSequence().getMessageOfInvalidObjectFlow() == 0) {
                    error = "\n( transitive closure failed )";
                } else if (this.gragra.getBasisGraGra().getCurrentRuleSequence().getMessageOfInvalidObjectFlow() == 1) {
                    error = "\n( persistent object flow failed )";
                }
                JOptionPane.showMessageDialog(this.applFrame, "Object flow of the current rule sequence is not valid!" + error, "Cannot transform!", 0);
                return;
            }
            this.transformRuleSequences = this.gragra.getBasisGraGra().trafoByApplicableRuleSequence() ? this.gragraTransform.createRuleSequenceTransform(true) : this.gragraTransform.createRuleSequenceTransform(false);
            this.sequences = true;
            this.gragraTransform.startTransformByRuleSequence(this.gragra, this.gragra.getBasisGraGra().getCurrentRuleSequence());
        }
    }

    private void brakeTrafoRS() {
        this.getGraGra().getGraph().setTransformChangeEnabled(false);
        if (this.sequences) {
            this.sleep = false;
            this.resetIconsIfTransformInterpret(true);
            this.resetMoveEditMode();
            this.disableStopMenuItem();
            this.buttonT.setEnabled(true);
            this.buttonLayout.setEnabled(true);
            if (this.transformRuleSequences != null) {
                this.removeEditEventListener(this.transformRuleSequences);
                this.transformRuleSequences.dispose();
            }
            this.sequences = false;
            this.addEditEventListener(this.gragraTransform.getTransformDebugger());
            if (this.gragraTransform.checkRuleApplicabilityEnabled()) {
                this.gragraTransform.getApplicableRules(this.getGraGra());
            }
            this.fireEditEvent(new EditEvent((Object)this, -1, "Transformation of  <" + this.getGraGra().getName() + "  broken"));
        }
        this.selectToolBarTransformItem("");
        this.typeEditor.setEnabled(true);
        if (this.undoManager != null && this.undoManager.isEnabled() && this.undoManager.canUndo()) {
            this.buttonUndo.setEnabled(true);
            if (this.undoManager.canRedo()) {
                this.buttonRedo.setEnabled(true);
            }
            this.setUndoStepButtonEnabled(true);
        }
        if (this.getGraGra().isAnimated()) {
            this.undoManager.setEnabled(true);
        }
        if (this.applFrame instanceof AGGAppl) {
            ((AGGAppl)this.applFrame).getGraGraTreeView().getTree().treeDidChange();
        }
        if (this.evolutionaryLayouter.getWriteMetricValues() && this.jpgPath != null && !this.jpgPath.equals("")) {
            this.writeMetricValues(String.valueOf(this.jpgPath) + File.separator + this.getGraGra().getFileName() + "_metrics.log");
        }
        this.setActivePanel(this.graphEditor.getGraphPanel());
    }

    public boolean isEditable() {
        if (!this.getGraGra().getGraph().isEditable()) {
            this.updateGraphics();
            JOptionPane.showMessageDialog(this.applFrame, "Grammar is locked by Critical Pair Analysis \nor transformation is running.", "Cannot transform", 2);
            return false;
        }
        return true;
    }

    public boolean isImageViewModeSelected() {
        return this.mode.getItem(7).isSelected();
    }

    public boolean isAnimationRunning() {
        return this.animationThread;
    }

    public NodeAnimation getNodeAnimation() {
        return this.nodeAnimation;
    }

    public boolean isGraGraReadyToTransform(EdGraGra gg) {
        String msgstr = "";
        if (!gg.getBasisGraGra().isGraphReadyForTransform()) {
            msgstr = "The host graph of this grammar is not fine.\nPlease check attribute settings of the objects.";
        } else {
            Pair<Object, String> obj = gg.getBasisGraGra().isReadyToTransform(true);
            if (obj != null) {
                if (obj instanceof Rule) {
                    msgstr = "The rule  <" + ((Rule)((Object)obj)).getName() + ">  of this grammar is not fine.\n" + "Please check attribute settings of the objects.";
                } else if (obj instanceof AtomConstraint) {
                    msgstr = "The graph constraint  <" + ((AtomConstraint)((Object)obj)).getName() + ">  of this grammar is not fine.\n" + "Please check attribute settings of the objects.";
                }
            } else if (this.gragraTransform.ruleSequenceEnabled() && gg.getBasisGraGra().getCurrentRuleSequence() == null) {
                JOptionPane.showMessageDialog(this.applFrame, "Graph transformation by Rule Sequence failed.\nThere isn't any rule sequence defined.", "Cannot transform!", 2);
                this.selectToolBarTransformItem("");
                this.setEditMode(this.lasteditmode);
                return false;
            }
        }
        if (!msgstr.equals("")) {
            this.updateGraphics();
            JOptionPane.showMessageDialog(this.applFrame, "Not ready to transform!\n" + msgstr, "Cannot transform", 0);
            this.selectToolBarTransformItem("");
            this.setEditMode(this.lasteditmode);
            return false;
        }
        return true;
    }

    public void doPrepareTransformProc() {
        this.resetIconsIfTransformInterpret(false);
        this.lasteditmode = this.getEditMode();
        this.setEditMode(9);
        this.gragraTransform.getApplicableRules(this.getGraGra(), true);
        this.buttonT.setEnabled(false);
        this.buttonUndo.setEnabled(false);
        this.buttonUndoStep.setEnabled(false);
        this.buttonRedo.setEnabled(false);
        this.buttonLayout.setEnabled(false);
    }

    public void doStopTransformLayeredProc() {
        this.sleep = false;
        this.gragraTransform.stopTransformLayered();
        if (!this.gragraTransform.breakAllLayerEnabled()) {
            this.selectToolBarTransformItem("start");
        }
    }

    public void doStopTransformInterpreterProc() {
        this.sleep = false;
        if (this.interpreter == this.gragraTransform.getInterpreterTransform()) {
            this.gragraTransform.stopTransformInterpreter();
        } else {
            this.gragraTransform.stopRulePriorityTransformInterpreter();
        }
    }

    public void doStopTransformRuleSequencesProc() {
        this.sleep = false;
        this.gragraTransform.stopTransformRuleSequences();
    }

    public void doPrepareInteractiveMatchProc() {
        this.lasteditmode = this.getEditMode();
        if (this.getGraGra() != null && this.ruleEditor.getRule() != null) {
            if (!this.getGraGra().getGraph().isEditable()) {
                JOptionPane.showMessageDialog(this.applFrame, "<html><body>Grammar is locked by critical pair analysis<br> or transformation is already running.</body<</html>", "Cannot transform", 2);
                return;
            }
            if (!this.ruleEditor.getRule().isEditable()) {
                return;
            }
            if (!(this.interpreting || this.layering || this.sequences)) {
                ((AttrTupleManager)AttrTupleManager.getDefaultManager()).setVariableContext(false);
                this.forwardModeCommand("Move");
                this.selectToolBarTransformItem("match");
                if (this.graphEditor.getGraph().adjustTypeObjectsMap()) {
                    this.getGraGra().destroyAllMatches();
                    this.gragra.getBasisGraGra().getMorphismCompletionStrategy().resetTypeMap(this.gragra.getBasisGraGra().getGraph());
                }
                if (this.gragraTransform.checkRuleApplicabilityEnabled() && !this.gragraTransform.getApplicableRules(this.getGraGra()).contains(this.ruleEditor.getRule().getBasisRule())) {
                    JOptionPane.showMessageDialog(this.applFrame, "Current rule isn't applicable. \nPlease select an applicable rule.", "Cannot match", 2);
                    this.selectToolBarTransformItem("");
                    return;
                }
                this.gragraTransform.matchDef(this.ruleEditor.getRule());
            }
        }
    }

    public void doPrepareCompletionMatchProc() {
        if (this.getGraGra() != null && this.ruleEditor.getRule() != null) {
            if (!this.getGraGra().getGraph().isEditable()) {
                JOptionPane.showMessageDialog(this.applFrame, "Grammar is locked by critical pair analysis \nor transformation is already running.", "Cannot transform", 2);
                return;
            }
            if (!this.ruleEditor.getRule().isEditable()) {
                return;
            }
            ((AttrTupleManager)AttrTupleManager.getDefaultManager()).setVariableContext(false);
            if (!(this.interpreting || this.layering || this.sequences)) {
                if (this.tmpTransformThread == null || !this.tmpTransformThread.isAlive()) {
                    this.selectToolBarTransformItem("completion");
                    if (this.graphEditor.getGraph().adjustTypeObjectsMap()) {
                        this.getGraGra().destroyAllMatches();
                        this.gragra.getBasisGraGra().getMorphismCompletionStrategy().resetTypeMap(this.gragra.getBasisGraGra().getGraph());
                    }
                    if (this.ruleEditor.isObjMapping()) {
                        this.ruleEditor.resetEditModeAfterMapping();
                    }
                    if (this.editmode == 42) {
                        this.setEditMode(this.lasteditmode);
                    }
                    this.gragraTransform.nextCompletion(this.ruleEditor.getRule());
                } else {
                    this.fireEditEvent(new EditEvent((Object)this, -1, " next completion ... Please wait. "));
                }
            }
        }
    }

    public void doExecuteStepProc() {
        if (this.getGraGra() == null || this.ruleEditor.getRule() == null || this.graphEditor.getGraph() == null || this.graphEditor.getGraph().isTypeGraph() || !this.isEditable()) {
            return;
        }
        if (this.evolutionaryLayouter.isEnabled() && this.getGraph().getGraphGen() == 0) {
            this.getGraph().incGraphGen();
        } else {
            this.getGraGra().getGraph().enableDefaultGraphLayout(true);
        }
        ((AttrTupleManager)AttrTupleManager.getDefaultManager()).setVariableContext(false);
        if (!(this.interpreting || this.layering || this.sequences)) {
            this.getGraph().setTransformChangeEnabled(true);
            if (this.undoManager != null && this.undoManager.isEnabled()) {
                this.undoManager.setUndoEndOfTransformStepAllowed(true);
            }
            if (!(this.tmpTransformThread != null && this.tmpTransformThread.isAlive() || this.buttonStep.isSelected())) {
                this.selectToolBarTransformItem("step");
                this.resetMoveEditMode();
                this.graphEditor.getGraph().adjustTypeObjectsMap();
                this.gragraTransform.step(this.ruleEditor.getRule());
            } else {
                this.fireEditEvent(new EditEvent((Object)this, -1, " transformation step ... Please wait. "));
            }
        }
    }

    protected void setNodeAnimation(Match m) {
        EdRule r;
        if (m != null && (r = this.getGraGra().getRule(m.getRule())).isAnimated()) {
            this.animationThread = this.nodeAnimation.prepareAnimation(r, this.getGraph(), (Graphics2D)this.graphEditor.getGraphPanel().getCanvas().getGraphics());
        }
    }

    protected void runAnimationThread() {
        if (this.animationThread) {
            this.getGraph().enableStaticNodePosition();
            this.getGraph().setStraightenArcs(true);
            if (!this.nodeToAnimateOnfront) {
                this.getGraph().setNodeOfAnimatedTypeToFront();
                this.nodeToAnimateOnfront = true;
            }
            this.nodeAnimation.animate();
            this.animationThread = false;
        }
    }

    private void loadDataInEditor(GraGraTreeNodeData data) {
        this.gra = null;
        this.graph = null;
        this.rule = null;
        this.nac = null;
        this.pac = null;
        this.ac = null;
        this.atomicConstr = null;
        this.postApplCond = null;
        this.resetGraGra = false;
        this.wasPostAtomApplCond = this.isPostAtomApplCond;
        this.isPostAtomApplCond = false;
        if (data.isGraGra() && data.getGraGra() != null && data.getGraGra().getBasisGraGra() != null) {
            this.gra = this.loadGrammarInEditor(data);
        } else if (data.isGraph() && data.getGraph() != null && data.getGraph().getBasisGraph() != null) {
            this.graph = this.loadGraphInEditor(data);
        } else if (data.isAtomic() && data.getAtomic() != null && data.getAtomic().getBasisAtomic() != null) {
            this.atomicConstr = this.loadAtomicConstraintInEditor(data);
        } else if (data.isConclusion() && data.getConclusion() != null && data.getConclusion().getBasisAtomic() != null) {
            this.atomicConstr = this.loadConclusionOfAtomicInEditor(data);
        } else if (data.isRuleScheme() && data.getRuleScheme() != null && data.getRuleScheme().getBasisRule() != null) {
            this.rule = this.loadRuleInEditor(data);
        } else if (data.isRule() && data.getRule() != null && data.getRule().getBasisRule() != null) {
            this.rule = this.loadRuleInEditor(data);
        } else if (data.isConstraint()) {
            this.loadFormulaInEditor(data);
        } else if (data.isRuleConstraint() && data.getTreeNode() != null) {
            this.postApplCond = this.loadPostApplCondOfRuleInEditor(data);
        } else if (data.isAtomApplCond() && data.getAtomApplCond() != null && data.getTreeNode() != null) {
            this.postApplCond = this.loadAtomicOfPostAplCondOfRuleInEditor(data);
        } else if (data.isNAC() && data.getNAC() != null && data.getNAC().getBasisGraph() != null) {
            this.nac = this.loadNACInEditor(data);
        } else if (data.isPAC() && data.getPAC() != null && data.getPAC().getBasisGraph() != null) {
            this.pac = this.loadPACInEditor(data);
        } else if (data.isNestedAC() && data.getNestedAC() != null && data.getNestedAC().getBasisGraph() != null) {
            this.ac = this.loadNestedACInEditor(data);
        } else if (data.isAttrCondition()) {
            this.loadAttrConditionInEditor(data);
        }
        if (this.hasAttrEditorOnTop()) {
            this.attrTypeChangedWarning();
            if (this.rule != null && this.rule != this.ruleEditor.getRule()) {
                this.ruleEditor.setRule(this.rule);
            }
            this.resetRuleEditor();
        } else if (this.hasAttrEditorOnBottom() && !data.isAttrCondition()) {
            this.attrTypeChangedWarning();
            this.resetGraphEditor();
        }
        if (this.wasPostAtomApplCond != this.isPostAtomApplCond) {
            this.resetRuleEditor();
        }
        if (this.resetGraGra) {
            this.loadDataInEditorResetGraGra(data);
        }
        this.fireEditEvent(new EditEvent((Object)this, -9, ""));
    }

    private EdGraGra loadGrammarInEditor(GraGraTreeNodeData data) {
        if (!this.attrEditorExists) {
            this.setAttrEditor();
        }
        if (data.getGraGra() != this.gragra) {
            this.resetGraGra = true;
            this.dividerLocation = this.splitPane.getDividerLocation();
            this.dividerLocation1 = this.typeEditor.getTypePalette().getDividerLocation();
            this.graph = data.getGraGra().getGraph();
            if (!data.getGraGra().getRules().isEmpty()) {
                this.rule = data.getGraGra().getRules().firstElement();
                if (this.rule.getMatch() != null) {
                    this.rule.update();
                    this.graph.update();
                }
                if (!this.rule.getNACs().isEmpty()) {
                    this.nac = this.rule.getNACs().firstElement();
                } else if (!this.rule.getPACs().isEmpty()) {
                    this.pac = this.rule.getPACs().firstElement();
                }
            }
            ((AGGAppl)this.applFrame).setPreferenceNoArcParallel(!data.getGraGra().getTypeSet().getBasisTypeSet().isArcParallel());
        }
        return data.getGraGra();
    }

    private EdGraph loadGraphInEditor(GraGraTreeNodeData data) {
        if (data.getGraph() != this.graphEditor.getGraph() || this.graphEditor.isEmpty()) {
            if (this.gragra == null || data.getGraph().getGraGra() != this.gragra) {
                this.resetGraGra = true;
                this.gra = data.getGraph().getGraGra();
                if (!data.getGraph().isTypeGraph()) {
                    this.gra.resetGraph(data.getGraph());
                }
                if (!this.gra.getRules().isEmpty()) {
                    this.rule = this.gra.getRules().firstElement();
                }
                if (this.rule != null && !this.rule.getNACs().isEmpty()) {
                    this.nac = this.rule.getNACs().firstElement();
                } else if (this.rule != null && !this.rule.getPACs().isEmpty()) {
                    this.pac = this.rule.getPACs().firstElement();
                }
            } else if (!data.getGraph().isTypeGraph()) {
                if (this.gragra.getGraph() != data.getGraph()) {
                    this.gragra.resetGraph(data.getGraph());
                }
                data.setData(data.getGraph());
                this.graphEditor.setGraph(data.getGraph());
                this.graphEditor.updateGraphics();
            } else {
                this.graphEditor.setGraph(data.getGraph());
                this.graphEditor.updateGraphics();
            }
        }
        this.setMsg(this.graphEditor.getMsg());
        return data.getGraph();
    }

    private EdAtomic loadAtomicConstraintInEditor(GraGraTreeNodeData data) {
        this.atomicConstr = data.getAtomic();
        if (data.getAtomic() != this.ruleEditor.getAtomic()) {
            this.dividerLocation = this.splitPane.getDividerLocation();
            if (this.ruleEditor.getAtomic() != null) {
                this.dividerLocationSet.put(this.ruleEditor.getAtomic(), this.splitPane.getDividerLocation());
            }
            if (this.gragra == null || data.getAtomic().getGraGra() != this.gragra) {
                this.resetGraGra = true;
                this.gra = data.getAtomic().getGraGra();
                this.graph = this.gra.getGraph();
                if (data.getAtomic().isParent()) {
                    this.atomicConstr = data.getAtomic().getConclusion(0);
                }
            } else {
                if (this.ruleEditor.getAtomic() != null) {
                    if (this.atomicConstr.isParent()) {
                        this.atomicConstr = this.ruleEditor.getAtomic().getParent() != data.getAtomic() ? data.getAtomic().getConclusion(0) : null;
                    }
                } else if (data.getAtomic().isParent()) {
                    this.atomicConstr = data.getAtomic().getConclusion(0);
                }
                if (this.atomicConstr != null) {
                    this.atomicConstr.update();
                    this.ruleEditor.setAtomic(this.atomicConstr);
                    if (this.dividerLocationSet.get(this.atomicConstr) != null) {
                        this.splitPane.setDividerLocation(this.dividerLocationSet.get(this.atomicConstr));
                    }
                    this.ruleEditor.updateGraphics();
                }
            }
        }
        this.resetEnabledOfMenus(data, false);
        this.resetEnabledOfToolBarItems(data, false);
        return this.atomicConstr;
    }

    private EdAtomic loadConclusionOfAtomicInEditor(GraGraTreeNodeData data) {
        if (data.getConclusion() != this.ruleEditor.getAtomic()) {
            if (this.gragra == null || data.getConclusion().getGraGra() != this.gragra) {
                this.resetGraGra = true;
                this.gra = data.getConclusion().getGraGra();
                this.graph = this.gra.getGraph();
            } else {
                data.getConclusion().update();
                this.ruleEditor.setAtomic(data.getConclusion());
                this.ruleEditor.updateGraphics();
                if (this.ruleEditor.isObjMapping()) {
                    this.ruleEditor.resetEditModeAfterMapping();
                }
            }
        } else {
            String s = data.getConclusion().getBasisAtomic().getAtomicName();
            this.ruleEditor.setAtomicTitle(data.getConclusion().getBasisAtomic().getName(), s);
        }
        this.resetEnabledOfMenus(data, false);
        this.resetEnabledOfToolBarItems(data, false);
        return data.getConclusion();
    }

    private EdRule loadRuleInEditor(GraGraTreeNodeData data) {
        boolean done = false;
        this.dividerLocation = this.splitPane.getDividerLocation();
        if (data.getRule() != this.ruleEditor.getRule()) {
            if (this.ruleEditor.getRule() != null) {
                this.dividerLocationSet.put(this.ruleEditor.getRule(), this.splitPane.getDividerLocation());
            }
            if (this.gragra == null || data.getRule().getGraGra() != this.gragra) {
                this.resetGraGra = true;
                this.gra = data.getRule().getGraGra();
                this.graph = this.gra.getGraph();
                this.rule = data.getRule();
                if (!data.getRule().getNACs().isEmpty()) {
                    this.nac = data.getRule().getNACs().firstElement();
                } else if (!data.getRule().getPACs().isEmpty()) {
                    this.pac = data.getRule().getPACs().firstElement();
                }
            }
            if (!this.resetGraGra) {
                if (data.getRule().getBasisRule() instanceof AmalgamatedRule) {
                    if (data.getRule().getBasisRule().getRuleScheme() != null) {
                        this.ruleEditor.setRule(data.getRule());
                        done = true;
                    }
                } else {
                    this.ruleEditor.setRule(data.getRule());
                    done = true;
                    if (!data.getRule().getNACs().isEmpty()) {
                        this.nac = data.getRule().getNACs().firstElement();
                        this.ruleEditor.setNAC(this.nac);
                    } else if (!data.getRule().getPACs().isEmpty()) {
                        this.pac = data.getRule().getPACs().firstElement();
                        this.ruleEditor.setPAC(this.pac);
                    } else {
                        this.ruleEditor.setNestedAC(null);
                    }
                }
            }
        } else if (data.getRule().getLeft() != this.ruleEditor.getLeftPanel().getGraph() || data.getRule().getRight() != this.ruleEditor.getRightPanel().getGraph()) {
            this.ruleEditor.resetRule();
            done = true;
        } else if (!this.ruleEditor.isRightPanelVisible()) {
            this.ruleEditor.resetRule();
            done = true;
        } else {
            this.ruleEditor.setNAC(null);
            this.ruleEditor.setPAC(null);
            this.ruleEditor.setNestedAC(null);
            done = true;
        }
        if (done) {
            if (this.dividerLocationSet.get(this.ruleEditor.getRule()) != null) {
                this.splitPane.setDividerLocation(this.dividerLocationSet.get(this.ruleEditor.getRule()));
            } else {
                this.splitPane.setDividerLocation(this.dividerLocation);
            }
        }
        if (!(this.interpreting || this.layering || this.sequences)) {
            this.resetEnabledOfMenus(data, false);
            this.resetEnabledOfToolBarItems(data, false);
        }
        return data.getRule();
    }

    private void loadFormulaInEditor(GraGraTreeNodeData data) {
        this.gra = data.getConstraint().getGraGra();
        if (this.gra != null && this.gra != this.gragra) {
            this.resetGraGra = true;
            this.dividerLocation = this.splitPane.getDividerLocation();
            this.graph = this.gra.getGraph();
            if (!this.gra.getRules().isEmpty()) {
                this.rule = this.gra.getRules().firstElement();
                if (this.rule.getMatch() != null) {
                    this.rule.update();
                    this.graph.update();
                }
            }
            if (this.rule != null && !this.rule.getNACs().isEmpty()) {
                this.nac = this.rule.getNACs().firstElement();
            } else if (this.rule != null && !this.rule.getPACs().isEmpty()) {
                this.pac = this.rule.getPACs().firstElement();
            }
        }
    }

    private EdAtomApplCond loadPostApplCondOfRuleInEditor(GraGraTreeNodeData data) {
        DefaultMutableTreeNode node = data.getTreeNode();
        if (node.getChildCount() != 0) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(0);
            GraGraTreeNodeData c = (GraGraTreeNodeData)child.getUserObject();
            this.postApplCond = c.getAtomApplCond();
            if (this.gragra != null) {
                this.gra = ((GraGraTreeNodeData)((DefaultMutableTreeNode)node.getParent().getParent()).getUserObject()).getGraGra();
                this.rule = ((GraGraTreeNodeData)((DefaultMutableTreeNode)node.getParent()).getUserObject()).getRule();
                if (this.gra != this.gragra) {
                    this.resetGraGra = true;
                    this.graph = this.gra.getGraph();
                }
                this.pacMorphs.setGraGra(this.gra);
                this.pacMorphs.setRule(this.rule);
                this.pacMorphs.setAtomApplCond(this.postApplCond.getAtomApplCond());
                this.resetEnabledOfMenus(c, false);
                this.resetEnabledOfToolBarItems(c, false);
                this.isPostAtomApplCond = true;
            }
            return this.postApplCond;
        }
        return null;
    }

    private EdAtomApplCond loadAtomicOfPostAplCondOfRuleInEditor(GraGraTreeNodeData data) {
        DefaultMutableTreeNode node = data.getTreeNode();
        this.postApplCond = data.getAtomApplCond();
        if (this.gragra != null) {
            this.gra = ((GraGraTreeNodeData)((DefaultMutableTreeNode)node.getParent().getParent().getParent()).getUserObject()).getGraGra();
            this.rule = ((GraGraTreeNodeData)((DefaultMutableTreeNode)node.getParent().getParent()).getUserObject()).getRule();
            if (this.gra != this.gragra) {
                this.resetGraGra = true;
                this.graph = this.gra.getGraph();
            }
            this.pacMorphs.setGraGra(this.gra);
            this.pacMorphs.setRule(this.rule);
            this.pacMorphs.setAtomApplCond(this.postApplCond.getAtomApplCond());
            this.resetEnabledOfMenus(data, false);
            this.resetEnabledOfToolBarItems(data, false);
            this.isPostAtomApplCond = true;
        }
        return this.postApplCond;
    }

    private EdNAC loadNACInEditor(GraGraTreeNodeData data) {
        if (this.gragra == null || data.getNAC().getRule().getGraGra() != this.gragra) {
            this.resetGraGra = true;
            this.rule = data.getNAC().getRule();
            this.gra = this.rule.getGraGra();
            this.graph = this.gra.getGraph();
        } else if (data.getNAC().getRule() != this.ruleEditor.getRule()) {
            this.rule = data.getNAC().getRule();
            this.ruleEditor.setRule(this.rule);
            this.ruleEditor.setNAC(data.getNAC());
            if (this.dividerLocationSet.get(this.rule) != null) {
                int divloc = this.dividerLocationSet.get(this.rule);
                if (this.dividerLocationSet.get(data.getNAC()) != null) {
                    int divloc1 = this.dividerLocationSet.get(data.getNAC());
                    if (divloc >= divloc1) {
                        this.splitPane.setDividerLocation(divloc);
                    } else {
                        this.splitPane.setDividerLocation(divloc1);
                    }
                } else {
                    this.splitPane.setDividerLocation(this.dividerLocationSet.get(this.rule));
                }
            } else {
                this.splitPane.setDividerLocation(this.dividerLocation);
            }
            this.ruleEditor.updateGraphics();
            if (this.ruleEditor.isObjMapping()) {
                this.ruleEditor.resetEditModeAfterMapping();
            }
        } else if (data.getNAC() != this.ruleEditor.getNAC()) {
            this.dividerLocation = this.splitPane.getDividerLocation();
            if (this.ruleEditor.getNAC() != null) {
                this.dividerLocationSet.put(this.ruleEditor.getNAC(), this.splitPane.getDividerLocation());
            } else if (this.ruleEditor.getPAC() != null) {
                this.dividerLocationSet.put(this.ruleEditor.getPAC(), this.splitPane.getDividerLocation());
            } else if (this.ruleEditor.getNestedAC() != null) {
                this.dividerLocationSet.put(this.ruleEditor.getNestedAC(), this.splitPane.getDividerLocation());
            }
            this.ruleEditor.setNAC(data.getNAC());
            if (this.dividerLocationSet.get(data.getNAC()) != null) {
                this.splitPane.setDividerLocation(this.dividerLocationSet.get(data.getNAC()));
            }
            if (this.ruleEditor.isObjMapping()) {
                this.ruleEditor.resetEditModeAfterMapping();
            }
        }
        this.resetEnabledOfMenus(data, false);
        this.resetEnabledOfToolBarItems(data, false);
        return data.getNAC();
    }

    private EdPAC loadPACInEditor(GraGraTreeNodeData data) {
        if (this.gragra == null || data.getPAC().getRule().getGraGra() != this.gragra) {
            this.resetGraGra = true;
            this.rule = data.getPAC().getRule();
            this.gra = this.rule.getGraGra();
            this.graph = this.gra.getGraph();
        } else if (data.getPAC().getRule() != this.ruleEditor.getRule()) {
            this.rule = data.getPAC().getRule();
            this.ruleEditor.setRule(this.rule);
            this.ruleEditor.setPAC(data.getPAC());
            if (this.dividerLocationSet.get(this.rule) != null) {
                int divloc = this.dividerLocationSet.get(this.rule);
                if (this.dividerLocationSet.get(data.getPAC()) != null) {
                    int divloc1 = this.dividerLocationSet.get(data.getPAC());
                    if (divloc >= divloc1) {
                        this.splitPane.setDividerLocation(divloc);
                    } else {
                        this.splitPane.setDividerLocation(divloc1);
                    }
                } else {
                    this.splitPane.setDividerLocation(this.dividerLocationSet.get(this.rule));
                }
            } else {
                this.splitPane.setDividerLocation(this.dividerLocation);
            }
            this.ruleEditor.updateGraphics();
            if (this.ruleEditor.isObjMapping()) {
                this.ruleEditor.resetEditModeAfterMapping();
            }
        } else if (data.getPAC() != this.ruleEditor.getPAC()) {
            this.dividerLocation = this.splitPane.getDividerLocation();
            if (this.ruleEditor.getPAC() != null) {
                this.dividerLocationSet.put(this.ruleEditor.getPAC(), this.splitPane.getDividerLocation());
            } else if (this.ruleEditor.getNAC() != null) {
                this.dividerLocationSet.put(this.ruleEditor.getNAC(), this.splitPane.getDividerLocation());
            } else if (this.ruleEditor.getNestedAC() != null) {
                this.dividerLocationSet.put(this.ruleEditor.getNestedAC(), this.splitPane.getDividerLocation());
            }
            this.ruleEditor.setPAC(data.getPAC());
            if (this.dividerLocationSet.get(data.getPAC()) != null) {
                this.splitPane.setDividerLocation(this.dividerLocationSet.get(data.getPAC()));
            }
            if (this.ruleEditor.isObjMapping()) {
                this.ruleEditor.resetEditModeAfterMapping();
            }
        }
        this.resetEnabledOfMenus(data, false);
        this.resetEnabledOfToolBarItems(data, false);
        return data.getPAC();
    }

    private EdNestedApplCond loadNestedACInEditor(GraGraTreeNodeData data) {
        if (this.gragra == null || data.getNestedAC().getRule().getGraGra() != this.gragra) {
            this.resetGraGra = true;
            this.rule = data.getNestedAC().getRule();
            this.gra = this.rule.getGraGra();
            this.graph = this.gra.getGraph();
        } else if (data.getNestedAC().getRule() != this.ruleEditor.getRule()) {
            this.dividerLocation = this.splitPane.getDividerLocation();
            if (this.ruleEditor.getNestedAC() != null) {
                this.dividerLocationSet.put(this.ruleEditor.getNestedAC(), this.splitPane.getDividerLocation());
            } else if (this.ruleEditor.getNAC() != null) {
                this.dividerLocationSet.put(this.ruleEditor.getNAC(), this.splitPane.getDividerLocation());
            } else if (this.ruleEditor.getPAC() != null) {
                this.dividerLocationSet.put(this.ruleEditor.getPAC(), this.splitPane.getDividerLocation());
            }
            this.rule = data.getNestedAC().getRule();
            this.ruleEditor.setRule(this.rule);
            if (this.dividerLocationSet.get(this.rule) != null) {
                this.splitPane.setDividerLocation(this.dividerLocationSet.get(this.rule));
            }
            this.ruleEditor.setNestedAC(null);
            if (this.ruleEditor.isObjMapping()) {
                this.ruleEditor.resetEditModeAfterMapping();
            }
        } else if (data.getNestedAC() != this.ruleEditor.getNestedAC()) {
            this.dividerLocation = this.splitPane.getDividerLocation();
            if (this.ruleEditor.getNestedAC() != null) {
                this.dividerLocationSet.put(this.ruleEditor.getNestedAC(), this.splitPane.getDividerLocation());
            } else if (this.ruleEditor.getNAC() != null) {
                this.dividerLocationSet.put(this.ruleEditor.getNAC(), this.splitPane.getDividerLocation());
            } else if (this.ruleEditor.getPAC() != null) {
                this.dividerLocationSet.put(this.ruleEditor.getPAC(), this.splitPane.getDividerLocation());
            }
            this.ruleEditor.setNestedAC(data.getNestedAC());
            if (this.dividerLocationSet.get(data.getNestedAC()) != null) {
                this.splitPane.setDividerLocation(this.dividerLocationSet.get(data.getNestedAC()));
            }
            if (this.ruleEditor.isObjMapping()) {
                this.ruleEditor.resetEditModeAfterMapping();
            }
        } else if (this.ruleEditor.isRightPanelVisible()) {
            this.ruleEditor.setNestedAC(data.getNestedAC());
        }
        this.resetEnabledOfMenus(data, false);
        this.resetEnabledOfToolBarItems(data, false);
        return data.getNestedAC();
    }

    private void loadAttrConditionInEditor(GraGraTreeNodeData data) {
        if (this.ruleEditor.getAtomic() != null) {
            Pair<CondMember, EdRule> attrCond = data.getAttrCondition();
            if (attrCond.second instanceof EdAtomic) {
                this.atomicConstr = (EdAtomic)attrCond.second;
                if (this.atomicConstr.getParent().getGraGra() != this.gragra) {
                    this.resetGraGra = true;
                    this.gra = this.atomicConstr.getParent().getGraGra();
                    this.graph = this.gra.getGraph();
                } else if (this.atomicConstr != this.ruleEditor.getAtomic()) {
                    this.ruleEditor.setAtomic(this.atomicConstr);
                }
                this.setAttrEditorOnBottom(this.attrEditor.getComponent());
                this.attrEditor.setContext(this.atomicConstr.getMorphism().getAttrContext());
                ((TopEditor)this.attrEditor).selectContextEditor(true);
                ((TopEditor)this.attrEditor).setTuple(null);
            } else {
                this.rule = (EdRule)attrCond.second;
                if (this.rule.getGraGra() != this.gragra) {
                    this.resetGraGra = true;
                    this.gra = this.rule.getGraGra();
                    this.graph = this.gra.getGraph();
                } else if (this.rule != this.ruleEditor.getRule()) {
                    this.ruleEditor.setRule(this.rule);
                }
                if (this.hasAttrEditorOnTop()) {
                    this.resetRuleEditor();
                }
                this.setAttrEditorOnBottom(this.attrEditor.getComponent());
                this.attrEditor.setContext(this.rule.getBasisRule().getAttrContext());
                ((TopEditor)this.attrEditor).selectContextEditor(true);
                ((TopEditor)this.attrEditor).setTuple(null);
            }
        } else if (this.ruleEditor.getRule() != null) {
            Pair<CondMember, EdRule> attrCond = data.getAttrCondition();
            if (attrCond.second instanceof EdAtomic) {
                this.atomicConstr = (EdAtomic)attrCond.second;
                if (this.atomicConstr.getParent().getGraGra() != this.gragra) {
                    this.resetGraGra = true;
                    this.gra = this.atomicConstr.getParent().getGraGra();
                    this.graph = this.gra.getGraph();
                } else if (this.atomicConstr != this.ruleEditor.getAtomic()) {
                    this.ruleEditor.setAtomic(this.atomicConstr);
                }
                this.setAttrEditorOnBottom(this.attrEditor.getComponent());
                this.attrEditor.setContext(this.atomicConstr.getMorphism().getAttrContext());
                ((TopEditor)this.attrEditor).selectContextEditor(true);
                ((TopEditor)this.attrEditor).setTuple(null);
            } else {
                this.rule = (EdRule)attrCond.second;
                if (this.rule.getGraGra() != this.gragra) {
                    this.resetGraGra = true;
                    this.gra = this.rule.getGraGra();
                    this.graph = this.gra.getGraph();
                } else if (this.rule != this.ruleEditor.getRule()) {
                    this.ruleEditor.setRule(this.rule);
                }
                if (this.hasAttrEditorOnTop()) {
                    this.resetRuleEditor();
                }
                this.setAttrEditorOnBottom(this.attrEditor.getComponent());
                this.attrEditor.setContext(this.rule.getBasisRule().getAttrContext());
                ((TopEditor)this.attrEditor).selectContextEditor(true);
                ((TopEditor)this.attrEditor).setTuple(null);
            }
        }
    }

    private void loadDataInEditorResetGraGra(GraGraTreeNodeData data) {
        this.setGraGra(this.gra);
        this.typeEditor.setGraGra(this.gra);
        if (this.dividerLocation1 == 0) {
            this.typeEditor.getTypePalette().setDividerLocation(this.splitPane.getHeight() / 2);
        } else {
            this.typeEditor.getTypePalette().setDividerLocation(this.dividerLocation1);
        }
        if (this.splitPane1.getRightComponent() != this.typeEditor.getTypePalette().getTypePaletteComponent()) {
            this.splitPane1.setRightComponent(this.typeEditor.getTypePalette().getTypePaletteComponent());
        }
        this.splitPane1.setDividerLocation(this.getWidth() - this.typeEditor.getTypePalette().getWidthOfPalette());
        this.graphEditor.setGraph(this.graph);
        this.resetEnabledOfMenus(data, true);
        this.resetEnabledOfToolBarItems(data, true);
        if (this.atomicConstr != null) {
            this.ruleEditor.setAtomic(this.atomicConstr);
            if (this.dividerLocationSet.get(this.atomicConstr) != null) {
                this.splitPane.setDividerLocation(this.dividerLocationSet.get(this.atomicConstr));
            } else {
                this.splitPane.setDividerLocation(this.dividerLocation);
            }
        } else if (this.rule != null) {
            this.ruleEditor.setRule(this.rule);
            if (this.nac != null) {
                this.ruleEditor.setNAC(this.nac);
            } else if (this.pac != null) {
                this.ruleEditor.setPAC(this.pac);
            } else {
                this.ac = null;
                this.ruleEditor.setNestedAC(null);
            }
            if (this.rule != null && this.dividerLocationSet.get(this.rule) != null) {
                int divloc = this.dividerLocationSet.get(this.rule);
                if (this.nac != null && this.dividerLocationSet.get(this.nac) != null) {
                    int divloc1 = this.dividerLocationSet.get(this.nac);
                    if (divloc >= divloc1) {
                        this.splitPane.setDividerLocation(divloc);
                    } else {
                        this.splitPane.setDividerLocation(divloc1);
                    }
                } else if (this.pac != null && this.dividerLocationSet.get(this.pac) != null) {
                    int divloc1 = this.dividerLocationSet.get(this.pac);
                    if (divloc >= divloc1) {
                        this.splitPane.setDividerLocation(divloc);
                    } else {
                        this.splitPane.setDividerLocation(divloc1);
                    }
                } else if (this.ac != null && this.dividerLocationSet.get(this.ac) != null) {
                    int divloc1 = this.dividerLocationSet.get(this.ac);
                    if (divloc >= divloc1) {
                        this.splitPane.setDividerLocation(divloc);
                    } else {
                        this.splitPane.setDividerLocation(divloc1);
                    }
                } else {
                    this.splitPane.setDividerLocation(this.dividerLocationSet.get(this.rule));
                }
            } else {
                this.splitPane.setDividerLocation(this.dividerLocation);
            }
        }
        this.updateGraphics();
        if (this.getEditMode() == -1) {
            this.setEditMode(11);
            this.forwardModeCommand("Draw");
        } else if (this.getGraGra().getTypeSet().isEmpty()) {
            this.setEditMode(11);
            this.forwardModeCommand("Draw");
        } else {
            if (this.ruleEditor.isObjMapping()) {
                this.ruleEditor.resetEditModeAfterMapping();
            }
            this.setEditMode(this.lasteditmode);
            this.selectToolBarModeItem(this.lasteditmode);
        }
        if (this.gragraTransform.checkRuleApplicabilityEnabled()) {
            this.gragraTransform.getApplicableRules(this.getGraGra());
        }
    }

    public void loadRuleAttrContextInEditor(EdRule r) {
        if (!(r instanceof EdRuleScheme) && this.ruleEditor.getRule() == r) {
            if (this.hasAttrEditorOnTop()) {
                this.resetRuleEditor();
            }
            this.setAttrEditorOnBottom(this.attrEditor.getComponent());
            this.attrEditor.setContext(r.getBasisRule().getAttrContext());
            ((TopEditor)this.attrEditor).selectContextEditor(true);
            ((TopEditor)this.attrEditor).setTuple(null);
        }
    }

    private void deleteDataFromEditor(GraGraTreeNodeData data) {
        if (data.isGraGra()) {
            int i = 0;
            while (i < data.getGraGra().getRules().size()) {
                this.removeRuleContextFromAttrEditor(data.getGraGra().getRules().get(i));
                ++i;
            }
            if (data.getGraGra() == this.gragra) {
                this.clear();
            }
        } else if (data.isTypeGraph()) {
            if (data.getGraph().equals(this.graphEditor.getGraph())) {
                this.graphEditor.clear();
            }
        } else if (data.isGraph() && !data.isTypeGraph()) {
            if (data.getGraph().equals(this.graphEditor.getGraph())) {
                this.graphEditor.clear();
            }
        } else if (data.isRule()) {
            this.removeRuleContextFromAttrEditor(data.getRule());
            if (data.getRule().equals(this.ruleEditor.getRule())) {
                this.ruleEditor.clear();
            }
        } else if (data.isNAC()) {
            if (data.getNAC().equals(this.ruleEditor.getNAC())) {
                this.ruleEditor.clearNAC();
            }
        } else if (data.isPAC()) {
            if (data.getPAC().equals(this.ruleEditor.getPAC())) {
                this.ruleEditor.clearPAC();
            }
        } else if (data.isNestedAC()) {
            if (data.getNestedAC().equals(this.ruleEditor.getNestedAC())) {
                this.ruleEditor.clearNestedAC();
            }
        } else if (data.isAtomic()) {
            if (data.getAtomic().equals(this.ruleEditor.getAtomic())) {
                this.ruleEditor.clear();
            }
        } else if (data.isConclusion()) {
            if (data.getConclusion().equals(this.ruleEditor.getAtomic())) {
                this.ruleEditor.clear();
            }
        } else if (data.isAtomApplCond()) {
            this.pacMorphs.setAtomApplCond(null);
        }
    }

    private void removeRuleContextFromAttrEditor(EdRule r) {
        if (this.attrEditorExists) {
            ((OpenViewSetting)this.attrEditor.getViewSetting().getOpenView()).removeFormat(r.getBasisRule().getAttrContext().getVariables().getType());
            ((OpenViewSetting)this.attrEditor.getViewSetting().getOpenView()).removeFormat(r.getBasisRule().getAttrContext().getConditions().getType());
        }
    }

    public JPopupMenu getGraphLayoutMenu() {
        return this.graphLayouts.getMenu();
    }

    private void createMainMenus() {
        this.createEditMenu();
        this.createModeMenu();
        this.createTransformMenu();
    }

    private void createEditMenu() {
        String[] editLabels = new String[]{"Undo Edit                                      Ctrl+Z", "Redo Edit                                      Ctrl+Y", "Discard All Edits                              ", "Attributes                                     Ctrl+A", "Delete                                           Ctrl+D", "Copy                                              Ctrl+C", "Paste                                            Ctrl+V", "Select Nodes of Type               Ctrl+Alt+N", "Select Edges of Type               Ctrl+Alt+E", "Select All                                     Ctrl+Alt+S", "Deselect All                                Ctrl+Alt+U", "Straighten Edges                           Ctrl+E", "Identic Rule                         Ctrl+Shift+R", "Identic NAC                          Ctrl+Shift+N", "Identic PAC                          Ctrl+Shift+P", "Identic General AC             Ctrl+Shift+A"};
        String[] editCommands = new String[]{"undo", "redo", "discardAllEdits", "attributes", "delete", "copy", "paste", "selectNodeType", "selectArcType", "selectAll", "deselectAll", "straighten", "identicRule", "identicNAC", "identicPAC", "identicAC"};
        char[] editMnemonics = new char[]{'U', 'R', ' ', 'B', 'L', 'C', ' ', 'N', 'G', 'S', 'D', 'H', 'I', ' ', ' ', ' '};
        this.edit.setMnemonic('E');
        int i = 0;
        while (i < editLabels.length) {
            JMenuItem mi = new JMenuItem(editLabels[i]);
            if (editMnemonics[i] != ' ') {
                mi.setMnemonic(editMnemonics[i]);
            }
            mi.setEnabled(true);
            mi.setActionCommand(editCommands[i]);
            mi.addActionListener(this.actionAdapter);
            this.edit.add(mi);
            if (editCommands[i].equals("discardAllEdits") || editCommands[i].equals("attributes") || editCommands[i].equals("paste") || editCommands[i].equals("deselectAll") || editCommands[i].equals("straighten")) {
                this.edit.addSeparator();
            }
            ++i;
        }
        this.mainMenus.addElement(this.edit);
    }

    private void createModeMenu() {
        String[] modeLabels = new String[]{"Draw              Shift+D", "Select            Shift+S", "Move              Shift+M", "Attributes        Shift+A", "Map                Ctrl+M", "Unmap              Ctrl+U", "Image_view"};
        String[] modeCommands = new String[]{"drawMode", "selectMode", "moveMode", "attributesMode", "mapMode", "unmapMode", "imageMode"};
        char[] modeMnemonics = new char[]{'D', 'S', 'M', 'B', 'P', 'U', 'I'};
        this.mode.setMnemonic('M');
        int i = 0;
        while (i < modeLabels.length) {
            JCheckBoxMenuItem mi = new JCheckBoxMenuItem(modeLabels[i]);
            mi.setMnemonic(modeMnemonics[i]);
            mi.setEnabled(true);
            mi.setActionCommand(modeCommands[i]);
            mi.addActionListener(this.actionAdapter);
            this.mode.add(mi);
            if (modeCommands[i].equals("unmapMode")) {
                this.mode.addSeparator();
            }
            ++i;
        }
        this.mode.getItem(0).setSelected(true);
        this.mainMenus.addElement(this.mode);
    }

    private void createTransformMenu() {
        String[] transLabels = new String[]{"Start                           Shift+Ctrl+T", "Stop                           Shift+Ctrl+Q", "Match                         Shift+Ctrl+M", "Next Completion        Shift+Ctrl+C", "Step                            Shift+Ctrl+S", "Undo Step                   Shift+Ctrl+U", "Options..."};
        String[] transCommands = new String[]{"start", "stop", "match", "completion", "step", "undoStep", "options"};
        char[] transMnemonics = new char[]{'t', 'o', 'c', 'N', 'S', 'U', ' '};
        this.transform.setMnemonic('T');
        int i = 0;
        while (i < transLabels.length) {
            JMenuItem mi = new JMenuItem(transLabels[i]);
            mi.setMnemonic(transMnemonics[i]);
            mi.setEnabled(true);
            mi.setActionCommand(transCommands[i]);
            mi.addActionListener(this.actionAdapter);
            if (mi.getActionCommand().equals("stop") || mi.getActionCommand().equals("undoStep")) {
                mi.setEnabled(false);
            }
            this.transform.add(mi);
            if (transCommands[i].equals("stop") || transCommands[i].equals("step") || transCommands[i].equals("undoStep")) {
                this.transform.addSeparator();
            }
            ++i;
        }
        this.mainMenus.addElement(this.transform);
    }

    private void resetEnabledOfMenus(GraGraTreeNodeData selNode, boolean gragraIsChanged) {
        if (this.gragra != null) {
            if (gragraIsChanged) {
                if (selNode != null) {
                    if (selNode.isAtomic() || selNode.isConclusion()) {
                        this.edit.setEnabled(true);
                        this.mode.setEnabled(true);
                        this.transform.setEnabled(false);
                        this.setEditMode(this.lasteditmode);
                    } else if (selNode.isRuleConstraint() || selNode.isConstraint() || selNode.isAtomApplCond()) {
                        if (this.editmode != 9) {
                            this.lasteditmode = this.editmode;
                        }
                        this.setEditMode(9);
                        this.edit.setEnabled(false);
                        this.mode.setEnabled(false);
                        this.transform.setEnabled(false);
                    } else {
                        this.edit.setEnabled(true);
                        this.mode.setEnabled(true);
                        this.transform.setEnabled(true);
                        this.setEditMode(this.lasteditmode);
                    }
                }
            } else if (selNode != null) {
                if (selNode.isAtomic() || selNode.isConclusion()) {
                    this.edit.setEnabled(true);
                    this.mode.setEnabled(true);
                    this.transform.setEnabled(false);
                    this.setEditMode(this.lasteditmode);
                } else if (selNode.isRuleConstraint() || selNode.isConstraint() || selNode.isAtomApplCond()) {
                    if (this.editmode != 9) {
                        this.lasteditmode = this.editmode;
                    }
                    this.setEditMode(9);
                    this.edit.setEnabled(false);
                    this.mode.setEnabled(false);
                    this.transform.setEnabled(false);
                } else {
                    this.edit.setEnabled(true);
                    this.mode.setEnabled(true);
                    this.transform.setEnabled(true);
                    this.setEditMode(this.lasteditmode);
                }
            }
        } else {
            this.edit.setEnabled(false);
            this.mode.setEnabled(false);
            this.transform.setEnabled(false);
        }
    }

    private void resetModeMenu(JCheckBoxMenuItem selItem) {
        int i = 0;
        while (i < this.mode.getItemCount()) {
            if (this.mode.getMenuComponent(i) instanceof JMenuItem) {
                JMenuItem mi = this.mode.getItem(i);
                if (selItem == null) {
                    mi.setSelected(false);
                } else if (!selItem.getText().equals("Image_view") && !mi.getText().equals("Image_view") && selItem.getState() && !mi.equals(selItem)) {
                    mi.setSelected(!selItem.getState());
                }
            }
            ++i;
        }
    }

    private JCheckBoxMenuItem getModeMenuItem(String itemname) {
        String name = itemname.replaceAll(" ", "");
        int i = 0;
        while (i < this.mode.getItemCount()) {
            JMenuItem mi;
            String miname;
            if (this.mode.getMenuComponent(i) instanceof JMenuItem && (miname = (mi = this.mode.getItem(i)).getText().replaceAll(" ", "")).indexOf(name) != -1) {
                return (JCheckBoxMenuItem)mi;
            }
            ++i;
        }
        return null;
    }

    public void forwardModeCommand(JCheckBoxMenuItem selItem) {
        if (!selItem.getText().equals("Image_view")) {
            selItem.setSelected(true);
        }
        this.resetModeMenu(selItem);
        this.modePopupMenu.selectEditModeMenuItem(selItem.getText());
        this.selectToolBarModeItem(selItem.getText());
    }

    public void forwardModeCommand(String selName) {
        JCheckBoxMenuItem selItem = this.getModeMenuItem(selName);
        if (selItem != null) {
            this.forwardModeCommand(selItem);
        } else {
            this.modePopupMenu.selectEditModeMenuItem(selName);
            this.selectToolBarModeItem(selName);
        }
    }

    public void resetTransformMenu(String selName) {
        if (selName.equals("Start")) {
            this.resetTransformMenu(this.transform.getItem(0));
        } else if (selName.equals("Stop")) {
            this.resetTransformMenu(this.transform.getItem(1));
        }
    }

    public void resetTransformMenu(JMenuItem selItem) {
        block9: {
            block8: {
                if (!selItem.getActionCommand().equals("start")) break block8;
                int i = 0;
                while (i < this.transform.getItemCount()) {
                    if (this.transform.getMenuComponent(i) instanceof JMenuItem) {
                        JMenuItem mi = this.transform.getItem(i);
                        if (mi.getActionCommand().equals("stop") || mi.getActionCommand().equals("undoStep") || mi.getActionCommand().equals("options") || mi.getText().equals("Transform")) {
                            mi.setEnabled(true);
                        } else {
                            mi.setEnabled(false);
                        }
                    }
                    ++i;
                }
                break block9;
            }
            if (!selItem.getActionCommand().equals("stop")) break block9;
            int i = 0;
            while (i < this.transform.getItemCount()) {
                if (this.transform.getMenuComponent(i) instanceof JMenuItem) {
                    JMenuItem mi = this.transform.getItem(i);
                    if (mi.getActionCommand().equals("stop")) {
                        mi.setEnabled(false);
                    } else {
                        mi.setEnabled(true);
                    }
                }
                ++i;
            }
        }
    }

    private void disableStopMenuItem() {
        int i = 0;
        while (i < this.transform.getItemCount()) {
            if (this.transform.getItem(i) != null) {
                if (this.transform.getItem(i).getActionCommand().equals("stop")) {
                    this.transform.getItem(i).setEnabled(false);
                } else {
                    this.transform.getItem(i).setEnabled(true);
                }
            }
            ++i;
        }
    }

    private void fillToolBar() {
        this.toolBar.addTool(this.toolBar.createTool("imageable", "attributes", "Attributes of a selected object", "attributes", this.actionAdapter, false));
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.toolBar.addTool(this.toolBar.createTool("imageable", "delete", "Delete selected object(s)", "delete", this.actionAdapter, false));
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.toolBar.addTool(this.toolBar.createTool("imageable", "copy", "Copy selected object(s)", "copy", this.actionAdapter, false));
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.toolBar.addTool(this.toolBar.createTool("imageable", "paste", "Paste", "paste", this.actionAdapter, false));
        this.toolBar.addSeparator();
        this.toolBar.addTool(this.toolBar.createTool("iconable", "SelectNodeTypeIcon", "Select nodes of current type", "selectNodeType", this.actionAdapter, false));
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.toolBar.addTool(this.toolBar.createTool("iconable", "SelectArcTypeIcon", "Select arcs of current type", "selectArcType", this.actionAdapter, false));
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.toolBar.addTool(this.toolBar.createTool("iconable", "SelectAllIcon", "Select all objects", "selectAll", this.actionAdapter, false));
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.toolBar.addTool(this.toolBar.createTool("iconable", "DeselectAllIcon", "Deselect all objects / Redraw", "deselectAll", this.actionAdapter, false));
        this.toolBar.addSeparator(this.freeSpace);
        this.toolBar.addTool(this.toolBar.createTool("textable", "IR", "Identic Rule", "identicRule", this.actionAdapter, false));
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.toolBar.addTool(this.buttonIdenticNAC);
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.toolBar.addTool(this.buttonIdenticPAC);
        this.indxIdenticNestedAC = this.toolBar.getComponentCount();
        this.toolBar.addSeparator(this.freeSpace);
        this.editModeButtons.add(this.toolBar.addTool(this.toolBar.createTool("imageable", "draw_mode", "Draw mode", "drawMode", this.actionAdapter, false)));
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.editModeButtons.add(this.toolBar.addTool(this.toolBar.createTool("imageable", "select_mode", "Select mode", "selectMode", this.actionAdapter, false)));
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.editModeButtons.add(this.toolBar.addTool(this.toolBar.createTool("imageable", "move_mode", "Move mode", "moveMode", this.actionAdapter, false)));
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.editModeButtons.add(this.toolBar.addTool(this.toolBar.createTool("imageable", "attributes_mode", "Attributes mode", "attributesMode", this.actionAdapter, false)));
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.editModeButtons.add(this.toolBar.addTool(this.toolBar.createTool("imageable", "map_mode", "Map mode", "mapMode", this.actionAdapter, false)));
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.editModeButtons.add(this.toolBar.addTool(this.toolBar.createTool("imageable", "unmap_mode", "Unmap mode", "unmapMode", this.actionAdapter, false)));
        this.toolBar.addSeparator(this.freeSpace);
        this.toolBar.addTool(this.buttonMatch);
        this.transformButtons.add(this.buttonMatch);
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.toolBar.addTool(this.buttonCompletion);
        this.transformButtons.add(this.buttonCompletion);
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.toolBar.addTool(this.buttonStep);
        this.transformButtons.add(this.buttonStep);
        this.toolBar.addSeparator(this.freeSpace);
        this.toolBar.addTool(this.buttonStart);
        this.transformButtons.add(this.buttonStart);
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.toolBar.addTool(this.buttonStop);
        this.transformButtons.add(this.buttonStop);
        this.toolBar.addSeparator(new Dimension(3, 3));
        this.toolBar.addTool(this.buttonUndoStep);
        this.transformButtons.add(this.buttonUndoStep);
        this.toolBar.addSeparator(this.freeSpace);
        this.toolBar.addTool(this.buttonT);
        this.buttonT.setForeground(Color.red);
        ((TextIcon)this.buttonT.getIcon()).setColor(Color.red);
        this.toolBar.addSeparator(this.freeSpace);
        this.toolBar.addTool(this.buttonUndo);
        this.toolBar.addTool(this.buttonRedo);
        this.toolBar.addSeparator(this.freeSpace);
        this.toolBar.addTool(this.buttonLayout);
        this.toolBar.addTool(this.buttonLayoutMenu);
    }

    private void selectToolBarModeItem(int editMode) {
        if (editMode == 11) {
            this.selectToolBarModeItem("Draw");
        } else if (editMode == 12) {
            this.selectToolBarModeItem("Select");
        } else if (editMode == 13) {
            this.selectToolBarModeItem("Move");
        } else if (editMode == 114) {
            this.selectToolBarModeItem("Attributes");
        } else if (editMode == 115) {
            this.selectToolBarModeItem("Map");
        } else if (editMode == 116) {
            this.selectToolBarModeItem("Unmap");
        } else {
            this.selectToolBarModeItem("Draw");
        }
    }

    public void selectToolBarModeItem(String editMode) {
        String actionComand = "drawMode";
        String emode = editMode.replaceAll(" ", "");
        if (emode.indexOf("Select") != -1) {
            actionComand = "selectMode";
        } else if (emode.indexOf("Move") != -1) {
            actionComand = "moveMode";
        } else if (emode.indexOf("Attributes") != -1) {
            actionComand = "attributesMode";
        } else if (emode.indexOf("Map") != -1) {
            actionComand = "mapMode";
        } else if (emode.indexOf("Unmap") != -1) {
            actionComand = "unmapMode";
        }
        int i = 0;
        while (i < this.editModeButtons.size()) {
            JButton b = this.editModeButtons.get(i);
            if (b.getActionCommand().equals(actionComand)) {
                if (!b.isSelected()) {
                    b.setBackground(new Color(153, 153, 255));
                    b.setSelected(true);
                    if (this.ruleEditor.isObjMapping()) {
                        this.ruleEditor.resetEditModeAfterMapping();
                    }
                    this.selectToolBarTransformItem("");
                }
            } else {
                b.setBackground(this.bgc);
                b.setSelected(false);
            }
            ++i;
        }
    }

    public void selectToolBarTransformItem(String actionComand) {
        int i = 0;
        while (i < this.transformButtons.size()) {
            JButton b = this.transformButtons.get(i);
            if (b.getActionCommand().equals(actionComand)) {
                if (!b.isSelected()) {
                    b.setBackground(Color.yellow);
                    b.setSelected(true);
                }
            } else {
                b.setBackground(this.bgc);
                b.setSelected(false);
            }
            ++i;
        }
    }

    private void resetEnabledOfToolBarItems(GraGraTreeNodeData nodeData, boolean gragraIsChanged) {
        if (this.gragra != null) {
            if (nodeData != null) {
                if (gragraIsChanged) {
                    if (nodeData.isAtomic() || nodeData.isConclusion()) {
                        int i = 0;
                        while (i < this.toolBar.getComponentCount()) {
                            if (this.toolBar.getComponentAtIndex(i) instanceof JButton) {
                                JButton b = (JButton)this.toolBar.getComponentAtIndex(i);
                                b.setEnabled(true);
                                if (b == this.buttonRedo) {
                                    this.updateRedoButton();
                                }
                                if (b == this.buttonUndo) {
                                    this.updateUndoButton();
                                }
                                if (b == this.buttonUndoStep) {
                                    this.setUndoStepButtonEnabled(false);
                                }
                                if (b.getIcon() instanceof TextIcon) {
                                    if (((TextIcon)b.getIcon()).getText().equals("IR")) {
                                        b.setIcon(new TextIcon("IA", true));
                                        b.setToolTipText("Identic Atomic");
                                    }
                                    if (((TextIcon)b.getIcon()).getText().equals("IN") || ((TextIcon)b.getIcon()).getText().equals("IP") || ((TextIcon)b.getIcon()).getText().equals("IGAC")) {
                                        ((TextIcon)b.getIcon()).setEnabled(false);
                                        b.setEnabled(false);
                                    } else {
                                        ((TextIcon)b.getIcon()).setEnabled(true);
                                    }
                                }
                            }
                            ++i;
                        }
                        this.resetSelectIcons(true);
                        this.resetTransformIcons(false);
                    } else if (nodeData.isRuleConstraint() || nodeData.isConstraint() || nodeData.isAtomApplCond()) {
                        int i = 0;
                        while (i < this.toolBar.getComponentCount()) {
                            if (this.toolBar.getComponentAtIndex(i) instanceof JButton) {
                                JButton b = (JButton)this.toolBar.getComponentAtIndex(i);
                                if (b == this.buttonLayout || b == this.buttonLayoutMenu) {
                                    b.setEnabled(true);
                                } else {
                                    b.setEnabled(false);
                                }
                                if (b.getIcon() instanceof TextIcon) {
                                    ((TextIcon)b.getIcon()).setEnabled(false);
                                }
                            }
                            ++i;
                        }
                        this.resetSelectIcons(false);
                        this.resetTransformIcons(false);
                    } else if (nodeData.isGraGra() || nodeData.isGraph()) {
                        int i = 0;
                        while (i < this.toolBar.getComponentCount()) {
                            if (this.toolBar.getComponentAtIndex(i) instanceof JButton) {
                                JButton b = (JButton)this.toolBar.getComponentAtIndex(i);
                                b.setEnabled(true);
                                if (b == this.buttonRedo) {
                                    this.updateRedoButton();
                                }
                                if (b == this.buttonUndo) {
                                    this.updateUndoButton();
                                }
                                if (b == this.buttonUndoStep) {
                                    this.setUndoStepButtonEnabled(false);
                                }
                                if (b.getIcon() instanceof TextIcon) {
                                    ((TextIcon)b.getIcon()).setEnabled(true);
                                }
                            }
                            ++i;
                        }
                        this.resetSelectIcons(true);
                        this.resetTransformIcons(true);
                    } else if (nodeData.isRule() || nodeData.isNAC() || nodeData.isPAC()) {
                        int i = 0;
                        while (i < this.toolBar.getComponentCount()) {
                            if (this.toolBar.getComponentAtIndex(i) instanceof JButton) {
                                JButton b = (JButton)this.toolBar.getComponentAtIndex(i);
                                b.setEnabled(true);
                                if (b == this.buttonRedo) {
                                    this.updateRedoButton();
                                }
                                if (b == this.buttonUndo) {
                                    this.updateUndoButton();
                                }
                                if (b == this.buttonUndoStep) {
                                    this.setUndoStepButtonEnabled(false);
                                }
                                if (b.getIcon() instanceof TextIcon) {
                                    if (((TextIcon)b.getIcon()).getText().equals("IA")) {
                                        b.setIcon(new TextIcon("IR", true));
                                        b.setToolTipText("Identic Rule");
                                    }
                                    ((TextIcon)b.getIcon()).setEnabled(true);
                                }
                            }
                            ++i;
                        }
                        if (nodeData.isRule()) {
                            this.resetButtonIdenticNAC(false);
                            this.resetButtonIdenticPAC(false);
                        } else if (nodeData.isNAC()) {
                            this.resetButtonIdenticPAC(false);
                        } else if (nodeData.isPAC()) {
                            this.resetButtonIdenticNAC(false);
                        }
                        this.resetSelectIcons(true);
                        this.resetTransformIcons(true);
                    }
                } else if (nodeData.isAtomic() || nodeData.isConclusion()) {
                    int i = 0;
                    while (i < this.toolBar.getComponentCount()) {
                        if (this.toolBar.getComponentAtIndex(i) instanceof JButton) {
                            JButton b = (JButton)this.toolBar.getComponentAtIndex(i);
                            b.setEnabled(true);
                            if (b == this.buttonRedo) {
                                this.updateRedoButton();
                            }
                            if (b == this.buttonUndo) {
                                this.updateUndoButton();
                            }
                            if (b == this.buttonUndoStep) {
                                this.setUndoStepButtonEnabled(false);
                            }
                            if (b.getIcon() instanceof TextIcon) {
                                if (((TextIcon)b.getIcon()).getText().equals("IR")) {
                                    b.setIcon(new TextIcon("IA", true));
                                    b.setToolTipText("Identic Atomic");
                                }
                                ((TextIcon)b.getIcon()).setEnabled(true);
                            }
                        }
                        ++i;
                    }
                    this.resetButtonIdenticNAC(false);
                    this.resetButtonIdenticPAC(false);
                    this.resetButtonIdenticNestedAC(false);
                    this.resetSelectIcons(true);
                    this.resetTransformIcons(false);
                } else if (nodeData.isRuleConstraint() || nodeData.isConstraint() || nodeData.isAtomApplCond()) {
                    int i = 0;
                    while (i < this.toolBar.getComponentCount()) {
                        if (this.toolBar.getComponentAtIndex(i) instanceof JButton) {
                            JButton b = (JButton)this.toolBar.getComponentAtIndex(i);
                            if (b == this.buttonLayout || b == this.buttonLayoutMenu) {
                                b.setEnabled(true);
                            } else {
                                b.setEnabled(false);
                            }
                            if (b.getIcon() instanceof TextIcon) {
                                ((TextIcon)b.getIcon()).setEnabled(false);
                            }
                        }
                        ++i;
                    }
                    this.resetSelectIcons(false);
                    this.resetTransformIcons(false);
                } else if (nodeData.isGraGra() || nodeData.isGraph()) {
                    int i = 0;
                    while (i < this.toolBar.getComponentCount()) {
                        if (this.toolBar.getComponentAtIndex(i) instanceof JButton) {
                            JButton b = (JButton)this.toolBar.getComponentAtIndex(i);
                            b.setEnabled(true);
                            if (b == this.buttonRedo) {
                                this.updateRedoButton();
                            }
                            if (b == this.buttonUndo) {
                                this.updateUndoButton();
                            }
                            if (b == this.buttonUndoStep) {
                                this.setUndoStepButtonEnabled(false);
                            }
                            if (b.getIcon() instanceof TextIcon) {
                                ((TextIcon)b.getIcon()).setEnabled(true);
                            }
                        }
                        ++i;
                    }
                    this.resetSelectIcons(true);
                    this.resetTransformIcons(true);
                } else if (nodeData.isRule() || nodeData.isNAC() || nodeData.isPAC() || nodeData.isNestedAC()) {
                    int i = 0;
                    while (i < this.toolBar.getComponentCount()) {
                        if (this.toolBar.getComponentAtIndex(i) instanceof JButton) {
                            JButton b = (JButton)this.toolBar.getComponentAtIndex(i);
                            b.setEnabled(true);
                            if (b == this.buttonRedo) {
                                this.updateRedoButton();
                            }
                            if (b == this.buttonUndo) {
                                this.updateUndoButton();
                            }
                            if (b == this.buttonUndoStep) {
                                this.setUndoStepButtonEnabled(false);
                            }
                            if (b.getIcon() instanceof TextIcon) {
                                if (((TextIcon)b.getIcon()).getText().equals("IA")) {
                                    b.setIcon(new TextIcon("IR", true));
                                    b.setToolTipText("Identic Rule");
                                }
                                ((TextIcon)b.getIcon()).setEnabled(true);
                            }
                        }
                        ++i;
                    }
                    if (nodeData.isRule()) {
                        this.resetButtonIdenticNAC(false);
                        this.resetButtonIdenticPAC(false);
                        this.resetButtonIdenticNestedAC(false);
                    } else if (nodeData.isNAC()) {
                        this.resetButtonIdenticPAC(false);
                        this.resetButtonIdenticNestedAC(false);
                    } else if (nodeData.isPAC()) {
                        this.resetButtonIdenticNAC(false);
                        this.resetButtonIdenticNestedAC(false);
                    } else if (nodeData.isNestedAC()) {
                        this.resetButtonIdenticNAC(false);
                        this.resetButtonIdenticPAC(false);
                    }
                    this.resetSelectIcons(true);
                    this.resetTransformIcons(true);
                }
            } else {
                int i = 0;
                while (i < this.toolBar.getComponentCount()) {
                    if (this.toolBar.getComponentAtIndex(i) instanceof JButton) {
                        JButton b = (JButton)this.toolBar.getComponentAtIndex(i);
                        b.setEnabled(true);
                        if (b == this.buttonRedo) {
                            this.updateRedoButton();
                        }
                        if (b == this.buttonUndo) {
                            this.updateUndoButton();
                        }
                        if (b == this.buttonUndoStep) {
                            this.setUndoStepButtonEnabled(false);
                        }
                        if (b.getIcon() instanceof TextIcon) {
                            ((TextIcon)b.getIcon()).setEnabled(true);
                        }
                    }
                    ++i;
                }
                this.resetSelectIcons(true);
                this.resetTransformIcons(true);
            }
        } else {
            int i = 0;
            while (i < this.toolBar.getComponentCount()) {
                if (this.toolBar.getComponentAtIndex(i) instanceof JButton) {
                    JButton b = (JButton)this.toolBar.getComponentAtIndex(i);
                    b.setEnabled(false);
                    if (b.getIcon() instanceof TextIcon) {
                        ((TextIcon)b.getIcon()).setEnabled(false);
                    }
                }
                ++i;
            }
            this.resetSelectIcons(false);
            this.resetTransformIcons(false);
            this.resetStartTrafoIcon(false);
        }
        this.toolBar.revalidate();
    }

    private void resetSelectIcons(boolean enable) {
        int i = 0;
        while (i < this.toolBar.getComponentCount()) {
            if (this.toolBar.getComponentAtIndex(i) instanceof JButton) {
                JButton b = (JButton)this.toolBar.getComponentAtIndex(i);
                if (b.getIcon() instanceof DeselectAllIcon) {
                    ((DeselectAllIcon)b.getIcon()).setEnabled(enable);
                    b.setEnabled(enable);
                } else if (b.getIcon() instanceof SelectAllIcon) {
                    ((SelectAllIcon)b.getIcon()).setEnabled(enable);
                    b.setEnabled(enable);
                } else if (b.getIcon() instanceof SelectNodeTypeIcon) {
                    ((SelectNodeTypeIcon)b.getIcon()).setEnabled(enable);
                    b.setEnabled(enable);
                } else if (b.getIcon() instanceof SelectArcTypeIcon) {
                    ((SelectArcTypeIcon)b.getIcon()).setEnabled(enable);
                    b.setEnabled(enable);
                }
            }
            ++i;
        }
    }

    private void resetEditIcons(boolean enable) {
        int i = 0;
        while (i < this.toolBar.getComponentCount()) {
            if (this.toolBar.getComponentAtIndex(i) instanceof JButton) {
                JButton b = (JButton)this.toolBar.getComponentAtIndex(i);
                if (b.getActionCommand().equals("attributes") || b.getActionCommand().equals("delete") || b.getActionCommand().equals("copy") || b.getActionCommand().equals("paste")) {
                    b.setEnabled(enable);
                }
                if (b.getIcon() instanceof TextIcon) {
                    if (((TextIcon)b.getIcon()).getText().equals("IR") || ((TextIcon)b.getIcon()).getText().equals("IA")) {
                        ((TextIcon)b.getIcon()).setEnabled(enable);
                        b.setEnabled(enable);
                    }
                    if (((TextIcon)b.getIcon()).getText().equals("IN")) {
                        if (this.nacExists) {
                            this.resetButtonIdenticNAC(enable);
                        } else {
                            this.resetButtonIdenticNAC(false);
                        }
                    }
                    if (((TextIcon)b.getIcon()).getText().equals("IP")) {
                        if (this.pacExists) {
                            this.resetButtonIdenticPAC(enable);
                        } else {
                            this.resetButtonIdenticPAC(false);
                        }
                    }
                    if (((TextIcon)b.getIcon()).getText().equals("IGAC")) {
                        if (this.acExists) {
                            this.resetButtonIdenticNestedAC(enable);
                        } else {
                            this.resetButtonIdenticNestedAC(false);
                        }
                    }
                } else if (b.getIcon() instanceof SelectNodeTypeIcon) {
                    ((SelectNodeTypeIcon)b.getIcon()).setEnabled(enable);
                    b.setEnabled(enable);
                } else if (b.getIcon() instanceof SelectArcTypeIcon) {
                    ((SelectArcTypeIcon)b.getIcon()).setEnabled(enable);
                    b.setEnabled(enable);
                } else if (b.getIcon() instanceof SelectAllIcon) {
                    ((SelectAllIcon)b.getIcon()).setEnabled(enable);
                    b.setEnabled(enable);
                } else if (b.getIcon() instanceof DeselectAllIcon) {
                    ((DeselectAllIcon)b.getIcon()).setEnabled(enable);
                    b.setEnabled(enable);
                }
            }
            ++i;
        }
    }

    private void resetButtonIdenticNAC(boolean b) {
        ((TextIcon)this.buttonIdenticNAC.getIcon()).setEnabled(b);
        this.buttonIdenticNAC.setEnabled(b);
    }

    private void resetButtonIdenticPAC(boolean b) {
        ((TextIcon)this.buttonIdenticPAC.getIcon()).setEnabled(b);
        this.buttonIdenticPAC.setEnabled(b);
    }

    private void resetButtonIdenticNestedAC(boolean b) {
        ((TextIcon)this.buttonIdenticNestedAC.getIcon()).setEnabled(b);
        this.buttonIdenticNestedAC.setEnabled(b);
    }

    private void resetEditModeIcons(boolean enable) {
        int i = 0;
        while (i < this.toolBar.getComponentCount()) {
            JButton b;
            if (this.toolBar.getComponentAtIndex(i) instanceof JButton && ((b = (JButton)this.toolBar.getComponentAtIndex(i)).getActionCommand().equals("drawMode") || b.getActionCommand().equals("selectMode") || b.getActionCommand().equals("attributesMode") || b.getActionCommand().equals("mapMode") || b.getActionCommand().equals("unmapMode"))) {
                b.setEnabled(enable);
            }
            ++i;
        }
    }

    public void resetEditModeAfterMapping(int editMode) {
        if (this.editmode == 42 || this.editmode == 115 || this.editmode == 116) {
            if (this.editmode == 42) {
                this.selectToolBarTransformItem("");
            }
            this.ruleEditor.resetEditModeAfterMapping();
            this.lasteditmode = editMode;
            this.setEditMode(editMode);
            this.forwardModeCommand(EditorConstants.getModeOfID(editMode));
        }
    }

    public void resetMoveEditMode() {
        this.lasteditmode = 13;
        this.setEditMode(13);
        this.forwardModeCommand(EditorConstants.getModeOfID(13));
    }

    public void resetSelectEditMode() {
        this.lasteditmode = 12;
        this.setEditMode(12);
        this.forwardModeCommand(EditorConstants.getModeOfID(12));
    }

    private void resetTransformIcons(boolean enable) {
        int i = 0;
        while (i < this.toolBar.getComponentCount()) {
            if (this.toolBar.getComponentAtIndex(i) instanceof JButton) {
                JButton b = (JButton)this.toolBar.getComponentAtIndex(i);
                if (b.getIcon() instanceof MatchIcon) {
                    ((MatchIcon)b.getIcon()).setEnabled(enable);
                    b.setEnabled(enable);
                } else if (b.getIcon() instanceof CompletionIcon) {
                    ((CompletionIcon)b.getIcon()).setEnabled(enable);
                    b.setEnabled(enable);
                } else if (b.getIcon() instanceof StepIcon) {
                    ((StepIcon)b.getIcon()).setEnabled(enable);
                    b.setEnabled(enable);
                } else if (b.getIcon() instanceof StartIcon) {
                    ((StartIcon)b.getIcon()).setEnabled(enable);
                    b.setEnabled(enable);
                } else if (b.getIcon() instanceof StopIcon) {
                    ((StopIcon)b.getIcon()).setEnabled(false);
                    b.setEnabled(false);
                } else if (b.getIcon() instanceof StepBackIcon) {
                    ((StepBackIcon)b.getIcon()).setEnabled(false);
                    b.setEnabled(false);
                }
            }
            ++i;
        }
    }

    private void resetStartTrafoIcon(boolean enable) {
        int i = 0;
        while (i < this.toolBar.getComponentCount()) {
            JButton b;
            if (this.toolBar.getComponentAtIndex(i) instanceof JButton && (b = (JButton)this.toolBar.getComponentAtIndex(i)).getIcon() instanceof StartIcon) {
                ((StartIcon)b.getIcon()).setEnabled(enable);
                b.setEnabled(enable);
            }
            ++i;
        }
    }

    public void enableNestedApplCond(boolean b) {
        if (b) {
            this.toolBar.addSeparator(new Dimension(3, 3), this.indxIdenticNestedAC);
            this.toolBar.addTool(this.buttonIdenticNestedAC, this.indxIdenticNestedAC + 1);
        }
    }

    public void enableStopButton(boolean b) {
        ((StopIcon)this.buttonStop.getIcon()).setEnabled(b);
        this.buttonStop.setEnabled(b);
    }

    public void setUndoStepButtonEnabled(boolean b) {
        ((StepBackIcon)this.buttonUndoStep.getIcon()).setEnabled(b);
        this.buttonUndoStep.setEnabled(b);
    }

    public void updateUndoButtonAfterAttrEdit(GraphPanel p) {
        if (this.attrChanged) {
            if (p.getGraph() != null) {
                p.getGraph().undoManagerEndEdit();
            }
            this.updateUndoButton();
            this.attrChanged = false;
        } else if (p.getGraph() != null) {
            p.getGraph().undoManagerLastEditDie();
        }
    }

    public void updateUndoButton() {
        if (this.undoManager != null && this.undoManager.isEnabled()) {
            if (this.undoManager.canUndo()) {
                this.buttonUndo.setEnabled(true);
            } else {
                this.buttonUndo.setEnabled(false);
            }
        } else {
            this.buttonUndo.setEnabled(false);
        }
    }

    public void updateRedoButton() {
        if (this.undoManager != null && this.undoManager.isEnabled()) {
            if (this.undoManager.canRedo()) {
                this.buttonRedo.setEnabled(true);
            } else {
                this.buttonRedo.setEnabled(false);
            }
        } else {
            this.buttonRedo.setEnabled(false);
        }
    }

    public void setUndoButtonEnabled(boolean b) {
        if (this.undoManager != null && this.undoManager.isEnabled()) {
            if (b && this.undoManager.canUndo()) {
                this.buttonUndo.setEnabled(true);
            } else if (!b && !this.undoManager.canUndo()) {
                this.buttonUndo.setEnabled(false);
            }
        } else {
            this.buttonUndo.setEnabled(false);
        }
    }

    public void undoEdit() {
        if (this.getGraGra() == null || !this.getGraGra().getGraph().isEditable()) {
            return;
        }
        if (!this.interpreting && !this.layering && !this.sequences && this.undoManager != null && this.undoManager.isEnabled() && this.undoManager.canUndo()) {
            this.getGraGra().getGraph().setTransformChangeEnabled(false);
            this.undoManager.undo();
            this.updateGraphics();
            if (!this.undoManager.canUndo()) {
                this.buttonUndo.setEnabled(false);
                this.setUndoStepButtonEnabled(false);
            }
            if (this.undoManager.canRedo()) {
                this.buttonRedo.setEnabled(true);
            }
        }
    }

    public void undoTransformStep() {
        if (this.getGraGra() != null && this.ruleEditor.getRule() != null) {
            if (!this.getGraGra().getGraph().isEditable()) {
                return;
            }
            if (!(this.interpreting || this.layering || this.sequences)) {
                if (this.undoManager != null && this.undoManager.isEnabled() && this.undoManager.canUndo()) {
                    this.selectToolBarTransformItem("undoStep");
                    int undoID = this.undoManager.getUndoStateID();
                    int lastEndOfStepUndoID = this.undoManager.getUndoEndOfTransformStep();
                    while (lastEndOfStepUndoID >= 0 && undoID >= lastEndOfStepUndoID) {
                        if (!this.undoManager.canUndo()) break;
                        this.undoManager.undo();
                        undoID = this.undoManager.getUndoStateID();
                    }
                    if (lastEndOfStepUndoID == -1) {
                        this.setUndoStepButtonEnabled(false);
                    }
                    if (!this.undoManager.canUndo()) {
                        this.setUndoButtonEnabled(false);
                    }
                    if (this.undoManager.canRedo()) {
                        this.buttonRedo.setEnabled(true);
                    }
                    this.graphEditor.updateGraphics();
                }
                this.selectToolBarTransformItem("");
            }
        }
    }

    public void redoEdit() {
        if (!(this.getGraGra() == null && this.getGraGra().getGraph().isEditable() || this.interpreting || this.layering || this.sequences || this.undoManager == null || !this.undoManager.isEnabled() || !this.undoManager.canRedo())) {
            this.undoManager.redo();
            this.updateGraphics();
            this.buttonRedo.setEnabled(false);
            if (this.undoManager.canUndo()) {
                this.buttonUndo.setEnabled(true);
            }
        }
    }

    public void discardAllEdits() {
        if (this.undoManager != null && this.undoManager.isEnabled()) {
            this.undoManager.discardAllEdits();
            this.buttonUndo.setEnabled(false);
            this.buttonRedo.setEnabled(false);
            this.setUndoStepButtonEnabled(false);
        }
    }

    public void resetStepCounter() {
        this.stepCounter = 0;
    }

    public void resetTransformationKindIcon(boolean enable, String text) {
        if (enable) {
            if (text.equals("NT")) {
                ((TextIcon)this.buttonT.getIcon()).setText("NT");
                this.buttonT.setToolTipText(" Transformation by applying rules non-deterministically (default) ");
            } else if (text.equals("LT")) {
                ((TextIcon)this.buttonT.getIcon()).setText("LT");
                this.buttonT.setToolTipText(" Transformation by applying rules due to layers ");
            } else if (text.equals("PT")) {
                ((TextIcon)this.buttonT.getIcon()).setText("PT");
                this.buttonT.setToolTipText(" Transformation by applying rules due to priorities ");
            } else if (text.equals("ST")) {
                ((TextIcon)this.buttonT.getIcon()).setText("ST");
                this.buttonT.setToolTipText(" Transformation by applying rules due to sequences of rules");
            }
            ((TextIcon)this.buttonT.getIcon()).setEnabled(true);
            this.buttonT.setEnabled(true);
        }
        if (this.buttonT.getGraphics() != null) {
            this.buttonT.update(this.buttonT.getGraphics());
        }
    }

    private void resetTransformDebugIcons(boolean enable) {
        int i = 0;
        while (i < this.toolBar.getComponentCount()) {
            if (this.toolBar.getComponentAtIndex(i) instanceof JButton) {
                JButton b = (JButton)this.toolBar.getComponentAtIndex(i);
                if (b.getIcon() instanceof MatchIcon) {
                    ((MatchIcon)b.getIcon()).setEnabled(enable);
                    b.setEnabled(enable);
                } else if (b.getIcon() instanceof CompletionIcon) {
                    ((CompletionIcon)b.getIcon()).setEnabled(enable);
                    b.setEnabled(enable);
                } else if (b.getIcon() instanceof StepIcon) {
                    ((StepIcon)b.getIcon()).setEnabled(enable);
                    b.setEnabled(enable);
                }
            }
            ++i;
        }
    }

    private void resetIconsIfTransformInterpret(boolean enable) {
        if (this.applFrame instanceof AGGAppl) {
            ((AGGAppl)this.applFrame).getGraGraTreeView().resetFileIcons(enable);
        }
        this.resetEditIcons(enable);
        this.resetEditModeIcons(enable);
        this.resetTransformDebugIcons(enable);
        this.toolBar.revalidate();
    }

    private int removeWarning(String msgStr) {
        Object[] options = new Object[]{"YES", "NO"};
        int answer = JOptionPane.showOptionDialog(null, msgStr, "Warning", -1, 2, null, options, options[1]);
        return answer;
    }

    public void doPrepareLayouterProc() {
        this.graphEditor.getGraph().enableDefaultGraphLayout(false);
        if (this.evolutionaryLayouter.getJpgOutput()) {
            this.jpgPath = this.exportJPEG.getDirectoryForJPEGs(this);
            if (this.jpgPath != null && !this.jpgPath.equals("")) {
                String filename = String.valueOf(this.getGraGra().getFileName()) + "_0.jpg";
                this.exportJPEG.save(this.graphEditor.getGraphPanel().getCanvas(), String.valueOf(this.jpgPath) + File.separator + filename);
            }
        }
        if (this.evolutionaryLayouter.getWriteMetricValues()) {
            this.graphEditor.getGraph().updateVisibility();
            if (this.metricvalues == null) {
                this.metricvalues = this.createMetricValues(this.graphEditor.getGraph().getVisibleNodes(), this.graphEditor.getGraph().getVisibleArcs());
            }
        }
    }

    public void doPrepareDefaultGraphLayout() {
        this.graphEditor.getGraph().enableDefaultGraphLayout(true);
        if (this.staticNodePositionForGraphLayouter) {
            this.graphEditor.getGraph().enableStaticNodePosition();
        }
    }

    private void saveGraphJPEG() {
        if (this.gragra == null) {
            return;
        }
        this.exportJPEG.setDirectory(this.gragra.getDirName());
        this.exportJPEG.save(this.graphEditor.getGraphPanel().getCanvas());
    }

    private void setNodeIds(EdGraph g) {
        Vector<EdNode> nodes = g.getNodes();
        int i = 0;
        while (i < nodes.size()) {
            EdNode n = nodes.get(i);
            if (n.getNodeID() == -1) {
                n.setNodeID(n.hashCode());
            }
            ++i;
        }
    }

    private Vector<String> createMetricValues(List<EdNode> nodes, List<EdArc> arcs) {
        Vector<String> metricValues = new Vector<String>();
        String s = new String("A  \tB \tC \tD   \tE    \tF     \tG    \tH    \tI          J          K       ");
        metricValues.add(s);
        String s1 = "";
        int i = 0;
        while (i < 94) {
            s1 = s1.concat("-");
            ++i;
        }
        metricValues.add(s1);
        s = new String("age\t#n\t#e\tn_ov\tn_eov\te_xing\te_dif\tn_mov\td_single   d_mental   d_layout");
        metricValues.add(s);
        s1 = "";
        i = 0;
        while (i < 94) {
            s1 = s1.concat("-");
            ++i;
        }
        metricValues.add(s1);
        LayoutMetrics lmetric = this.evolutionaryLayouter.getLayoutMetrics();
        int age = 0;
        s = new String(String.valueOf(age) + "\t");
        int nodesNm = nodes.size();
        s = String.valueOf(s) + nodesNm + "\t";
        int arcsNm = arcs.size();
        s = String.valueOf(s) + arcsNm + "\t";
        int nodeOverlapping = lmetric.getNodeIntersect(nodes, false);
        s = String.valueOf(s) + nodeOverlapping + "\t";
        int arcNodeOverlapping = lmetric.getArcNodeIntersect(nodes, arcs);
        s = String.valueOf(s) + arcNodeOverlapping + "\t";
        int arcArcOverlapping = lmetric.getArcArcIntersect(arcs);
        s = String.valueOf(s) + arcArcOverlapping + "\t";
        s = String.valueOf(s) + lmetric.getAverageArcLengthDeviation(arcs) + "\t";
        s = String.valueOf(s) + "N/A\t";
        float singleDistance = lmetric.getSingleDistance(nodesNm, arcsNm, nodeOverlapping, arcNodeOverlapping, arcArcOverlapping);
        String str_singleDistance = String.valueOf(singleDistance);
        s = String.valueOf(s) + str_singleDistance.substring(0, str_singleDistance.indexOf(46) + 2) + "\t   ";
        s = String.valueOf(s) + "N/A\t      ";
        s = String.valueOf(s) + "N/A";
        metricValues.add(s);
        return metricValues;
    }

    private void writeMetricValues(String filename) {
        try {
            BufferedWriter buf = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(filename)));
            int i = 0;
            while (i < this.metricvalues.size()) {
                buf.write(String.valueOf(this.metricvalues.get(i)) + "\n");
                ++i;
            }
            buf.flush();
            buf.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void enableStaticNodePositionForGraphLayouter(boolean enable) {
        this.staticNodePositionForGraphLayouter = enable;
        this.graphEditor.enableStaticNodePositionForGraphLayouter(enable);
    }

    public void doStandardLayoutProc() {
        if (this.staticNodePositionForGraphLayouter) {
            this.getGraph().enableStaticNodePosition();
        }
        if (this.evolutionaryLayouter.isEnabled()) {
            this.doStandardELayoutProc(this.getGraph());
        } else {
            this.getGraph().enableDefaultGraphLayout(true);
            this.getGraph().update();
        }
    }

    public void doStandardELayoutProc(EdGraph g) {
        g.updateVisibility();
        List<EdNode> visiblenodes = g.getVisibleNodes();
        List<EdArc> visiblearcs = g.getVisibleArcs();
        if (g.getNodes().size() <= 1) {
            return;
        }
        g.enableDefaultGraphLayout(false);
        g.straightAllArcs();
        g.updateNodePosEtoL(visiblenodes);
        g.updateLengthOfLayoutEdge(visiblearcs, this.evolutionaryLayouter.getGeneralEdgeLength());
        this.setNodeIds(g);
        LayoutMetrics lmetrics = this.evolutionaryLayouter.getLayoutMetrics();
        int i = 0;
        while (i < g.getNodes().size()) {
            g.getNodes().get(i).calculateCluster(lmetrics.getEpsilon(), g.getNodes());
            ++i;
        }
        Dimension neededpanel = this.evolutionaryLayouter.getNeededPanelSize(visiblenodes);
        int panelx = this.getPanelOfGraph(g).getWidth();
        int panely = this.getPanelOfGraph(g).getHeight();
        neededpanel.setSize(Math.max(neededpanel.width, panelx), Math.max(neededpanel.height, panely));
        this.getPanelOfGraph(g).getCanvas().setSize(neededpanel);
        this.evolutionaryLayouter.setPanelSize(neededpanel);
        int intersect = this.evolutionaryLayouter.getNodeIntersect(visiblenodes, true);
        if (intersect > 0) {
            this.evolutionaryLayouter.setFrozenByDefault(false);
            this.evolutionaryLayouter.makeRandomLayoutOfNodes(g, visiblenodes);
        } else {
            this.evolutionaryLayouter.setFrozenByDefault(true);
        }
        this.evolutionaryLayouter.layoutGraph(g, visiblenodes, visiblearcs);
        if (this.evolutionaryLayouter.isCentre()) {
            this.evolutionaryLayouter.centreLayout(g, visiblenodes);
        }
        g.resolveArcOverlappings(15);
        g.setCurrentLayoutToDefault(true);
    }

    public void doStepLayoutProc() {
        if (this.evolutionaryLayouter.isEnabled()) {
            this.doStepELayoutProc();
        } else {
            this.getGraph().update();
        }
    }

    private void doStepELayoutProc() {
        this.getGraph().updateVisibility();
        List<EdNode> visiblenodes = this.getGraph().getVisibleNodes();
        Vector<EdArc> visiblearcs = new Vector<EdArc>();
        if (visiblenodes.size() <= 1) {
            return;
        }
        this.getGraph().enableDefaultGraphLayout(false);
        this.evolutionaryLayouter.setOldEdGraph(this.getGraph().copy());
        this.getGraph().incGraphGen();
        this.getGraph().updateNodePosEtoL(visiblenodes);
        this.setNodeIds(this.getGraph());
        LayoutMetrics lmetrics = this.evolutionaryLayouter.getLayoutMetrics();
        int i = 0;
        while (i < this.getGraph().getNodes().size()) {
            this.getGraph().getNodes().get(i).calculateCluster(lmetrics.getEpsilon(), this.getGraph().getNodes());
            ++i;
        }
        if (this.getGraph().isNodeRemoved()) {
            this.evolutionaryLayouter.shockAging(this.getGraph());
        }
        Dimension neededpanel = this.evolutionaryLayouter.getNeededPanelSize(visiblenodes);
        int panelx = this.getPanelOfGraph(this.getGraph()).getWidth();
        int panely = this.getPanelOfGraph(this.getGraph()).getHeight();
        neededpanel.setSize(Math.max(neededpanel.width, panelx), Math.max(neededpanel.height, panely));
        this.getPanelOfGraph(this.getGraph()).getCanvas().setSize(neededpanel);
        this.evolutionaryLayouter.setPanelSize(neededpanel);
        this.evolutionaryLayouter.setFrozenByDefault(false);
        int intersect = this.evolutionaryLayouter.getNodeIntersect(visiblenodes, true);
        if (intersect > 0) {
            this.evolutionaryLayouter.makeRandomLayoutOfNodes(this.getGraph(), visiblenodes);
        }
        this.evolutionaryLayouter.layoutGraph(this.getGraph(), visiblenodes, visiblearcs);
        if (this.evolutionaryLayouter.isCentre()) {
            this.evolutionaryLayouter.centreLayout(this.getGraph(), visiblenodes);
        }
        this.getGraph().resolveArcOverlappings(15);
        if (this.evolutionaryLayouter.getJpgOutput()) {
            if (this.jpgPath == null && !this.exportJPEG.isCancelled()) {
                this.jpgPath = this.exportJPEG.getDirectoryForJPEGs(this);
            }
            if (this.jpgPath != null && !this.jpgPath.equals("")) {
                String filename = String.valueOf(this.getGraGra().getFileName()) + "_" + this.getGraph().getGraphGen() + ".jpg";
                this.exportJPEG.save(this.graphEditor.getGraphPanel().getCanvas(), String.valueOf(this.jpgPath) + File.separator + filename);
            }
        }
        if (this.evolutionaryLayouter.getWriteMetricValues()) {
            if (this.metricvalues == null) {
                this.metricvalues = this.createMetricValues(visiblenodes, visiblearcs);
            }
            String metrics = this.getMetricValuesString(this.getGraph().getGraphGen(), visiblenodes, visiblearcs, this.evolutionaryLayouter.getOldEdGraph().getVisibleNodes(), lmetrics);
            this.metricvalues.addElement(metrics);
        }
    }

    private String getMetricValuesString(int graphAgeGeneration, List<EdNode> nodes, List<EdArc> arcs, List<EdNode> oldnodes, LayoutMetrics lmetrics) {
        String str;
        int age = graphAgeGeneration;
        String metrics = new String(String.valueOf(age) + "\t");
        int nodesNm = nodes.size();
        metrics = String.valueOf(metrics) + nodesNm + "\t";
        int arcsNm = arcs.size();
        metrics = String.valueOf(metrics) + arcsNm + "\t";
        int nodeOverlapping = lmetrics.getNodeIntersect(nodes, false);
        metrics = String.valueOf(metrics) + nodeOverlapping + "\t";
        int arcNodeOverlapping = lmetrics.getArcNodeIntersect(nodes, arcs);
        metrics = String.valueOf(metrics) + arcNodeOverlapping + "\t";
        int arcArcOverlapping = lmetrics.getArcArcIntersect(arcs);
        metrics = String.valueOf(metrics) + arcArcOverlapping + "\t";
        int movementsOfArcs = lmetrics.getAverageArcLengthDeviation(arcs);
        metrics = String.valueOf(metrics) + movementsOfArcs + "\t";
        int movementsOfNodes = lmetrics.getAverageNodeMove(oldnodes, nodes);
        metrics = String.valueOf(metrics) + movementsOfNodes + "\t";
        float singleDist = lmetrics.getSingleDistance(nodesNm, arcsNm, nodeOverlapping, arcNodeOverlapping, arcArcOverlapping);
        String singleDistance = str = String.valueOf(singleDist);
        if (str.length() > str.indexOf(46) + 2) {
            singleDistance = str.substring(0, str.indexOf(46) + 2);
        }
        metrics = String.valueOf(metrics) + singleDistance + "\t   ";
        float mentalDist = lmetrics.getMentalDistance(nodesNm, arcsNm, movementsOfNodes, movementsOfArcs);
        String mentalDistance = str = String.valueOf(mentalDist);
        if (str.length() > str.indexOf(46) + 2) {
            mentalDistance = str.substring(0, str.indexOf(46) + 2);
        }
        metrics = String.valueOf(metrics) + mentalDistance + "\t      ";
        float layoutQual = lmetrics.getLayoutQuality(singleDist, mentalDist);
        String layoutQuality = str = String.valueOf(layoutQual);
        if (str.length() > str.indexOf(46) + 2) {
            layoutQuality = str.substring(0, str.indexOf(46) + 2);
        }
        metrics = String.valueOf(metrics) + layoutQuality;
        return metrics;
    }

    public ZestGraphLayout getZestGraphLayouter() {
        return this.graphLayouts.getZestLayouter() != null ? this.graphLayouts.getZestLayouter() : null;
    }

    public void setGraphLayoutAlgorithmName(String name) {
        this.graphLayoutAlgorithmName = name;
        this.buttonLayout.setToolTipText(name);
    }

    public boolean doZestLayoutProc(EdGraph g, GraphPanel gp, String algorithmname) {
        boolean result = false;
        if (this.graphLayouts.getZestLayouter() != null) {
            this.graphLayouts.getZestLayouter().setGraph(g);
            this.graphLayouts.getZestLayouter().setAlgorithm(algorithmname);
            result = this.graphLayouts.getZestLayouter().applyLayout();
        }
        return result;
    }

    public void doGraphLayout() {
        GraphPanel gp;
        EdGraph g = this.activePanel == null ? this.getGraph() : this.activePanel.getGraph();
        GraphPanel graphPanel = gp = this.activePanel == null ? this.getGraphEditor().getGraphPanel() : this.activePanel;
        if (this.graphLayoutAlgorithmName.equals("Default ( Spring based )")) {
            this.doStandardELayoutProc(g);
            gp.updateGraphics(true);
        } else if (this.doZestLayoutProc(g, gp, this.graphLayoutAlgorithmName)) {
            gp.updateGraphics(true);
        }
    }

    public void activateObjectNameMenuItem(boolean b) {
        this.editPopupMenu.activateObjectNameMenuItem(b);
    }
}

