/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.cpa;

import agg.attribute.impl.AttrTupleManager;
import agg.editor.impl.EdArc;
import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdNode;
import agg.gui.AGGAppl;
import agg.gui.cpa.ConflictsDependenciesContainerSaveLoad;
import agg.gui.cpa.ConflictsDependenciesGraph;
import agg.gui.cpa.CriticalPairAnalysisGUI;
import agg.gui.cpa.CriticalPairAnalysisSeparated;
import agg.gui.cpa.CriticalPairPanel;
import agg.gui.cpa.GraphDesktop;
import agg.gui.cpa.SelectRulesForCPAnalysisDialog;
import agg.gui.event.TreeViewEvent;
import agg.gui.event.TreeViewEventListener;
import agg.gui.options.CriticalPairOptionGUI;
import agg.gui.options.ParserGUIOption;
import agg.gui.options.ParserOptionGUI;
import agg.gui.parser.GUIExchange;
import agg.gui.parser.LayerGUI;
import agg.gui.parser.PairIOGUI;
import agg.gui.parser.event.OptionEvent;
import agg.gui.parser.event.OptionListener;
import agg.gui.parser.event.ParserGUIEvent;
import agg.gui.parser.event.ParserGUIListener;
import agg.gui.parser.event.StatusMessageEvent;
import agg.gui.parser.event.StatusMessageListener;
import agg.gui.saveload.GraphicsExportJPEG;
import agg.gui.treeview.GraGraTreeView;
import agg.parser.CriticalPairOption;
import agg.parser.DependencyPairContainer;
import agg.parser.ExcludePairContainer;
import agg.parser.LayerOption;
import agg.parser.LayeredDependencyPairContainer;
import agg.parser.LayeredExcludePairContainer;
import agg.parser.OptionEventListener;
import agg.parser.PairContainer;
import agg.parser.ParserEvent;
import agg.parser.ParserEventListener;
import agg.parser.ParserFactory;
import agg.parser.ParserMessageEvent;
import agg.parser.ParserOption;
import agg.parser.PriorityDependencyPairContainer;
import agg.parser.PriorityExcludePairContainer;
import agg.util.Pair;
import agg.xt_basis.GraGra;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Rule;
import agg.xt_basis.RuleLayer;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyVetoException;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class CriticalPairAnalysis
implements TreeViewEventListener,
ParserEventListener,
OptionListener,
OptionEventListener,
ParserGUIListener,
ActionListener,
StatusMessageListener {
    public boolean allowNodeTypeInheritance;
    JMenu back;
    private SelectRulesForCPAnalysisDialog rulesDialog;
    protected static CriticalPairAnalysis cpa;
    protected GUIExchange changer;
    protected ParserGUIOption option;
    protected ParserOptionGUI pOptionGUI;
    protected ParserOption pOption;
    protected LayerOption lOption;
    protected CriticalPairOptionGUI cpOptionGUI;
    protected CriticalPairOption cpOption;
    protected CriticalPairAnalysisGUI pairsGUI;
    protected PairContainer pairsContainer;
    protected PairContainer pairsContainer2;
    protected ConflictsDependenciesGraph conflictDependGraph;
    protected PairIOGUI pairsIOGUI;
    protected JMenu pairsMenu;
    protected JMenu startCP;
    protected JMenu loadCP;
    protected JMenu cpaGraphCP;
    protected JMenu showCP;
    protected JMenuItem rulesCP;
    protected JMenuItem resetCP;
    protected JMenuItem unlockCP;
    protected JMenuItem startCPconflicts;
    protected JMenuItem startCPdependencies;
    protected JMenuItem stopCP;
    protected JMenuItem consistCP;
    protected JMenuItem debugCP;
    protected JMenuItem emptyCP;
    protected JMenuItem loadCPcpx;
    protected JMenuItem loadCPdpx;
    protected JMenuItem loadSeparateCPcpx;
    protected JMenuItem loadSeparateCPdpx;
    protected JMenuItem saveCP;
    protected JMenuItem showConflictCP;
    protected JMenuItem showDependencyCP;
    protected JMenuItem cpaCombiGraphCP;
    protected JMenuItem checkHostGraphCP;
    protected JMenuItem backCP;
    protected Vector<ParserEventListener> listener;
    protected Vector<StatusMessageListener> pmlistener;
    protected AGGAppl parent;
    protected EdGraGra pairsGraGra;
    protected EdGraph cpaGraph;
    protected RuleLayer rlayer;
    protected GraGraTreeView treeView;
    protected EdGraGra selectedGraGra;
    protected List<Rule> ruleList1;
    protected List<Rule> ruleList2;
    protected Vector<JMenu> menus;
    protected Hashtable<EdGraGra, Boolean> gragraChanged = new Hashtable();
    protected boolean isWarned = false;
    protected boolean isLocked = true;
    protected boolean resetDone = false;
    protected Hashtable<JFrame, CriticalPairAnalysisSeparated> separatedFrames = new Hashtable();
    protected CriticalPairAnalysisSeparated hostGraphCPA;
    Hashtable<Graph, Vector<Hashtable<GraphObject, GraphObject>>> hostGraphCPAcontainer;
    protected JFrame hostGraphFrame;
    protected Hashtable<Graph, Pair<Vector<Hashtable<GraphObject, GraphObject>>, JButton>> overlapGraphs;
    protected Graph overlapGraph;
    protected Vector<Hashtable<GraphObject, GraphObject>> hostGraphMappings;
    protected JButton nextMatchAtHostGraphButton;
    protected GraphDesktop graphDesktop;
    protected int x = 100;
    protected int y = 50;
    protected int mouseX = -1;
    protected int mouseY = -1;
    protected WindowListener wl;
    protected JFrame lastActiveFrame;
    protected boolean pairsSaved = false;
    protected GraphicsExportJPEG exportJPEG;
    protected String message = "";

    public CriticalPairAnalysis(AGGAppl appl, GraGraTreeView graTreeView) {
        this.parent = appl;
        this.treeView = graTreeView;
        this.listener = new Vector();
        this.pmlistener = new Vector();
        this.cpOption = new CriticalPairOption();
        this.cpOption.addOptionListener(this);
        this.cpOptionGUI = new CriticalPairOptionGUI(this, this.cpOption, this.option, this.pOption);
        this.pairsGUI = new CriticalPairAnalysisGUI(appl, this.option);
        this.pairsIOGUI = new PairIOGUI(this.parent);
        this.back = new JMenu("               Back to AGG Editor             ");
        this.back.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                CriticalPairAnalysis.this.backToMainGUI(false);
            }
        });
        this.menus = new Vector(2);
        this.createAnalysisMenu();
        this.addCPAnalysisEventListener(this);
        this.pairsGUI.addStatusMessageListener(this);
        this.changer = new GUIExchange(this.parent);
        cpa = this;
        this.wl = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (e.getSource() instanceof JFrame) {
                    if ((JFrame)e.getSource() == CriticalPairAnalysis.this.hostGraphFrame) {
                        EdGraph hostg = CriticalPairAnalysis.this.treeView.getCurrentGraGra().getGraph();
                        for (GraphObject graphObject : hostg.getBasisGraph().getNodesSet()) {
                            graphObject.setCritical(false);
                            EdNode n = hostg.findNode(graphObject);
                            if (n == null) continue;
                            n.clearMorphismMark();
                        }
                        for (GraphObject graphObject : hostg.getBasisGraph().getArcsSet()) {
                            graphObject.setCritical(false);
                            EdArc a = hostg.findArc(graphObject);
                            if (a == null) continue;
                            a.clearMorphismMark();
                        }
                        hostg.deselectAll();
                        hostg.update();
                        CriticalPairAnalysis.this.treeView.graphDidChange();
                        if (CriticalPairAnalysis.this.overlapGraphs != null) {
                            CriticalPairAnalysis.this.overlapGraphs.clear();
                            CriticalPairAnalysis.this.overlapGraphs = null;
                        }
                        if (CriticalPairAnalysis.this.hostGraphCPA.getPairContainer(0) != null) {
                            if (CriticalPairAnalysis.this.pairsGUI.getCriticalPairPanel(0) != null) {
                                CriticalPairAnalysis.this.pairsGUI.getCriticalPairPanel(0).refreshView();
                            }
                            CriticalPairAnalysis.this.hostGraphCPA.getPairContainer(0).enableUseHostGraph(false, null, null);
                        } else if (CriticalPairAnalysis.this.hostGraphCPA.getPairContainer(1) != null) {
                            if (CriticalPairAnalysis.this.pairsGUI.getCriticalPairPanel(1) != null) {
                                CriticalPairAnalysis.this.pairsGUI.getCriticalPairPanel(1).refreshView();
                            }
                            CriticalPairAnalysis.this.hostGraphCPA.getPairContainer(1).enableUseHostGraph(false, null, null);
                        }
                        CriticalPairAnalysis.this.pairsGraGra.setChanged(false);
                        CriticalPairAnalysis.this.resetRuleApplicable(CriticalPairAnalysis.this.pairsGraGra.getBasisGraGra());
                        if (CriticalPairAnalysis.this.selectedGraGra != null) {
                            CriticalPairAnalysis.this.selectedGraGra.setChanged(false);
                            CriticalPairAnalysis.this.resetRuleApplicable(CriticalPairAnalysis.this.selectedGraGra.getBasisGraGra());
                        }
                        CriticalPairAnalysis.this.treeView.getTree().treeDidChange();
                        CriticalPairAnalysis.this.pairsSaved = true;
                        CriticalPairAnalysis.this.separatedFrames.remove(e.getSource());
                    } else {
                        CriticalPairAnalysis.this.separatedFrames.remove(e.getSource());
                    }
                }
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }
        };
        this.parent.addWindowListener(this.wl);
    }

    private void addBackToAGGMenuBar(AGGAppl appl) {
        appl.addMenu(this.back);
    }

    private void removeBackFromAGGMenuBar(AGGAppl appl) {
        appl.removeMenu(this.back);
    }

    public Enumeration<JMenu> getMenus() {
        return this.menus.elements();
    }

    public EdGraGra getGraGra() {
        return this.pairsGraGra;
    }

    public boolean isEmpty() {
        return this.pairsGUI.isEmpty();
    }

    public CriticalPairAnalysisGUI getCriticalPairAnalysisGUI() {
        return this.pairsGUI;
    }

    public CriticalPairOption getCriticalPairOption() {
        return this.cpOption;
    }

    public CriticalPairOptionGUI getCriticalPairOptionGUI() {
        return this.cpOptionGUI;
    }

    public void setCriticalPairOption(CriticalPairOption cpOpt) {
        this.cpOption = cpOpt;
    }

    public void setCriticalPairOptionGUI(CriticalPairOptionGUI cpOptionGUI) {
        this.cpOptionGUI = cpOptionGUI;
    }

    public void setLayerOption(LayerOption lo) {
        this.lOption = lo;
    }

    public void setParserOption(ParserOption pOption) {
        this.pOption = pOption;
        this.cpOptionGUI.setParserOption(pOption);
        pOption.addOptionListener(this.cpOptionGUI);
    }

    public void setGUIOption(ParserGUIOption guiOption) {
        this.option = guiOption;
        this.cpOptionGUI.setGUIOption(guiOption);
        this.pairsGUI.setGUIOption(guiOption);
    }

    public void setGraGra(EdGraGra gra) {
        if (this.pairsGraGra != null) {
            this.pairsGraGra.setEditable(true);
            this.gragraChanged.remove(this.pairsGraGra);
        }
        this.pairsGraGra = gra;
        this.pairsGUI.setGraGra(this.pairsGraGra);
        this.pairsContainer = null;
        this.pairsContainer2 = null;
        this.conflictDependGraph = null;
        this.cpaGraph = null;
        this.ruleList1 = null;
        this.ruleList2 = null;
        if (this.pairsGraGra != null) {
            this.rulesCP.setEnabled(true);
            this.resetCP.setEnabled(true);
            this.startCP.setEnabled(true);
            this.debugCP.setEnabled(true);
            if (this.pairsGraGra.getBasisGraGra().isLayered()) {
                this.cpOptionGUI.initLayers(this.pairsGraGra.getBasisGraGra().getEnabledLayers());
            }
            this.gragraChanged.put(this.pairsGraGra, new Boolean(this.pairsGraGra.isChanged()));
        } else {
            this.rulesCP.setEnabled(false);
            this.resetCP.setEnabled(false);
            this.unlockCP.setEnabled(false);
            this.startCP.setEnabled(false);
            this.stopCP.setEnabled(false);
            this.debugCP.setEnabled(false);
            this.emptyCP.setEnabled(false);
            this.loadCP.setEnabled(true);
            this.saveCP.setEnabled(false);
            this.showCP.setEnabled(false);
            this.checkHostGraphCP.setEnabled(false);
            this.backCP.setEnabled(false);
        }
    }

    public void setExportJPEG(GraphicsExportJPEG jpg) {
        this.exportJPEG = jpg;
        if (this.pairsGUI != null) {
            this.pairsGUI.getGraphDesktop().setExportJPEG(this.exportJPEG);
        }
    }

    @Override
    public void treeViewEventOccurred(TreeViewEvent e) {
        int msgkey = e.getMsg();
        if (msgkey == 61 && e.getData().isGraGra()) {
            this.selectedGraGra = e.getData().getGraGra();
            if (this.pairsGraGra == null) {
                this.setGraGra(this.selectedGraGra);
            } else if (this.pairsGUI.getGraphDesktop().hasEmptyComponents()) {
                this.setGraGra(this.selectedGraGra);
            } else if (!(this.changer.isSet() || !this.pairsSaved || this.pairsGraGra.getBasisGraGra().compareTo(this.selectedGraGra.getBasisGraGra(), true) && this.layerUsed() == this.cpOption.layeredEnabled())) {
                this.setGraGra(this.selectedGraGra);
            }
        }
        if (msgkey == 7 && e.getData().isGraGra()) {
            if (this.pairsGraGra == e.getData().getGraGra()) {
                this.pairsGUI.reinitGraphDesktop();
                this.setGraGra(null);
                this.pairsSaved = true;
            }
            if (this.selectedGraGra == e.getData().getGraGra()) {
                this.selectedGraGra = null;
            }
        }
    }

    @Override
    public void parserEventOccured(ParserEvent e) {
        if (e.getMessage().indexOf("Critical") != -1 && e.getMessage().indexOf("finished") != -1) {
            this.pairsSaved = false;
            this.updateCPAgraph();
            this.startCP.setEnabled(true);
            this.stopCP.setEnabled(false);
            this.consistCP.setEnabled(true);
            this.loadCP.setEnabled(true);
            this.saveCP.setEnabled(true);
            this.showCP.setEnabled(true);
            this.checkHostGraphCP.setEnabled(true);
            if (this.backCP.isEnabled()) {
                this.emptyCP.setEnabled(true);
            } else {
                this.unlockCP.setEnabled(true);
                this.rulesCP.setEnabled(true);
                this.resetCP.setEnabled(true);
                this.debugCP.setEnabled(true);
                this.checkHostGraphCP.setEnabled(true);
            }
            this.fireParserEvent(new ParserMessageEvent(this, " Please select a pair of rules to see results."));
        } else if (e.getMessage().indexOf("Checking Host Graph ") != -1 && e.getMessage().indexOf("started") != -1) {
            if (this.hostGraphCPA != null) {
                JOptionPane.showMessageDialog(this.parent, "Checking of the host graph has started. Please wait for the finish-message.", "  CPA  ", 1);
            }
        } else if (e.getMessage().indexOf("Checking Host Graph") != -1 && e.getMessage().indexOf("finished") != -1) {
            if (this.hostGraphCPA != null) {
                JOptionPane.showMessageDialog(this.parent, "Checking of the host graph finished. Please select a rule pair to see results.", "  CPA  ", 1);
            }
        } else if (e.getMessage().indexOf("rule pair") != -1) {
            this.pairsSaved = false;
            if (!this.stopCP.isEnabled()) {
                if (e.getMessage().indexOf("done") == -1) {
                    this.startCP.setEnabled(false);
                    this.loadCP.setEnabled(false);
                    if (this.backCP.isEnabled()) {
                        this.consistCP.setEnabled(false);
                        this.saveCP.setEnabled(false);
                        this.showCP.setEnabled(false);
                        this.checkHostGraphCP.setEnabled(false);
                    }
                } else if (e.getMessage().indexOf("done") != -1) {
                    this.startCP.setEnabled(true);
                    this.loadCP.setEnabled(true);
                    if (this.backCP.isEnabled()) {
                        this.consistCP.setEnabled(true);
                        this.saveCP.setEnabled(true);
                        this.showCP.setEnabled(true);
                        this.checkHostGraphCP.setEnabled(true);
                    }
                }
            }
        } else if (e.getMessage().indexOf("Critical") != -1 && e.getMessage().indexOf("stopped") != -1) {
            this.pairsSaved = false;
            this.updateCPAgraph();
        }
    }

    @Override
    public void optionEventOccurred(OptionEvent e) {
        if (e.getSource() instanceof JCheckBox) {
            JCheckBox cb = (JCheckBox)e.getSource();
            if (cb.getText().equals("NACs")) {
                this.cpOption.enableNacs(cb.isSelected());
            } else if (cb.getText().equals("PACs")) {
                this.cpOption.enablePacs(cb.isSelected());
            }
        }
    }

    @Override
    public void optionEventOccurred(EventObject e) {
        if (e.getSource() instanceof CriticalPairOption) {
            if (this.pairsContainer != null) {
                this.setCPoptions((ExcludePairContainer)this.pairsContainer);
                if (this.pairsContainer instanceof LayeredExcludePairContainer) {
                    ((LayeredExcludePairContainer)this.pairsContainer).setLayer(this.cpOption.getLayer());
                }
            }
            if (this.pairsContainer2 != null) {
                ((DependencyPairContainer)this.pairsContainer2).enableSwitchDependency(this.cpOption.switchDependencyEnabled());
                this.setCPoptions((ExcludePairContainer)this.pairsContainer2);
                if (this.pairsContainer2 instanceof LayeredDependencyPairContainer) {
                    ((LayeredDependencyPairContainer)this.pairsContainer2).setLayer(this.cpOption.getLayer());
                }
            }
        }
        Enumeration<JFrame> en = this.separatedFrames.keys();
        while (en.hasMoreElements()) {
            JFrame key = en.nextElement();
            CriticalPairAnalysisSeparated cpas = this.separatedFrames.get(key);
            ExcludePairContainer excludePC = cpas.getPairContainer(0);
            ExcludePairContainer excludePC2 = cpas.getPairContainer(1);
            if (excludePC != null) {
                this.setCPoptions(excludePC);
            }
            if (excludePC2 == null) continue;
            ((DependencyPairContainer)excludePC2).enableSwitchDependency(this.cpOption.switchDependencyEnabled());
            this.setCPoptions(excludePC2);
        }
    }

    private void setCPoptions(ExcludePairContainer pc) {
        pc.enableComplete(this.cpOption.completeEnabled());
        pc.enableReduce(this.cpOption.reduceEnabled());
        pc.enableConsistent(this.cpOption.consistentEnabled());
        pc.enableIgnoreIdenticalRules(this.cpOption.ignoreIdenticalRulesEnabled());
        pc.enableReduceSameMatch(this.cpOption.reduceSameMatchEnabled());
        pc.enableStrongAttrCheck(this.cpOption.strongAttrCheckEnabled());
        pc.enableEqualVariableNameOfAttrMapping(this.cpOption.equalVariableNameOfAttrMappingEnabled());
        pc.enableNamedObjectOnly(this.cpOption.namedObjectEnabled());
        pc.enableMaxBoundOfCriticKind(this.cpOption.getMaxBoundOfCriticKind());
        if (!(pc instanceof DependencyPairContainer)) {
            pc.enableDirectlyStrictConfluent(this.cpOption.directlyStrictConflEnabled());
            pc.enableDirectlyStrictConfluentUpToIso(this.cpOption.directlyStrictConflUpToIsoEnabled());
        }
    }

    protected void createAnalysisMenu() {
        this.pairsMenu = new JMenu("Critical Pair Analysis");
        this.pairsMenu.setMnemonic('C');
        this.resetCP = new JMenuItem("Reset");
        this.resetCP.setEnabled(false);
        this.resetCP.setMnemonic('s');
        this.pairsMenu.add(this.resetCP);
        this.resetCPaddActionListener();
        this.unlockCP = new JMenuItem("Unlock");
        this.unlockCP.setEnabled(false);
        this.unlockCP.setMnemonic('U');
        this.pairsMenu.add(this.unlockCP);
        this.unlockCPaddActionListener();
        this.rulesCP = new JMenuItem("Set Rules");
        this.rulesCP.setEnabled(false);
        this.pairsMenu.add(this.rulesCP);
        this.rulesCPaddActionListener();
        this.pairsMenu.addSeparator();
        this.startCP = new JMenu("Generate");
        this.startCP.setMnemonic('G');
        this.startCPconflicts = new JMenuItem("Conflicts");
        this.startCPconflicts.setMnemonic('C');
        this.startCPdependencies = new JMenuItem("Dependencies");
        this.startCPdependencies.setMnemonic('D');
        this.startCP.add(this.startCPconflicts);
        this.startCP.add(this.startCPdependencies);
        this.startCP.setEnabled(false);
        this.pairsMenu.add(this.startCP);
        this.startCPaddActionListener();
        this.pairsMenu.addSeparator();
        this.stopCP = new JMenuItem("Stop");
        this.stopCP.setEnabled(false);
        this.stopCP.setMnemonic('o');
        this.pairsMenu.add(this.stopCP);
        this.stopCPaddActionListener();
        this.emptyCP = new JMenuItem("Empty");
        this.emptyCP.setEnabled(false);
        this.emptyCP.setMnemonic('y');
        this.pairsMenu.add(this.emptyCP);
        this.emptyCPaddActionListener();
        this.pairsMenu.addSeparator();
        this.debugCP = new JMenuItem("Debug");
        this.debugCP.setEnabled(false);
        this.debugCP.setMnemonic('D');
        this.pairsMenu.add(this.debugCP);
        this.debugCPaddActionListener();
        this.pairsMenu.addSeparator();
        this.consistCP = new JMenuItem("Check Consistency");
        this.consistCP.setEnabled(false);
        this.consistCP.setMnemonic('k');
        this.pairsMenu.add(this.consistCP);
        this.consistCPaddActionListener();
        this.checkHostGraphCP = new JMenuItem("Check Host Graph");
        this.checkHostGraphCP.setEnabled(false);
        this.checkHostGraphCP.setMnemonic(72);
        this.pairsMenu.add(this.checkHostGraphCP);
        this.checkHostGraphCPaddActionListener();
        this.pairsMenu.addSeparator();
        this.loadCP = new JMenu("Load");
        this.loadCP.setMnemonic('L');
        this.pairsMenu.add(this.loadCP);
        this.loadCPcpx = new JMenuItem("In This Window");
        this.loadCPcpx.setMnemonic('i');
        this.loadCPcpx.setDisplayedMnemonicIndex(5);
        this.loadSeparateCPcpx = new JMenuItem("In New Window");
        this.loadSeparateCPcpx.setMnemonic('N');
        this.loadSeparateCPcpx.setDisplayedMnemonicIndex(3);
        this.loadCP.add(this.loadCPcpx);
        this.loadCP.add(this.loadSeparateCPcpx);
        this.loadCPaddActionListener();
        this.saveCP = new JMenuItem("Save");
        this.saveCP.setEnabled(false);
        this.saveCP.setMnemonic('v');
        this.pairsMenu.add(this.saveCP);
        this.saveCPaddActionListener();
        this.showCP = new JMenu("Show");
        this.showCP.setMnemonic('w');
        this.showCP.setEnabled(false);
        this.showConflictCP = this.showCP.add(new JMenuItem("Conflicts"));
        this.showConflictCP.setMnemonic('i');
        this.showDependencyCP = this.showCP.add(new JMenuItem("Dependencies"));
        this.showDependencyCP.setMnemonic('n');
        this.cpaCombiGraphCP = this.showCP.add(new JMenuItem("CPA Graph"));
        this.cpaCombiGraphCP.setMnemonic('G');
        this.pairsMenu.add(this.showCP);
        this.showCPaddActionListener();
        this.pairsMenu.addSeparator();
        this.backCP = new JMenuItem("Back to AGG Editor");
        this.backCP.setEnabled(false);
        this.backCP.setMnemonic('b');
        this.pairsMenu.add(this.backCP);
        this.backCPaddActionListener();
        this.menus.addElement(this.pairsMenu);
    }

    private void rulesCPaddActionListener() {
        this.rulesCP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CriticalPairAnalysis.this.setRulesForCPA(CriticalPairAnalysis.this.selectedGraGra);
            }
        });
    }

    void setRulesForCPA(EdGraGra selGraGra) {
        if (this.resetGraGra(this.selectedGraGra)) {
            this.rulesDialog = new SelectRulesForCPAnalysisDialog(this.parent, this.selectedGraGra.getBasisGraGra(), new Point(300, 300));
            this.rulesDialog.setVisible(true);
            this.ruleList1 = this.rulesDialog.getExtendedRuleList1();
            this.ruleList2 = this.rulesDialog.getExtendedRuleList2();
            this.debugCPA();
        }
    }

    private void resetCPaddActionListener() {
        this.resetCP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CriticalPairAnalysis.this.resetCPAGraGra(CriticalPairAnalysis.this.selectedGraGra);
            }
        });
    }

    void resetCPAGraGra(EdGraGra selGraGra) {
        if (this.resetGraGra(this.selectedGraGra) && this.selectedGraGra.getBasisGraGra().isLayered()) {
            this.cpOptionGUI.initLayers(this.selectedGraGra.getBasisGraGra().getEnabledLayers());
        }
    }

    boolean resetGraGra(EdGraGra selGraGra) {
        if (!this.backCP.isEnabled()) {
            if (selGraGra == null) {
                return false;
            }
            if (!this.doAllowInheritance(selGraGra.getBasisGraGra())) {
                this.inheritanceWarning();
                return false;
            }
            if (!this.areRulesInjective(selGraGra.getBasisGraGra()) || !this.checkIfReadyToTransform(selGraGra)) {
                return false;
            }
            if (this.pairsGUI.getGraGra() != null) {
                if (this.pairsGUI.isOnePairThreadAlive()) {
                    this.pairsGUI.stopOnePairThread();
                }
                if (!this.stopCP.isEnabled()) {
                    this.removeEventListenersFromPairContainer(this.pairsContainer);
                    this.removeEventListenersFromPairContainer(this.pairsContainer2);
                    this.pairsGUI.reinitGraphDesktop();
                    this.pairsContainer = null;
                    this.pairsContainer2 = null;
                    this.cpaGraph = null;
                    this.conflictDependGraph = null;
                    this.pairsGraGra = selGraGra;
                    this.gragraChanged.put(this.pairsGraGra, new Boolean(this.pairsGraGra.isChanged()));
                    this.pairsGUI.setGraGra(this.pairsGraGra);
                    this.pairsSaved = true;
                    this.resetDone = true;
                } else {
                    JOptionPane.showMessageDialog(null, "Critical pair computation is running!.\nPlease wait or stop the computation.", "Warning", 2);
                }
                this.startCP.setEnabled(true);
            }
        }
        return true;
    }

    protected void unlockAllGraGras() {
        if (this.pairsGraGra != null && this.pairsGraGra.getBasisGraGra() != null && this.pairsGraGra != this.selectedGraGra) {
            this.pairsGraGra.setEditable(true);
        }
        if (this.selectedGraGra != null) {
            this.selectedGraGra.setEditable(true);
        }
        Enumeration<EdGraGra> keys = this.gragraChanged.keys();
        while (keys.hasMoreElements()) {
            EdGraGra gra = keys.nextElement();
            if (gra.getBasisGraGra() == null) continue;
            gra.setEditable(true);
            if (this.gragraChanged.get(gra) != null) {
                gra.setChanged(this.gragraChanged.get(gra));
                continue;
            }
            gra.setChanged(false);
        }
        this.gragraChanged.clear();
    }

    private void unlockCPaddActionListener() {
        this.unlockCP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!CriticalPairAnalysis.this.backCP.isEnabled()) {
                    CriticalPairAnalysis.this.unlockAllGraGras();
                    ((AttrTupleManager)AttrTupleManager.getDefaultManager()).setVariableContext(false);
                    if (CriticalPairAnalysis.this.selectedGraGra != null) {
                        CriticalPairAnalysis.this.selectedGraGra.setEditable(true);
                        CriticalPairAnalysis.this.selectedGraGra.updateRules();
                    }
                    CriticalPairAnalysis.this.isLocked = false;
                    CriticalPairAnalysis.this.fireParserEvent(new ParserMessageEvent(this, "Grammar isn't locked anymore."));
                }
            }
        });
    }

    private void startCPaddActionListener() {
        this.startCPconflicts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CriticalPairAnalysis.this.unlockAllGraGras();
                CriticalPairAnalysis.this.generateConflicts();
            }
        });
        this.startCPdependencies.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CriticalPairAnalysis.this.unlockAllGraGras();
                CriticalPairAnalysis.this.generateDependencies();
            }
        });
    }

    public boolean compareCurrentGraGraToSelectedGraGra() {
        if (this.selectedGraGra == null || this.pairsGraGra == null || this.pairsGraGra.getBasisGraGra() == null) {
            return true;
        }
        if (this.pairsGraGra == this.selectedGraGra) {
            if (this.cpOption.layeredEnabled() && this.cpOption.layeredEnabled() != this.layerUsed()) {
                this.message = "layered";
                return false;
            }
            return true;
        }
        if (!this.pairsGraGra.getBasisGraGra().compareTo(this.selectedGraGra.getBasisGraGra(), true) && !this.pairsSaved) {
            return false;
        }
        if (this.cpOption.layeredEnabled() && !this.layerUsed() && !this.pairsSaved) {
            return false;
        }
        return this.cpOption.layeredEnabled() || !this.layerUsed() || this.pairsSaved;
    }

    public void generateConflicts() {
        if (!this.compareCurrentGraGraToSelectedGraGra()) {
            int answer = this.gragraWarning("");
            if (answer == 0) {
                this.saveCriticalPairs();
            } else if (answer == 2) {
                return;
            }
            if (!this.resetGraGra(this.selectedGraGra)) {
                JOptionPane.showMessageDialog(null, "Something gone wrong. Cannot set selected grammar", "Grammar failed.", 2);
                return;
            }
        } else if (!this.isLocked) {
            this.resetWarning(false);
        }
        if (this.pairsGraGra == null || this.pairsGraGra.getBasisGraGra() == null) {
            JOptionPane.showMessageDialog(null, "There isn't any graph grammar available.", "Warning", 2);
            return;
        }
        if (!this.doAllowInheritance(this.pairsGraGra.getBasisGraGra())) {
            this.inheritanceWarning();
            return;
        }
        if (!this.areRulesInjective(this.pairsGraGra.getBasisGraGra())) {
            return;
        }
        if (!this.changer.isSet()) {
            if (this.checkIfReadyToTransform(this.pairsGraGra)) {
                this.cpOption.setCriticalPairAlgorithm(0);
                this.cpOptionGUI.update();
                this.pairsContainer = this.generateNew(this.pairsContainer);
                this.changeToCPAgui(this.pairsGUI.getContainer());
            }
        } else {
            this.cpOption.setCriticalPairAlgorithm(0);
            this.cpOptionGUI.update();
            if (this.pairsContainer == null) {
                this.pairsContainer = this.generateNew(this.pairsContainer);
            } else {
                this.generate(this.pairsContainer);
            }
        }
    }

    public void generateDependencies() {
        if (!this.compareCurrentGraGraToSelectedGraGra()) {
            int answer = this.gragraWarning("");
            if (answer == 0) {
                this.saveCriticalPairs();
            } else if (answer == 2) {
                return;
            }
            if (!this.resetGraGra(this.selectedGraGra)) {
                JOptionPane.showMessageDialog(null, "Something gone wrong. Cannot set selected grammar.", "Grammar failed", 2);
                return;
            }
        } else if (!this.isLocked) {
            this.resetWarning(false);
        }
        if (this.pairsGraGra == null || this.pairsGraGra.getBasisGraGra() == null) {
            JOptionPane.showMessageDialog(null, "No graph grammar is available.", "Warning", 2);
            return;
        }
        if (!this.doAllowInheritance(this.pairsGraGra.getBasisGraGra())) {
            this.inheritanceWarning();
            return;
        }
        if (!this.areRulesInjective(this.pairsGraGra.getBasisGraGra())) {
            return;
        }
        if (!this.changer.isSet()) {
            if (this.checkIfReadyToTransform(this.pairsGraGra)) {
                if (this.cpOption.getCriticalPairAlgorithm() == 0) {
                    this.cpOption.setCriticalPairAlgorithm(1);
                    this.cpOptionGUI.update();
                }
                this.pairsContainer2 = this.generateNew(this.pairsContainer2);
                this.changeToCPAgui(this.pairsGUI.getContainer());
            }
        } else {
            if (this.cpOption.getCriticalPairAlgorithm() == 0) {
                this.cpOption.setCriticalPairAlgorithm(1);
                this.cpOptionGUI.update();
            }
            if (this.pairsContainer2 == null) {
                this.pairsContainer2 = this.generateNew(this.pairsContainer2);
            } else {
                this.generate(this.pairsContainer2);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private PairContainer generateNew(PairContainer pcontainer) {
        PairContainer pc = pcontainer;
        if (pc != null) {
            this.changeToCPAgui(this.pairsGUI.getContainer());
            this.generate(pc);
            return pc;
        }
        this.resetLayerFunction();
        pc = this.makeEmptyCriticalPairs(this.cpOption.getCriticalPairAlgorithm());
        if (pc == null) {
            JOptionPane.showMessageDialog(null, "Generating critical pairs failed.", "Warning", 2);
            return null;
        }
        if (!this.checkIfReadyToTransform(this.pairsGraGra)) {
            JOptionPane.showMessageDialog(null, "Generating critical pairs failed.", "Warning", 2);
            this.backCP.setEnabled(true);
            return null;
        }
        if (this.ruleList1 != null && this.ruleList2 != null) {
            pc.setRules(this.ruleList1, this.ruleList2);
        }
        this.resetCP_GUI(this.pairsGraGra, pc, true);
        this.rulesCP.setEnabled(false);
        this.resetCP.setEnabled(false);
        this.unlockCP.setEnabled(false);
        this.debugCP.setEnabled(false);
        this.backCP.setEnabled(true);
        this.changeToCPAgui(this.pairsGUI.getContainer());
        this.pairsGraGra.setEditable(false);
        this.isLocked = true;
        ParserFactory.generateCriticalPairs(pc);
        this.fireParserEvent(new ParserMessageEvent(this, "Generate critical pairs ...  Please wait ..."));
        this.startCP.setEnabled(false);
        this.stopCP.setEnabled(true);
        this.emptyCP.setEnabled(false);
        this.consistCP.setEnabled(false);
        this.loadCP.setEnabled(false);
        this.saveCP.setEnabled(false);
        this.showCP.setEnabled(false);
        this.checkHostGraphCP.setEnabled(false);
        return pc;
    }

    private void generate(PairContainer pc) {
        if (pc != null && pc.isAlive()) {
            JOptionPane.showMessageDialog(null, "Generating is already running.", "Warning", 2);
            return;
        }
        this.fireParserEvent(new ParserMessageEvent(this, "Generating critical pairs ... "));
        if (pc != null && ((ExcludePairContainer)pc).isComputed()) {
            this.rulesCP.setEnabled(false);
            this.resetCP.setEnabled(false);
            this.unlockCP.setEnabled(false);
            this.startCP.setEnabled(true);
            this.stopCP.setEnabled(false);
            this.emptyCP.setEnabled(true);
            this.consistCP.setEnabled(true);
            this.loadCP.setEnabled(true);
            this.saveCP.setEnabled(true);
            this.showCP.setEnabled(true);
            this.checkHostGraphCP.setEnabled(true);
            this.backCP.setEnabled(true);
            this.fireParserEvent(new ParserMessageEvent(this, "Generate critical pairs ... Done"));
        } else if (this.pairsGUI.isOnePairThreadAlive()) {
            this.rulesCP.setEnabled(false);
            this.resetCP.setEnabled(false);
            this.unlockCP.setEnabled(false);
            this.startCP.setEnabled(false);
            this.stopCP.setEnabled(true);
            this.emptyCP.setEnabled(true);
            this.consistCP.setEnabled(false);
            this.loadCP.setEnabled(false);
            this.saveCP.setEnabled(false);
            this.showCP.setEnabled(false);
            this.checkHostGraphCP.setEnabled(false);
            this.backCP.setEnabled(true);
            this.fireParserEvent(new ParserMessageEvent(this, "Generating critical pairs of the selected rules is still running ..."));
        } else if (this.checkIfReadyToTransform(this.pairsGraGra)) {
            this.pairsGraGra.setEditable(false);
            this.isLocked = true;
            PairContainer pc_tmp = null;
            if (this.resetLayerFunction()) {
                pc_tmp = this.makeEmptyCriticalPairs(this.cpOption.getCriticalPairAlgorithm());
                if (pc_tmp == null) {
                    JOptionPane.showMessageDialog(null, "Generating critical pairs failed.", "Warning", 2);
                    return;
                }
                if (pc_tmp.getKindOfConflict() == 0) {
                    this.pairsContainer = pc_tmp;
                } else if (pc_tmp.getKindOfConflict() == 1) {
                    this.pairsContainer2 = pc_tmp;
                }
            }
            if (pc_tmp != null) {
                if (this.ruleList1 != null && this.ruleList2 != null) {
                    pc_tmp.setRules(this.ruleList1, this.ruleList2);
                }
                this.resetCP_GUI(this.pairsGraGra, pc_tmp, false);
                ParserFactory.generateCriticalPairs(pc_tmp);
            } else {
                if (pc != null && this.ruleList1 != null && this.ruleList2 != null) {
                    pc.setRules(this.ruleList1, this.ruleList2);
                }
                this.resetCP_GUI(this.pairsGraGra, pc, false);
                ParserFactory.generateCriticalPairs(pc);
            }
            this.rulesCP.setEnabled(false);
            this.resetCP.setEnabled(false);
            this.unlockCP.setEnabled(false);
            this.startCP.setEnabled(false);
            this.stopCP.setEnabled(true);
            this.emptyCP.setEnabled(false);
            this.consistCP.setEnabled(false);
            this.loadCP.setEnabled(false);
            this.saveCP.setEnabled(false);
            this.showCP.setEnabled(false);
            this.checkHostGraphCP.setEnabled(false);
            this.backCP.setEnabled(true);
            this.fireParserEvent(new ParserMessageEvent(this, "Generating critical pairs ... Please wait ..."));
        } else {
            JOptionPane.showMessageDialog(null, "Generating critical pairs failed.", "Warning", 2);
            this.fireParserEvent(new ParserMessageEvent(this, "Generating critical pairs failed. "));
            this.backCP.setEnabled(true);
            return;
        }
    }

    private void stopCPaddActionListener() {
        this.stopCP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PairContainer pc = CriticalPairAnalysis.this.pairsGUI.getActivePairContainer();
                if (pc != null && pc.isAlive()) {
                    pc.stop();
                } else {
                    if (CriticalPairAnalysis.this.pairsContainer != null) {
                        if (CriticalPairAnalysis.this.pairsContainer.isAlive()) {
                            CriticalPairAnalysis.this.pairsContainer.stop();
                        } else if (CriticalPairAnalysis.this.pairsContainer.getActiveExcludePair() != null) {
                            CriticalPairAnalysis.this.pairsContainer.getActiveExcludePair().stop();
                        }
                    }
                    if (CriticalPairAnalysis.this.pairsContainer2 != null) {
                        if (CriticalPairAnalysis.this.pairsContainer2.isAlive()) {
                            CriticalPairAnalysis.this.pairsContainer2.stop();
                        } else if (CriticalPairAnalysis.this.pairsContainer2.getActiveExcludePair() != null) {
                            CriticalPairAnalysis.this.pairsContainer2.getActiveExcludePair().stop();
                        }
                    }
                }
                if (!CriticalPairAnalysis.this.backCP.isEnabled()) {
                    CriticalPairAnalysis.this.rulesCP.setEnabled(true);
                    CriticalPairAnalysis.this.resetCP.setEnabled(true);
                    CriticalPairAnalysis.this.unlockCP.setEnabled(true);
                    CriticalPairAnalysis.this.startCP.setEnabled(true);
                    CriticalPairAnalysis.this.stopCP.setEnabled(false);
                    CriticalPairAnalysis.this.debugCP.setEnabled(true);
                    CriticalPairAnalysis.this.emptyCP.setEnabled(false);
                    CriticalPairAnalysis.this.consistCP.setEnabled(false);
                    CriticalPairAnalysis.this.loadCP.setEnabled(true);
                    CriticalPairAnalysis.this.saveCP.setEnabled(false);
                    CriticalPairAnalysis.this.showCP.setEnabled(true);
                    CriticalPairAnalysis.this.checkHostGraphCP.setEnabled(true);
                } else {
                    CriticalPairAnalysis.this.startCP.setEnabled(true);
                    CriticalPairAnalysis.this.stopCP.setEnabled(false);
                    CriticalPairAnalysis.this.emptyCP.setEnabled(true);
                    CriticalPairAnalysis.this.consistCP.setEnabled(true);
                    CriticalPairAnalysis.this.loadCP.setEnabled(true);
                    CriticalPairAnalysis.this.saveCP.setEnabled(true);
                    CriticalPairAnalysis.this.showCP.setEnabled(true);
                    CriticalPairAnalysis.this.checkHostGraphCP.setEnabled(true);
                }
            }
        });
    }

    private void consistCPaddActionListener() {
        this.consistCP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CriticalPairAnalysis.this.changer.isSet()) {
                    PairContainer pc = CriticalPairAnalysis.this.pairsGUI.getActivePairContainer();
                    if (pc == null) {
                        if (CriticalPairAnalysis.this.pairsContainer != null && CriticalPairAnalysis.this.pairsContainer2 == null) {
                            pc = CriticalPairAnalysis.this.pairsContainer;
                        } else if (CriticalPairAnalysis.this.pairsContainer2 != null && CriticalPairAnalysis.this.pairsContainer == null) {
                            pc = CriticalPairAnalysis.this.pairsContainer2;
                        }
                    }
                    if (pc == CriticalPairAnalysis.this.pairsContainer) {
                        if (!CriticalPairAnalysis.this.pairsContainer.isEmpty()) {
                            if (!CriticalPairAnalysis.this.pairsContainer.getGrammar().getConstraints().hasMoreElements()) {
                                JOptionPane.showMessageDialog(null, "Nothing to check. Any constraint doesn't exist.");
                                return;
                            }
                            Thread t = new Thread(){

                                @Override
                                public void run() {
                                    ((ExcludePairContainer)(this).CriticalPairAnalysis.this.pairsContainer).checkConsistency();
                                }
                            };
                            t.setPriority(4);
                            t.start();
                            while (t.isAlive()) {
                            }
                            CriticalPairAnalysis.this.pairsGUI.setCriticalPairs(CriticalPairAnalysis.this.pairsContainer);
                        }
                    } else if (pc == CriticalPairAnalysis.this.pairsContainer2) {
                        if (!CriticalPairAnalysis.this.pairsContainer2.isEmpty()) {
                            if (!CriticalPairAnalysis.this.pairsContainer2.getGrammar().getConstraints().hasMoreElements()) {
                                JOptionPane.showMessageDialog(null, "Nothing to check. Any constraint doesn't exist.");
                                return;
                            }
                            Thread t = new Thread(){

                                @Override
                                public void run() {
                                    ((ExcludePairContainer)(this).CriticalPairAnalysis.this.pairsContainer2).checkConsistency();
                                }
                            };
                            t.setPriority(4);
                            t.start();
                            while (t.isAlive()) {
                            }
                            CriticalPairAnalysis.this.pairsGUI.setCriticalPairs(CriticalPairAnalysis.this.pairsContainer2);
                        }
                    } else {
                        JOptionPane.showMessageDialog(null, "Cannot check. \nPlease select a pair table first.", "", 2);
                    }
                }
            }
        });
    }

    private void emptyCPaddActionListener() {
        this.emptyCP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CriticalPairAnalysis.this.backCP.isEnabled()) {
                    if (CriticalPairAnalysis.this.pairsGUI.isOnePairThreadAlive()) {
                        CriticalPairAnalysis.this.pairsGUI.stopOnePairThread();
                    }
                    PairContainer pc = CriticalPairAnalysis.this.pairsGUI.getActivePairContainer();
                    String title = "Rule Conflicts";
                    if (pc == null) {
                        if (CriticalPairAnalysis.this.pairsContainer != null && CriticalPairAnalysis.this.pairsContainer2 == null) {
                            pc = CriticalPairAnalysis.this.pairsContainer;
                            title = "Rule Conflicts";
                        } else if (CriticalPairAnalysis.this.pairsContainer2 != null && CriticalPairAnalysis.this.pairsContainer == null) {
                            pc = CriticalPairAnalysis.this.pairsContainer2;
                            title = "Rule Dependencies";
                        }
                    } else if (pc == CriticalPairAnalysis.this.pairsContainer) {
                        title = "Rule Conflicts";
                    } else if (pc == CriticalPairAnalysis.this.pairsContainer2) {
                        title = "Rule Dependencies";
                    }
                    if (pc != null) {
                        int answer = 0;
                        if (pc.isComputed() || !pc.isEmpty()) {
                            answer = CriticalPairAnalysis.this.emptyWarning(title);
                        }
                        if (answer == 0) {
                            pc.clear();
                            pc.refreshOptions(CriticalPairAnalysis.this.cpOption);
                            if (pc.getKindOfConflict() == 0) {
                                CriticalPairAnalysis.this.pairsGUI.getGraphDesktop().getConflictPairPanel().refreshView();
                            } else {
                                CriticalPairAnalysis.this.pairsGUI.getGraphDesktop().getDependPairPanel().refreshView();
                            }
                            CriticalPairAnalysis.this.pairsGUI.update();
                            CriticalPairAnalysis.this.fireParserEvent(new ParserMessageEvent(this, "Empty critical pairs generated. Choose a pair of rules to check it. "));
                            CriticalPairAnalysis.this.startCP.setEnabled(true);
                            CriticalPairAnalysis.this.loadCP.setEnabled(true);
                            CriticalPairAnalysis.this.saveCP.setEnabled(true);
                        }
                    } else {
                        JOptionPane.showMessageDialog(null, "Cannot make empty. \nPlease select a pair table first.", "", 2);
                    }
                }
            }
        });
    }

    void showPairContainer(int kindOfConflict) {
        if (kindOfConflict == 0) {
            if (this.pairsContainer == null) {
                this.pairsContainer = this.makeEmptyCriticalPairs(0);
                this.resetCP_GUI(this.pairsGraGra, this.pairsContainer, true);
                this.fireParserEvent(new ParserMessageEvent(this, "Empty critical pairs generated. Choose a pair of rules to check it. "));
            } else {
                this.pairsGUI.getGraphDesktop().addCriticalPairTable(this.pairsGUI.getGraphDesktop().getConflictPairPanel(), "");
            }
            this.startCP.setEnabled(true);
            this.loadCP.setEnabled(true);
            this.saveCP.setEnabled(true);
        } else if (kindOfConflict == 1) {
            if (this.pairsContainer2 == null) {
                this.pairsContainer2 = this.makeEmptyCriticalPairs(1);
                this.resetCP_GUI(this.pairsGraGra, this.pairsContainer2, true);
                this.fireParserEvent(new ParserMessageEvent(this, "Empty critical pairs generated. Choose a pair of rules to check it. "));
            } else {
                this.pairsGUI.getGraphDesktop().addCriticalPairTable(this.pairsGUI.getGraphDesktop().getDependPairPanel(), "");
            }
            this.startCP.setEnabled(true);
            this.loadCP.setEnabled(true);
            this.saveCP.setEnabled(true);
        }
    }

    int emptyWarning(String obj) {
        Object[] options = new Object[]{"YES", "NO"};
        int answer = JOptionPane.showOptionDialog(null, "Are you sure, you want to delete already computed rule pairs?", "Delete   " + obj, -1, 2, null, options, options[1]);
        return answer;
    }

    int gragraWarning(String obj) {
        Object[] options = new Object[]{"YES", "NO", "CANCEL"};
        String s = "";
        if (obj != null && !obj.equals("")) {
            s = "\n( " + obj + " )";
        }
        int answer = JOptionPane.showOptionDialog(null, "Currently selected grammar is different from the grammar of critical pairs." + s + "\nCritical pairs are not empty. You can lose results." + "\nDo you want to save the results first?", "Different grammar   ", -1, 2, null, options, options[0]);
        return answer;
    }

    private void saveCPaddActionListener() {
        this.saveCP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CriticalPairAnalysis.this.pairsGUI.isGenerating()) {
                    CriticalPairAnalysis.this.fireParserEvent(new ParserMessageEvent(this, "Cannot save.  Computing is still running ..."));
                    return;
                }
                if (CriticalPairAnalysis.this.pairsGUI.isOnePairThreadAlive()) {
                    CriticalPairAnalysis.this.fireParserEvent(new ParserMessageEvent(this, "Cannot save.  Computing is still running ..."));
                    return;
                }
                if (CriticalPairAnalysis.this.changer.isSet()) {
                    CriticalPairAnalysis.this.saveCriticalPairs();
                }
            }
        });
    }

    void saveCriticalPairs() {
        ConflictsDependenciesContainerSaveLoad cdPC = new ConflictsDependenciesContainerSaveLoad(this.pairsContainer, this.pairsContainer2, this.cpaGraph, this.pairsGraGra);
        this.pairsIOGUI.setCriticalPairContainer(cdPC);
        this.pairsIOGUI.save();
        if (this.pairsIOGUI.fileIsSaved()) {
            this.treeView.setFileDirectory(this.pairsIOGUI.getDirectoryName());
            this.fireParserEvent(new ParserMessageEvent(this, "Critical pairs are saved."));
            this.pairsSaved = true;
        }
        this.pairsSaved = true;
    }

    private void debugCPaddActionListener() {
        this.debugCP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CriticalPairAnalysis.this.debugCPA();
            }
        });
    }

    void debugCPA() {
        if (this.pairsGraGra == null || this.pairsGraGra.getBasisGraGra() == null) {
            JOptionPane.showMessageDialog(null, "There isn't any graph grammar available.", "Warning", 2);
            return;
        }
        if (!this.doAllowInheritance(this.pairsGraGra.getBasisGraGra())) {
            this.inheritanceWarning();
            return;
        }
        if (!this.areRulesInjective(this.pairsGraGra.getBasisGraGra()) || !this.checkIfReadyToTransform(this.pairsGraGra)) {
            return;
        }
        if (!this.changer.isSet()) {
            if (!this.compareCurrentGraGraToSelectedGraGra()) {
                int answer = this.gragraWarning("");
                if (answer == 0) {
                    this.saveCriticalPairs();
                } else if (answer == 2) {
                    return;
                }
                this.setGraGra(this.selectedGraGra);
                if (!this.resetGraGra(this.selectedGraGra)) {
                    JOptionPane.showMessageDialog(null, "Something gone wrong. Cannot set selected grammar", "Grammar failed.", 2);
                    return;
                }
            } else if (!this.isLocked && !this.resetDone) {
                this.resetWarning(true);
            }
            this.unlockAllGraGras();
            this.pairsGraGra.setEditable(false);
            this.isLocked = !this.pairsGraGra.isEditable();
            this.changeToCPAgui(this.pairsGUI.getContainer());
            this.rulesCP.setEnabled(false);
            this.resetCP.setEnabled(false);
            this.unlockCP.setEnabled(false);
            this.debugCP.setEnabled(false);
            this.emptyCP.setEnabled(true);
            this.consistCP.setEnabled(true);
            this.saveCP.setEnabled(true);
            this.showCP.setEnabled(true);
            this.checkHostGraphCP.setEnabled(true);
            this.backCP.setEnabled(true);
            if (this.pairsContainer == null && this.cpOption.getCriticalPairAlgorithm() == 0) {
                this.resetLayerFunction();
                this.pairsContainer = this.makeEmptyCriticalPairs(this.cpOption.getCriticalPairAlgorithm());
                if (this.pairsContainer == null) {
                    JOptionPane.showMessageDialog(null, "Creating empty critical pairs failed.", "Warning", 2);
                    return;
                }
                if (this.ruleList1 != null && this.ruleList2 != null) {
                    this.pairsContainer.setRules(this.ruleList1, this.ruleList2);
                }
                this.resetCP_GUI(this.pairsGraGra, this.pairsContainer, true);
                this.fireParserEvent(new ParserMessageEvent(this, "Choose a pair of rules to check it."));
            } else if (this.pairsContainer2 == null && (this.cpOption.getCriticalPairAlgorithm() == 1 || this.cpOption.getCriticalPairAlgorithm() == 2)) {
                this.resetLayerFunction();
                this.pairsContainer2 = this.makeEmptyCriticalPairs(this.cpOption.getCriticalPairAlgorithm());
                if (this.pairsContainer2 == null) {
                    JOptionPane.showMessageDialog(null, "Creating empty critical pairs failed.", "Warning", 2);
                    return;
                }
                if (this.ruleList1 != null && this.ruleList2 != null) {
                    this.pairsContainer2.setRules(this.ruleList1, this.ruleList2);
                }
                this.resetCP_GUI(this.pairsGraGra, this.pairsContainer2, true);
                this.fireParserEvent(new ParserMessageEvent(this, "Choose a pair of rules to check it."));
            } else if (this.pairsGUI.pairsComputed()) {
                this.saveCP.setEnabled(true);
                this.fireParserEvent(new ParserMessageEvent(this, "Generating critical pairs ... Done"));
            } else if (this.pairsGUI.isOnePairThreadAlive()) {
                this.pairsGUI.getCriticalPairPanel().refreshView();
                this.pairsGUI.getCriticalPairPanel2().refreshView();
                this.stopCP.setEnabled(true);
                this.startCP.setEnabled(false);
                this.emptyCP.setEnabled(true);
                this.consistCP.setEnabled(false);
                this.loadCP.setEnabled(false);
                this.saveCP.setEnabled(false);
                this.showCP.setEnabled(false);
                this.checkHostGraphCP.setEnabled(false);
                this.fireParserEvent(new ParserMessageEvent(this, "Generating critical pairs of the selected rule pair is still running ..."));
            } else if (this.stopCP.isEnabled()) {
                this.emptyCP.setEnabled(false);
                this.consistCP.setEnabled(false);
                this.loadCP.setEnabled(false);
                this.saveCP.setEnabled(false);
                this.showCP.setEnabled(false);
                this.checkHostGraphCP.setEnabled(false);
                this.fireParserEvent(new ParserMessageEvent(this, "Generating critical pairs ... Continuing ..."));
            } else {
                this.fireParserEvent(new ParserMessageEvent(this, "Please choose a pair of rules to check it. "));
                this.startCP.setEnabled(true);
                this.emptyCP.setEnabled(true);
                this.consistCP.setEnabled(true);
                this.loadCP.setEnabled(true);
                this.saveCP.setEnabled(true);
                this.showCP.setEnabled(true);
                this.checkHostGraphCP.setEnabled(true);
            }
        }
    }

    private void loadCPaddActionListener() {
        this.loadCPcpx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object[] options;
                int answer;
                CriticalPairAnalysis.this.unlockAllGraGras();
                if (CriticalPairAnalysis.this.loadPairContainer(".cpx") && CriticalPairAnalysis.this.pairsGraGra != null && (answer = JOptionPane.showOptionDialog(null, "Do you want to put the grammar of critical pairs into GraGras treeview?", "Critical Pair Anlysis", -1, 3, null, options = new Object[]{"YES", "NO"}, options[0])) == 0) {
                    CriticalPairAnalysis.this.treeView.addGraGra(CriticalPairAnalysis.this.pairsGraGra);
                }
            }
        });
        this.loadSeparateCPcpx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CriticalPairAnalysisSeparated separatedFrame = CriticalPairAnalysis.this.loadPairContainerSeparated(".cpx");
                if (separatedFrame.getGraGra() != null) {
                    Object[] options = new Object[]{"YES", "NO"};
                    int answer = JOptionPane.showOptionDialog(null, "Do you want to put the grammar of critical pairs into GraGras treeview?", "Critical Pair Anlysis", -1, 3, null, options, options[0]);
                    if (answer == 0) {
                        separatedFrame.getGraGra().setChanged(false);
                        CriticalPairAnalysis.this.treeView.addGraGra(separatedFrame.getGraGra());
                    }
                    separatedFrame.toFront();
                }
            }
        });
    }

    private void checkHostGraphCPaddActionListener() {
        this.checkHostGraphCP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CriticalPairAnalysis.this.treeView.getCurrentGraGra() != null) {
                    if (CriticalPairAnalysis.this.pairsGUI.isOnePairThreadAlive()) {
                        return;
                    }
                    if (CriticalPairAnalysis.this.pairsGUI.isGenerating()) {
                        return;
                    }
                    if (!CriticalPairAnalysis.this.doAllowInheritance(CriticalPairAnalysis.this.treeView.getCurrentGraGra().getBasisGraGra())) {
                        CriticalPairAnalysis.this.inheritanceWarning();
                        return;
                    }
                    if (!CriticalPairAnalysis.this.treeView.getCurrentGraGra().getBasisGraGra().isGraphReadyForTransform()) {
                        JOptionPane.showMessageDialog(null, " It was not possible to check the host graph.\nMaybe not all attributes of the host graph are set.", "Warning", 2);
                        return;
                    }
                    int kind = 0;
                    if (CriticalPairAnalysis.this.pairsContainer == null && CriticalPairAnalysis.this.pairsContainer2 == null) {
                        CriticalPairAnalysis.this.hostGraphCPA = new CriticalPairAnalysisSeparated((JFrame)CriticalPairAnalysis.this.parent, CriticalPairAnalysis.this.pairsIOGUI, CriticalPairAnalysis.this.cpOptionGUI, CriticalPairAnalysis.this.cpOption, CriticalPairAnalysis.this.lOption, CriticalPairAnalysis.this.pOption, CriticalPairAnalysis.this.option);
                    } else if (CriticalPairAnalysis.this.pairsContainer != null && CriticalPairAnalysis.this.pairsContainer2 != null) {
                        if (CriticalPairAnalysis.this.pairsGUI.getActivePairContainer() != null) {
                            kind = CriticalPairAnalysis.this.pairsGUI.getActivePairContainer().getKindOfConflict();
                        }
                        if (kind == 0) {
                            CriticalPairAnalysis.this.hostGraphCPA = new CriticalPairAnalysisSeparated((JFrame)CriticalPairAnalysis.this.parent, (ExcludePairContainer)CriticalPairAnalysis.this.pairsContainer, null, CriticalPairAnalysis.this.cpOption, CriticalPairAnalysis.this.lOption, CriticalPairAnalysis.this.pOption, CriticalPairAnalysis.this.option);
                        } else if (kind == 1 || kind == 2) {
                            CriticalPairAnalysis.this.hostGraphCPA = null;
                            JOptionPane.showMessageDialog(null, "Sorry. To check rule dependency at the host graph isn't possible.", "Warning", 2);
                        }
                    } else if (CriticalPairAnalysis.this.pairsContainer != null && !CriticalPairAnalysis.this.pairsContainer.isEmpty()) {
                        CriticalPairAnalysis.this.hostGraphCPA = new CriticalPairAnalysisSeparated((JFrame)CriticalPairAnalysis.this.parent, (ExcludePairContainer)CriticalPairAnalysis.this.pairsContainer, null, CriticalPairAnalysis.this.cpOption, CriticalPairAnalysis.this.lOption, CriticalPairAnalysis.this.pOption, CriticalPairAnalysis.this.option);
                    } else if (CriticalPairAnalysis.this.pairsContainer2 != null && !CriticalPairAnalysis.this.pairsContainer2.isEmpty()) {
                        CriticalPairAnalysis.this.hostGraphCPA = null;
                        JOptionPane.showMessageDialog(null, "Sorry. To check rule dependency at the host graph isn't possible.", "Warning", 2);
                    } else {
                        JOptionPane.showMessageDialog(null, "Sorry. There is nothing to check.", "Warning", 2);
                        return;
                    }
                    if (CriticalPairAnalysis.this.hostGraphCPA != null) {
                        if (CriticalPairAnalysis.this.changer.isSet()) {
                            CriticalPairAnalysis.this.backToMainGUI(true);
                        }
                        CriticalPairAnalysis.this.hostGraphFrame = CriticalPairAnalysis.this.hostGraphCPA.getFrame();
                        CriticalPairAnalysis.this.separatedFrames.put(CriticalPairAnalysis.this.hostGraphFrame, CriticalPairAnalysis.this.hostGraphCPA);
                        CriticalPairAnalysis.this.hostGraphFrame.addWindowListener(CriticalPairAnalysis.this.wl);
                        CriticalPairAnalysis.this.x += 100;
                        CriticalPairAnalysis.this.y = 50;
                        CriticalPairAnalysis.this.hostGraphCPA.setLocation(CriticalPairAnalysis.this.x, CriticalPairAnalysis.this.y);
                        CriticalPairAnalysis.this.fireParserEvent(new ParserMessageEvent(this, "Critical pairs are loaded. Checking the host graph. Please wait ..."));
                        if (CriticalPairAnalysis.this.hostGraphCPA.getCriticalPairAnalysisGUI().getCriticalPairPanel(kind) != null) {
                            CriticalPairAnalysis.this.hostGraphCPA.getCriticalPairAnalysisGUI().getGraphDesktop().addParserGUIListener(cpa);
                            CriticalPairAnalysis.this.hostGraphCPA.getCriticalPairAnalysisGUI().getCriticalPairPanel(kind).addParserGUIListener(cpa);
                            ExcludePairContainer epc = CriticalPairAnalysis.this.hostGraphCPA.getPairContainer(kind);
                            if (epc != null) {
                                if (CriticalPairAnalysis.this.treeView.getCurrentGraGra().getBasisGraGra().getTypeSet().contains(epc.getGrammar().getTypeSet())) {
                                    epc.enableUseHostGraph(true, CriticalPairAnalysis.this.treeView.getCurrentGraGra().getBasisGraGra().getGraph(), CriticalPairAnalysis.this.treeView.getCurrentGraGra().getBasisGraGra().getMorphismCompletionStrategy());
                                    ParserFactory.generateCriticalPairs(epc);
                                    while (epc.isAlive()) {
                                    }
                                    CriticalPairAnalysis.this.fireParserEvent(new ParserMessageEvent(this, " "));
                                    CriticalPairAnalysis.this.startCP.setEnabled(true);
                                    CriticalPairAnalysis.this.stopCP.setEnabled(false);
                                    CriticalPairAnalysis.this.emptyCP.setEnabled(true);
                                    CriticalPairAnalysis.this.consistCP.setEnabled(true);
                                    CriticalPairAnalysis.this.loadCP.setEnabled(true);
                                    CriticalPairAnalysis.this.saveCP.setEnabled(true);
                                    CriticalPairAnalysis.this.showCP.setEnabled(true);
                                    CriticalPairAnalysis.this.checkHostGraphCP.setEnabled(true);
                                    CriticalPairAnalysis.this.hostGraphCPA.getCriticalPairAnalysisGUI().getGraphDesktop().setIconOfCPAGraph(true);
                                    CriticalPairAnalysis.this.hostGraphCPA.getCriticalPairAnalysisGUI().getGraphDesktop().setIconOfPairTable(CriticalPairAnalysis.this.hostGraphCPA.getCriticalPairAnalysisGUI().getCriticalPairPanel2(), true);
                                    CriticalPairAnalysis.this.hostGraphCPA.showFrame();
                                } else {
                                    CriticalPairAnalysis.this.separatedFrames.remove(CriticalPairAnalysis.this.hostGraphFrame);
                                    CriticalPairAnalysis.this.hostGraphFrame.dispose();
                                    JOptionPane.showMessageDialog(null, "It was not possible to check the host graph.\nMismatch between types of the host graph and a CPA-grammar.", "Warning", 2);
                                }
                            }
                        }
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "There isn't any graph to check.", "Warning", 2);
                }
            }
        });
    }

    private void showCPaddActionListener() {
        this.showConflictCP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CriticalPairAnalysis.this.showPairContainer(0);
            }
        });
        this.showDependencyCP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CriticalPairAnalysis.this.showPairContainer(1);
            }
        });
        this.showCPAGraphCPaddActionListener();
    }

    private void showCPAGraphCPaddActionListener() {
        this.cpaCombiGraphCP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CriticalPairAnalysis.this.showCPAGraph();
            }
        });
    }

    public void showCPAGraph() {
        if (this.pairsContainer != null || this.pairsContainer2 != null) {
            if (this.cpaGraph != null) {
                if (this.conflictDependGraph != null) {
                    if (this.pairsContainer != null) {
                        this.pairsGUI.getGraphDesktop().getConflictPairPanel().removeParserGUIListener(this.conflictDependGraph);
                    }
                    if (this.pairsContainer2 != null) {
                        this.pairsGUI.getGraphDesktop().getDependPairPanel().removeParserGUIListener(this.conflictDependGraph);
                    }
                    this.pairsGUI.getGraphDesktop().removeActionListenerFromCPAGraphMenu(this.conflictDependGraph);
                    this.conflictDependGraph.dispose();
                    this.cpaGraph = null;
                }
                this.pairsGUI.getGraphDesktop().removeAllGraphFrames();
                this.pairsGUI.getGraphDesktop().removeRuleFrames();
                this.pairsGUI.getGraphDesktop().removeCPAGraphFrame();
                this.pairsGUI.getGraphDesktop().getDesktop().repaint();
                this.conflictDependGraph = new ConflictsDependenciesGraph((ExcludePairContainer)this.pairsContainer, (ExcludePairContainer)this.pairsContainer2, null, false);
                this.cpaGraph = this.conflictDependGraph.getGraph();
                if (this.cpaGraph != null) {
                    if (this.pairsContainer != null) {
                        this.pairsGUI.getGraphDesktop().getConflictPairPanel().addParserGUIListener(this.conflictDependGraph);
                    }
                    if (this.pairsContainer2 != null) {
                        this.pairsGUI.getGraphDesktop().getDependPairPanel().addParserGUIListener(this.conflictDependGraph);
                    }
                    this.pairsGUI.getGraphDesktop().addActionListenerToCPAGraphMenu(this.conflictDependGraph);
                    this.conflictDependGraph.setGraphDesktop(this.pairsGUI.getGraphDesktop());
                    try {
                        this.pairsGUI.getGraphDesktop().addGraph(this.cpaGraph, 400, 300).setIcon(false);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                    this.pairsGUI.getGraphDesktop().refresh();
                }
            } else {
                this.conflictDependGraph = new ConflictsDependenciesGraph((ExcludePairContainer)this.pairsContainer, (ExcludePairContainer)this.pairsContainer2);
                this.cpaGraph = this.conflictDependGraph.getGraph();
                if (this.cpaGraph != null) {
                    if (this.pairsContainer != null) {
                        this.pairsGUI.getGraphDesktop().getConflictPairPanel().addParserGUIListener(this.conflictDependGraph);
                    }
                    if (this.pairsContainer2 != null) {
                        this.pairsGUI.getGraphDesktop().getDependPairPanel().addParserGUIListener(this.conflictDependGraph);
                    }
                    this.pairsGUI.getGraphDesktop().addActionListenerToCPAGraphMenu(this.conflictDependGraph);
                    this.conflictDependGraph.setGraphDesktop(this.pairsGUI.getGraphDesktop());
                    this.pairsGUI.getGraphDesktop().getDesktop().repaint();
                    try {
                        this.pairsGUI.getGraphDesktop().addGraph(this.cpaGraph, 400, 300).setIcon(false);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                } else {
                    JOptionPane.showMessageDialog(null, "There is nothing to show.", "Warning", 2);
                }
            }
        } else {
            this.loadPairContainerSeparated(".cpx");
        }
    }

    private void backCPaddActionListener() {
        this.backCP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((AttrTupleManager)AttrTupleManager.getDefaultManager()).setVariableContext(false);
                if (CriticalPairAnalysis.this.changer.isSet()) {
                    CriticalPairAnalysis.this.backToMainGUI(false);
                }
            }
        });
    }

    void backToMainGUI(boolean warning) {
        Object[] options;
        int answer;
        if (warning && (answer = JOptionPane.showOptionDialog(null, "Do you want to change to graph editor to observe the host graph?", "", -1, 2, null, options = new Object[]{"YES", "NO"}, options[1])) != 0) {
            return;
        }
        this.changeToAGGgui();
        if (!this.stopCP.isEnabled()) {
            this.rulesCP.setEnabled(true);
            this.resetCP.setEnabled(true);
            this.unlockCP.setEnabled(true);
            this.debugCP.setEnabled(true);
            this.emptyCP.setEnabled(false);
        } else {
            this.rulesCP.setEnabled(false);
            this.resetCP.setEnabled(false);
            this.unlockCP.setEnabled(false);
            this.debugCP.setEnabled(true);
            this.emptyCP.setEnabled(false);
            this.loadCP.setEnabled(false);
        }
        this.consistCP.setEnabled(false);
        this.saveCP.setEnabled(false);
        this.showCP.setEnabled(false);
        this.backCP.setEnabled(false);
        this.pairsGraGra.setEditable(true);
        this.pairsGraGra.getBasisGraGra().removeShiftedApplConditionsFromMultiRules();
        if (this.pairsContainer != null) {
            this.pairsContainer.restoreExprReplacedByVarInApplConds();
        } else if (this.pairsContainer2 != null) {
            this.pairsContainer2.restoreExprReplacedByVarInApplConds();
        }
        if (this.pairsContainer instanceof LayeredExcludePairContainer || this.pairsContainer2 instanceof LayeredDependencyPairContainer) {
            this.treeView.getTreeModel().ruleNameChanged(this.pairsGraGra, true);
            this.treeView.getTree().treeDidChange();
        }
        this.pairsGraGra.update();
        if (this.gragraChanged.get(this.pairsGraGra) != null) {
            this.pairsGraGra.setChanged(this.gragraChanged.get(this.pairsGraGra));
        } else {
            this.pairsGraGra.setChanged(false);
        }
        this.resetDone = false;
        this.fireParserEvent(new ParserMessageEvent(this, "back to AGG editor ... The grammar  <" + this.pairsGraGra.getName() + ">  is still used by CPA."));
    }

    private void updateCPAgraph() {
        if (this.cpaGraph != null && this.conflictDependGraph != null) {
            this.conflictDependGraph.updateGraphAlongPairContainer();
            this.cpaGraph.makeGraphObjectsOfNewBasisObjects(false);
            this.cpaGraph.setTransformChangeEnabled(true);
            this.cpaGraph.updateGraph();
            this.cpaGraph.setTransformChangeEnabled(false);
            this.pairsGUI.getGraphDesktop().refresh();
        }
    }

    @Override
    public void occured(ParserGUIEvent e) {
        if (e.getSource() instanceof CriticalPairPanel) {
            this.overlapGraphs = null;
        }
        if (e.getSource() instanceof GraphDesktop) {
            this.graphDesktop = (GraphDesktop)e.getSource();
            if (e.getData() instanceof Graph) {
                if (this.overlapGraphs == null) {
                    this.overlapGraphs = new Hashtable();
                }
                this.overlapGraph = (Graph)e.getData();
                if (this.overlapGraphs.get(this.overlapGraph) == null) {
                    ExcludePairContainer epc = this.hostGraphCPA.getPairContainer(0);
                    if (epc == null) {
                        this.overlapGraphs = null;
                        return;
                    }
                    Hashtable<Graph, Vector<Hashtable<GraphObject, GraphObject>>> ht = epc.getExcludeContainerForTestGraph();
                    Vector<Hashtable<GraphObject, GraphObject>> matches = ht.get(this.overlapGraph);
                    if (matches != null) {
                        this.hostGraphMappings = new Vector(matches.size());
                        this.hostGraphMappings.addAll(matches);
                        if (this.hostGraphMappings.size() > 1) {
                            this.nextMatchAtHostGraphButton = this.graphDesktop.addNextButton(this.overlapGraph, "Click here to get next match at host graph");
                            this.nextMatchAtHostGraphButton.addActionListener(this);
                        } else {
                            this.nextMatchAtHostGraphButton = null;
                        }
                        Pair<Vector<Hashtable<GraphObject, GraphObject>>, JButton> pair = new Pair<Vector<Hashtable<GraphObject, GraphObject>>, JButton>(this.hostGraphMappings, this.nextMatchAtHostGraphButton);
                        this.overlapGraphs.put(this.overlapGraph, pair);
                        if (this.hostGraphMappings.size() > 0) {
                            Hashtable<GraphObject, GraphObject> objs = this.hostGraphMappings.elementAt(0);
                            this.showCriticalMatch(this.treeView.getCurrentGraGra().getGraph(), this.graphDesktop.getInternalLayoutGraph(this.overlapGraph), objs);
                            this.treeView.graphDidChange();
                            this.hostGraphMappings.remove(0);
                        } else {
                            this.showCriticalMatch(this.treeView.getCurrentGraGra().getGraph(), null, null);
                            this.treeView.graphDidChange();
                        }
                    } else {
                        this.showCriticalMatch(this.treeView.getCurrentGraGra().getGraph(), null, null);
                        this.treeView.graphDidChange();
                    }
                } else {
                    Pair<Vector<Hashtable<GraphObject, GraphObject>>, JButton> pair = this.overlapGraphs.get(this.overlapGraph);
                    this.hostGraphMappings = (Vector)pair.first;
                    this.nextMatchAtHostGraphButton = (JButton)pair.second;
                    if (this.hostGraphMappings != null && this.hostGraphMappings.size() > 0) {
                        Hashtable<GraphObject, GraphObject> objs = this.hostGraphMappings.elementAt(0);
                        this.showCriticalMatch(this.treeView.getCurrentGraGra().getGraph(), this.graphDesktop.getInternalLayoutGraph(this.overlapGraph), objs);
                        this.treeView.graphDidChange();
                        this.hostGraphMappings.removeElementAt(0);
                    }
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButton) {
            if ((JButton)e.getSource() == this.nextMatchAtHostGraphButton) {
                if (this.hostGraphMappings != null && this.hostGraphMappings.size() > 0) {
                    Hashtable<GraphObject, GraphObject> objs = this.hostGraphMappings.elementAt(0);
                    this.showCriticalMatch(this.treeView.getCurrentGraGra().getGraph(), this.graphDesktop.getInternalLayoutGraph(this.overlapGraph), objs);
                    this.treeView.graphDidChange();
                    this.hostGraphMappings.remove(0);
                } else {
                    JOptionPane.showMessageDialog(this.hostGraphFrame, "No more matches.");
                }
            }
        } else if (e.getSource() == this.cpOptionGUI.getComponentMaxBoundOfCriticKind()) {
            if (this.pairsContainer != null) {
                this.pairsContainer.refreshOptions(this.cpOption);
            }
            if (this.pairsContainer2 != null) {
                this.pairsContainer2.refreshOptions(this.cpOption);
            }
        }
    }

    public void refreshOptionsOfPairContainer() {
        if (this.pairsContainer != null) {
            this.pairsContainer.refreshOptions(this.cpOption);
        }
        if (this.pairsContainer2 != null) {
            this.pairsContainer2.refreshOptions(this.cpOption);
        }
    }

    public PairContainer getConflictPairContainer() {
        return this.pairsContainer;
    }

    public PairContainer getDependencyPairContainer() {
        return this.pairsContainer2;
    }

    @Override
    public void newMessage(StatusMessageEvent sme) {
        if (sme.getMessage().indexOf("is running") >= 0) {
            this.stopCP.setEnabled(true);
        } else if (sme.getMessage().indexOf("finished") >= 0) {
            this.stopCP.setEnabled(false);
        }
    }

    protected boolean loadPairContainer(String filefilter) {
        if (this.pairsGUI.isOnePairThreadAlive()) {
            this.pairsGUI.stopOnePairThread();
        }
        this.pairsIOGUI.setFileFilter(filefilter);
        this.pairsIOGUI.setDirectoryName(this.treeView.getFileDirectory(), "");
        Object o = this.pairsIOGUI.load(true);
        if (o == null) {
            this.cpOption.enableLayered(false);
            return false;
        }
        this.treeView.setFileDirectory(this.pairsIOGUI.getDirectoryName());
        if (this.pairsIOGUI.isCombined()) {
            ConflictsDependenciesContainerSaveLoad cdc = (ConflictsDependenciesContainerSaveLoad)o;
            if (this.cpaGraph != null) {
                if (this.conflictDependGraph != null) {
                    if (this.pairsContainer != null) {
                        this.pairsGUI.getGraphDesktop().getConflictPairPanel().removeParserGUIListener(this.conflictDependGraph);
                    }
                    if (this.pairsContainer2 != null) {
                        this.pairsGUI.getGraphDesktop().getDependPairPanel().removeParserGUIListener(this.conflictDependGraph);
                    }
                    this.pairsGUI.getGraphDesktop().removeActionListenerFromCPAGraphMenu(this.conflictDependGraph);
                    this.conflictDependGraph = null;
                }
                this.cpaGraph = null;
            }
            this.cpOption.setOptionsFromList(cdc.getLoadedCPAOptions());
            if (this.pairsContainer != null) {
                this.removeEventListenersFromPairContainer(this.pairsContainer);
            }
            if (this.pairsContainer2 != null) {
                this.removeEventListenersFromPairContainer(this.pairsContainer2);
            }
            this.pairsGUI.reinitGraphDesktop();
            this.pairsContainer = null;
            this.pairsContainer2 = null;
            this.pairsGUI.getGraphDesktop().getDesktop().repaint();
            if (cdc.isPriority()) {
                if (cdc.getPriorityExcludePairContainer() != null) {
                    this.pairsContainer = cdc.getPriorityExcludePairContainer();
                }
                if (cdc.getPriorityDependencyPairContainer() != null) {
                    this.pairsContainer2 = cdc.getPriorityDependencyPairContainer();
                }
                this.cpOption.enablePriority(true);
                this.cpOption.enableLayered(false);
            } else if (cdc.isLayered()) {
                if (cdc.getLayeredExcludePairContainer() != null) {
                    this.pairsContainer = cdc.getLayeredExcludePairContainer();
                }
                if (cdc.getLayeredDependencyPairContainer() != null) {
                    this.pairsContainer2 = cdc.getLayeredDependencyPairContainer();
                }
                this.cpOption.enableLayered(true);
                this.cpOption.enablePriority(false);
            } else {
                if (cdc.getExcludePairContainer() != null) {
                    this.pairsContainer = cdc.getExcludePairContainer();
                    this.cpOption.setCriticalPairAlgorithm(this.pairsContainer.getKindOfConflict());
                }
                if (cdc.getDependencyPairContainer() != null) {
                    this.pairsContainer2 = cdc.getDependencyPairContainer();
                    this.cpOption.setCriticalPairAlgorithm(this.pairsContainer2.getKindOfConflict());
                }
                this.cpOption.enablePriority(false);
                this.cpOption.enableLayered(false);
            }
            if (cdc.getContainerCount() == 2) {
                this.pairsGraGra = cdc.getPairsGraGra();
                this.pairsGUI.setGraGra(this.pairsGraGra);
                this.resetCP_GUI(this.pairsGraGra, this.pairsContainer, true);
                this.resetCP_GUI(this.pairsGraGra, this.pairsContainer2, true);
            } else if (cdc.getContainerCount() == 1) {
                if (this.pairsContainer != null) {
                    this.pairsGraGra = cdc.getPairsGraGra();
                    this.pairsGUI.setGraGra(this.pairsGraGra);
                    this.resetCP_GUI(this.pairsGraGra, this.pairsContainer, true);
                } else if (this.pairsContainer2 != null) {
                    this.pairsGraGra = cdc.getPairsGraGra();
                    this.pairsGUI.setGraGra(this.pairsGraGra);
                    this.resetCP_GUI(this.pairsGraGra, this.pairsContainer2, true);
                }
            }
            this.cpaGraph = cdc.getCPAGraph();
            if (this.cpaGraph != null) {
                this.conflictDependGraph = new ConflictsDependenciesGraph((ExcludePairContainer)this.pairsContainer, (ExcludePairContainer)this.pairsContainer2, this.cpaGraph, true);
                this.conflictDependGraph.setGraphDesktop(this.pairsGUI.getGraphDesktop());
                this.pairsGUI.getGraphDesktop().addActionListenerToCPAGraphMenu(this.conflictDependGraph);
                if (this.pairsContainer != null) {
                    this.pairsGUI.getGraphDesktop().getConflictPairPanel().addParserGUIListener(this.conflictDependGraph);
                }
                if (this.pairsContainer2 != null) {
                    this.pairsGUI.getGraphDesktop().getDependPairPanel().addParserGUIListener(this.conflictDependGraph);
                }
                this.pairsGUI.getGraphDesktop().addGraph(this.cpaGraph, 400, 300);
                try {
                    if (this.pairsGUI.getGraphDesktop().getInternalCPAGraphFrame().isIcon()) {
                        this.pairsGUI.getGraphDesktop().getInternalCPAGraphFrame().setIcon(false);
                    }
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                this.pairsGUI.getGraphDesktop().refresh();
            }
            if (this.pairsGraGra != null) {
                this.pairsGraGra.setChanged(false);
                if (this.pairsGraGra.getBasisGraGra().isLayered()) {
                    this.cpOptionGUI.initLayers(this.pairsGraGra.getBasisGraGra().getEnabledLayers());
                }
            }
            this.cpOptionGUI.update();
            if (!this.changer.isSet()) {
                this.changeToCPAgui(this.pairsGUI.getContainer());
                this.rulesCP.setEnabled(false);
                this.resetCP.setEnabled(false);
                this.startCP.setEnabled(true);
                this.stopCP.setEnabled(false);
                this.debugCP.setEnabled(false);
                this.emptyCP.setEnabled(true);
                this.consistCP.setEnabled(true);
                this.saveCP.setEnabled(true);
                this.backCP.setEnabled(true);
                this.showCP.setEnabled(true);
                this.checkHostGraphCP.setEnabled(true);
            }
            this.fireParserEvent(new ParserMessageEvent(this, "Critical pairs are loaded."));
            this.pairsSaved = true;
            this.pairsGraGra.setChanged(false);
            return true;
        }
        this.fireParserEvent(new ParserMessageEvent(this, "Load ritical pairs failed."));
        return false;
    }

    protected CriticalPairAnalysisSeparated loadPairContainerSeparated(String filefilter) {
        this.pairsIOGUI.setDirectoryName(this.treeView.getFileDirectory(), "");
        this.pairsIOGUI.setFileFilter(filefilter);
        CriticalPairAnalysisSeparated separatedFrame = new CriticalPairAnalysisSeparated((JFrame)this.parent, this.pairsIOGUI, this.cpOptionGUI, this.cpOption, this.lOption, this.pOption, this.option);
        if (separatedFrame.isReady()) {
            separatedFrame.setExportJPEG(this.exportJPEG);
            this.x += 100;
            this.y = 50;
            separatedFrame.setLocation(this.x, this.y);
            separatedFrame.showFrame();
            this.separatedFrames.put(separatedFrame.getFrame(), separatedFrame);
            separatedFrame.getFrame().addWindowListener(this.wl);
            this.fireParserEvent(new ParserMessageEvent(this, "Critical pairs are loaded."));
            this.treeView.setFileDirectory(this.pairsIOGUI.getDirectoryName());
        }
        return separatedFrame;
    }

    protected void inheritanceWarning() {
        JOptionPane.showMessageDialog(null, "Sorry!\nThis item is not available for the graph grammar \nwith node type inheritance.", "Warning", 2);
    }

    protected void resetWarning(boolean warn) {
        int answer;
        int n = answer = warn ? -1 : 0;
        if (warn) {
            Object[] options = new Object[]{"Reset", "Keep"};
            answer = JOptionPane.showOptionDialog(null, "Do you want to reset the grammar for critical pair analysis?", "Warning", -1, 3, null, options, options[0]);
        }
        if (answer == 0) {
            this.resetCPAGraGra(this.selectedGraGra);
        } else {
            this.gragraChanged.put(this.selectedGraGra, new Boolean(this.selectedGraGra.isChanged()));
        }
    }

    private void showCriticalMatch(EdGraph hostg, EdGraph overlapg, Hashtable<GraphObject, GraphObject> map) {
        hostg.deselectAll();
        for (GraphObject graphObject : hostg.getBasisGraph().getNodesSet()) {
            graphObject.setCritical(false);
            EdNode n = hostg.findNode(graphObject);
            if (n == null) continue;
            n.clearMorphismMark();
        }
        for (GraphObject graphObject : hostg.getBasisGraph().getArcsSet()) {
            graphObject.setCritical(false);
            EdArc a = hostg.findArc(graphObject);
            if (a == null) continue;
            a.clearMorphismMark();
        }
        if (overlapg == null) {
            hostg.update();
            return;
        }
        Enumeration<GraphObject> enumeration = map.keys();
        while (enumeration.hasMoreElements()) {
            EdArc ai;
            GraphObject o = enumeration.nextElement();
            GraphObject i = map.get(o);
            i.setCritical(true);
            EdNode no = overlapg.findNode(o);
            if (no != null) {
                EdNode ni = hostg.findNode(i);
                if (ni == null) continue;
                ni.addMorphismMark(no.getMorphismMark());
                continue;
            }
            EdArc ao = overlapg.findArc(o);
            if (ao == null || (ai = hostg.findArc(i)) == null) continue;
            ai.addMorphismMark(ao.getMorphismMark());
        }
        int i = 0;
        while (i < hostg.getNodes().size()) {
            EdNode n = hostg.getNodes().elementAt(i);
            if (n.getBasisNode().isCritical()) {
                hostg.setSelectedNode(n);
            }
            ++i;
        }
        i = 0;
        while (i < hostg.getArcs().size()) {
            EdArc a = hostg.getArcs().elementAt(i);
            if (a.getBasisArc().isCritical()) {
                hostg.setSelectedArc(a);
            }
            ++i;
        }
        hostg.update();
    }

    public void addCPAnalysisEventListener(ParserEventListener l) {
        if (!this.listener.contains(l)) {
            this.listener.add(0, l);
        }
    }

    public void removeCPAnalysisEventListener(ParserEventListener l) {
        if (this.listener.contains(l)) {
            this.listener.removeElement(l);
        }
    }

    synchronized void fireParserEvent(ParserEvent e) {
        int i = 0;
        while (i < this.listener.size()) {
            this.listener.elementAt(i).parserEventOccured(e);
            ++i;
        }
    }

    public void addStatusMessageListener(StatusMessageListener l) {
        if (!this.pmlistener.contains(l)) {
            this.pmlistener.add(0, l);
        }
        this.pairsGUI.addStatusMessageListener(l);
    }

    protected boolean resetLayerFunction() {
        if (this.cpOption.layeredEnabled()) {
            if (!(this.pairsContainer != null && this.pairsContainer.getLayer() != null || this.pairsContainer2 != null && this.pairsContainer2.getLayer() != null)) {
                RuleLayer tmpRL = new RuleLayer(this.pairsGraGra.getBasisGraGra().getEnabledRules());
                this.rlayer = new RuleLayer(this.pairsGraGra.getBasisGraGra().getEnabledRules());
                LayerGUI lgui = new LayerGUI(this.parent, this.rlayer);
                lgui.showGUI();
                if (lgui.isCancelled()) {
                    this.cpOption.enableLayered(false);
                    this.cpOptionGUI.update();
                } else if (tmpRL.compareTo(this.rlayer)) {
                    return false;
                }
                return true;
            }
            return false;
        }
        return this.pairsContainer != null && this.pairsContainer.getLayer() != null || this.pairsContainer2 != null && this.pairsContainer2.getLayer() != null;
    }

    protected PairContainer makeEmptyCriticalPairs(int kindOfAlgorithm) {
        if (kindOfAlgorithm == 0) {
            if (this.pairsContainer != null) {
                this.pairsContainer.clear();
                this.pairsContainer.refreshOptions(this.cpOption);
                return this.pairsContainer;
            }
            PairContainer pc = ParserFactory.createEmptyCriticalPairs(this.pairsGraGra.getBasisGraGra(), kindOfAlgorithm, this.cpOption.layeredEnabled());
            if (this.conflictDependGraph != null && pc != null) {
                pc.addPairEventListener(this.conflictDependGraph);
                this.conflictDependGraph.setConflictPairContainer(pc);
            }
            return pc;
        }
        if (kindOfAlgorithm == 1 || kindOfAlgorithm == 2) {
            if (this.pairsContainer2 != null) {
                this.pairsContainer2.clear();
                this.pairsContainer2.refreshOptions(this.cpOption);
                return this.pairsContainer2;
            }
            PairContainer pc = ParserFactory.createEmptyCriticalPairs(this.pairsGraGra.getBasisGraGra(), kindOfAlgorithm, this.cpOption.layeredEnabled());
            if (this.conflictDependGraph != null && pc != null) {
                pc.addPairEventListener(this.conflictDependGraph);
                this.conflictDependGraph.setDependencyPairContainer(pc);
            }
            return pc;
        }
        return null;
    }

    void resetCP_GUI(EdGraGra gragra, PairContainer pc, boolean newpc) {
        if (gragra == null || gragra.getRules().isEmpty()) {
            return;
        }
        if (pc != null) {
            this.pairsGUI.showGACsWarn = true;
            if (this.pairsGUI.getGraGra() == gragra) {
                if (newpc) {
                    this.addEventListenersToPairContainer(pc);
                    this.pairsGUI.setCriticalPairs(pc);
                } else {
                    this.pairsGUI.update();
                }
                this.setCPoptions((ExcludePairContainer)pc);
                if (pc instanceof LayeredExcludePairContainer) {
                    ((LayeredExcludePairContainer)pc).setLayer(this.cpOption.getLayer());
                } else if (pc instanceof LayeredDependencyPairContainer) {
                    ((LayeredDependencyPairContainer)pc).setLayer(this.cpOption.getLayer());
                }
            }
        }
        int i = 0;
        while (i < this.separatedFrames.size()) {
            if (this.separatedFrames.get(new Integer(i)) != null) {
                CriticalPairAnalysisSeparated cpas = this.separatedFrames.get(new Integer(i));
                ExcludePairContainer excludePC = cpas.getPairContainer(0);
                ExcludePairContainer excludePC2 = cpas.getPairContainer(1);
                if (excludePC != null) {
                    this.setCPoptions(excludePC);
                }
                if (excludePC2 != null) {
                    this.setCPoptions(excludePC2);
                }
            }
            ++i;
        }
    }

    boolean checkIfReadyToTransform(EdGraGra gragra) {
        Object test;
        Pair<Object, String> pair = gragra.getBasisGraGra().isReadyToTransform(true);
        if (pair != null && !(pair.first instanceof Graph) && (test = pair.first) != null) {
            JOptionPane.showMessageDialog(null, "Cannot set the grammar to analyze.\n" + (String)pair.second, "Warning", 2);
            return false;
        }
        return true;
    }

    private void removeEventListenersFromPairContainer(PairContainer pc) {
        if (pc == null) {
            return;
        }
        int i = 0;
        while (i < this.listener.size()) {
            if (pc instanceof LayeredDependencyPairContainer) {
                ((LayeredDependencyPairContainer)pc).stop();
                ((LayeredDependencyPairContainer)pc).removePairEventListener(this.listener.elementAt(i));
            } else if (pc instanceof LayeredExcludePairContainer) {
                ((LayeredExcludePairContainer)pc).stop();
                ((LayeredExcludePairContainer)pc).removePairEventListener(this.listener.elementAt(i));
            } else if (pc instanceof DependencyPairContainer) {
                ((DependencyPairContainer)pc).stop();
                ((DependencyPairContainer)pc).removePairEventListener(this.listener.elementAt(i));
            } else if (pc instanceof ExcludePairContainer) {
                ((ExcludePairContainer)pc).stop();
                ((ExcludePairContainer)pc).removePairEventListener(this.listener.elementAt(i));
            }
            ++i;
        }
    }

    private void addEventListenersToPairContainer(PairContainer pc) {
        int i = 0;
        while (i < this.listener.size()) {
            if (pc instanceof LayeredDependencyPairContainer) {
                ((LayeredDependencyPairContainer)pc).addPairEventListener(this.listener.elementAt(i));
            } else if (pc instanceof LayeredExcludePairContainer) {
                ((LayeredExcludePairContainer)pc).addPairEventListener(this.listener.elementAt(i));
            } else if (pc instanceof PriorityDependencyPairContainer) {
                ((PriorityDependencyPairContainer)pc).addPairEventListener(this.listener.elementAt(i));
            } else if (pc instanceof PriorityExcludePairContainer) {
                ((PriorityExcludePairContainer)pc).addPairEventListener(this.listener.elementAt(i));
            } else if (pc instanceof DependencyPairContainer) {
                ((DependencyPairContainer)pc).addPairEventListener(this.listener.elementAt(i));
            } else if (pc instanceof ExcludePairContainer) {
                ((ExcludePairContainer)pc).addPairEventListener(this.listener.elementAt(i));
            }
            ++i;
        }
    }

    private boolean layerUsed() {
        if (this.pairsContainer != null && this.pairsContainer instanceof LayeredExcludePairContainer) {
            return true;
        }
        if (this.pairsContainer2 != null && this.pairsContainer2 instanceof LayeredDependencyPairContainer) {
            return true;
        }
        return this.pairsContainer == null && this.pairsContainer2 == null;
    }

    void resetRuleApplicable(GraGra gra) {
        int i = 0;
        while (i < gra.getListOfRules().size()) {
            Rule r = gra.getListOfRules().get(i);
            r.setApplicable(true);
            ++i;
        }
    }

    boolean doAllowInheritance(GraGra gra) {
        return !gra.getTypeSet().usesInheritance() || this.allowNodeTypeInheritance;
    }

    boolean areRulesInjective(GraGra gra) {
        Vector<Rule> noninjectives = gra.getNonInjectiveRules();
        String text = "\n[ ";
        int i = 0;
        while (i < noninjectives.size()) {
            text = String.valueOf(text) + noninjectives.get(i).getName() + "  ";
            ++i;
        }
        text = String.valueOf(text) + "]";
        if (!gra.getNonInjectiveRules().isEmpty()) {
            JOptionPane.showMessageDialog(null, "Sorry!\nThis item isn't available for the graph grammar \nwith non-injective rules." + text, "Warning", 2);
            return false;
        }
        return true;
    }

    private void changeToCPAgui(Component c) {
        this.addBackToAGGMenuBar(this.parent);
        this.changer.changeWith(c);
    }

    private void changeToAGGgui() {
        ((AttrTupleManager)AttrTupleManager.getDefaultManager()).setVariableContext(false);
        this.removeBackFromAGGMenuBar(this.parent);
        this.changer.restore();
    }
}

