/*
 * Decompiled with CFR 0.152.
 */
package agg.editor.impl;

import agg.gui.animation.AnimationParam;
import agg.util.XMLHelper;
import agg.util.XMLObject;
import agg.xt_basis.Type;
import java.awt.Color;
import java.util.List;
import java.util.Vector;

public class EdType
implements XMLObject {
    public String name = "";
    public int shape = 51;
    public Color color = Color.black;
    public boolean filled;
    public String imageFileName = "";
    public String resourcesPath = System.getProperty("user.dir");
    public final AnimationParam animationParameter = new AnimationParam(0, 0, 10, 0);
    protected boolean iconable;
    protected boolean animated;
    protected Type bType;
    protected String itsContextUsage;
    private boolean typeKeyChanged;
    private boolean attrTypeChanged;

    public EdType(String name, int shape, Color color, String iconFileName, Type bType) {
        this.name = name;
        this.shape = shape;
        this.color = color;
        this.imageFileName = iconFileName;
        this.bType = bType;
        if (bType != null) {
            this.bType.setStringRepr(name);
            this.setAdditionalReprOfBasisType(this.shape, this.color, this.filled, this.imageFileName);
        }
        this.itsContextUsage = "";
    }

    public EdType(String name, int shape, Color color, boolean filledShape, String iconFileName, Type bType) {
        this.name = name;
        this.shape = shape;
        this.color = color;
        this.filled = filledShape;
        this.imageFileName = iconFileName;
        this.bType = bType;
        if (bType != null) {
            this.bType.setStringRepr(name);
            this.setAdditionalReprOfBasisType(this.shape, this.color, this.filled, this.imageFileName);
        }
        this.itsContextUsage = "";
    }

    public EdType() {
        this("", 51, Color.black, "", null);
    }

    public EdType(String name) {
        this(name, 51, Color.black, "", null);
    }

    public EdType(String name, int shape, Color color, String iconFileName) {
        this(name, shape, color, iconFileName, null);
    }

    public EdType(String name, int shape, Color color, boolean filledShape, String iconFileName) {
        this(name, shape, color, filledShape, iconFileName, null);
    }

    public EdType(String name, Type bType) {
        this(name, 51, Color.black, "", bType);
    }

    public EdType(Type bType) {
        this(bType, 51, Color.black, "");
    }

    public EdType(Type bType, int shape, Color color, String iconFileName) {
        this(bType != null ? bType.getStringRepr() : "", shape, color, iconFileName, bType);
    }

    public EdType(Type bType, int shape, Color color, boolean filledShape, String iconFileName) {
        this(bType != null ? bType.getStringRepr() : "", shape, color, filledShape, iconFileName, bType);
    }

    public void dispose() {
        this.bType = null;
    }

    public void finalize() {
    }

    public void setAttrTypeChanged(boolean b) {
        this.attrTypeChanged = true;
    }

    public boolean hasAttrTypeChanged() {
        return this.attrTypeChanged;
    }

    public String getName() {
        return this.name;
    }

    public int getShape() {
        return this.shape;
    }

    public boolean hasFilledShape() {
        return this.filled;
    }

    public Color getColor() {
        return this.color;
    }

    public String getImageFileName() {
        return this.imageFileName;
    }

    public Type getBasisType() {
        return this.bType;
    }

    public String getTypeName() {
        if (this.bType != null) {
            return this.bType.getStringRepr();
        }
        return this.name;
    }

    public boolean isNodeType() {
        return this.bType.getAdditionalRepr().indexOf(":[NODE]:") >= 0;
    }

    public boolean isArcType() {
        return this.bType.getAdditionalRepr().indexOf(":[EDGE]:") >= 0;
    }

    public void setName(String nm) {
        this.name = nm;
        if (this.bType != null) {
            this.bType.setStringRepr(this.name);
        }
    }

    public void setShape(int sh) {
        this.shape = sh;
    }

    public void setFilledShape(boolean b) {
        this.filled = b;
    }

    public void setColor(Color col) {
        this.color = col;
    }

    public void setImageFileName(String fname) {
        this.imageFileName = fname;
    }

    public void setBasisType(Type btype) {
        this.bType = btype;
    }

    public void setAdditionalReprOfBasisType() {
        this.setAdditionalReprOfBasisType(this.shape, this.color, this.filled, this.imageFileName);
    }

    public void setAdditionalReprOfBasisType(int sh, Color col) {
        this.setAdditionalReprOfBasisType(sh, col, this.filled, this.imageFileName);
    }

    public void setAdditionalReprOfBasisType(int sh, Color col, String imgFilename) {
        this.setAdditionalReprOfBasisType(sh, col, this.filled, imgFilename);
    }

    public void setAdditionalReprOfBasisType(int sh, Color col, boolean filledShape, String imgFilename) {
        this.shape = sh;
        this.color = col;
        this.filled = filledShape;
        this.imageFileName = imgFilename;
        String shapeStr = "";
        String colorStr = this.color.toString();
        String markStr = "[]";
        switch (this.shape) {
            case 51: {
                shapeStr = "RECT";
                markStr = "[NODE]";
                break;
            }
            case 54: {
                shapeStr = "ROUNDRECT";
                markStr = "[NODE]";
                break;
            }
            case 52: {
                shapeStr = "CIRCLE";
                markStr = "[NODE]";
                break;
            }
            case 53: {
                shapeStr = "OVAL";
                markStr = "[NODE]";
                break;
            }
            case 55: {
                shapeStr = "ICON";
                markStr = "[NODE]";
                break;
            }
            case 61: {
                shapeStr = "SOLID_LINE";
                markStr = "[EDGE]";
                break;
            }
            case 62: {
                shapeStr = "DASH_LINE";
                markStr = "[EDGE]";
                break;
            }
            case 63: {
                shapeStr = "DOT_LINE";
                markStr = "[EDGE]";
                break;
            }
            default: {
                shapeStr = "RECT";
                markStr = "[NODE]";
            }
        }
        String filledStr = "";
        if (this.filled) {
            if ("[NODE]".equals(markStr)) {
                filledStr = "FILLED";
            } else if ("[EDGE]".equals(markStr)) {
                filledStr = "BOLD";
            }
        }
        String addRepr = ":";
        addRepr = addRepr.concat(shapeStr).concat(":");
        addRepr = addRepr.concat(colorStr).concat(":");
        if (!"".equals(filledStr)) {
            addRepr = addRepr.concat(filledStr).concat(":");
        }
        addRepr = addRepr.concat(markStr).concat(":");
        this.bType.setAdditionalRepr(addRepr);
        this.bType.setImageFilename(this.imageFileName);
    }

    protected void enrichAdditionalRepr() {
        if (!this.imageFileName.equals("") && this.bType.getImageFilename().indexOf(this.imageFileName) == -1) {
            this.bType.setImageFilename(this.imageFileName);
        }
    }

    public List<String> getAdditionalReprOfBasisType() {
        String addRepr = this.bType.getAdditionalRepr();
        String shapeStr = "";
        String colorStr = "";
        String filledStr = "";
        String imageFileNameStr = "";
        String markStr = "[]";
        String[] test = addRepr.split(":");
        int i = 0;
        while (i < test.length) {
            String testStr = test[i];
            if (testStr.indexOf("RECT") != -1 || testStr.indexOf("ROUND") != -1 || testStr.indexOf("CIRCLE") != -1 || testStr.indexOf("OVAL") != -1 || testStr.indexOf("IMAGE") != -1 || testStr.indexOf("SOLID_LINE") != -1 || testStr.indexOf("DASH_LINE") != -1 || testStr.indexOf("DOT_LINE") != -1) {
                shapeStr = testStr;
            } else if (testStr.indexOf("Color") != -1) {
                colorStr = testStr;
            } else if (testStr.indexOf("FILLED") != -1 || testStr.indexOf("BOLD") != -1) {
                filledStr = testStr;
            } else if (testStr.indexOf(".jpg") != -1 || testStr.indexOf(".gif") != -1 || testStr.indexOf(".xpm") != -1) {
                imageFileNameStr = testStr;
            } else if (testStr.indexOf("[NODE]") != -1 || testStr.indexOf("[EDGE]") != -1) {
                markStr = testStr;
            }
            ++i;
        }
        this.imageFileName = this.bType.getImageFilename();
        Vector<String> v = new Vector<String>(5);
        v.add(shapeStr);
        v.add(colorStr);
        v.add(filledStr);
        v.add(imageFileNameStr);
        v.add(markStr);
        return v;
    }

    public boolean hasOldAdditionalRepr() {
        if (this.bType == null) {
            return false;
        }
        if (!this.bType.getAdditionalRepr().equals("")) {
            return this.bType.getAdditionalRepr().indexOf("51:") != -1 || this.bType.getAdditionalRepr().indexOf("52:") != -1 || this.bType.getAdditionalRepr().indexOf("53:") != -1 || this.bType.getAdditionalRepr().indexOf("54:") != -1 || this.bType.getAdditionalRepr().indexOf("55:") != -1 || this.bType.getAdditionalRepr().indexOf("61:") != -1 || this.bType.getAdditionalRepr().indexOf("62:") != -1 || this.bType.getAdditionalRepr().indexOf("63:") != -1;
        }
        return true;
    }

    public void setIconable(boolean iconable) {
        this.iconable = iconable;
    }

    public boolean isIconable() {
        return !this.imageFileName.equals("") && this.iconable;
    }

    public void setAnimated(boolean b) {
        this.animated = b;
    }

    public boolean isAnimated() {
        return this.animated;
    }

    public int getAnimationKind() {
        return this.animationParameter.kind;
    }

    public void setResourcesPath(String path) {
        this.resourcesPath = path;
    }

    public String getResourcesPath() {
        return this.resourcesPath;
    }

    public void setContextUsage(String context) {
        this.itsContextUsage = context;
    }

    public String getContextUsage() {
        return this.itsContextUsage;
    }

    public boolean redefineType(String newName, int newShape, Color newColor, boolean filledshape, String newImageFileName) {
        if (!this.name.equals(newName) || this.shape != newShape || !this.color.equals(newColor) || this.filled != filledshape) {
            this.typeKeyChanged = true;
        }
        if (this.typeKeyChanged || !this.imageFileName.equals(newImageFileName)) {
            this.name = newName;
            this.shape = newShape;
            this.color = newColor;
            this.filled = filledshape;
            this.imageFileName = newImageFileName;
            if (this.bType != null) {
                this.bType.setStringRepr(this.name);
                this.setAdditionalReprOfBasisType(this.shape, this.color, filledshape, this.imageFileName);
            }
            return true;
        }
        return false;
    }

    public boolean hasTypeKeyChanged() {
        return this.typeKeyChanged;
    }

    public void setTypeKeyChanged(boolean b) {
        this.typeKeyChanged = b;
    }

    public boolean redefineType(String newName, int newShape, Color newColor, String newImageFileName, String newComment) {
        boolean result = this.redefineType(newName, newShape, newColor, false, newImageFileName);
        if (this.bType != null) {
            this.bType.setTextualComment(newComment);
        }
        return result;
    }

    public boolean redefineType(String newName, int newShape, Color newColor, boolean filledshape, String newImageFileName, String newComment) {
        boolean result = this.redefineType(newName, newShape, newColor, filledshape, newImageFileName);
        if (this.bType != null) {
            this.bType.setTextualComment(newComment);
        }
        return result;
    }

    public boolean compareTo(EdType t) {
        return this.bType.compareTo(t.getBasisType());
    }

    public boolean isParentOf(EdType t) {
        return this.bType.isParentOf(t.getBasisType());
    }

    @Override
    public void XwriteObject(XMLHelper h) {
        if (h.openObject(this.bType, this) && this.animated) {
            h.addAttr("animated", "true");
            h.openSubTag("Animation");
            h.addAttr("kind", this.animationParameter.getKind());
            h.addAttr("step", this.animationParameter.getStep());
            h.addAttr("delay", this.animationParameter.getDelay());
            h.addAttr("plus", this.animationParameter.getEndPlus());
            h.addAttr("edge", this.animationParameter.getTargetEdgeTypeName());
            h.close();
        }
    }

    @Override
    public void XreadObject(XMLHelper h) {
        h.peekObject(this.bType, this);
        String animatedAttr = h.readAttr("animated");
        if ("true".equals(animatedAttr)) {
            this.setAnimated(true);
            if (h.readSubTag("Animation")) {
                String par5;
                String par4;
                String par3;
                String par2;
                String par1 = h.readAttr("delay");
                if (!"".equals(par1)) {
                    this.animationParameter.setDelay(par1);
                }
                if (!"".equals(par2 = h.readAttr("kind"))) {
                    this.animationParameter.setKind(par2);
                }
                if (!"".equals(par3 = h.readAttr("step"))) {
                    this.animationParameter.setStep(par3);
                }
                if (!"".equals(par4 = h.readAttr("plus"))) {
                    this.animationParameter.setEndPlus(par4);
                }
                if (!"".equals(par5 = h.readAttr("edge"))) {
                    this.animationParameter.setTargetEdgeTypeName(par5);
                }
            }
        }
    }
}

