/*
 * Decompiled with CFR 0.152.
 */
package agg.parser;

import agg.parser.ExcludePairContainer;
import agg.parser.ExcludeParser;
import agg.parser.InvalidAlgorithmException;
import agg.parser.ParserErrorEvent;
import agg.parser.ParserMessageEvent;
import agg.parser.RuleInstances;
import agg.util.Pair;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.GraGra;
import agg.xt_basis.Graph;
import agg.xt_basis.Match;
import agg.xt_basis.MorphCompletionStrategy;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SimpleExcludeParser
extends ExcludeParser {
    public SimpleExcludeParser(GraGra grammar, Graph hostGraph, Graph stopGraph, ExcludePairContainer excludeContainer) {
        super(grammar, hostGraph, stopGraph, excludeContainer);
    }

    @Override
    public boolean parse() {
        Pair tmpPair;
        this.correct = true;
        this.fireParserEvent(new ParserMessageEvent(this, "Starting simple exclude parser ..."));
        Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>> conflictFree = null;
        if (this.stop) {
            return false;
        }
        try {
            conflictFree = this.pairContainer.getContainer(3);
        }
        catch (InvalidAlgorithmException iae) {
            this.fireParserEvent(new ParserErrorEvent(iae, "ERROR: " + iae.getMessage()));
            return false;
        }
        Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>> exclude = null;
        if (this.stop) {
            return false;
        }
        try {
            exclude = this.pairContainer.getContainer(0);
        }
        catch (InvalidAlgorithmException iae) {
            this.fireParserEvent(new ParserErrorEvent(iae, "ERROR: " + iae.getMessage()));
            return false;
        }
        if (this.stop) {
            return false;
        }
        Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>> conflictFreeLight = null;
        Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>> excludeLight = null;
        excludeLight = new Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>>();
        conflictFreeLight = new Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>>();
        if (this.stop) {
            return false;
        }
        this.makeLightContainer(exclude, excludeLight);
        if (this.stop) {
            return false;
        }
        this.makeLightContainer(conflictFree, conflictFreeLight);
        if (this.stop) {
            return false;
        }
        Enumeration<Rule> keys = conflictFreeLight.keys();
        while (keys.hasMoreElements()) {
            Rule key = keys.nextElement();
            if (!excludeLight.containsKey(key)) continue;
            conflictFreeLight.remove(key);
        }
        RuleInstances eri = new RuleInstances();
        this.fireParserEvent(new ParserMessageEvent(this, "Parser initialized"));
        if (this.stop) {
            return false;
        }
        boolean ruleApplied = false;
        while (!this.stop && !this.graph.isIsomorphicTo(this.stopGraph) && this.correct) {
            Match m;
            Rule r;
            ruleApplied = false;
            Enumeration<Rule> keys2 = conflictFreeLight.keys();
            while (keys2.hasMoreElements() && !ruleApplied) {
                r = keys2.nextElement();
                this.fireParserEvent(new ParserMessageEvent(this, "Searching for easy match"));
                m = BaseFactory.theFactory().createMatch(r, this.getHostGraph());
                m.setCompletionStrategy((MorphCompletionStrategy)this.grammar.getMorphismCompletionStrategy().clone(), true);
                while (!this.stop && !ruleApplied && m.nextCompletion()) {
                    if (!m.isValid() || !this.applyRule(m)) continue;
                    ruleApplied = true;
                    try {
                        Thread.sleep(this.delay);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (this.stop || ruleApplied) continue;
            keys2 = excludeLight.keys();
            while (keys2.hasMoreElements() && !ruleApplied) {
                r = keys2.nextElement();
                this.fireParserEvent(new ParserMessageEvent(this, "Searching for difficult match"));
                m = BaseFactory.theFactory().createMatch(r, this.getHostGraph());
                m.setCompletionStrategy((MorphCompletionStrategy)this.grammar.getMorphismCompletionStrategy().clone(), true);
                boolean found = false;
                while (!found && m.nextCompletion()) {
                    if (eri.isIn(m) || !m.isValid()) continue;
                    found = true;
                }
                if (!this.stop && found) {
                    OrdinaryMorphism copyMorph = this.getHostGraph().isomorphicCopy();
                    if (copyMorph == null) continue;
                    this.fireParserEvent(new ParserMessageEvent(copyMorph, "IsoCopy"));
                    eri.add(m);
                    Pair<Graph, RuleInstances> tmpPair2 = new Pair<Graph, RuleInstances>(this.getHostGraph(), eri);
                    this.stack.push(tmpPair2);
                    eri = new RuleInstances();
                    this.setHostGraph(copyMorph.getImage());
                    OrdinaryMorphism tmpMorph = m.compose(copyMorph);
                    Match n = tmpMorph.makeMatch(m.getRule());
                    n.setCompletionStrategy((MorphCompletionStrategy)this.grammar.getMorphismCompletionStrategy().clone(), true);
                    boolean notFound = false;
                    while (!(this.stop || n.isValid() || notFound)) {
                        if (n.nextCompletion()) continue;
                        notFound = true;
                    }
                    if (this.stop || notFound || !this.applyRule(n)) continue;
                    ruleApplied = true;
                    try {
                        Thread.sleep(this.delay);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                BaseFactory.theFactory().destroyMatch(m);
                m = null;
            }
            if (this.stop || ruleApplied) continue;
            try {
                tmpPair = (Pair)this.stack.pop();
                this.setHostGraph((Graph)tmpPair.first);
                eri = (RuleInstances)tmpPair.second;
            }
            catch (Exception ioe) {
                this.fireParserEvent(new ParserErrorEvent(this, "ERROR: This graph is not part of the language"));
                this.correct = false;
            }
        }
        while (!this.stack.empty()) {
            try {
                this.fireParserEvent(new ParserMessageEvent(this, "Cleaning stack."));
                tmpPair = (Pair)this.stack.pop();
                Graph g = (Graph)tmpPair.first;
                BaseFactory.theFactory().destroyGraph(g);
                tmpPair.second = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.fireParserEvent(new ParserMessageEvent(this, "Stopping parser. Result is " + this.correct + "."));
        return this.correct;
    }
}

