/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.model.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class ScriptEngineWrapper {
    private static final Pattern WILDCARD_PATTERN = Pattern.compile("(.*)\\.\\*$");
    private static final Pattern DIR_FQN_PATTERN = Pattern.compile("(.*)\\.([a-z][^.]*)*$");
    private static final Pattern CLASS_FQN_PATTERN = Pattern.compile("(.*)\\.([A-Z][^.]*)$");
    private final ScriptEngine engine;
    private final List<String> globalImports;

    public ScriptEngineWrapper(ScriptEngine engine, String[] globalImports) {
        this.engine = engine;
        this.globalImports = new ArrayList<String>();
        if (globalImports != null) {
            int i = 0;
            while (i < globalImports.length) {
                this.globalImports.add(globalImports[i]);
                ++i;
            }
        }
        if (engine == null) {
            System.err.println("Warning: cannot find JavaScript engine");
        }
    }

    public ScriptEngineWrapper(String[] globalImports) {
        this(new ScriptEngineManager().getEngineByName("JavaScript"), globalImports);
    }

    public ScriptEngine getEngine() {
        return this.engine;
    }

    public Object eval(String script, List<String> localImports) throws ScriptException {
        if (!this.globalImports.isEmpty() || !localImports.isEmpty()) {
            script = ScriptEngineWrapper.toStringWithImports(script, this.globalImports, localImports);
        }
        return this.engine.eval(script);
    }

    public void put(String key, Object value) {
        this.engine.put(key, value);
    }

    private static String toStringWithImports(String script, List<String> ... imports) {
        StringBuffer out = new StringBuffer();
        String delim = "";
        out.append("with (new JavaImporter(");
        int i = 0;
        while (i < imports.length) {
            for (String entry : imports[i]) {
                if (!ScriptEngineWrapper.isDirectory(entry) && !ScriptEngineWrapper.isWildcard(entry)) continue;
                out.append(delim).append(ScriptEngineWrapper.stripWildcard(entry));
                delim = ", ";
            }
            ++i;
        }
        out.append(")) { ");
        i = 0;
        while (i < imports.length) {
            for (String entry : imports[i]) {
                Matcher m = CLASS_FQN_PATTERN.matcher(entry);
                if (!m.matches()) continue;
                String filename = m.group(2);
                out.append("var ");
                out.append(filename);
                out.append(" = Java.type('");
                out.append(entry);
                out.append("'); ");
            }
            ++i;
        }
        out.append(script);
        out.append(" }");
        return out.toString();
    }

    private static String stripWildcard(String imp) {
        return ScriptEngineWrapper.isWildcard(imp) ? imp.substring(0, imp.length() - 2) : imp;
    }

    private static boolean isDirectory(String imp) {
        return DIR_FQN_PATTERN.matcher(imp).matches();
    }

    private static boolean isWildcard(String imp) {
        return WILDCARD_PATTERN.matcher(imp).matches();
    }
}

