/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.views.components;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.eef.runtime.EEFRuntimePlugin;
import org.eclipse.emf.eef.runtime.api.component.IPropertiesEditionComponent;
import org.eclipse.emf.eef.runtime.api.notify.IPropertiesEditionEvent;
import org.eclipse.emf.eef.runtime.api.notify.IPropertiesEditionListener;
import org.eclipse.emf.eef.runtime.api.parts.IPropertiesEditionPart;
import org.eclipse.emf.eef.runtime.api.providers.IPropertiesEditionPartProvider;
import org.eclipse.emf.eef.runtime.impl.components.StandardPropertiesEditionComponent;
import org.eclipse.emf.eef.runtime.impl.notify.PropertiesValidationEditionEvent;
import org.eclipse.emf.eef.runtime.impl.services.PropertiesEditionPartProviderService;
import org.eclipse.emf.eef.runtime.impl.utils.EEFConverterUtil;
import org.eclipse.emf.eef.runtime.ui.widgets.ButtonsModeEnum;
import org.eclipse.emf.eef.views.ViewElement;
import org.eclipse.emf.eef.views.ViewReference;
import org.eclipse.emf.eef.views.ViewsPackage;
import org.eclipse.emf.eef.views.parts.ViewReferencePropertiesEditionPart;
import org.eclipse.emf.eef.views.parts.ViewsViewsRepository;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class ViewReferenceBasePropertiesEditionComponent
extends StandardPropertiesEditionComponent {
    public static String BASE_PART = "Base";
    private String[] parts = new String[]{BASE_PART};
    private ViewReference viewReference;
    protected ViewReferencePropertiesEditionPart basePart;

    public ViewReferenceBasePropertiesEditionComponent(EObject viewReference, String editing_mode) {
        if (viewReference instanceof ViewReference) {
            this.viewReference = (ViewReference)viewReference;
            if ("Live".equals(editing_mode)) {
                this.semanticAdapter = this.initializeSemanticAdapter();
                this.viewReference.eAdapters().add((Object)this.semanticAdapter);
            }
        }
        this.editing_mode = editing_mode;
    }

    private AdapterImpl initializeSemanticAdapter() {
        return new EContentAdapter(){

            public void notifyChanged(final Notification msg) {
                if (ViewReferenceBasePropertiesEditionComponent.this.basePart == null) {
                    ViewReferenceBasePropertiesEditionComponent.this.dispose();
                } else {
                    Runnable updateRunnable = new Runnable(){

                        public void run() {
                            ViewReferenceBasePropertiesEditionComponent.this.runUpdateRunnable(msg);
                        }
                    };
                    if (Display.getCurrent() == null) {
                        PlatformUI.getWorkbench().getDisplay().syncExec(updateRunnable);
                    } else {
                        updateRunnable.run();
                    }
                }
            }
        };
    }

    protected void runUpdateRunnable(Notification msg) {
        if (ViewsPackage.eINSTANCE.getViewElement_Name().equals(msg.getFeature()) && this.basePart != null) {
            if (msg.getNewValue() != null) {
                this.basePart.setName(EcoreUtil.convertToString((EDataType)EcorePackage.eINSTANCE.getEString(), (Object)msg.getNewValue()));
            } else {
                this.basePart.setName("");
            }
        }
        if (ViewsPackage.eINSTANCE.getViewReference_View().equals(msg.getFeature()) && this.basePart != null) {
            this.basePart.setReferencedView((EObject)msg.getNewValue());
        }
    }

    public Class translatePart(String key) {
        if (BASE_PART.equals(key)) {
            return ViewsViewsRepository.ViewReference.class;
        }
        return super.translatePart(key);
    }

    public String[] partsList() {
        return this.parts;
    }

    public IPropertiesEditionPart getPropertiesEditionPart(int kind, String key) {
        if (this.viewReference != null && BASE_PART.equals(key)) {
            IPropertiesEditionPartProvider provider;
            if (this.basePart == null && (provider = PropertiesEditionPartProviderService.getInstance().getProvider(ViewsViewsRepository.class)) != null) {
                this.basePart = (ViewReferencePropertiesEditionPart)provider.getPropertiesEditionPart(ViewsViewsRepository.ViewReference.class, kind, (IPropertiesEditionComponent)this);
                this.addListener((IPropertiesEditionListener)this.basePart);
            }
            return (IPropertiesEditionPart)this.basePart;
        }
        return null;
    }

    public void setPropertiesEditionPart(Class key, int kind, IPropertiesEditionPart propertiesEditionPart) {
        if (key == ViewsViewsRepository.ViewReference.class) {
            this.basePart = (ViewReferencePropertiesEditionPart)propertiesEditionPart;
        }
    }

    public void initPart(Class key, int kind, EObject elt, ResourceSet allResource) {
        this.setInitializing(true);
        if (this.basePart != null && key == ViewsViewsRepository.ViewReference.class) {
            ((IPropertiesEditionPart)this.basePart).setContext(elt, allResource);
            ViewReference viewReference = (ViewReference)elt;
            if (viewReference.getName() != null) {
                this.basePart.setName(EEFConverterUtil.convertToString((EDataType)EcorePackage.eINSTANCE.getEString(), (Object)viewReference.getName()));
            }
            this.basePart.initReferencedView(allResource, (EObject)viewReference.getView());
            this.basePart.setReferencedViewButtonMode(ButtonsModeEnum.BROWSE);
            this.basePart.addFilterToReferencedView(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    return element instanceof ViewElement;
                }
            });
        }
        this.setInitializing(false);
    }

    public CompoundCommand getPropertiesEditionCommand(EditingDomain editingDomain) {
        CompoundCommand cc = new CompoundCommand();
        if (this.viewReference != null && this.basePart != null) {
            cc.append(SetCommand.create((EditingDomain)editingDomain, (Object)this.viewReference, (Object)ViewsPackage.eINSTANCE.getViewElement_Name(), (Object)EEFConverterUtil.createFromString((EDataType)EcorePackage.eINSTANCE.getEString(), (String)this.basePart.getName())));
            if (this.viewReference.eGet((EStructuralFeature)ViewsPackage.eINSTANCE.getViewReference_View()) == null || !this.viewReference.eGet((EStructuralFeature)ViewsPackage.eINSTANCE.getViewReference_View()).equals(this.basePart.getReferencedView())) {
                cc.append(SetCommand.create((EditingDomain)editingDomain, (Object)this.viewReference, (Object)ViewsPackage.eINSTANCE.getViewReference_View(), (Object)this.basePart.getReferencedView()));
            }
        }
        if (!cc.isEmpty()) {
            return cc;
        }
        cc.append((Command)IdentityCommand.INSTANCE);
        return cc;
    }

    public EObject getPropertiesEditionObject(EObject source) {
        if (source instanceof ViewReference) {
            ViewReference viewReferenceToUpdate = (ViewReference)source;
            viewReferenceToUpdate.setName((String)EEFConverterUtil.createFromString((EDataType)EcorePackage.eINSTANCE.getEString(), (String)this.basePart.getName()));
            viewReferenceToUpdate.setView((ViewElement)this.basePart.getReferencedView());
            return viewReferenceToUpdate;
        }
        return null;
    }

    public void firePropertiesChanged(IPropertiesEditionEvent event) {
        if (!this.isInitializing()) {
            Diagnostic valueDiagnostic = this.validateValue(event);
            if (1 == event.getState() && "Live".equals(this.editing_mode) && valueDiagnostic.getSeverity() == 0) {
                CompoundCommand command = new CompoundCommand();
                if (ViewsViewsRepository.ViewReference.name == event.getAffectedEditor()) {
                    command.append(SetCommand.create((EditingDomain)this.liveEditingDomain, (Object)this.viewReference, (Object)ViewsPackage.eINSTANCE.getViewElement_Name(), (Object)EEFConverterUtil.createFromString((EDataType)EcorePackage.eINSTANCE.getEString(), (String)((String)event.getNewValue()))));
                }
                if (ViewsViewsRepository.ViewReference.referencedView == event.getAffectedEditor()) {
                    command.append(SetCommand.create((EditingDomain)this.liveEditingDomain, (Object)this.viewReference, (Object)ViewsPackage.eINSTANCE.getViewReference_View(), (Object)event.getNewValue()));
                }
                if (!command.isEmpty() && !command.canExecute()) {
                    EEFRuntimePlugin.getDefault().logError("Cannot perform model change command.", null);
                } else {
                    this.liveEditingDomain.getCommandStack().execute((Command)command);
                }
            }
            if (valueDiagnostic.getSeverity() != 0 && valueDiagnostic instanceof BasicDiagnostic) {
                super.firePropertiesChanged((IPropertiesEditionEvent)new PropertiesValidationEditionEvent(event, valueDiagnostic));
            } else {
                Diagnostic validate = this.validate();
                super.firePropertiesChanged((IPropertiesEditionEvent)new PropertiesValidationEditionEvent(event, validate));
            }
            super.firePropertiesChanged(event);
        }
    }

    public boolean isRequired(String key, int kind) {
        return key == ViewsViewsRepository.ViewReference.name || key == ViewsViewsRepository.ViewReference.referencedView;
    }

    public String getHelpContent(String key, int kind) {
        if (key == ViewsViewsRepository.ViewReference.name) {
            return "The element name";
        }
        if (key == ViewsViewsRepository.ViewReference.referencedView) {
            return "The referenced view";
        }
        return super.getHelpContent(key, kind);
    }

    public Diagnostic validateValue(IPropertiesEditionEvent event) {
        Diagnostic ret = Diagnostic.OK_INSTANCE;
        if (event.getNewValue() != null) {
            String newStringValue = event.getNewValue().toString();
            try {
                if (ViewsViewsRepository.ViewReference.name == event.getAffectedEditor()) {
                    Object newValue = EcoreUtil.createFromString((EDataType)ViewsPackage.eINSTANCE.getViewElement_Name().getEAttributeType(), (String)newStringValue);
                    ret = Diagnostician.INSTANCE.validate(ViewsPackage.eINSTANCE.getViewElement_Name().getEAttributeType(), newValue);
                }
            }
            catch (IllegalArgumentException iae) {
                ret = BasicDiagnostic.toDiagnostic((Throwable)iae);
            }
            catch (WrappedException we) {
                ret = BasicDiagnostic.toDiagnostic((Throwable)we);
            }
        }
        return ret;
    }

    public Diagnostic validate() {
        Diagnostic validate = Diagnostic.OK_INSTANCE;
        if ("Batch".equals(this.editing_mode)) {
            EObject copy = EcoreUtil.copy((EObject)this.viewReference);
            copy = this.getPropertiesEditionObject(copy);
            validate = EEFRuntimePlugin.getEEFValidator().validate(copy);
        } else if ("Live".equals(this.editing_mode)) {
            validate = EEFRuntimePlugin.getEEFValidator().validate((EObject)this.viewReference);
        }
        return validate;
    }

    public void dispose() {
        if (this.semanticAdapter != null) {
            this.viewReference.eAdapters().remove((Object)this.semanticAdapter);
        }
    }

    public String getTabText(String p_key) {
        return this.basePart.getTitle();
    }
}

