/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.ui.wizards;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.eef.runtime.api.component.IPropertiesEditionComponent;
import org.eclipse.emf.eef.runtime.api.notify.IPropertiesEditionEvent;
import org.eclipse.emf.eef.runtime.api.notify.IPropertiesEditionListener;
import org.eclipse.emf.eef.runtime.api.parts.IPropertiesEditionPart;
import org.eclipse.emf.eef.runtime.api.parts.ISWTPropertiesEditionPart;
import org.eclipse.emf.eef.runtime.api.providers.IPropertiesEditionProvider;
import org.eclipse.emf.eef.runtime.impl.services.PropertiesContextService;
import org.eclipse.emf.eef.runtime.impl.services.PropertiesEditionComponentService;
import org.eclipse.emf.eef.runtime.ui.utils.EEFRuntimeUIMessages;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class EditPropertyWizard
extends Wizard {
    private boolean initState;
    private WizardPage mainPage;
    protected EditingDomain editingDomain;
    protected EObject eObject;
    protected Command command;
    protected IPropertiesEditionComponent propertiesEditionComponent;
    protected ResourceSet allResources;

    public EditPropertyWizard(EditingDomain editingDomain, EObject eObject, ResourceSet allResources) {
        this.editingDomain = editingDomain;
        this.eObject = eObject;
        this.allResources = allResources;
        IPropertiesEditionProvider provider = PropertiesEditionComponentService.getInstance().getProvider(eObject);
        this.propertiesEditionComponent = provider.getPropertiesEditionComponent(eObject, "Batch");
        PropertiesContextService.getInstance().push(eObject, this.propertiesEditionComponent);
        this.setWindowTitle(eObject.eClass().getName());
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public EObject getEObject() {
        return this.eObject;
    }

    public Command getCommand() {
        return this.command;
    }

    public void addListener(IPropertiesEditionListener listener) {
        this.propertiesEditionComponent.addListener(listener);
    }

    public boolean performCancel() {
        PropertiesContextService.getInstance().pop();
        return super.performCancel();
    }

    public boolean performFinish() {
        if (this.editingDomain != null) {
            CompoundCommand finishCommand = this.propertiesEditionComponent.getPropertiesEditionCommand(this.editingDomain);
            if (finishCommand.canExecute()) {
                this.command = finishCommand;
                PropertiesContextService.getInstance().pop();
                return true;
            }
            return false;
        }
        this.eObject = this.propertiesEditionComponent.getPropertiesEditionObject(this.eObject);
        PropertiesContextService.getInstance().pop();
        return true;
    }

    public void addPages() {
        this.mainPage = new EditPropertyWizardPage();
        this.addPage((IWizardPage)this.mainPage);
        this.propertiesEditionComponent.addListener((EditPropertyWizardPage)this.mainPage);
    }

    private class EditPropertyWizardPage
    extends WizardPage
    implements IPropertiesEditionListener {
        protected EditPropertyWizardPage() {
            super(EEFRuntimeUIMessages.EditPropertyWizard_main_page_title);
            this.setTitle(EditPropertyWizard.this.eObject.eClass().getName());
            this.setDescription(String.valueOf(EEFRuntimeUIMessages.EditPropertyWizard_main_page_description) + EditPropertyWizard.this.eObject.eClass().getName());
        }

        public void createControl(Composite parent) {
            FillLayout parentLayout = new FillLayout();
            parent.setLayout((Layout)parentLayout);
            ScrolledComposite scrolledContainer = new ScrolledComposite(parent, 768);
            Composite container = new Composite((Composite)scrolledContainer, 2048);
            FillLayout containerLayout = new FillLayout();
            container.setLayout((Layout)containerLayout);
            CTabFolder folder = new CTabFolder(container, 2048);
            this.initializeTabs(folder);
            this.setControl((Control)scrolledContainer);
            scrolledContainer.setExpandHorizontal(true);
            scrolledContainer.setExpandVertical(true);
            scrolledContainer.setContent((Control)container);
            scrolledContainer.setMinSize(folder.computeSize(-1, -1));
        }

        private void initializeTabs(CTabFolder folder) {
            EditPropertyWizard.this.initState = true;
            String[] partsList = EditPropertyWizard.this.propertiesEditionComponent.partsList();
            int i = 0;
            while (i < partsList.length) {
                String nextComponentKey = partsList[i];
                Composite editComposite = null;
                IPropertiesEditionPart part = EditPropertyWizard.this.editingDomain != null ? EditPropertyWizard.this.propertiesEditionComponent.getPropertiesEditionPart(0, nextComponentKey) : EditPropertyWizard.this.propertiesEditionComponent.getPropertiesEditionPart(0, nextComponentKey);
                if (part instanceof ISWTPropertiesEditionPart) {
                    editComposite = ((ISWTPropertiesEditionPart)((Object)part)).createFigure((Composite)folder);
                    if (EditPropertyWizard.this.allResources == null) {
                        EditPropertyWizard.this.propertiesEditionComponent.initPart(EditPropertyWizard.this.propertiesEditionComponent.translatePart(nextComponentKey), 0, EditPropertyWizard.this.eObject);
                    } else {
                        EditPropertyWizard.this.propertiesEditionComponent.initPart(EditPropertyWizard.this.propertiesEditionComponent.translatePart(nextComponentKey), 0, EditPropertyWizard.this.eObject, EditPropertyWizard.this.allResources);
                    }
                }
                if (editComposite == null) {
                    editComposite = new Composite((Composite)folder, 0);
                }
                CTabItem tab = new CTabItem(folder, 0);
                tab.setControl((Control)editComposite);
                tab.setText(EditPropertyWizard.this.propertiesEditionComponent.getTabText(nextComponentKey));
                ++i;
            }
            EditPropertyWizard.this.initState = false;
        }

        public void firePropertiesChanged(IPropertiesEditionEvent event) {
            this.handleChange(event);
        }

        private void handleChange(IPropertiesEditionEvent event) {
            if (EditPropertyWizard.this.initState) {
                return;
            }
            Diagnostic diag = EditPropertyWizard.this.propertiesEditionComponent.validateValue(event);
            if (diag != null && diag.getSeverity() != 0) {
                this.updateStatus(diag.getMessage());
            } else {
                this.updateStatus(null);
            }
        }

        private void updateStatus(String message) {
            this.setMessage(null);
            this.setErrorMessage(message);
            this.setPageComplete(message == null);
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
        }

        private Composite getFirstEditionPart() {
            Control[] controls = ((ScrolledComposite)this.getControl()).getChildren();
            if (controls.length > 0 && (controls = ((Composite)controls[0]).getChildren()).length > 0 && controls[0] instanceof CTabFolder) {
                Control[] tabs = ((CTabFolder)controls[0]).getChildren();
                return (Composite)tabs[0];
            }
            return null;
        }

        private boolean setFocus(Control[] controls) {
            int i = 0;
            while (i < controls.length) {
                Text txt;
                if (controls[i] instanceof Group && this.setFocus(((Group)controls[i]).getChildren())) {
                    return true;
                }
                if (controls[i] instanceof Text && (txt = (Text)controls[i]).getEditable()) {
                    txt.setFocus();
                    return true;
                }
                ++i;
            }
            return false;
        }
    }
}

