/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.net4j.buffer;

import org.eclipse.net4j.buffer.IBuffer;
import org.eclipse.net4j.buffer.IBufferProvider;
import org.eclipse.net4j.util.lifecycle.Lifecycle;

public abstract class BufferProvider
extends Lifecycle
implements IBufferProvider,
IBufferProvider.Introspection {
    private short bufferCapacity;
    private long providedBuffers;
    private long retainedBuffers;

    public BufferProvider(short bufferCapacity) {
        this.bufferCapacity = bufferCapacity;
    }

    public final long getProvidedBuffers() {
        return this.providedBuffers;
    }

    public final long getRetainedBuffers() {
        return this.retainedBuffers;
    }

    public final short getBufferCapacity() {
        return this.bufferCapacity;
    }

    public final IBuffer provideBuffer() {
        ++this.providedBuffers;
        return this.doProvideBuffer();
    }

    public final void retainBuffer(IBuffer buffer) {
        ++this.retainedBuffers;
        this.doRetainBuffer(buffer);
    }

    public String toString() {
        return "BufferProvider[capacity=" + this.bufferCapacity + "]";
    }

    protected abstract IBuffer doProvideBuffer();

    protected abstract void doRetainBuffer(IBuffer var1);
}

