/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mapping.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.MappingPackage;
import org.eclipse.emf.mapping.MappingPlugin;
import org.eclipse.emf.mapping.domain.MappingDomain;

public class RemoveMappingCommand
extends AbstractCommand {
    protected static final String LABEL = MappingPlugin.getPlugin().getString("_UI_RemoveMappingCommand_label");
    protected static final String DESCRIPTION = MappingPlugin.getPlugin().getString("_UI_RemoveMappingCommand_description");
    protected MappingDomain domain;
    protected Collection collection;
    Command subcommand;
    static /* synthetic */ Class class$0;

    public static Command create(MappingDomain domain, Mapping mapping) {
        return RemoveMappingCommand.create(domain, Collections.singleton(mapping));
    }

    public static Command create(MappingDomain domain, Collection collection) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.mapping.command.RemoveMappingCommand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return domain.createCommand(clazz, new CommandParameter((Object)domain.getMappingRoot(), null, collection));
    }

    public RemoveMappingCommand(MappingDomain domain, Collection collection) {
        super(LABEL, DESCRIPTION);
        this.domain = domain;
        this.collection = collection;
    }

    protected boolean prepare() {
        boolean result = true;
        if (this.domain == null || this.collection == null || this.collection.isEmpty()) {
            result = false;
        } else {
            Iterator objects = this.collection.iterator();
            while (objects.hasNext()) {
                Object object = objects.next();
                if (!(object instanceof Mapping)) {
                    result = false;
                    break;
                }
                Mapping mapping = (Mapping)object;
                result = this.domain.getMappingRoot().canRemoveMapping(mapping);
            }
        }
        return result;
    }

    public void execute() {
        CompoundCommand subcommands = new CompoundCommand();
        Iterator mappings = this.collection.iterator();
        while (mappings.hasNext()) {
            Mapping mapping = (Mapping)mappings.next();
            Mapping parentMapping = mapping.getNestedIn();
            this.domain.getMappingRoot().deregister(mapping);
            subcommands.appendAndExecute((Command)new RemoveCommand((EditingDomain)this.domain, (EObject)parentMapping, (EStructuralFeature)MappingPackage.eINSTANCE.getMapping_Nested(), (Object)mapping));
            ArrayList nestedMappings = new ArrayList(mapping.getNested());
            if (nestedMappings.isEmpty()) continue;
            subcommands.appendAndExecute((Command)new RemoveCommand((EditingDomain)this.domain, (EObject)mapping, (EStructuralFeature)MappingPackage.eINSTANCE.getMapping_Nested(), nestedMappings));
            subcommands.appendAndExecute((Command)new AddCommand((EditingDomain)this.domain, (EObject)parentMapping, (EStructuralFeature)MappingPackage.eINSTANCE.getMapping_Nested(), nestedMappings));
        }
        this.subcommand = subcommands.unwrap();
    }

    public void undo() {
        Iterator objects = this.collection.iterator();
        while (objects.hasNext()) {
            Mapping mapping = (Mapping)objects.next();
            this.domain.getMappingRoot().register(mapping);
        }
        this.subcommand.undo();
    }

    public void redo() {
        Iterator objects = this.collection.iterator();
        while (objects.hasNext()) {
            Mapping mapping = (Mapping)objects.next();
            this.domain.getMappingRoot().deregister(mapping);
        }
        this.subcommand.redo();
    }

    public Collection getResult() {
        return this.collection;
    }

    public void dispose() {
        if (this.subcommand != null) {
            this.subcommand.dispose();
        }
        super.dispose();
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (domain: " + this.domain + ")");
        result.append(" (collection: " + this.collection + ")");
        result.append(" (subcommand: " + this.subcommand + ")");
        return result.toString();
    }
}

