/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui;

import java.text.MessageFormat;
import org.eclipse.emf.cdo.internal.ui.SharedIcons;
import org.eclipse.emf.cdo.internal.ui.messages.Messages;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.net4j.util.container.IElementProcessor;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CDOInteractiveExceptionHandler
implements CDOSession.ExceptionHandler,
IElementProcessor {
    public void handleException(final CDOSession session, final int attempt, Exception exception) throws Exception {
        final Exception[] result = new Exception[]{exception};
        Runnable runnable = new Runnable(){

            public void run() {
                boolean retry;
                Dialog dialog = CDOInteractiveExceptionHandler.this.createDialog(session, attempt, result[0]);
                boolean bl = retry = dialog.open() == 0;
                if (retry) {
                    result[0] = null;
                }
            }
        };
        Display display = UIUtil.getDisplay();
        if (Thread.currentThread() == display.getThread()) {
            runnable.run();
        } else {
            display.syncExec(runnable);
        }
        if (result[0] != null) {
            throw result[0];
        }
    }

    public Object process(IManagedContainer container, String productGroup, String factoryType, String description, Object element) {
        InternalCDOSession session;
        if (element instanceof InternalCDOSession && !(session = (InternalCDOSession)element).isActive()) {
            element = this.processSession(container, productGroup, factoryType, description, session);
        }
        return element;
    }

    protected Object processSession(IManagedContainer container, String productGroup, String factoryType, String description, InternalCDOSession session) {
        if (session.getExceptionHandler() == null) {
            session.setExceptionHandler((CDOSession.ExceptionHandler)this);
        }
        return session;
    }

    protected Shell getParentShell() {
        return new Shell();
    }

    protected Dialog createDialog(CDOSession session, int attempt, Exception exception) {
        return new ExceptionDialog(this.getParentShell(), session, attempt, exception);
    }

    public static class ExceptionDialog
    extends TitleAreaDialog {
        public static final String TITLE = Messages.getString("CDOInteractiveExceptionHandler.0");
        private CDOSession session;
        private int attempt;
        private Exception exception;

        public ExceptionDialog(Shell parentShell, CDOSession session, int attempt, Exception exception) {
            super(parentShell);
            this.setShellStyle(this.getShellStyle() | 0x10000 | 0x400 | 0x20 | 0x10);
            this.session = session;
            this.attempt = attempt;
            this.exception = exception;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(TITLE);
        }

        protected Control createDialogArea(Composite parent) {
            GridLayout layout = UIUtil.createGridLayout((int)1);
            layout.marginWidth = 10;
            layout.marginHeight = 10;
            Composite composite = new Composite((Composite)super.createDialogArea(parent), 0);
            composite.setLayoutData((Object)UIUtil.createGridData());
            composite.setLayout((Layout)layout);
            String attemptsStr = this.attempt == 1 ? Messages.getString("CDOInteractiveExceptionHandler.1") : Messages.getString("CDOInteractiveExceptionHandler.2");
            this.setTitle(MessageFormat.format(Messages.getString("CDOInteractiveExceptionHandler.3"), this.session, this.attempt, attemptsStr));
            this.setTitleImage(SharedIcons.getImage("wizban/ProtocolProblem"));
            String str = IOUtil.toString((Throwable)this.exception);
            str = str.replaceAll("\r", "");
            Text text = new Text(composite, 2562);
            text.setLayoutData((Object)UIUtil.createGridData());
            text.setBackground(text.getDisplay().getSystemColor(1));
            text.setEditable(false);
            text.setText(str);
            return composite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, Messages.getString("CDOInteractiveExceptionHandler.4"), true);
            this.createButton(parent, 1, Messages.getString("CDOInteractiveExceptionHandler.5"), false);
        }
    }
}

