/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.emf.cdo.common.CDOProtocolView;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.id.CDOIDObject;
import org.eclipse.emf.cdo.common.id.CDOIDProvider;
import org.eclipse.emf.cdo.common.model.CDOClass;
import org.eclipse.emf.cdo.common.model.CDOClassRef;
import org.eclipse.emf.cdo.common.model.CDOFeature;
import org.eclipse.emf.cdo.internal.server.RevisionManager;
import org.eclipse.emf.cdo.internal.server.SessionManager;
import org.eclipse.emf.cdo.internal.server.Transaction;
import org.eclipse.emf.cdo.internal.server.View;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.internal.server.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.internal.server.protocol.InvalidationNotification;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.server.SessionCreationException;
import org.eclipse.emf.cdo.server.StoreUtil;
import org.eclipse.emf.cdo.spi.common.InternalCDORevision;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Session
extends Container<IView>
implements ISession,
CDOIDProvider {
    private SessionManager sessionManager;
    private CDOServerProtocol protocol;
    private int sessionID;
    private boolean legacySupportEnabled;
    private ConcurrentMap<Integer, IView> views = new ConcurrentHashMap<Integer, IView>();
    private IListener protocolListener = new LifecycleEventAdapter(){

        protected void onDeactivated(ILifecycle lifecycle) {
            Session.this.deactivate();
        }
    };

    public Session(SessionManager sessionManager, CDOServerProtocol protocol, int sessionID, boolean legacySupportEnabled) throws SessionCreationException {
        this.sessionManager = sessionManager;
        this.protocol = protocol;
        this.sessionID = sessionID;
        this.legacySupportEnabled = legacySupportEnabled;
        protocol.addListener(this.protocolListener);
        try {
            this.activate();
        }
        catch (Exception ex) {
            throw new SessionCreationException(ex);
        }
    }

    @Override
    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public int getSessionID() {
        return this.sessionID;
    }

    public boolean isLegacySupportEnabled() {
        return this.legacySupportEnabled;
    }

    @Override
    public CDOServerProtocol getProtocol() {
        return this.protocol;
    }

    public View[] getElements() {
        return this.getViews();
    }

    public boolean isEmpty() {
        return this.views.isEmpty();
    }

    public View[] getViews() {
        return this.views.values().toArray(new View[this.views.size()]);
    }

    public IView getView(int viewID) {
        return (IView)this.views.get(viewID);
    }

    public void changeView(int viewID, byte kind) {
        switch (kind) {
            case 4: {
                this.closeView(viewID);
                break;
            }
            case 1: {
                this.openView(viewID, CDOProtocolView.Type.TRANSACTION);
                break;
            }
            case 3: {
                this.openView(viewID, CDOProtocolView.Type.READONLY);
                break;
            }
            case 2: {
                this.openView(viewID, CDOProtocolView.Type.AUDIT);
                break;
            }
            default: {
                throw new ImplementationError("Invalid kind: " + kind);
            }
        }
    }

    @Override
    public IView closeView(int viewID) {
        IView view = (IView)this.views.remove(viewID);
        if (view != null) {
            this.fireElementRemovedEvent(view);
        }
        return view;
    }

    @Override
    public IView openView(int viewID, CDOProtocolView.Type type) {
        IView view = this.createView(viewID, type);
        this.views.put(viewID, view);
        this.fireElementAddedEvent(view);
        return view;
    }

    public Transaction openTransaction(int viewID, final long timeStamp) {
        Transaction transaction = new Transaction(this, viewID){

            protected long createTimeStamp() {
                return timeStamp;
            }
        };
        this.views.put(viewID, transaction);
        this.fireElementAddedEvent(transaction);
        return transaction;
    }

    private IView createView(int viewID, CDOProtocolView.Type type) {
        if (type == CDOProtocolView.Type.TRANSACTION) {
            return new Transaction(this, viewID);
        }
        return new View(this, viewID, type);
    }

    public void notifyInvalidation(long timeStamp, List<CDOIDAndVersion> dirtyIDs) {
        try {
            new InvalidationNotification(this.protocol.getChannel(), timeStamp, dirtyIDs).send();
        }
        catch (Exception ex) {
            OM.LOG.error((Throwable)ex);
        }
    }

    public CDOID provideCDOID(Object idObject) {
        CDOID id = (CDOID)idObject;
        if (!this.legacySupportEnabled || id.isNull() || id.isMeta()) {
            return id;
        }
        CDOIDObject objectID = (CDOIDObject)id;
        if (objectID.getClassRef() == null) {
            CDOClassRef classRef = this.getClassRef((CDOID)objectID);
            objectID = objectID.asLegacy(classRef);
        }
        return objectID;
    }

    public CDOClassRef getClassRef(CDOID id) {
        RevisionManager revisionManager = this.sessionManager.getRepository().getRevisionManager();
        CDOClass cdoClass = revisionManager.getObjectType(id);
        return cdoClass != null ? cdoClass.createClassRef() : StoreUtil.getReader().readObjectType(id);
    }

    public void collectContainedRevisions(InternalCDORevision revision, int referenceChunk, Set<CDOID> revisions, List<InternalCDORevision> additionalRevisions) {
        RevisionManager revisionManager = this.getSessionManager().getRepository().getRevisionManager();
        CDOClass cdoClass = revision.getCDOClass();
        CDOFeature[] features = cdoClass.getAllFeatures();
        int i = 0;
        while (i < features.length) {
            CDOID id;
            Object value;
            CDOFeature feature = features[i];
            if (feature.isReference() && !feature.isMany() && feature.isContainment() && (value = revision.getValue(feature)) instanceof CDOID && !(id = (CDOID)value).isNull() && !revisions.contains(id)) {
                InternalCDORevision containedRevision = revisionManager.getRevision(id, referenceChunk);
                revisions.add(id);
                additionalRevisions.add(containedRevision);
                this.collectContainedRevisions(containedRevision, referenceChunk, revisions, additionalRevisions);
            }
            ++i;
        }
    }

    public String toString() {
        return MessageFormat.format("Session[{0}, {1}]", this.sessionID, this.protocol.getChannel());
    }

    protected void doDeactivate() throws Exception {
        this.protocol.removeListener(this.protocolListener);
        this.sessionManager.sessionClosed(this);
        super.doDeactivate();
    }
}

