/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate.tuplizer;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Map;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.server.hibernate.id.CDOIDHibernate;
import org.eclipse.emf.cdo.server.hibernate.internal.id.CDOIDHibernateFactoryImpl;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateCommitContext;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateThreadContext;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateUtil;
import org.eclipse.emf.cdo.spi.common.InternalCDORevision;
import org.hibernate.HibernateException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.Setter;

public class CDOSyntheticIdPropertyHandler
implements Getter,
Setter,
PropertyAccessor {
    private static final long serialVersionUID = 1L;

    public Getter getGetter(Class theClass, String propertyName) throws PropertyNotFoundException {
        return this;
    }

    public Setter getSetter(Class theClass, String propertyName) throws PropertyNotFoundException {
        return this;
    }

    public Object get(Object owner) throws HibernateException {
        InternalCDORevision revision = HibernateUtil.getInstance().getCDORevision(owner);
        if (revision == null) {
            return null;
        }
        if (!(revision.getID() instanceof CDOIDHibernate)) {
            return null;
        }
        CDOIDHibernate cdoID = (CDOIDHibernate)revision.getID();
        return cdoID.getId();
    }

    public Object getForInsert(Object arg0, Map arg1, SessionImplementor arg2) throws HibernateException {
        return this.get(arg0);
    }

    public Method getMethod() {
        return null;
    }

    public String getMethodName() {
        return null;
    }

    public Class getReturnType() {
        return null;
    }

    public void set(Object target, Object value, SessionFactoryImplementor factory) throws HibernateException {
        InternalCDORevision revision;
        CDOID cdoID;
        if (value == null) {
            return;
        }
        HibernateCommitContext hcc = null;
        if (HibernateThreadContext.isHibernateCommitContextSet()) {
            hcc = HibernateThreadContext.getHibernateCommitContext();
        }
        if ((cdoID = (revision = HibernateUtil.getInstance().getCDORevision(target)).getID()) == null) {
            CDOIDHibernate newCDOID = CDOIDHibernateFactoryImpl.getInstance().createCDOID((Serializable)value, revision.getCDOClass().getName());
            revision.setID((CDOID)newCDOID);
            if (hcc != null) {
                hcc.setNewID(cdoID, (CDOID)newCDOID);
            }
        } else if (cdoID instanceof CDOIDTemp) {
            CDOIDHibernate newCDOID = CDOIDHibernateFactoryImpl.getInstance().createCDOID((Serializable)value, revision.getCDOClass().getName());
            revision.setID((CDOID)newCDOID);
            if (hcc != null) {
                hcc.getCommitContext().addIDMapping((CDOIDTemp)cdoID, (CDOID)newCDOID);
                hcc.setNewID(cdoID, (CDOID)newCDOID);
            }
        } else {
            CDOIDHibernate hbCDOID = (CDOIDHibernate)revision.getID();
            if (!hbCDOID.getId().equals(value)) {
                throw new IllegalStateException("Current id and new id are different " + value + "/" + hbCDOID.getId());
            }
        }
    }
}

