/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.workspace.util.tests;

import java.util.Collections;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.examples.extlibrary.Book;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.tests.AbstractTest;
import org.eclipse.emf.workspace.tests.fixtures.TestCommand;
import org.eclipse.emf.workspace.util.WorkspaceValidateEditSupport;

public class ValidateEditTest
extends AbstractTest {
    private static final String newTitle = "New Title";
    private Book book;
    private final Command cmd = new TestCommand(){

        public void execute() {
            try {
                ValidateEditTest.this.book.setTitle(ValidateEditTest.newTitle);
            }
            catch (Exception e) {
                ValidateEditTest.this.fail(e);
            }
        }
    };

    public ValidateEditTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(ValidateEditTest.class, "Validate-Edit Support Tests");
    }

    public void test_noValidateEditRequired() {
        try {
            this.getCommandStack().execute(this.cmd, null);
            this.assertTitleChanged();
            this.assertResourceDirty();
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    public void ignore_test_validateEditRollback() {
        this.setResourceReadOnly();
        try {
            this.getCommandStack().execute(this.cmd, null);
            ValidateEditTest.fail((String)"Should have rolled back");
        }
        catch (RollbackException e) {
            System.out.println("Got expected exception: " + e.getLocalizedMessage());
        }
        catch (Exception e) {
            this.fail(e);
        }
        this.assertTitleNotChanged();
        this.assertResourceNotDirty();
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.setValidateEdit();
        this.testResource.setTrackingModification(true);
        this.startReading();
        this.book = (Book)this.find("root/Root Book");
        this.commit();
        ValidateEditTest.assertNotNull((Object)this.book);
    }

    protected void doTearDown() throws Exception {
        this.book = null;
        super.doTearDown();
    }

    void setResourceReadOnly() {
        ResourceAttributes attr = new ResourceAttributes();
        attr.setReadOnly(true);
        try {
            this.file.setResourceAttributes(attr);
        }
        catch (CoreException e) {
            this.fail((Exception)((Object)e));
        }
    }

    void setValidateEdit() {
        TransactionalEditingDomain.DefaultOptions defaults = (TransactionalEditingDomain.DefaultOptions)TransactionUtil.getAdapter((TransactionalEditingDomain)this.domain, TransactionalEditingDomain.DefaultOptions.class);
        defaults.setDefaultTransactionOptions(Collections.singletonMap("validate_edit", new WorkspaceValidateEditSupport()));
    }

    void assertTitleChanged() {
        ValidateEditTest.assertEquals((String)newTitle, (String)this.book.getTitle());
    }

    void assertTitleNotChanged() {
        ValidateEditTest.assertFalse((boolean)newTitle.equals(this.book.getTitle()));
    }

    void assertResourceDirty() {
        ValidateEditTest.assertTrue((String)"Resource not dirty", (boolean)this.testResource.isModified());
    }

    void assertResourceNotDirty() {
        ValidateEditTest.assertFalse((String)"Resource is dirty", (boolean)this.testResource.isModified());
    }
}

