/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.internal.utils;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ComparisonUtil {
    private ComparisonUtil() {
    }

    public static Function<Diff, Iterable<Diff>> getSubDiffs(boolean leftToRight) {
        return ComparisonUtil.getSubDiffs(leftToRight, new LinkedHashSet<Diff>());
    }

    public static boolean isAddOrSetDiff(Diff difference) {
        Object feature;
        boolean result = false;
        if (difference.getKind() == DifferenceKind.ADD) {
            result = true;
        } else if (difference.getKind() == DifferenceKind.CHANGE && (feature = difference instanceof ReferenceChange ? ((ReferenceChange)difference).getReference() : (difference instanceof AttributeChange ? ((AttributeChange)difference).getAttribute() : null)) != null && !feature.isMany()) {
            Match match = difference.getMatch();
            EObject source = match.getComparison().isThreeWay() ? match.getOrigin() : match.getRight();
            result = source == null ? true : ComparisonUtil.equalToDefault(source, (EStructuralFeature)feature);
        }
        return result;
    }

    private static boolean equalToDefault(EObject object, EStructuralFeature feature) {
        Object value = ReferenceUtil.safeEGet(object, feature);
        Object defaultValue = feature.getDefaultValue();
        if (value == null) {
            return defaultValue == null;
        }
        return value.equals(feature.getDefaultValue()) || "".equals(value);
    }

    public static boolean isDeleteOrUnsetDiff(Diff difference) {
        Object feature;
        boolean result = false;
        if (difference.getKind() == DifferenceKind.DELETE) {
            result = true;
        } else if (difference.getKind() == DifferenceKind.CHANGE && (feature = difference instanceof ReferenceChange ? ((ReferenceChange)difference).getReference() : (difference instanceof AttributeChange ? ((AttributeChange)difference).getAttribute() : null)) != null && !feature.isMany()) {
            Match match = difference.getMatch();
            EObject expectedContainer = difference.getSource() == DifferenceSource.LEFT ? match.getLeft() : match.getRight();
            result = expectedContainer == null ? true : ComparisonUtil.equalToDefault(expectedContainer, (EStructuralFeature)feature);
        }
        return result;
    }

    private static Function<Diff, Iterable<Diff>> getSubDiffs(final boolean leftToRight, final LinkedHashSet<Diff> processedDiffs) {
        return new Function<Diff, Iterable<Diff>>(){

            public Iterable<Diff> apply(Diff diff) {
                if (diff instanceof ReferenceChange) {
                    Match matchOfValue = diff.getMatch().getComparison().getMatch(((ReferenceChange)diff).getValue());
                    if (((ReferenceChange)diff).getReference().isContainment()) {
                        Iterable<Diff> subDiffs = matchOfValue.getAllDifferences();
                        Iterables.addAll((Collection)processedDiffs, subDiffs);
                        Iterable associatedDiffs = ComparisonUtil.getAssociatedDiffs(diff, subDiffs, processedDiffs, leftToRight);
                        return ImmutableSet.copyOf((Iterable)Iterables.concat(subDiffs, (Iterable)associatedDiffs));
                    }
                }
                return ImmutableSet.of();
            }
        };
    }

    private static Iterable<Diff> getAssociatedDiffs(Diff diffRoot, Iterable<Diff> subDiffs, LinkedHashSet<Diff> processedDiffs, boolean leftToRight) {
        HashSet<Diff> associatedDiffs = new HashSet<Diff>();
        for (Diff diff : subDiffs) {
            LinkedHashSet<Diff> reqs = new LinkedHashSet<Diff>();
            if (leftToRight) {
                if (diff.getSource() == DifferenceSource.LEFT) {
                    reqs.addAll((Collection<Diff>)diff.getRequires());
                } else {
                    reqs.addAll((Collection<Diff>)diff.getRequiredBy());
                }
            } else if (diff.getSource() == DifferenceSource.LEFT) {
                reqs.addAll((Collection<Diff>)diff.getRequiredBy());
            } else {
                reqs.addAll((Collection<Diff>)diff.getRequires());
            }
            reqs.remove(diffRoot);
            associatedDiffs.addAll(reqs);
            for (Diff req : reqs) {
                if (Iterables.contains(subDiffs, (Object)req) || processedDiffs.contains(req)) continue;
                processedDiffs.add(req);
                Iterables.addAll(associatedDiffs, (Iterable)((Iterable)ComparisonUtil.getSubDiffs(leftToRight, processedDiffs).apply((Object)req)));
            }
        }
        return associatedDiffs;
    }
}

