/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.logical;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Set;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.utils.StorageTraversal;
import org.eclipse.emf.compare.utils.IDiagnosable;

@Beta
public final class SynchronizationModel
implements IDiagnosable {
    private final StorageTraversal leftTraversal;
    private final StorageTraversal rightTraversal;
    private final StorageTraversal originTraversal;
    private Diagnostic diagnostic;

    public SynchronizationModel(StorageTraversal leftTraversal, StorageTraversal rightTraversal, StorageTraversal originTraversal) {
        this(leftTraversal, rightTraversal, originTraversal, (Diagnostic)new BasicDiagnostic("org.eclipse.emf.compare.ide.ui", 0, null, new Object[]{leftTraversal, rightTraversal, originTraversal}));
    }

    public SynchronizationModel(StorageTraversal leftTraversal, StorageTraversal rightTraversal, StorageTraversal originTraversal, Diagnostic diagnostic) {
        this.diagnostic = (Diagnostic)Preconditions.checkNotNull((Object)diagnostic);
        this.leftTraversal = leftTraversal == null ? new StorageTraversal((Set)Sets.newHashSet()) : leftTraversal;
        this.rightTraversal = rightTraversal == null ? new StorageTraversal((Set)Sets.newHashSet()) : rightTraversal;
        this.originTraversal = originTraversal == null ? new StorageTraversal((Set)Sets.newHashSet()) : originTraversal;
    }

    public StorageTraversal getLeftTraversal() {
        return this.leftTraversal;
    }

    public StorageTraversal getRightTraversal() {
        return this.rightTraversal;
    }

    public StorageTraversal getOriginTraversal() {
        return this.originTraversal;
    }

    public Diagnostic getDiagnostic() {
        BasicDiagnostic ret = new BasicDiagnostic("org.eclipse.emf.compare.ide.ui", 0, EMFCompareIDEUIMessages.getString("SynchronizationModel.diagnosticMesg"), new Object[]{this});
        if (this.diagnostic.getSeverity() >= 2) {
            ret.add(this.diagnostic);
        }
        if (this.leftTraversal.getDiagnostic().getSeverity() >= 2) {
            ret.add(this.leftTraversal.getDiagnostic());
        }
        if (this.originTraversal.getDiagnostic().getSeverity() >= 2) {
            ret.add(this.originTraversal.getDiagnostic());
        }
        if (this.rightTraversal.getDiagnostic().getSeverity() >= 2) {
            ret.add(this.rightTraversal.getDiagnostic());
        }
        return ret;
    }

    public void setDiagnostic(Diagnostic diagnostic) {
        this.diagnostic = diagnostic;
    }
}

