/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtimperative.utilities;

import com.google.common.collect.Iterables;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.internal.prettyprint.PrettyPrinter;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbasePrettyPrintVisitor;
import org.eclipse.qvtd.pivot.qvtimperative.AddStatement;
import org.eclipse.qvtd.pivot.qvtimperative.AppendParameter;
import org.eclipse.qvtd.pivot.qvtimperative.AppendParameterBinding;
import org.eclipse.qvtd.pivot.qvtimperative.BufferStatement;
import org.eclipse.qvtd.pivot.qvtimperative.CheckStatement;
import org.eclipse.qvtd.pivot.qvtimperative.ConnectionVariable;
import org.eclipse.qvtd.pivot.qvtimperative.DeclareStatement;
import org.eclipse.qvtd.pivot.qvtimperative.EntryPoint;
import org.eclipse.qvtd.pivot.qvtimperative.GuardParameter;
import org.eclipse.qvtd.pivot.qvtimperative.GuardParameterBinding;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeModel;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTransformation;
import org.eclipse.qvtd.pivot.qvtimperative.LoopParameterBinding;
import org.eclipse.qvtd.pivot.qvtimperative.LoopVariable;
import org.eclipse.qvtd.pivot.qvtimperative.Mapping;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCall;
import org.eclipse.qvtd.pivot.qvtimperative.MappingLoop;
import org.eclipse.qvtd.pivot.qvtimperative.MappingParameter;
import org.eclipse.qvtd.pivot.qvtimperative.MappingParameterBinding;
import org.eclipse.qvtd.pivot.qvtimperative.MappingStatement;
import org.eclipse.qvtd.pivot.qvtimperative.NewStatement;
import org.eclipse.qvtd.pivot.qvtimperative.NewStatementPart;
import org.eclipse.qvtd.pivot.qvtimperative.ObservableStatement;
import org.eclipse.qvtd.pivot.qvtimperative.QVTimperativePackage;
import org.eclipse.qvtd.pivot.qvtimperative.SetStatement;
import org.eclipse.qvtd.pivot.qvtimperative.SimpleParameter;
import org.eclipse.qvtd.pivot.qvtimperative.SimpleParameterBinding;
import org.eclipse.qvtd.pivot.qvtimperative.SpeculateStatement;
import org.eclipse.qvtd.pivot.qvtimperative.Statement;
import org.eclipse.qvtd.pivot.qvtimperative.VariableStatement;
import org.eclipse.qvtd.pivot.qvtimperative.util.QVTimperativeVisitor;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeUtil;

public class QVTimperativePrettyPrintVisitor
extends QVTbasePrettyPrintVisitor
implements QVTimperativeVisitor<Object> {
    public QVTimperativePrettyPrintVisitor(@NonNull PrettyPrinter context) {
        super(context);
    }

    protected void appendObservedProperties(@NonNull ObservableStatement asObservableStatement) {
        Iterable<@NonNull Property> observedProperties = QVTimperativeUtil.getObservedProperties(asObservableStatement);
        if (!Iterables.isEmpty(observedProperties)) {
            ((PrettyPrinter)this.context).append("observe ");
            boolean isFirst = true;
            for (Property asProperty : observedProperties) {
                if (!isFirst) {
                    ((PrettyPrinter)this.context).append(", ");
                }
                ((PrettyPrinter)this.context).appendParent(null, (Element)asProperty, "::");
                ((PrettyPrinter)this.context).appendName((NamedElement)asProperty);
                isFirst = false;
            }
            ((PrettyPrinter)this.context).append(" ");
        }
    }

    @Override
    public Object visitAddStatement(@NonNull AddStatement asAddStatement) {
        this.appendObservedProperties(asAddStatement);
        ((PrettyPrinter)this.context).append("add ");
        ((PrettyPrinter)this.context).appendName((NamedElement)asAddStatement.getTargetVariable());
        ((PrettyPrinter)this.context).append(" += ");
        this.safeVisit((Visitable)asAddStatement.getOwnedExpression());
        ((PrettyPrinter)this.context).append(";\n");
        return null;
    }

    @Override
    public Object visitAppendParameter(@NonNull AppendParameter asParameter) {
        ((PrettyPrinter)this.context).append("append ");
        ((PrettyPrinter)this.context).appendName((NamedElement)asParameter);
        ((PrettyPrinter)this.context).append(" ");
        Type type = asParameter.getType();
        if (type != null) {
            ((PrettyPrinter)this.context).append(" : ");
            ((PrettyPrinter)this.context).appendTypedMultiplicity((TypedElement)asParameter);
        }
        ((PrettyPrinter)this.context).append(";\n");
        return null;
    }

    @Override
    public Object visitAppendParameterBinding(@NonNull AppendParameterBinding pAppendParameterBinding) {
        ((PrettyPrinter)this.context).appendName((NamedElement)pAppendParameterBinding.getBoundVariable());
        ((PrettyPrinter)this.context).append(" appendsTo ");
        ((PrettyPrinter)this.context).appendName((NamedElement)pAppendParameterBinding.getValue());
        ((PrettyPrinter)this.context).append(";\n");
        return null;
    }

    @Override
    public Object visitBufferStatement(@NonNull BufferStatement pBuffer) {
        if (pBuffer.isIsStrict()) {
            ((PrettyPrinter)this.context).append("strict ");
        }
        ((PrettyPrinter)this.context).append("buffer");
        Integer firstPass = pBuffer.getFirstPass();
        if (firstPass != null) {
            ((PrettyPrinter)this.context).append(":");
            ((PrettyPrinter)this.context).append((Number)firstPass);
            Integer lastPass = pBuffer.getLastPass();
            if (lastPass != null) {
                ((PrettyPrinter)this.context).append("..");
                ((PrettyPrinter)this.context).append((Number)lastPass);
            }
        }
        ((PrettyPrinter)this.context).append(" ");
        ((PrettyPrinter)this.context).appendName((NamedElement)pBuffer);
        ((PrettyPrinter)this.context).append(" : ");
        ((PrettyPrinter)this.context).appendTypedMultiplicity((TypedElement)pBuffer);
        ((PrettyPrinter)this.context).append(";\n");
        return null;
    }

    @Override
    public Object visitCheckStatement(@NonNull CheckStatement asCheckStatement) {
        this.appendObservedProperties(asCheckStatement);
        ((PrettyPrinter)this.context).append("check ");
        this.safeVisit((Visitable)asCheckStatement.getOwnedExpression());
        ((PrettyPrinter)this.context).append(";\n");
        return null;
    }

    @Override
    public Object visitConnectionVariable(@NonNull ConnectionVariable object) {
        return this.visitVariableDeclaration(object);
    }

    @Override
    public Object visitDeclareStatement(@NonNull DeclareStatement asDeclareStatement) {
        OCLExpression asInit;
        this.appendObservedProperties(asDeclareStatement);
        if (asDeclareStatement.isIsCheck()) {
            ((PrettyPrinter)this.context).append("check ");
        }
        ((PrettyPrinter)this.context).append("var ");
        ((PrettyPrinter)this.context).appendName((NamedElement)asDeclareStatement);
        Type type = asDeclareStatement.getType();
        if (type != null) {
            ((PrettyPrinter)this.context).append(" : ");
            ((PrettyPrinter)this.context).appendTypedMultiplicity((TypedElement)asDeclareStatement);
        }
        if ((asInit = asDeclareStatement.getOwnedExpression()) != null) {
            ((PrettyPrinter)this.context).append(" := ");
            this.safeVisit((Visitable)asInit);
        }
        ((PrettyPrinter)this.context).append(";\n");
        return null;
    }

    @Override
    public Object visitEntryPoint(@NonNull EntryPoint pEntryPoint) {
        if (pEntryPoint.isIsStrict()) {
            ((PrettyPrinter)this.context).append("strict ");
        }
        ((PrettyPrinter)this.context).append("entry ");
        ((PrettyPrinter)this.context).appendName((NamedElement)pEntryPoint);
        boolean isFirst = true;
        for (TypedModel pTypedModel : QVTimperativeUtil.getInputTypedModels(pEntryPoint)) {
            if (isFirst) {
                ((PrettyPrinter)this.context).append("input ");
            } else {
                ((PrettyPrinter)this.context).append(", ");
            }
            this.safeVisit((Visitable)pTypedModel);
        }
        isFirst = true;
        for (TypedModel pTypedModel : QVTimperativeUtil.getOutputTypedModels(pEntryPoint)) {
            if (isFirst) {
                ((PrettyPrinter)this.context).append("output ");
            } else {
                ((PrettyPrinter)this.context).append(", ");
            }
            this.safeVisit((Visitable)pTypedModel);
        }
        ((PrettyPrinter)this.context).append(" in ");
        ((PrettyPrinter)this.context).appendName((NamedElement)pEntryPoint.getTransformation());
        ((PrettyPrinter)this.context).append(" {\n");
        ((PrettyPrinter)this.context).push("", "");
        for (MappingParameter pVariable : QVTimperativeUtil.getOwnedMappingParameters(pEntryPoint)) {
            this.safeVisit((Visitable)pVariable);
        }
        for (Statement pStatement : pEntryPoint.getOwnedStatements()) {
            this.safeVisit((Visitable)pStatement);
        }
        ((PrettyPrinter)this.context).pop();
        return null;
    }

    @Override
    public Object visitGuardParameter(@NonNull GuardParameter asParameter) {
        Property successProperty;
        ((PrettyPrinter)this.context).append("guard:");
        ((PrettyPrinter)this.context).appendName((NamedElement)asParameter.getReferredTypedModel());
        ((PrettyPrinter)this.context).append(" ");
        ((PrettyPrinter)this.context).appendName((NamedElement)asParameter);
        Type type = asParameter.getType();
        if (type != null) {
            ((PrettyPrinter)this.context).append(" : ");
            ((PrettyPrinter)this.context).appendTypedMultiplicity((TypedElement)asParameter);
        }
        if ((successProperty = asParameter.getSuccessProperty()) != null) {
            ((PrettyPrinter)this.context).append(" success ");
            ((PrettyPrinter)this.context).appendName((NamedElement)successProperty);
        }
        ((PrettyPrinter)this.context).append(";\n");
        return null;
    }

    @Override
    public Object visitGuardParameterBinding(@NonNull GuardParameterBinding pGuardParameterBinding) {
        if (pGuardParameterBinding.isIsCheck()) {
            ((PrettyPrinter)this.context).append("check ");
        }
        ((PrettyPrinter)this.context).appendName((NamedElement)pGuardParameterBinding.getBoundVariable());
        ((PrettyPrinter)this.context).append(" consumes ");
        this.safeVisit((Visitable)pGuardParameterBinding.getValue());
        ((PrettyPrinter)this.context).append(";\n");
        return null;
    }

    @Override
    public Object visitImperativeModel(@NonNull ImperativeModel object) {
        return this.visitModel((Model)object);
    }

    @Override
    public Object visitImperativeTransformation(@NonNull ImperativeTransformation object) {
        return this.visitTransformation(object);
    }

    @Override
    public Object visitLoopParameterBinding(@NonNull LoopParameterBinding pLoopParameterBinding) {
        if (pLoopParameterBinding.isIsCheck()) {
            ((PrettyPrinter)this.context).append("check ");
        }
        ((PrettyPrinter)this.context).appendName((NamedElement)pLoopParameterBinding.getBoundVariable());
        ((PrettyPrinter)this.context).append(" iterates ");
        this.safeVisit((Visitable)pLoopParameterBinding.getValue());
        ((PrettyPrinter)this.context).append(";\n");
        return null;
    }

    @Override
    public Object visitLoopVariable(@NonNull LoopVariable asVariable) {
        ((PrettyPrinter)this.context).appendName((NamedElement)asVariable);
        Type type = asVariable.getType();
        if (type != null) {
            ((PrettyPrinter)this.context).append(" : ");
            ((PrettyPrinter)this.context).appendTypedMultiplicity((TypedElement)asVariable);
        }
        return null;
    }

    @Override
    public Object visitMapping(@NonNull Mapping pMapping) {
        if (pMapping.isIsStrict()) {
            ((PrettyPrinter)this.context).append("strict ");
        }
        ((PrettyPrinter)this.context).append("map");
        Integer firstPass = pMapping.getFirstPass();
        if (firstPass != null) {
            ((PrettyPrinter)this.context).append(":");
            ((PrettyPrinter)this.context).append((Number)firstPass);
            Integer lastPass = pMapping.getLastPass();
            if (lastPass != null) {
                ((PrettyPrinter)this.context).append("..");
                ((PrettyPrinter)this.context).append((Number)lastPass);
            }
        }
        ((PrettyPrinter)this.context).append(" ");
        ((PrettyPrinter)this.context).appendName((NamedElement)pMapping);
        ((PrettyPrinter)this.context).append(" in ");
        ((PrettyPrinter)this.context).appendName((NamedElement)pMapping.getTransformation());
        ((PrettyPrinter)this.context).append(" {\n");
        ((PrettyPrinter)this.context).push("", "");
        for (MappingParameter pVariable : QVTimperativeUtil.getOwnedMappingParameters(pMapping)) {
            this.safeVisit((Visitable)pVariable);
        }
        for (Statement pStatement : pMapping.getOwnedStatements()) {
            this.safeVisit((Visitable)pStatement);
        }
        ((PrettyPrinter)this.context).pop();
        return null;
    }

    @Override
    public Object visitMappingCall(@NonNull MappingCall pMappingCall) {
        ((PrettyPrinter)this.context).append(pMappingCall.isIsInstall() ? "install " : (pMappingCall.isIsInvoke() ? "invoke " : "call "));
        ((PrettyPrinter)this.context).appendName((NamedElement)pMappingCall.getReferredMapping());
        ((PrettyPrinter)this.context).append(" {\n");
        ((PrettyPrinter)this.context).push("", "");
        for (MappingParameterBinding mappingParameterBinding : QVTimperativeUtil.getOwnedMappingParameterBindings(pMappingCall)) {
            this.safeVisit((Visitable)mappingParameterBinding);
        }
        ((PrettyPrinter)this.context).append("}");
        ((PrettyPrinter)this.context).pop();
        return null;
    }

    @Override
    public Object visitMappingLoop(@NonNull MappingLoop asMappingLoop) {
        this.appendObservedProperties(asMappingLoop);
        ((PrettyPrinter)this.context).append("for ");
        ((PrettyPrinter)this.context).appendElement((Element)asMappingLoop.getOwnedIterators().get(0));
        ((PrettyPrinter)this.context).append(" in ");
        ((PrettyPrinter)this.context).appendElement((Element)asMappingLoop.getOwnedExpression());
        ((PrettyPrinter)this.context).append(" {");
        ((PrettyPrinter)this.context).push("", "");
        for (MappingStatement pMappingStatement : asMappingLoop.getOwnedMappingStatements()) {
            this.safeVisit((Visitable)pMappingStatement);
        }
        ((PrettyPrinter)this.context).append("}");
        ((PrettyPrinter)this.context).pop();
        return null;
    }

    @Override
    public Object visitMappingParameter(@NonNull MappingParameter object) {
        return this.visiting((Visitable)object);
    }

    @Override
    public Object visitMappingParameterBinding(@NonNull MappingParameterBinding object) {
        return this.visiting((Visitable)object);
    }

    @Override
    public Object visitMappingStatement(@NonNull MappingStatement object) {
        return this.visiting((Visitable)object);
    }

    @Override
    public Object visitNewStatement(@NonNull NewStatement asNewStatement) {
        this.appendObservedProperties(asNewStatement);
        if (asNewStatement.isIsContained()) {
            ((PrettyPrinter)this.context).append("contained ");
        }
        ((PrettyPrinter)this.context).append("new:");
        ((PrettyPrinter)this.context).appendName((NamedElement)asNewStatement.getReferredTypedModel());
        ((PrettyPrinter)this.context).append(" ");
        ((PrettyPrinter)this.context).appendName((NamedElement)asNewStatement);
        Type type = asNewStatement.getType();
        if (type != null) {
            ((PrettyPrinter)this.context).append(" : ");
            ((PrettyPrinter)this.context).appendTypedMultiplicity((TypedElement)asNewStatement);
        }
        if (asNewStatement.eIsSet((EStructuralFeature)QVTimperativePackage.Literals.NEW_STATEMENT__OWNED_PARTS)) {
            ((PrettyPrinter)this.context).append(" {");
            boolean isFirst = true;
            for (NewStatementPart part : asNewStatement.getOwnedParts()) {
                if (!isFirst) {
                    ((PrettyPrinter)this.context).append(", ");
                }
                this.safeVisit((Visitable)part);
                isFirst = false;
            }
            ((PrettyPrinter)this.context).append("}\n");
        } else {
            OCLExpression initExpression = asNewStatement.getOwnedExpression();
            if (initExpression != null) {
                ((PrettyPrinter)this.context).append(" = ");
                this.safeVisit((Visitable)initExpression);
            }
            ((PrettyPrinter)this.context).append(";\n");
        }
        return null;
    }

    @Override
    public Object visitNewStatementPart(@NonNull NewStatementPart asNewStatementPart) {
        ((PrettyPrinter)this.context).appendElement((Element)asNewStatementPart.getReferredProperty());
        ((PrettyPrinter)this.context).append(" = ");
        this.safeVisit((Visitable)asNewStatementPart.getOwnedExpression());
        return null;
    }

    @Override
    public Object visitObservableStatement(@NonNull ObservableStatement object) {
        return this.visiting((Visitable)object);
    }

    public Object visitPredicate(@NonNull Predicate pPredicate) {
        this.safeVisit((Visitable)pPredicate.getConditionExpression());
        return null;
    }

    @Override
    public Object visitSetStatement(@NonNull SetStatement asSetStatement) {
        this.appendObservedProperties(asSetStatement);
        if (asSetStatement.isIsNotify()) {
            ((PrettyPrinter)this.context).append("notify ");
        }
        ((PrettyPrinter)this.context).append("set ");
        ((PrettyPrinter)this.context).appendName((NamedElement)asSetStatement.getTargetVariable());
        ((PrettyPrinter)this.context).append(".");
        ((PrettyPrinter)this.context).appendName((NamedElement)QVTimperativeUtil.getTargetProperty(asSetStatement));
        ((PrettyPrinter)this.context).append(" := ");
        this.safeVisit((Visitable)asSetStatement.getOwnedExpression());
        ((PrettyPrinter)this.context).append(";\n");
        return null;
    }

    @Override
    public Object visitSimpleParameter(@NonNull SimpleParameter asParameter) {
        ((PrettyPrinter)this.context).append("in:");
        ((PrettyPrinter)this.context).appendName((NamedElement)asParameter.getReferredTypedModel());
        ((PrettyPrinter)this.context).append(" ");
        ((PrettyPrinter)this.context).appendName((NamedElement)asParameter);
        ((PrettyPrinter)this.context).append(" ");
        Type type = asParameter.getType();
        if (type != null) {
            ((PrettyPrinter)this.context).append(" : ");
            ((PrettyPrinter)this.context).appendTypedMultiplicity((TypedElement)asParameter);
        }
        ((PrettyPrinter)this.context).append(";\n");
        return null;
    }

    @Override
    public Object visitSimpleParameterBinding(@NonNull SimpleParameterBinding pSimpleParameterBinding) {
        if (pSimpleParameterBinding.isIsCheck()) {
            ((PrettyPrinter)this.context).append("check ");
        }
        ((PrettyPrinter)this.context).appendName((NamedElement)pSimpleParameterBinding.getBoundVariable());
        ((PrettyPrinter)this.context).append(" uses ");
        this.safeVisit((Visitable)pSimpleParameterBinding.getValue());
        ((PrettyPrinter)this.context).append(";\n");
        return null;
    }

    @Override
    public Object visitSpeculateStatement(@NonNull SpeculateStatement object) {
        ((PrettyPrinter)this.context).append("speculate ");
        boolean isFirst = true;
        for (OCLExpression expression : QVTimperativeUtil.getOwnedExpressions(object)) {
            if (!isFirst) {
                ((PrettyPrinter)this.context).append(", ");
            }
            this.safeVisit((Visitable)expression);
            isFirst = false;
        }
        ((PrettyPrinter)this.context).append(";\n");
        return null;
    }

    @Override
    public Object visitStatement(@NonNull Statement object) {
        return this.visiting((Visitable)object);
    }

    public Object visitVariable(@NonNull Variable pVariable) {
        if (pVariable.eContainer() instanceof MappingLoop) {
            ((PrettyPrinter)this.context).appendName((NamedElement)pVariable);
            ((PrettyPrinter)this.context).append(" : ");
            ((PrettyPrinter)this.context).appendElement((Element)pVariable.getType());
        } else {
            super.visitVariable(pVariable);
            ((PrettyPrinter)this.context).append(";\n");
        }
        return null;
    }

    @Override
    public Object visitVariableStatement(@NonNull VariableStatement object) {
        return this.visiting((Visitable)object);
    }
}

