/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound.v3;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedMap;

public class PrefixedIterable
implements Iterable<String> {
    private final String prefix;
    private final Iterable<String> strings;

    static Iterable<String> filteredByPrefix(SortedMap<String, ?> entries, String prefix) {
        return new PrefixedIterable(entries.tailMap(prefix).keySet(), prefix);
    }

    PrefixedIterable(Iterable<String> strings, String prefix) {
        this.prefix = PrefixedIterable.checkNotNull(prefix);
        this.strings = PrefixedIterable.checkNotNull(strings);
    }

    @Override
    public Iterator<String> iterator() {
        return new PrefixedIterator(this.strings.iterator(), this.prefix);
    }

    static <T> T checkNotNull(T value) {
        if (value == null) {
            throw new NullPointerException();
        }
        return value;
    }

    private static class PrefixedIterator
    implements Iterator<String> {
        final String prefix;
        final Iterator<String> strings;
        String next;

        PrefixedIterator(Iterator<String> strings, String prefix) {
            this.prefix = prefix;
            this.strings = strings;
            this.next = this.advance();
        }

        @Override
        public boolean hasNext() {
            return this.next != null && this.next.startsWith(this.prefix);
        }

        @Override
        public String next() {
            if (this.hasNext()) {
                String current = this.next;
                this.next = this.advance();
                return current;
            }
            throw new NoSuchElementException();
        }

        private String advance() {
            String peek = this.strings.hasNext() ? this.strings.next() : null;
            return peek != null && peek.startsWith(this.prefix) ? peek : null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

