/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.snapshot;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.snapshot.IOQLQuery;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.OQLParseException;
import org.eclipse.mat.snapshot.SnapshotFormat;
import org.eclipse.mat.util.IProgressListener;

public final class SnapshotFactory {
    private static Implementation factory;

    static {
        try {
            IExtension[] iExtensionArray;
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.mat.api.factory");
            if (extensionPoint != null && (iExtensionArray = extensionPoint.getExtensions()).length != 0) {
                IExtension extension = iExtensionArray[0];
                factory = (Implementation)extension.getConfigurationElements()[0].createExecutableExtension("impl");
            }
        }
        catch (InvalidRegistryObjectException e) {
            Logger.getLogger(SnapshotFactory.class.getName()).log(Level.SEVERE, Messages.SnapshotFactory_ErrorMsg_FactoryCreation, e);
        }
        catch (CoreException e) {
            Logger.getLogger(SnapshotFactory.class.getName()).log(Level.SEVERE, Messages.SnapshotFactory_ErrorMsg_FactoryCreation, e);
        }
        if (factory == null) {
            Logger.getLogger(SnapshotFactory.class.getName()).log(Level.SEVERE, Messages.SnapshotFactory_ErrorMsg_FactoryCreation);
        }
    }

    public static ISnapshot openSnapshot(File file, IProgressListener listener) throws SnapshotException {
        return SnapshotFactory.openSnapshot(file, new HashMap<String, String>(0), listener);
    }

    public static ISnapshot openSnapshot(File file, Map<String, String> arguments, IProgressListener listener) throws SnapshotException {
        return factory.openSnapshot(file, arguments, listener);
    }

    public static void dispose(ISnapshot snapshot) {
        factory.dispose(snapshot);
    }

    public static IOQLQuery createQuery(String queryString) throws OQLParseException, SnapshotException {
        return factory.createQuery(queryString);
    }

    public static List<SnapshotFormat> getSupportedFormats() {
        return factory.getSupportedFormats();
    }

    private SnapshotFactory() {
    }

    public static interface Implementation {
        public ISnapshot openSnapshot(File var1, Map<String, String> var2, IProgressListener var3) throws SnapshotException;

        public void dispose(ISnapshot var1);

        public IOQLQuery createQuery(String var1) throws OQLParseException, SnapshotException;

        public List<SnapshotFormat> getSupportedFormats();
    }
}

