/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.definition;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.lsp4e.operations.declaration.OpenDeclarationHyperlinkDetector;
import org.eclipse.lsp4e.test.utils.AbstractTestWithProject;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4e.tests.mock.MockTextDocumentService;
import org.eclipse.lsp4j.DeclarationParams;
import org.eclipse.lsp4j.ImplementationParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TypeDefinitionParams;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HyperlinkDetectorErrorHandlingTest
extends AbstractTestWithProject {
    private final OpenDeclarationHyperlinkDetector detector = new OpenDeclarationHyperlinkDetector();

    @Override
    protected ServerCapabilities getServerCapabilities() {
        ServerCapabilities caps = MockLanguageServer.defaultServerCapabilities();
        caps.setDefinitionProvider(Boolean.valueOf(true));
        caps.setTypeDefinitionProvider(Boolean.valueOf(true));
        caps.setDeclarationProvider(Boolean.valueOf(true));
        caps.setImplementationProvider(Boolean.valueOf(true));
        return caps;
    }

    @Test
    public void testDefinitionRemainsWhenTypeDefinitionErrors() throws Exception {
        MockLanguageServer.INSTANCE.setTextDocumentService(new MockTextDocumentService(arg_0 -> ((MockLanguageServer)MockLanguageServer.INSTANCE).buildMaybeDelayedFuture(arg_0)){

            public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> typeDefinition(TypeDefinitionParams params) {
                CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> f = new CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>>();
                f.completeExceptionally(new RuntimeException("unexpected error during typeDefinition retrieval"));
                return f;
            }

            public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> implementation(ImplementationParams params) {
                throw new RuntimeException("unexpected error during implementation retrieval");
            }

            public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> declaration(DeclarationParams params) {
                throw new RuntimeException("unexpected error during declaration retrieval");
            }
        });
        Assertions.assertThrows(RuntimeException.class, () -> {
            CompletableFuture completableFuture = MockLanguageServer.INSTANCE.getTextDocumentService().declaration(null);
        });
        Assertions.assertThrows(RuntimeException.class, () -> {
            CompletableFuture completableFuture = MockLanguageServer.INSTANCE.getTextDocumentService().implementation(null);
        });
        Assertions.assertTrue((boolean)MockLanguageServer.INSTANCE.getTextDocumentService().typeDefinition(null).isCompletedExceptionally());
        MockLanguageServer.INSTANCE.setDefinition(List.of(new Location("file://def", new Range(new Position(0, 0), new Position(0, 10))), new Location("file://def", new Range(new Position(1, 10), new Position(1, 20)))));
        IFile file = TestUtils.createUniqueTestFile(this.project, "Example Text");
        ITextViewer viewer = TestUtils.openTextViewer(file);
        IHyperlink[] links = this.detector.detectHyperlinks(viewer, (IRegion)new Region(0, 0), true);
        Assertions.assertNotNull((Object)links, (String)"Hyperlinks should not be null when definition succeeds despite typeDefinition error");
        Assertions.assertEquals((int)2, (int)links.length);
    }
}

