/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.handlers;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.handlers.Messages;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.handlers.RunScriptHandler;
import org.eclipse.linuxtools.systemtap.graphing.core.datasets.IDataSet;
import org.eclipse.linuxtools.systemtap.graphing.core.datasets.IDataSetParser;
import org.eclipse.linuxtools.systemtap.graphing.core.datasets.IFilteredDataSet;
import org.eclipse.linuxtools.systemtap.graphing.core.structures.ChartStreamDaemon;
import org.eclipse.linuxtools.systemtap.graphing.core.structures.GraphData;
import org.eclipse.linuxtools.systemtap.graphing.ui.views.GraphSelectorEditor;
import org.eclipse.linuxtools.systemtap.graphing.ui.views.GraphSelectorEditorInput;
import org.eclipse.linuxtools.systemtap.graphing.ui.widgets.ExceptionErrorDialog;
import org.eclipse.linuxtools.systemtap.structures.listeners.IGobblerListener;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.ScriptConsole;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class RunScriptChartHandler
extends RunScriptHandler {
    private List<IDataSetParser> parsers;
    private List<IFilteredDataSet> dataSets;
    private List<String> names;
    private List<LinkedList<GraphData>> graphs;

    public RunScriptChartHandler(List<IDataSetParser> parsers, List<IFilteredDataSet> dataSet, List<String> names, List<LinkedList<GraphData>> graphs) {
        this.parsers = parsers;
        this.dataSets = dataSet;
        this.names = names;
        this.graphs = graphs;
    }

    @Override
    protected void scriptConsoleInitialized(ScriptConsole console) {
        int n = this.parsers.size();
        for (int i = 0; i < n; ++i) {
            console.getCommand().addInputStreamListener((IGobblerListener)new ChartStreamDaemon((IDataSet)this.dataSets.get(i), this.parsers.get(i)));
        }
        try {
            String name = console.getName();
            String title = name.substring(name.lastIndexOf(47) + 1);
            IWorkbenchPage p = PlatformUI.getWorkbench().showPerspective("org.eclipse.linuxtools.systemtap.ui.ide.IDEPerspective", PlatformUI.getWorkbench().getActiveWorkbenchWindow());
            GraphSelectorEditor ivp = (GraphSelectorEditor)p.openEditor((IEditorInput)new GraphSelectorEditorInput(title), "org.eclipse.linuxtools.systemtap.graphing.ui.views.GraphSelectorEditor");
            String scriptName = console.getName();
            ivp.createScriptSets(scriptName, this.names, this.dataSets);
            for (int i = 0; i < n; ++i) {
                for (GraphData graph : this.graphs.get(i)) {
                    ivp.getDisplaySet(i).addGraph(graph);
                }
            }
        }
        catch (WorkbenchException we) {
            ExceptionErrorDialog.openError((String)Messages.RunScriptChartHandler_couldNotSwitchToGraphicPerspective, (Exception)((Object)we));
        }
        super.scriptConsoleInitialized(console);
    }
}

