package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.mandas.docker.Nullable;

/**
 * Immutable implementation of {@link CaConfig}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCaConfig.builder()}.
 */
@SuppressWarnings({"all"})
final class ImmutableCaConfig implements CaConfig {
  private final @Nullable Long nodeCertExpiry;
  private final @Nullable List<ExternalCa> externalCas;

  private ImmutableCaConfig(
      @Nullable Long nodeCertExpiry,
      @Nullable List<ExternalCa> externalCas) {
    this.nodeCertExpiry = nodeCertExpiry;
    this.externalCas = externalCas;
  }

  /**
   * @return The value of the {@code nodeCertExpiry} attribute
   */
  @JsonProperty("NodeCertExpiry")
  @Override
  public @Nullable Long nodeCertExpiry() {
    return nodeCertExpiry;
  }

  /**
   * @return The value of the {@code externalCas} attribute
   */
  @JsonProperty("ExternalCAs")
  @Override
  public @Nullable List<ExternalCa> externalCas() {
    return externalCas;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CaConfig#nodeCertExpiry() nodeCertExpiry} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nodeCertExpiry (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCaConfig withNodeCertExpiry(@Nullable Long value) {
    if (Objects.equals(this.nodeCertExpiry, value)) return this;
    return new ImmutableCaConfig(value, this.externalCas);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CaConfig#externalCas() externalCas}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCaConfig withExternalCas(@Nullable ExternalCa... elements) {
    if (elements == null) {
      return new ImmutableCaConfig(this.nodeCertExpiry, null);
    }
    @Nullable List<ExternalCa> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableCaConfig(this.nodeCertExpiry, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CaConfig#externalCas() externalCas}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of externalCas elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCaConfig withExternalCas(@Nullable Iterable<? extends ExternalCa> elements) {
    if (this.externalCas == elements) return this;
    @Nullable List<ExternalCa> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableCaConfig(this.nodeCertExpiry, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCaConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCaConfig
        && equalTo(0, (ImmutableCaConfig) another);
  }

  private boolean equalTo(int synthetic, ImmutableCaConfig another) {
    return Objects.equals(nodeCertExpiry, another.nodeCertExpiry)
        && Objects.equals(externalCas, another.externalCas);
  }

  /**
   * Computes a hash code from attributes: {@code nodeCertExpiry}, {@code externalCas}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(nodeCertExpiry);
    h += (h << 5) + Objects.hashCode(externalCas);
    return h;
  }

  /**
   * Prints the immutable value {@code CaConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CaConfig{"
        + "nodeCertExpiry=" + nodeCertExpiry
        + ", externalCas=" + externalCas
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link CaConfig} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CaConfig instance
   */
  public static ImmutableCaConfig copyOf(CaConfig instance) {
    if (instance instanceof ImmutableCaConfig) {
      return (ImmutableCaConfig) instance;
    }
    return ImmutableCaConfig.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCaConfig ImmutableCaConfig}.
   * <pre>
   * ImmutableCaConfig.builder()
   *    .nodeCertExpiry(Long | null) // nullable {@link CaConfig#nodeCertExpiry() nodeCertExpiry}
   *    .externalCas(List&amp;lt;org.mandas.docker.client.messages.swarm.ExternalCa&amp;gt; | null) // nullable {@link CaConfig#externalCas() externalCas}
   *    .build();
   * </pre>
   * @return A new ImmutableCaConfig builder
   */
  public static ImmutableCaConfig.Builder builder() {
    return new ImmutableCaConfig.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCaConfig ImmutableCaConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder implements CaConfig.Builder {
    private Long nodeCertExpiry;
    private List<ExternalCa> externalCas = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CaConfig} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CaConfig instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Long nodeCertExpiryValue = instance.nodeCertExpiry();
      if (nodeCertExpiryValue != null) {
        nodeCertExpiry(nodeCertExpiryValue);
      }
      @Nullable List<ExternalCa> externalCasValue = instance.externalCas();
      if (externalCasValue != null) {
        addAllExternalCas(externalCasValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CaConfig#nodeCertExpiry() nodeCertExpiry} attribute.
     * @param nodeCertExpiry The value for nodeCertExpiry (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("NodeCertExpiry")
    public final Builder nodeCertExpiry(@Nullable Long nodeCertExpiry) {
      this.nodeCertExpiry = nodeCertExpiry;
      return this;
    }

    /**
     * Adds one element to {@link CaConfig#externalCas() externalCas} list.
     * @param element A externalCas element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder externalCa(ExternalCa element) {
      if (this.externalCas == null) {
        this.externalCas = new ArrayList<ExternalCa>();
      }
      this.externalCas.add(Objects.requireNonNull(element, "externalCas element"));
      return this;
    }

    /**
     * Adds elements to {@link CaConfig#externalCas() externalCas} list.
     * @param elements An array of externalCas elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder externalCas(ExternalCa... elements) {
      if (this.externalCas == null) {
        this.externalCas = new ArrayList<ExternalCa>();
      }
      for (ExternalCa element : elements) {
        this.externalCas.add(Objects.requireNonNull(element, "externalCas element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CaConfig#externalCas() externalCas} list.
     * @param elements An iterable of externalCas elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ExternalCAs")
    public final Builder externalCas(@Nullable Iterable<? extends ExternalCa> elements) {
      if (elements == null) {
        this.externalCas = null;
        return this;
      }
      this.externalCas = new ArrayList<ExternalCa>();
      return addAllExternalCas(elements);
    }

    /**
     * Adds elements to {@link CaConfig#externalCas() externalCas} list.
     * @param elements An iterable of externalCas elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllExternalCas(Iterable<? extends ExternalCa> elements) {
      Objects.requireNonNull(elements, "externalCas element");
      if (this.externalCas == null) {
        this.externalCas = new ArrayList<ExternalCa>();
      }
      for (ExternalCa element : elements) {
        this.externalCas.add(Objects.requireNonNull(element, "externalCas element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableCaConfig ImmutableCaConfig}.
     * @return An immutable instance of CaConfig
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCaConfig build() {
      return new ImmutableCaConfig(nodeCertExpiry, externalCas == null ? null : createUnmodifiableList(true, externalCas));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
