/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.pdt.introspector.core.services;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.spi.RegistryContributor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.osgi.framework.Version;
import org.polarsys.kitalpha.pdt.introspector.core.IntrospectionContext;
import org.polarsys.kitalpha.pdt.introspector.core.comparators.PluginDependenciesComparator;
import org.polarsys.kitalpha.pdt.introspector.core.exceptions.IntrospectionExceptions;
import org.polarsys.kitalpha.pdt.introspector.core.services.ExtensionPointServices;
import org.polarsys.kitalpha.pdt.introspector.core.services.ExtensionServices;
import org.polarsys.kitalpha.pdt.introspector.core.services.Helpers;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.EclipseElement;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.EclipseModel;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.ExecutionEnvironment;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.ExportedPackage;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.Extension;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.ExtensionPoint;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.InclusionKind;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.PlatformFactory;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.Plugin;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.PluginDependencies;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.PluginDependency;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.PluginExtensionPoints;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.Repository;

public class PluginServices {
    private static final String ID_VERSION_SEPARATOR = "_v_";

    public static void createPlugins(IntrospectionContext introContext, IProgressMonitor monitor, EclipseModel myEclipseModel) throws IntrospectionExceptions {
        String IdAndVersion;
        String namedAndVersionnedPlugin;
        int qualifierSize;
        String qualifier;
        List<Object> platformPlugins = new ArrayList();
        List<Object> workspacePlugins = new ArrayList();
        ArrayList<Object> totalPlugins = new ArrayList<Object>();
        if (introContext.isVisitPlatform()) {
            platformPlugins = Arrays.asList(PluginRegistry.getExternalModels());
            totalPlugins.addAll(platformPlugins);
        }
        if (introContext.isVisitWorkspace()) {
            workspacePlugins = Arrays.asList(PluginRegistry.getWorkspaceModels());
            totalPlugins.addAll(workspacePlugins);
        }
        if (monitor != null) {
            monitor.subTask("Creating Plugins...");
        }
        for (IPluginModelBase iPluginModelBase : totalPlugins) {
            if (monitor != null && monitor.isCanceled()) {
                throw new IntrospectionExceptions();
            }
            String filterRegEx = introContext.getFilterRegEx();
            if (iPluginModelBase.getPluginBase().getId().startsWith(filterRegEx)) {
                Repository currentRepository = null;
                String pluginEntryIDAndVersionned_label = String.valueOf(iPluginModelBase.getPluginBase().getId()) + ID_VERSION_SEPARATOR + iPluginModelBase.getBundleDescription().getVersion();
                qualifier = iPluginModelBase.getBundleDescription().getVersion().getQualifier();
                qualifierSize = qualifier.length();
                boolean isQualifierMatch = introContext.isQualifierMatch();
                pluginEntryIDAndVersionned_label = Helpers.controlVersionLabel(pluginEntryIDAndVersionned_label, isQualifierMatch, qualifierSize);
                PluginServices.loadWorkspacePlugin(iPluginModelBase, introContext);
                if (platformPlugins.contains(iPluginModelBase)) {
                    currentRepository = introContext.getRepositoryToSaveHashMap().get("Platform");
                }
                if (workspacePlugins.contains(iPluginModelBase)) {
                    currentRepository = introContext.getRepositoryToSaveHashMap().get("Workspace");
                }
                Plugin currentPlugin = null;
                if (currentRepository != null) {
                    if (!introContext.getPluginId_Plugin_fromOtherModels().containsKey(pluginEntryIDAndVersionned_label)) {
                        currentPlugin = PluginServices.createPlugin(iPluginModelBase, introContext, currentRepository);
                        if (currentPlugin != null) {
                            PluginServices.createPluginExtensionsPoints(iPluginModelBase, currentPlugin, introContext);
                            EList extensionPoints = currentPlugin.getExtensionPoints().getExtensionPoints();
                            ExtensionPointServices.sortExtensionPoints((EList<ExtensionPoint>)extensionPoints);
                        } else {
                            String name = iPluginModelBase.getPluginBase().getName();
                            String message = "The plugin " + name + "cannot be added to the introspection model";
                            String detail = "The operation createPlugin have failed to implement the plugin " + name + " into the introspection model";
                            Helpers.createErrorForModelElement((EclipseElement)currentRepository, introContext, message, detail);
                        }
                        currentRepository.getPlugins().add((Object)currentPlugin);
                        introContext.addPlugin(pluginEntryIDAndVersionned_label, currentPlugin);
                    }
                } else {
                    Helpers.createErrorForModelElement((EclipseElement)myEclipseModel, introContext, "Repository cannot be loaded", "");
                }
            }
            if (monitor == null) continue;
            monitor.worked(1);
        }
        boolean bl = introContext.isQualifierMatch();
        if (monitor != null) {
            monitor.subTask("Setting up Plugins dependencies...");
        }
        for (IPluginModelBase iPluginModelBase : totalPlugins) {
            if (monitor != null && monitor.isCanceled()) {
                throw new IntrospectionExceptions();
            }
            namedAndVersionnedPlugin = "";
            IdAndVersion = String.valueOf(iPluginModelBase.getPluginBase().getId()) + ID_VERSION_SEPARATOR + iPluginModelBase.getPluginBase().getVersion();
            qualifier = iPluginModelBase.getBundleDescription().getVersion().getQualifier();
            qualifierSize = qualifier.length();
            namedAndVersionnedPlugin = Helpers.controlVersionLabel(IdAndVersion, bl, qualifierSize);
            Plugin currentPlugin = introContext.getPluginId_Plugin().get(namedAndVersionnedPlugin);
            if (!introContext.getPluginId_Plugin_fromOtherModels().containsKey(namedAndVersionnedPlugin) && currentPlugin != null) {
                PluginServices.createPluginDependencies(currentPlugin, iPluginModelBase, introContext);
            }
            if (currentPlugin != null) {
                EList pluginDependencies = currentPlugin.getPluginDependencies().getPluginDependencies();
                PluginServices.sortPluginDependencies((EList<PluginDependency>)pluginDependencies);
            }
            if (monitor == null) continue;
            monitor.worked(1);
        }
        if (monitor != null) {
            monitor.subTask("Setting up Plugins Extension Points & Extensions...");
        }
        for (IPluginModelBase iPluginModelBase : totalPlugins) {
            if (monitor != null && monitor.isCanceled()) {
                throw new IntrospectionExceptions();
            }
            namedAndVersionnedPlugin = "";
            IdAndVersion = String.valueOf(iPluginModelBase.getPluginBase().getId()) + ID_VERSION_SEPARATOR + iPluginModelBase.getPluginBase().getVersion();
            qualifier = iPluginModelBase.getBundleDescription().getVersion().getQualifier();
            qualifierSize = qualifier.length();
            namedAndVersionnedPlugin = Helpers.controlVersionLabel(IdAndVersion, bl, qualifierSize);
            Plugin currentPlugin = introContext.getPluginId_Plugin().get(namedAndVersionnedPlugin);
            if (!introContext.getPluginId_Plugin_fromOtherModels().containsKey(namedAndVersionnedPlugin) && currentPlugin != null) {
                PluginServices.createPluginExtensions(iPluginModelBase, introContext, currentPlugin);
            }
            if (monitor == null) continue;
            monitor.worked(1);
        }
    }

    private static Plugin createPlugin(IPluginModelBase pluginEntry, IntrospectionContext introContext, Repository currentRepository) {
        String[] execEvts;
        String id = String.valueOf(pluginEntry.getPluginBase().getId()) + ID_VERSION_SEPARATOR + pluginEntry.getPluginBase().getVersion();
        PlatformFactory factory = PlatformFactory.eINSTANCE;
        Plugin currentPlugin = factory.createPlugin();
        String version = pluginEntry.getPluginBase().getVersion();
        boolean qualifierMatch = introContext.isQualifierMatch();
        String qualifier = pluginEntry.getBundleDescription().getVersion().getQualifier();
        int qualifierSize = qualifier.length();
        String namedAndVersionnedPlugin = Helpers.controlVersionLabel(id, qualifierMatch, qualifierSize);
        if (qualifierMatch && qualifierSize > 0) {
            version = version.substring(0, version.length() - (qualifierSize + 1));
        }
        currentPlugin.setPluginDependencies(factory.createPluginDependencies());
        currentPlugin.setExtensionPoints(factory.createPluginExtensionPoints());
        currentPlugin.setExtensions(factory.createPluginExtensions());
        currentPlugin.setExportedPackages(factory.createExportedPackages());
        currentPlugin.setExecutionEnvironmnents(factory.createExecutionEnvironments());
        currentPlugin.setId(pluginEntry.getPluginBase().getId());
        currentPlugin.setVersion(version);
        BundleDescription bundleDescription = pluginEntry.getBundleDescription();
        String[] stringArray = execEvts = bundleDescription.getExecutionEnvironments();
        int n = execEvts.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            ExecutionEnvironment execEvt = factory.createExecutionEnvironment();
            execEvt.setId(string);
            currentPlugin.getExecutionEnvironmnents().getExecutionEnvironments().add((Object)execEvt);
            ++n2;
        }
        ExportPackageDescription[] exportPackages = bundleDescription.getExportPackages();
        if (exportPackages != null) {
            ExportPackageDescription[] exportPackageDescriptionArray = exportPackages;
            int n3 = exportPackages.length;
            n = 0;
            while (n < n3) {
                ExportPackageDescription exportPackageDescription = exportPackageDescriptionArray[n];
                String packageName = exportPackageDescription.getName();
                ExportedPackage exportedPackage = factory.createExportedPackage();
                exportedPackage.setId(packageName);
                currentPlugin.getExportedPackages().getExportedPackages().add((Object)exportedPackage);
                ++n;
            }
        }
        introContext.addPlugin(namedAndVersionnedPlugin, currentPlugin);
        return currentPlugin;
    }

    private static void createPluginDependencies(Plugin currentPlugin, IPluginModelBase pluginEntry, IntrospectionContext introContext) {
        BundleDescription bundleDescription = pluginEntry.getBundleDescription();
        List<Object> requiredBundles = new ArrayList();
        if (bundleDescription != null) {
            requiredBundles = Arrays.asList(bundleDescription.getRequiredBundles());
        } else {
            String string = "Cannot load the bundle for the plugin: " + currentPlugin.getId();
            String detail = "Cannot load the bundle for the plugin: " + currentPlugin.getId();
            Helpers.createErrorForModelElement((EclipseElement)currentPlugin, introContext, string, detail);
        }
        if (requiredBundles != null) {
            for (BundleSpecification bundleSpecification : requiredBundles) {
                VersionRange versionRange;
                String requiredPluginID = bundleSpecification.getName();
                Plugin neededPlugin = null;
                VersionRange range = versionRange = bundleSpecification.getVersionRange();
                boolean qualifierMatch = introContext.isQualifierMatch();
                if (versionRange != null) {
                    IPluginModelBase neededPluginModelBase = PluginRegistry.findModel((String)requiredPluginID, (VersionRange)range, null);
                    if (neededPluginModelBase != null) {
                        String versionNumber = neededPluginModelBase.getPluginBase().getVersion();
                        String qualifer = neededPluginModelBase.getBundleDescription().getVersion().getQualifier();
                        int qualifierSize = qualifer.length();
                        String requiredPlugin_Key = String.valueOf(requiredPluginID) + ID_VERSION_SEPARATOR + versionNumber;
                        requiredPlugin_Key = Helpers.controlVersionLabel(requiredPlugin_Key, qualifierMatch, qualifierSize);
                        neededPlugin = introContext.getPluginId_Plugin_fromOtherModels().containsKey(requiredPlugin_Key) ? introContext.getPluginId_Plugin_fromOtherModels().get(requiredPlugin_Key) : introContext.getPluginId_Plugin().get(requiredPlugin_Key);
                    }
                } else {
                    List<Plugin> availablePlugins = introContext.getAllPluginsWithGivenID(requiredPluginID);
                    neededPlugin = availablePlugins.get(availablePlugins.size() - 1);
                }
                if (neededPlugin != null) {
                    PluginDependency pluginDependency = PlatformFactory.eINSTANCE.createPluginDependency();
                    pluginDependency.setTarget(neededPlugin);
                    PluginServices.setUpVersionRangeForPluginDependence(pluginDependency, bundleSpecification);
                    PluginDependencies pluginDependenciesFolder = currentPlugin.getPluginDependencies();
                    pluginDependenciesFolder.getPluginDependencies().add((Object)pluginDependency);
                    continue;
                }
                if (!introContext.isStoreIntrospectionIssues()) continue;
                String message = "Cannot build dependency for the plugin " + currentPlugin.getId();
                String detail = String.valueOf(currentPlugin.getId()) + " depends on " + requiredPluginID + ", which doesn't exist!";
                Helpers.createErrorForModelElement((EclipseElement)currentPlugin, introContext, message, detail);
            }
        }
    }

    public static void setUpVersionRangeForPluginDependence(PluginDependency pluginDependency, BundleSpecification bundleDependency) {
        if (bundleDependency != null) {
            VersionRange range = bundleDependency.getVersionRange();
            boolean includeMin = range.getIncludeMinimum();
            boolean includeMax = range.getIncludeMaximum();
            Version min = range.getMinimum();
            Version right = range.getRight();
            Version max = right == null ? new Version(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE) : right;
            String minString = min.toString();
            String maxString = null;
            maxString = max.getMajor() == Integer.MAX_VALUE ? Helpers.UNDEFINED_STRING : max.toString();
            if (includeMin) {
                pluginDependency.setMinimumInclusion(InclusionKind.INCLUSIVE);
            } else {
                pluginDependency.setMinimumInclusion(InclusionKind.EXCLUSIVE);
            }
            if (includeMax) {
                pluginDependency.setMaximumInclusion(InclusionKind.INCLUSIVE);
            } else {
                pluginDependency.setMaximumInclusion(InclusionKind.EXCLUSIVE);
            }
            if (minString != null) {
                pluginDependency.setMinimumVersion(minString);
            } else {
                pluginDependency.setMinimumVersion(Helpers.UNDEFINED_STRING);
            }
            if (maxString != null) {
                pluginDependency.setMaximumVersion(maxString);
            } else {
                pluginDependency.setMaximumVersion(Helpers.UNDEFINED_STRING);
            }
        }
    }

    private static void createPluginExtensions(IPluginModelBase pluginEntry, IntrospectionContext introContext, Plugin currentPlugin) {
        IPluginExtension[] extensions;
        IPluginExtension[] iPluginExtensionArray = extensions = pluginEntry.getPluginBase().getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginExtension iPluginExtension = iPluginExtensionArray[n2];
            if (iPluginExtension != null) {
                String extPointID = iPluginExtension.getPoint();
                IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint(extPointID);
                iPluginExtension.getPluginBase();
                if (extPoint != null) {
                    IExtension[] contributingExtensions = extPoint.getExtensions();
                    ExtensionPoint modelExtPoint = introContext.getExtensionPointId_ExtensionPoint().get(extPointID);
                    IExtension[] iExtensionArray = contributingExtensions;
                    int n3 = contributingExtensions.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IExtension iExtension = iExtensionArray[n4];
                        String name = iExtension.getContributor().getName();
                        if (name.equals(pluginEntry.getPluginBase().getId())) {
                            PluginServices.createPluginExtension(introContext, pluginEntry, iExtension, extPoint, modelExtPoint, currentPlugin);
                        }
                        ++n4;
                    }
                } else {
                    Helpers.createErrorForModelElement((EclipseElement)currentPlugin, introContext, "extension point" + extPointID + " does not exist, altough it is referenced from -> " + pluginEntry.getPluginBase().getId(), "extension point " + extPointID + " does not exist, altough it is referenced from -> " + pluginEntry.getPluginBase().getId());
                }
            }
            ++n2;
        }
    }

    private static void loadWorkspacePlugin(IPluginModelBase pluginEntry, IntrospectionContext introContext) {
        IWorkspace workspace;
        IWorkspaceRoot workspaceRoot;
        IPath workspaceDirectory;
        String workspacePath;
        Object master = new Object();
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        String pluginPath = pluginEntry.getInstallLocation();
        if (pluginPath.contains(workspacePath = (workspaceDirectory = (workspaceRoot = (workspace = ResourcesPlugin.getWorkspace()).getRoot()).getLocation()).toOSString())) {
            String pluginDotXmlFilePathString = String.valueOf(pluginPath.replace(workspacePath, "")) + "/plugin.xml";
            Path pluginDotXmlFilePath = new Path(pluginDotXmlFilePathString);
            IFile pluginDotXmlFile = workspaceRoot.getFile((IPath)pluginDotXmlFilePath);
            String projectName = pluginEntry.getBundleDescription().getName();
            RegistryContributor contributor = new RegistryContributor(projectName, projectName, projectName, projectName);
            try {
                Field masterField = registry.getClass().getDeclaredField("masterToken");
                masterField.setAccessible(true);
                master = masterField.get(registry);
                if (registry.getExtensions(contributor.getName()).length == 0 && registry.getExtensionPoints(contributor.getName()).length == 0) {
                    registry.addContribution(pluginDotXmlFile.getContents(), (IContributor)contributor, false, contributor.getName(), null, master);
                }
            }
            catch (Exception e) {
                Helpers.createErrorForModelElement(null, introContext, "Cannot find XML on " + projectName, "Plugin : " + projectName + " does not include a xml");
            }
        }
    }

    private static void createPluginExtension(IntrospectionContext introContext, IPluginModelBase pluginEntry, IExtension currentExtension, IExtensionPoint currentExtensionPoint, ExtensionPoint extensionPoint, Plugin currentPlugin) {
        if (extensionPoint == null) {
            Helpers.createErrorForModelElement((EclipseElement)currentPlugin, introContext, "Cannot find a related extension point of " + currentPlugin.getId() + ".", "");
            return;
        }
        PlatformFactory platformFactory = PlatformFactory.eINSTANCE;
        Extension extension = platformFactory.createExtension();
        if (currentExtension.getSimpleIdentifier() != null) {
            extension.setId(currentExtension.getSimpleIdentifier());
        } else {
            extension.setId(Helpers.ANONYMOUS_ELEMENT);
        }
        extension.setExtensionPoint(extensionPoint);
        if (extensionPoint != null) {
            extensionPoint.getContributors().add((Object)extension);
        }
        ExtensionServices.createConfiguredSchemaElements(introContext, currentExtension, extensionPoint, extension);
        currentPlugin.getExtensions().getExtensions().add((Object)extension);
    }

    private static void createPluginExtensionsPoints(IPluginModelBase pluginEntry, Plugin currentPlugin, IntrospectionContext introContext) {
        PlatformFactory platformFactory = PlatformFactory.eINSTANCE;
        IPluginExtensionPoint[] extPoints = pluginEntry.getPluginBase().getExtensionPoints();
        ArrayList<IExtensionPoint> extensionPoints = new ArrayList<IExtensionPoint>();
        IPluginExtensionPoint[] iPluginExtensionPointArray = extPoints;
        int n = extPoints.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginExtensionPoint iPluginExtensionPoint = iPluginExtensionPointArray[n2];
            IExtensionPoint currentExtP = Platform.getExtensionRegistry().getExtensionPoint(iPluginExtensionPoint.getFullId());
            if (currentExtP != null) {
                extensionPoints.add(currentExtP);
            }
            ++n2;
        }
        ArrayList<IExtensionPoint> allExtensionPoints = new ArrayList<IExtensionPoint>();
        allExtensionPoints.addAll(extensionPoints);
        for (IExtensionPoint currentExtensionPoint : allExtensionPoints) {
            ExtensionPoint extensionPoint = platformFactory.createExtensionPoint();
            if (currentExtensionPoint.getUniqueIdentifier() == null) {
                extensionPoint.setId(Helpers.ANONYMOUS_ELEMENT);
            } else {
                extensionPoint.setId(currentExtensionPoint.getUniqueIdentifier());
            }
            PluginExtensionPoints extensionPointsFolder = currentPlugin.getExtensionPoints();
            extensionPointsFolder.getExtensionPoints().add((Object)extensionPoint);
            introContext.addExtensionPoint(extensionPoint.getId(), extensionPoint);
            ExtensionPointServices.createSchemaElements(introContext, currentExtensionPoint, extensionPoint);
        }
    }

    public static void sortPluginDependencies(EList<PluginDependency> dependencies) {
        PluginDependency[] containedPluginArray = (PluginDependency[])dependencies.toArray();
        PluginDependenciesComparator PluginDependenciesComparator2 = new PluginDependenciesComparator();
        Arrays.sort(containedPluginArray, PluginDependenciesComparator2);
        dependencies.clear();
        PluginDependency[] pluginDependencyArray = containedPluginArray;
        int n = containedPluginArray.length;
        int n2 = 0;
        while (n2 < n) {
            PluginDependency plugin = pluginDependencyArray[n2];
            dependencies.add((Object)plugin);
            ++n2;
        }
    }
}

