/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.pdt.introspector.core.launcher;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.internal.core.target.TargetPlatformService;
import org.eclipse.ui.statushandlers.StatusManager;
import org.polarsys.kitalpha.pdt.introspector.core.IntrospectionContext;
import org.polarsys.kitalpha.pdt.introspector.core.exceptions.IntrospectionExceptions;
import org.polarsys.kitalpha.pdt.introspector.core.messages.Messages;
import org.polarsys.kitalpha.pdt.introspector.core.services.FeatureServices;
import org.polarsys.kitalpha.pdt.introspector.core.services.ModelLoader;
import org.polarsys.kitalpha.pdt.introspector.core.services.PackageServices;
import org.polarsys.kitalpha.pdt.introspector.core.services.PluginServices;
import org.polarsys.kitalpha.pdt.introspector.preferences.utils.IntrospectorPreferenceMessages;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.EclipseModel;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.Feature;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.IntrospectionError;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.IntrospectionErrors;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.PlatformFactory;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.Plugin;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.Repository;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.RepositoryKind;

public class Introspector {
    public static EclipseModel introspect(EclipseModel myEclipseModel, IProgressMonitor monitor, IntrospectionContext introContext, IFolder folder) throws IntrospectionExceptions {
        int progressTarget;
        Repository myRepository;
        if (introContext.isActivateIncrementalIntrospection()) {
            ModelLoader modelLoader = new ModelLoader(introContext);
            ArrayList<URI> modelsToLoad = new ArrayList<URI>();
            modelLoader.findExistingModelsToReuse(modelsToLoad, folder, introContext.getSettedCriteria());
            int progressTarget2 = modelsToLoad.size();
            monitor.beginTask("Inspection of existing models", progressTarget2);
            modelLoader.loadOtherModels(modelLoader, modelsToLoad, monitor, folder);
        }
        String productName = null;
        ITargetPlatformService defaultPlatform = TargetPlatformService.getDefault();
        try {
            ITargetHandle workspaceTargetHandle = defaultPlatform.getWorkspaceTargetHandle();
            productName = workspaceTargetHandle.getTargetDefinition().getName();
        }
        catch (CoreException e1) {
            Status errorStatus = new Status(4, "org.polarsys.kitalpha.pdt.introspector.core", Messages.ErrorGenerationTargetHandler, (Throwable)e1);
            StatusManager.getManager().handle((IStatus)errorStatus);
        }
        if (introContext.getIntrospectionPerimeter().equals(IntrospectorPreferenceMessages.IntrospectorPreferenceMessages_PerimeterIsPlatformOnly)) {
            introContext.setVisitPlatform(true);
            introContext.setVisitWorkspace(false);
            myRepository = PlatformFactory.eINSTANCE.createRepository();
            myRepository.setName(productName);
            myRepository.setRepositoryKind(RepositoryKind.PLATFORM);
            progressTarget = introContext.isCreatePackages() ? 3 * introContext.getPlatformFeatureNumber() + 4 * introContext.getPlatformPluginNumber() : 2 * introContext.getPlatformFeatureNumber() + 3 * introContext.getPlatformPluginNumber();
            introContext.addRepositoryToSave("Platform", myRepository);
        } else if (introContext.getIntrospectionPerimeter().equals(IntrospectorPreferenceMessages.IntrospectorPreferenceMessages_PerimeterIsWorkspaceOnly)) {
            introContext.setVisitPlatform(false);
            introContext.setVisitWorkspace(true);
            myRepository = PlatformFactory.eINSTANCE.createRepository();
            myRepository.setName("workspace");
            myRepository.setRepositoryKind(RepositoryKind.WORKSPACE);
            progressTarget = introContext.isCreatePackages() ? 3 * introContext.getPlatformFeatureNumber() + 4 * introContext.getWorkspacePluginNumber() : 2 * introContext.getPlatformFeatureNumber() + 3 * introContext.getWorkspacePluginNumber();
            introContext.addRepositoryToSave("Workspace", myRepository);
        } else {
            introContext.setVisitPlatform(true);
            introContext.setVisitWorkspace(true);
            Repository platformRepo = PlatformFactory.eINSTANCE.createRepository();
            platformRepo.setName(productName);
            platformRepo.setRepositoryKind(RepositoryKind.PLATFORM);
            Repository workspaceRepo = PlatformFactory.eINSTANCE.createRepository();
            workspaceRepo.setName("Workspace");
            workspaceRepo.setRepositoryKind(RepositoryKind.WORKSPACE);
            progressTarget = introContext.isCreatePackages() ? 3 * introContext.getPlatformFeatureNumber() + 4 * introContext.getPlatformPluginNumber() + 4 * introContext.getWorkspacePluginNumber() + 3 * introContext.getPlatformFeatureNumber() : 2 * introContext.getPlatformFeatureNumber() + 3 * introContext.getPlatformPluginNumber() + 3 * introContext.getWorkspacePluginNumber() + 2 * introContext.getPlatformFeatureNumber();
            introContext.addRepositoryToSave("Platform", platformRepo);
            introContext.addRepositoryToSave("Workspace", workspaceRepo);
        }
        if (monitor != null) {
            monitor.beginTask("Introspection ", progressTarget);
        }
        PluginServices.createPlugins(introContext, monitor, myEclipseModel);
        FeatureServices.createFeatures(introContext, monitor);
        Collection<Repository> repositories = introContext.getRepositoryToSaveHashMap().values();
        for (Repository myRepository2 : repositories) {
            EList plugins = myRepository2.getPlugins();
            EList features = myRepository2.getFeatures();
            if (introContext.isCreatePackages()) {
                PackageServices.createPackages(introContext, monitor, myRepository2);
                continue;
            }
            PackageServices.sortPlugins((EList<Plugin>)plugins);
            PackageServices.sortFeatures((EList<Feature>)features);
        }
        EList eclipseModelRepositories = myEclipseModel.getRepositories();
        EList introspectionErrors = myEclipseModel.getIntrospectionErrors();
        Collection<IntrospectionError> introErrors = introContext.getIntroError();
        IntrospectionErrors errorsFolder = null;
        if (!introErrors.isEmpty()) {
            errorsFolder = PlatformFactory.eINSTANCE.createIntrospectionErrors();
            errorsFolder.setName("Errors");
            for (IntrospectionError introError : introErrors) {
                errorsFolder.getIntrospectionErrors().add((Object)introError);
            }
            introspectionErrors.add((Object)errorsFolder);
        }
        Collection<Repository> values = introContext.getRepositoryToSaveHashMap().values();
        eclipseModelRepositories.addAll(values);
        return myEclipseModel;
    }
}

