/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters.util;

import org.testng.ITestNGMethod;

public final class StackTraceTools {
    private StackTraceTools() {
    }

    public static int getTestRoot(StackTraceElement[] stack, ITestNGMethod method) {
        if (stack == null || method == null) {
            return -1;
        }
        String cname = method.getTestClass().getName();
        for (int x = stack.length - 1; x >= 0; --x) {
            if (!cname.equals(stack[x].getClassName()) || !method.getMethodName().equals(stack[x].getMethodName())) continue;
            return x;
        }
        return stack.length - 1;
    }

    public static StackTraceElement[] getTestNGInfrastructure(StackTraceElement[] stack, ITestNGMethod method) {
        if (method == null || stack == null) {
            return new StackTraceElement[0];
        }
        int slot = StackTraceTools.getTestRoot(stack, method);
        if (slot >= 0) {
            StackTraceElement[] r = new StackTraceElement[stack.length - slot];
            System.arraycopy(stack, slot, r, 0, r.length);
            return r;
        }
        return new StackTraceElement[0];
    }
}

