/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.services.exception;

public class UIMessages {
    private static final String UNKNOWN_TYPE = "Invalid Type :.*";
    private static final String IMAGE_ID_NOT_FOUND = "Image with id '.*' cannot be found.";
    private static final String NO_MODEL_SPECIFIED = "The model No path provided can not be loaded";

    public static String transformToUIMessage(String exceptionMessage) {
        if (exceptionMessage.matches(UNKNOWN_TYPE)) {
            return String.valueOf(exceptionMessage) + ". This may be due to references to multiple metamodels in your model. TIP: You could try to add the following attribute in <context> tag : searchMetamodels='true'.";
        }
        if (exceptionMessage.matches(IMAGE_ID_NOT_FOUND)) {
            return String.valueOf(exceptionMessage) + " TIP: Check script used inside the attribute 'object' of <image> tags. Brackets may be missing.";
        }
        if (exceptionMessage.matches(NO_MODEL_SPECIFIED)) {
            return "No model file provided. Please fill attribute 'model' of <context> tag.";
        }
        return exceptionMessage;
    }
}

