/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.services.exception;

import org.eclipse.gendoc.services.exception.UIMessages;

public abstract class GenDocException
extends Exception {
    private static final long serialVersionUID = -5488973275629846167L;
    private String uiMessage = "";

    protected GenDocException(String message) {
        super(message);
        this.uiMessage = UIMessages.transformToUIMessage(message);
    }

    protected GenDocException(Throwable t) {
        super(t);
        this.uiMessage = UIMessages.transformToUIMessage(t.getMessage());
    }

    protected GenDocException(String message, Throwable t) {
        super(message, t);
        this.uiMessage = UIMessages.transformToUIMessage(message);
    }

    public void setUIMessage(String uiMessage) {
        this.uiMessage = uiMessage;
    }

    public String getUIMessage() {
        return this.uiMessage;
    }
}

