/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.ui.run;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.gendoc.GendocProcess;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.IGendocDiagnostician;
import org.eclipse.gendoc.services.IProgressMonitorService;
import org.eclipse.gendoc.services.exception.GenDocException;
import org.eclipse.gendoc.ui.Activator;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class GenDocRunnable
implements IRunnableWithProgress {
    private final IFile currentFile;
    private IStatusLineManager statusLineManager;

    public GenDocRunnable(IFile selectedFile, IStatusLineManager statusLineManager) {
        this.currentFile = selectedFile;
        this.statusLineManager = statusLineManager;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        IGendocDiagnostician diagnostician = (IGendocDiagnostician)GendocServices.getDefault().getService(IGendocDiagnostician.class);
        diagnostician.init();
        IProgressMonitorService monitorService = (IProgressMonitorService)GendocServices.getDefault().getService(IProgressMonitorService.class);
        monitorService.setMonitor(monitor);
        try {
            try {
                GendocProcess gendocProcess = new GendocProcess();
                String resultFile = gendocProcess.runProcess(this.currentFile.getLocation().toFile());
                this.handleDiagnostic(diagnostician.getResultDiagnostic(), "The file has been generated but contains errors :\n", resultFile);
            }
            catch (GenDocException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.gendoc.ui", e.getUIMessage(), (Throwable)e));
                diagnostician.addDiagnostic((Diagnostic)new BasicDiagnostic(4, "org.eclipse.gendoc.ui", 0, e.getUIMessage(), null));
                this.handleDiagnostic(diagnostician.getResultDiagnostic(), "An error occured during generation.", null);
                GendocServices.getDefault().clear();
            }
            catch (Throwable t) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.gendoc.ui", t.getMessage(), t));
                diagnostician.addDiagnostic((Diagnostic)new BasicDiagnostic(4, "org.eclipse.gendoc.ui", 0, t.getMessage(), (Object[])t.getStackTrace()));
                this.handleDiagnostic(diagnostician.getResultDiagnostic(), "An unexpected error occured during the generation.", null);
                GendocServices.getDefault().clear();
            }
        }
        finally {
            GendocServices.getDefault().clear();
        }
    }

    private void handleDiagnostic(final Diagnostic resultDiagnostic, final String message, final String resultFilePath) {
        if (resultDiagnostic.getSeverity() == 0) {
            if (this.statusLineManager != null) {
                this.statusLineManager.setMessage(String.valueOf(resultFilePath) + " successfully generated");
            }
        } else {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    String path = "";
                    if (resultFilePath != null) {
                        path = resultFilePath;
                    }
                    ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Document generator", (String)(String.valueOf(message) + path), (IStatus)BasicDiagnostic.toIStatus((Diagnostic)resultDiagnostic));
                }
            });
        }
    }
}

