/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.script.services.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopologicalSort {
    public static <N> List<N> sort(Collection<? extends N> list, Edge<N> edgeRetriever) throws CycleException {
        if (edgeRetriever == null || list == null) {
            throw new IllegalArgumentException();
        }
        LinkedList result = new LinkedList();
        HashSet markedNodes = new HashSet();
        HashSet<N> unmarkedNodes = new HashSet<N>(list);
        HashSet temporaryNodes = new HashSet();
        while (!unmarkedNodes.isEmpty()) {
            Iterator i = unmarkedNodes.iterator();
            Object node = i.next();
            i.remove();
            TopologicalSort.visit(result, node, edgeRetriever, unmarkedNodes, markedNodes, temporaryNodes);
        }
        return result;
    }

    private static <N> void visit(List<? super N> result, N node, Edge<N> edgeRetriever, Set<? super N> unmark, Set<? super N> markedNodes, Set<? super N> temporaryNodes) throws CycleException {
        if (temporaryNodes.contains(node)) {
            throw new CycleException(node);
        }
        if (!markedNodes.contains(node)) {
            TopologicalSort.markTmp(node, unmark, unmark, temporaryNodes);
            List<N> outgoings = edgeRetriever.from(node);
            if (outgoings != null) {
                Iterator<N> iterator = outgoings.iterator();
                while (iterator.hasNext()) {
                    N o;
                    N m = o = iterator.next();
                    TopologicalSort.visit(result, m, edgeRetriever, unmark, markedNodes, temporaryNodes);
                }
                TopologicalSort.mark(node, unmark, markedNodes, temporaryNodes);
                TopologicalSort.unmarkTmp(node, unmark, markedNodes, temporaryNodes);
                result.add(0, node);
            }
        }
    }

    private static <N> void unmarkTmp(N node, Set<? super N> unmark, Set<? super N> markedNodes, Set<? super N> temporaryNodes) {
        unmark.add(node);
        markedNodes.add(node);
        temporaryNodes.remove(node);
    }

    private static <N> void markTmp(N node, Set<? super N> unmark, Set<? super N> markedNodes, Set<? super N> temporaryNodes) {
        unmark.remove(node);
        markedNodes.remove(node);
        temporaryNodes.add(node);
    }

    private static <N> void mark(N node, Set<? super N> unmark, Set<? super N> markedNodes, Set<? super N> temporaryNodes) {
        unmark.remove(node);
        temporaryNodes.remove(node);
        markedNodes.add(node);
    }

    private static <N> void unmark(N node, Set<? super N> unmark, Set<? super N> markedNodes, Set<? super N> temporaryNodes) {
        unmark.add(node);
        temporaryNodes.remove(node);
        markedNodes.remove(node);
    }

    private static <N> Set<? super N> getAllNoIncomingEdges(Collection<? extends N> list, Edge<N> edgeRetriever) {
        HashSet<N> result = new HashSet<N>();
        for (N o : list) {
            N n = o;
            List<N> edges = edgeRetriever.from(n);
            if (edges != null && !edges.isEmpty()) continue;
            result.add(n);
        }
        return result;
    }

    public static class CycleException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private Object node;

        public CycleException(Object node) {
            this.node = node;
        }

        public Object getNode() {
            return this.node;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Edge<N> {
        public List<? super N> from(N var1);
    }
}

