/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.generator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.analyzer.AnalysisVisitor;
import org.eclipse.ocl.examples.codegen.analyzer.NameManager;
import org.eclipse.ocl.examples.codegen.generator.CodeGenOptions;
import org.eclipse.ocl.examples.codegen.generator.CodeGenerator;
import org.eclipse.ocl.examples.codegen.generator.GenModelHelper;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.internal.manager.FinalAnalysis;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;

public abstract class AbstractCodeGenerator
implements CodeGenerator {
    public static final @NonNull String ORG_ECLIPSE_JDT_ANNOTATION_NON_NULL = "org.eclipse.jdt.annotation.NonNull";
    public static final @NonNull String ORG_ECLIPSE_JDT_ANNOTATION_NULLABLE = "org.eclipse.jdt.annotation.Nullable";
    protected final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension environmentFactory;
    protected final @NonNull PivotMetamodelManager metamodelManager;
    protected final @NonNull NameManager nameManager;
    protected final @NonNull GenModelHelper genModelHelper;
    private Set<@NonNull Operation> constrainedOperations = null;
    private CodeGenOptions options = null;
    private List<@NonNull Exception> problems = null;
    private @NonNull String defaultIndent = "    ";

    protected AbstractCodeGenerator(@NonNull EnvironmentFactoryInternal environmentFactory) {
        this.environmentFactory = (EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)environmentFactory;
        this.metamodelManager = environmentFactory.getMetamodelManager();
        this.nameManager = this.createNameManager();
        this.genModelHelper = this.createGenModelHelper();
    }

    protected AbstractCodeGenerator(@NonNull EnvironmentFactoryInternal environmentFactory, @NonNull NameManager nameManager, @NonNull GenModelHelper genModelHelper) {
        this.environmentFactory = (EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)environmentFactory;
        this.metamodelManager = environmentFactory.getMetamodelManager();
        this.nameManager = nameManager;
        this.genModelHelper = genModelHelper;
    }

    @Override
    public boolean addConstrainedOperation(@NonNull Operation constrainedOperation) {
        if (this.constrainedOperations == null) {
            this.constrainedOperations = new HashSet<Operation>();
        }
        return this.constrainedOperations.add(constrainedOperation);
    }

    @Override
    public void addProblem(@NonNull Exception problem) {
        List<@NonNull Exception> problems2 = this.problems;
        if (problems2 == null) {
            this.problems = problems2 = new ArrayList<Exception>();
        }
        problems2.add(problem);
    }

    @Override
    public @NonNull AnalysisVisitor createAnalysisVisitor() {
        return new AnalysisVisitor(this.getAnalyzer());
    }

    protected abstract @NonNull GenModelHelper createGenModelHelper();

    protected abstract @NonNull NameManager createNameManager();

    protected @NonNull CodeGenOptions createOptions() {
        return new CodeGenOptions();
    }

    protected @Nullable Iterable<@NonNull Operation> getConstrainedOperations() {
        return this.constrainedOperations;
    }

    @Override
    public @NonNull String getDefaultIndent() {
        return this.defaultIndent;
    }

    @Override
    public @NonNull EnvironmentFactoryInternal getEnvironmentFactory() {
        return this.environmentFactory;
    }

    @Override
    public @NonNull GenModelHelper getGenModelHelper() {
        return this.genModelHelper;
    }

    @Override
    public @NonNull NameManager getNameManager() {
        return this.nameManager;
    }

    @Override
    public @NonNull CodeGenOptions getOptions() {
        CodeGenOptions options2 = this.options;
        if (options2 == null) {
            this.options = options2 = this.createOptions();
        }
        return options2;
    }

    @Override
    public @Nullable List<@NonNull Exception> getProblems() {
        return this.problems;
    }

    @Override
    public @Nullable Operation isFinal(@NonNull Operation anOperation, @NonNull Class staticType) {
        PivotMetamodelManager metamodelManager = this.environmentFactory.getMetamodelManager();
        FinalAnalysis finalAnalysis = metamodelManager.getFinalAnalysis();
        return finalAnalysis.isFinal(anOperation, (CompleteClass)metamodelManager.getCompleteClass((Type)staticType));
    }
}

