/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.codegen.dynamic;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenClassifier;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.common.CodeGenHelper;
import org.eclipse.ocl.examples.codegen.dynamic.OCL2JavaFileObject;
import org.eclipse.ocl.examples.codegen.oclinjunit.JUnitCodeGenerator;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.library.LibraryOperation;
import org.eclipse.ocl.pivot.oclstdlib.OCLstdlibTables;

public class JavaGenModelCodeGenHelper
implements CodeGenHelper {
    protected final @NonNull EnvironmentFactoryInternal environmentFactory;
    private @NonNull Map<EPackage, GenPackage> ePackageMap = new HashMap<EPackage, GenPackage>();
    private @NonNull Map<String, GenPackage> uriMap = new HashMap<String, GenPackage>();
    private @NonNull Map<EClassifier, GenClassifier> eClassifierMap = new HashMap<EClassifier, GenClassifier>();

    public JavaGenModelCodeGenHelper(@NonNull GenModel genModel, @NonNull EnvironmentFactoryInternal environmentFactory) throws IOException {
        this.environmentFactory = environmentFactory;
        for (GenPackage genPackage : genModel.getGenPackages()) {
            assert (genPackage != null);
            this.install(genPackage);
        }
        for (GenPackage genPackage : genModel.getUsedGenPackages()) {
            assert (genPackage != null);
            this.install(genPackage);
        }
    }

    protected void install(@NonNull GenPackage genPackage) {
        EPackage ePackage = genPackage.getEcorePackage();
        if (ePackage != null && !this.ePackageMap.containsKey(ePackage)) {
            this.ePackageMap.put(ePackage, genPackage);
            String nsURI = ePackage.getNsURI();
            if (nsURI != null) {
                this.uriMap.put(nsURI, genPackage);
            }
            for (GenClassifier genClassifier : genPackage.getGenClassifiers()) {
                assert (genClassifier != null);
                EClassifier eClassifier = genClassifier.getEcoreClassifier();
                this.eClassifierMap.put(eClassifier, genClassifier);
            }
        }
        for (GenPackage nestedGenPackage : genPackage.getNestedGenPackages()) {
            assert (nestedGenPackage != null);
            this.install(nestedGenPackage);
        }
    }

    @Override
    public @NonNull String getCopyright(@NonNull String indentation) {
        return "";
    }

    public @Nullable GenClass getGenClass(@NonNull GenPackage genPackage, @NonNull Type type) {
        String name = type.getName();
        for (GenClass genClass : genPackage.getGenClasses()) {
            String clsName = genClass.getEcoreClass().getName();
            if (!name.equals(clsName)) continue;
            return genClass;
        }
        return null;
    }

    @Override
    public @NonNull GenPackage getGenPackage(@NonNull Class type) {
        Package pPackage = type.getOwningPackage();
        String nsURI = pPackage.getURI();
        GenPackage genPackage = this.uriMap.get(nsURI);
        if (nsURI != null) {
            if (genPackage != null) {
                return genPackage;
            }
            if ("http://www.eclipse.org/ocl/2015/Library".equals(nsURI) && (genPackage = this.uriMap.get("http://www.eclipse.org/ocl/2015/Pivot")) != null) {
                return genPackage;
            }
            genPackage = this.environmentFactory.getMetamodelManager().getGenPackage(nsURI);
            if (genPackage != null) {
                this.install(genPackage);
                return genPackage;
            }
        }
        throw new IllegalArgumentException("Unknown package '" + nsURI + "'");
    }

    @Override
    public @Nullable LibraryOperation loadClass(@NonNull ExpressionInOCL query, @NonNull File targetFolder, @NonNull String packageName, @NonNull String className, boolean saveSource) throws Exception {
        String qualifiedClassName = String.valueOf(packageName) + "." + className;
        String javaCodeSource = JUnitCodeGenerator.generateClassFile(this.environmentFactory, query, packageName, className);
        if (saveSource) {
            String fileName = targetFolder + "/" + qualifiedClassName.replace('.', '/') + ".java";
            FileWriter writer = new FileWriter(fileName);
            ((Writer)writer).append(javaCodeSource);
            ((Writer)writer).close();
        }
        OCLstdlibTables.LIBRARY.getClass();
        File explicitClassPath = new File(targetFolder.getParentFile(), "test-bin");
        String problems = OCL2JavaFileObject.saveClass(String.valueOf(explicitClassPath), qualifiedClassName, javaCodeSource, new String[0]);
        if (problems != null) {
            throw new IOException("Failed to compile " + qualifiedClassName + "\n" + problems);
        }
        java.lang.Class<?> testClass = OCL2JavaFileObject.loadExplicitClass(explicitClassPath, qualifiedClassName);
        return (LibraryOperation)testClass.newInstance();
    }
}

