/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.debugger.ui;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugException;
import org.eclipse.gemoc.commons.eclipse.ui.OpenEditor;
import org.eclipse.gemoc.dsl.debug.ide.adapter.DSLThreadAdapter;
import org.eclipse.gemoc.executionframework.debugger.ui.Activator;
import org.eclipse.gemoc.executionframework.engine.core.AbstractExecutionEngine;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionEngine;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.osgi.framework.Bundle;

public class OpenSemanticsHandler
extends AbstractHandler {
    private IExecutionEngine<?> engine;
    private String bundleSymbolicName;

    public OpenSemanticsHandler() {
        Activator.getDefault().setHandler(this);
    }

    private void searchForFile(File dir, List<File> accumulator, String name) {
        File[] files;
        File[] fileArray = files = dir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isFile() && f.getName().equals(name)) {
                accumulator.add(f);
            } else if (f.isDirectory()) {
                this.searchForFile(f, accumulator, name);
            }
            ++n2;
        }
    }

    public void locateAndOpenSource(TreeSelection selection) {
        TreePath path = selection.getPaths()[0].getParentPath();
        Object obj = path.getLastSegment();
        int idx = 0;
        if (obj instanceof DSLThreadAdapter) {
            try {
                idx = Arrays.asList(((DSLThreadAdapter)obj).getStackFrames()).indexOf(selection.getFirstElement());
            }
            catch (DebugException e) {
                Activator.error(e.getMessage(), e);
            }
        }
        Thread thread = ((AbstractExecutionEngine)this.engine).thread;
        StackTraceElement[] stackTrace = thread.getStackTrace();
        String className = this.engine.getClass().getName();
        String methodName = "executeStep";
        LinkedList<StackTraceElement> elements = new LinkedList<StackTraceElement>();
        int i = 0;
        while (i < stackTrace.length) {
            StackTraceElement element = stackTrace[i];
            if (element.getMethodName().equals(methodName) && element.getClassName().equals(className)) {
                if (idx == 0) {
                    elements.add(stackTrace[i + 1]);
                    break;
                }
                --idx;
            }
            ++i;
        }
        if (!elements.isEmpty()) {
            Bundle bundle = Platform.getBundle((String)this.bundleSymbolicName);
            File bundleFile = null;
            try {
                bundleFile = FileLocator.getBundleFile((Bundle)bundle);
                ArrayList<File> files = new ArrayList<File>();
                for (StackTraceElement e : elements) {
                    this.searchForFile(bundleFile, files, e.getFileName());
                }
                for (File f : files) {
                    OpenEditor.openFile((File)f);
                }
            }
            catch (IOException e) {
                Activator.error(e.getMessage(), e);
            }
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Supplier engineSupplier = org.eclipse.gemoc.executionframework.debugger.Activator.getDefault().getEngineSupplier();
        Supplier bundleSupplier = org.eclipse.gemoc.executionframework.debugger.Activator.getDefault().getBundleSymbolicNameSupplier();
        if (engineSupplier != null) {
            this.engine = (IExecutionEngine)engineSupplier.get();
        }
        if (bundleSupplier != null) {
            this.bundleSymbolicName = (String)bundleSupplier.get();
        }
        TreeSelection selection = (TreeSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        this.locateAndOpenSource(selection);
        return null;
    }

    public void setBundleSymbolicName(String bundleSymbolicName) {
        this.bundleSymbolicName = bundleSymbolicName;
    }

    public void setEngine(IExecutionEngine<?> engine) {
        this.engine = engine;
    }
}

