/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.CompareViewerSwitchingPane;
import org.eclipse.compare.ICompareInputLabelProvider;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.ResourceNode;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.ICompareInputChangeListener;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.CommonUIPlugin;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.command.ICompareCopyCommand;
import org.eclipse.emf.compare.domain.ICompareEditingDomain;
import org.eclipse.emf.compare.domain.impl.EMFCompareEditingDomain;
import org.eclipse.emf.compare.ide.internal.utils.DisposableResourceSet;
import org.eclipse.emf.compare.ide.internal.utils.NotLoadingResourceSet;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.configuration.EMFCompareConfiguration;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.MirrorUtil;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.label.NoDifferencesCompareInput;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.label.NoSelectedItemCompareInput;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.label.NoVisibleItemCompareInput;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.label.OnlyPseudoConflictsCompareInput;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.EMFCompareColor;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.RedoAction;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.UndoAction;
import org.eclipse.emf.compare.ide.ui.internal.editor.ComparisonScopeInput;
import org.eclipse.emf.compare.ide.ui.internal.logical.ComparisonScopeBuilder;
import org.eclipse.emf.compare.ide.ui.internal.logical.EmptyComparisonScope;
import org.eclipse.emf.compare.ide.ui.internal.logical.StreamAccessorStorage;
import org.eclipse.emf.compare.ide.ui.internal.progress.JobProgressInfoComposite;
import org.eclipse.emf.compare.ide.ui.internal.progress.JobProgressMonitorWrapper;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.AbstractStructuredViewerWrapper;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.CompareInputAdapter;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.CompareToolBar;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.DependencyData;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.EMFCompareDiffTreeRuler;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.EMFCompareStructureMergeViewerContentProvider;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.EMFCompareStructureMergeViewerLabelProvider;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.ForwardingCompareInputAdapter;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.Navigatable;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.ProblemIndicationComposite;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.WrappableTreeViewer;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.MergeAction;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.MergeContainedNonConflictingAction;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.provider.TreeCompareInputAdapterFactory;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.provider.TreeNodeCompareInput;
import org.eclipse.emf.compare.ide.ui.internal.util.CompareHandlerService;
import org.eclipse.emf.compare.ide.ui.internal.util.JFaceUtil;
import org.eclipse.emf.compare.ide.ui.internal.util.PlatformElementUtil;
import org.eclipse.emf.compare.internal.merge.MergeDataImpl;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.merge.CachingDiffRelationshipComputer;
import org.eclipse.emf.compare.merge.IDiffRelationshipComputer;
import org.eclipse.emf.compare.merge.IMergeOptionAware;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.rcp.internal.extension.impl.EMFCompareBuilderConfigurator;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.ICompareEditingDomainChange;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.IMergePreviewModeChange;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.SideLabelProvider;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.IColorChangeEvent;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.StructureMergeViewerFilter;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.impl.CascadingDifferencesFilter;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.StructureMergeViewerGrouper;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.provider.TreeItemProviderAdapterFactorySpec;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.match.MatchOfContainmentReferenceChangeProcessor;
import org.eclipse.emf.compare.rcp.ui.internal.util.SWTUtil;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.ICompareColor;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.filters.IDifferenceFilterChange;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroup;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroupProvider;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroupProviderChange;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.compare.utils.IDiagnosable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.tree.TreeFactory;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.team.internal.ui.mapping.ResourceDiffCompareInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.progress.PendingUpdateAdapter;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;

public class EMFCompareStructureMergeViewer
extends AbstractStructuredViewerWrapper<CTabFolder, WrappableTreeViewer>
implements CommandStackListener {
    private static final int TREE_RULER_WIDTH = 17;
    private static final Function<TreeNode, Diff> TREE_NODE_AS_DIFF = new Function<TreeNode, Diff>(){

        public Diff apply(TreeNode input) {
            if (input.getData() instanceof Diff) {
                return (Diff)input.getData();
            }
            return null;
        }
    };
    protected final IPreferenceStore preferenceStore = EMFCompareIDEUIPlugin.getDefault().getPreferenceStore();
    private ComposedAdapterFactory fAdapterFactory;
    private CachingDiffRelationshipComputer fDiffRelationshipComputer;
    private EMFCompareDiffTreeRuler treeRuler;
    private final ICompareInputChangeListener fCompareInputChangeListener;
    private ITreeViewerListener fWrappedTreeListener;
    private UndoAction undoAction;
    private RedoAction redoAction;
    private CompareHandlerService fHandlerService;
    private boolean resourceSetShouldBeDisposed;
    private DependencyData dependencyData;
    private ISelectionChangedListener selectionChangeListener;
    protected ISelection currentSelection;
    protected IPropertyChangeListener preferenceChangeListener;
    private final Listener fEraseItemListener;
    private JobProgressInfoComposite progressInfoItem;
    private Job inputChangedTask;
    private final Job titleBuilderJob = new TitleBuilderJob();
    private CompareToolBar toolBar;
    private Navigatable navigatable;
    private EMFCompareColor fColors;
    private boolean editingDomainNeedsToBeDisposed;
    private EMFCompareStructureMergeViewerContentProvider.FetchListener toolbarUpdaterContentProviderListener;
    private boolean cascadingDifferencesFilterEnabled;
    private IPropertyChangeListener fPreferenceChangeListener;
    private IPreferenceStore fPreferenceStore;

    public EMFCompareStructureMergeViewer(Composite parent, EMFCompareConfiguration config) {
        super(parent, config);
        this.updateLayout(true, false);
        StructureMergeViewerFilter structureMergeViewerFilter = this.getCompareConfiguration().getStructureMergeViewerFilter();
        ((WrappableTreeViewer)this.getViewer()).addFilter((ViewerFilter)structureMergeViewerFilter);
        StructureMergeViewerGrouper structureMergeViewerGrouper = this.getCompareConfiguration().getStructureMergeViewerGrouper();
        structureMergeViewerGrouper.install((StructuredViewer)this.getViewer());
        this.fCompareInputChangeListener = new ICompareInputChangeListener(){

            public void compareInputChanged(ICompareInput input) {
                EMFCompareStructureMergeViewer.this.compareInputChanged(input);
            }
        };
        this.setContentProvider((IContentProvider)new EMFCompareStructureMergeViewerContentProvider(this.getCompareConfiguration().getAdapterFactory(), (AbstractTreeViewer)this.getViewer()));
        this.navigatable = new Navigatable((WrappableTreeViewer)this.getViewer(), this.getContentProvider());
        this.toolBar = new CompareToolBar(CompareViewerPane.getToolBarManager((Composite)parent), structureMergeViewerGrouper, structureMergeViewerFilter, this.getCompareConfiguration());
        ((WrappableTreeViewer)this.getViewer()).addSelectionChangedListener(this.toolBar);
        this.createContextMenu();
        this.selectionChangeListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EMFCompareStructureMergeViewer.this.handleSelectionChangedEvent(event);
            }
        };
        this.addSelectionChangedListener(this.selectionChangeListener);
        this.preferenceChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                EMFCompareStructureMergeViewer.this.handlePreferenceChangedEvent(event);
            }
        };
        this.preferenceStore.addPropertyChangeListener(this.preferenceChangeListener);
        this.fWrappedTreeListener = new ITreeViewerListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                EMFCompareStructureMergeViewer.this.treeRuler.redraw();
            }

            public void treeCollapsed(TreeExpansionEvent event) {
                EMFCompareStructureMergeViewer.this.treeRuler.redraw();
            }
        };
        ((WrappableTreeViewer)this.getViewer()).addTreeListener(this.fWrappedTreeListener);
        this.fEraseItemListener = new Listener(){

            public void handleEvent(Event event) {
                EMFCompareStructureMergeViewer.this.handleEraseItemEvent(event);
            }
        };
        ((WrappableTreeViewer)this.getViewer()).getControl().addListener(40, this.fEraseItemListener);
        this.fHandlerService = CompareHandlerService.createFor(this.getCompareConfiguration().getContainer(), ((CTabFolder)this.getControl()).getShell());
        this.toolbarUpdaterContentProviderListener = new EMFCompareStructureMergeViewerContentProvider.FetchListener(){

            @Override
            public void startFetching() {
                EMFCompareStructureMergeViewer.this.toolBar.setEnabled(false);
            }

            @Override
            public void doneFetching() {
                EMFCompareStructureMergeViewer.this.toolBar.setEnabled(true);
            }
        };
        this.getContentProvider().addFetchingListener(this.toolbarUpdaterContentProviderListener);
        this.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new EMFCompareStructureMergeViewerLabelProvider(this.getCompareConfiguration().getAdapterFactory(), (Viewer)this)));
        this.undoAction = new UndoAction(this.getCompareConfiguration().getEditingDomain());
        this.redoAction = new RedoAction(this.getCompareConfiguration().getEditingDomain());
        this.editingDomainChange(null, this.getCompareConfiguration().getEditingDomain());
        this.inputChangedTask.setPriority(30);
        config.getEventBus().register((Object)this);
        boolean enabled = Iterables.any((Iterable)config.getStructureMergeViewerFilter().getSelectedDifferenceFilters(), (Predicate)Predicates.instanceOf(CascadingDifferencesFilter.class));
        this.setCascadingDifferencesFilterEnabled(enabled);
        this.fPreferenceChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                EMFCompareStructureMergeViewer.this.handlePreferenceChangeEvent(event);
            }
        };
        this.fPreferenceStore = this.getCompareConfiguration().getPreferenceStore();
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.addPropertyChangeListener(this.fPreferenceChangeListener);
        }
    }

    protected void handlePreferenceChangeEvent(PropertyChangeEvent event) {
        if (MirrorUtil.isMirroredPreference(event.getProperty())) {
            MirrorUtil.setMirrored(this.getCompareConfiguration(), Boolean.parseBoolean(event.getNewValue().toString()));
            ISelection originalSelection = this.getSelection();
            this.setSelection(null);
            ((WrappableTreeViewer)this.getViewer()).handleOpen(null);
            this.setSelection(originalSelection);
            ((WrappableTreeViewer)this.getViewer()).handleOpen(null);
        }
    }

    private void initToolbar(IProgressMonitor monitor) {
        if (!monitor.isCanceled()) {
            SWTUtil.safeSyncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    EMFCompareStructureMergeViewer.this.toolBar.initToolbar((AbstractTreeViewer)EMFCompareStructureMergeViewer.this.getViewer(), EMFCompareStructureMergeViewer.this.navigatable);
                    EMFCompareStructureMergeViewer.this.toolBar.setEnabled(false);
                }
            });
        }
    }

    private void enableToolbar(IProgressMonitor monitor) {
        if (!monitor.isCanceled()) {
            SWTUtil.safeSyncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    EMFCompareStructureMergeViewer.this.toolBar.setEnabled(true);
                }
            });
        }
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                EMFCompareStructureMergeViewer.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(((WrappableTreeViewer)this.getViewer()).getControl());
        ((WrappableTreeViewer)this.getViewer()).getControl().setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        if (!this.isOneMergeableItemSelected()) {
            return;
        }
        boolean leftEditable = this.getCompareConfiguration().isLeftEditable();
        boolean rightEditable = this.getCompareConfiguration().isRightEditable();
        EnumSet<MergeMode> modes = rightEditable && leftEditable ? EnumSet.of(MergeMode.RIGHT_TO_LEFT, MergeMode.LEFT_TO_RIGHT) : EnumSet.of(MergeMode.ACCEPT, MergeMode.REJECT);
        if (rightEditable || leftEditable) {
            for (MergeMode mode : modes) {
                IMerger.Registry mergerRegistry = EMFCompareRCPPlugin.getDefault().getMergerRegistry();
                if (this.isOneDiffSelected()) {
                    MergeAction mergeAction = new MergeAction(this.getCompareConfiguration(), mergerRegistry, mode, this.navigatable, (IStructuredSelection)this.getSelection());
                    manager.add((IAction)mergeAction);
                    continue;
                }
                if (!this.isOneMatchOrResourceMatchSelected()) continue;
                Predicate<TreeNode> filterPredicate = new Predicate<TreeNode>(){

                    public boolean apply(TreeNode input) {
                        return input != null && JFaceUtil.isFiltered((StructuredViewer)EMFCompareStructureMergeViewer.this.getViewer(), input, input.getParent());
                    }
                };
                MergeContainedNonConflictingAction mergeAction = new MergeContainedNonConflictingAction(this.getCompareConfiguration(), mergerRegistry, mode, this.navigatable, (IStructuredSelection)this.getSelection(), filterPredicate);
                manager.add((IAction)mergeAction);
            }
        }
    }

    private boolean isOneMergeableItemSelected() {
        return this.isOneDiffSelected() || this.isOneMatchOrResourceMatchSelected();
    }

    private boolean isOneDiffSelected() {
        Object element;
        ISelection selection = this.getSelection();
        return selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 && EMFCompareStructureMergeViewer.getDataOfTreeNodeOfAdapter(element = ((IStructuredSelection)selection).getFirstElement()) instanceof Diff;
    }

    private boolean isOneMatchOrResourceMatchSelected() {
        Object element;
        ISelection selection = this.getSelection();
        return selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 && this.isMatchOrMatchResource(EMFCompareStructureMergeViewer.getDataOfTreeNodeOfAdapter(element = ((IStructuredSelection)selection).getFirstElement()));
    }

    private boolean isMatchOrMatchResource(EObject eObject) {
        return eObject instanceof Match || eObject instanceof MatchResource;
    }

    @Override
    protected void preHookCreateControlAndViewer() {
        this.fAdapterFactory = this.initAdapterFactory(this.getCompareConfiguration().getComparison());
        this.getCompareConfiguration().setAdapterFactory((AdapterFactory)this.fAdapterFactory);
        this.fDiffRelationshipComputer = new CachingDiffRelationshipComputer(EMFCompareRCPPlugin.getDefault().getMergerRegistry());
        this.getCompareConfiguration().setDiffRelationshipComputer((IDiffRelationshipComputer)this.fDiffRelationshipComputer);
        this.inputChangedTask = new CompareInputChangedJob(EMFCompareIDEUIMessages.getString("EMFCompareStructureMergeViewer.computingModelDifferences"));
    }

    protected ComposedAdapterFactory initAdapterFactory(Comparison comparison) {
        LinkedHashMap context = Maps.newLinkedHashMap();
        context.put("comparison", comparison);
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory((ComposedAdapterFactory.Descriptor.Registry)EMFCompareRCPPlugin.getDefault().createFilteredAdapterFactoryRegistry((Map)context));
        adapterFactory.addAdapterFactory((AdapterFactory)new TreeItemProviderAdapterFactorySpec(this.getCompareConfiguration().getStructureMergeViewerFilter()));
        adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        return adapterFactory;
    }

    @Subscribe
    public void colorChanged(IColorChangeEvent changeColorEvent) {
        this.internalRedraw();
    }

    @Override
    protected AbstractStructuredViewerWrapper.ControlAndViewer<CTabFolder, WrappableTreeViewer> createControlAndViewer(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        CTabFolder tabFolder = new CTabFolder(parent, 0x800400);
        tabFolder.setLayout((Layout)new FillLayout());
        tabFolder.addControlListener((ControlListener)new ControlAdapter(){
            boolean guard = false;

            public void controlResized(ControlEvent event) {
                if (!this.guard) {
                    this.guard = true;
                    EMFCompareStructureMergeViewer.this.hideTabs();
                    this.guard = false;
                }
            }
        });
        this.updateProblemIndication(Diagnostic.OK_INSTANCE);
        Composite control = new Composite((Composite)tabFolder, 0);
        this.createItem(0, (Control)control);
        tabFolder.setSelection(0);
        GridData data = new GridData(4, 4, true, true);
        control.setLayoutData((Object)data);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        control.setLayout((Layout)layout);
        this.progressInfoItem = new JobProgressInfoComposite(this.inputChangedTask, control, 65792, 0);
        this.progressInfoItem.setLayoutData(new GridData(4, 4, true, true, 2, 1));
        this.progressInfoItem.setBackground(Display.getDefault().getSystemColor(25));
        WrappableTreeViewer treeViewer = new WrappableTreeViewer(control, 770){

            public boolean isExpandable(Object element) {
                if (element instanceof PendingUpdateAdapter) {
                    return false;
                }
                if (this.hasFilters()) {
                    return this.getFilteredChildren(element).length > 0;
                }
                return super.isExpandable(element);
            }
        };
        treeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        treeViewer.setUseHashlookup(true);
        treeViewer.getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                EMFCompareStructureMergeViewer.this.fHandlerService.updatePaneActionHandlers(new Runnable(){

                    @Override
                    public void run() {
                        EMFCompareStructureMergeViewer.this.fHandlerService.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)EMFCompareStructureMergeViewer.this.undoAction);
                        EMFCompareStructureMergeViewer.this.fHandlerService.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)EMFCompareStructureMergeViewer.this.redoAction);
                    }
                });
            }
        });
        this.dependencyData = new DependencyData(this.getCompareConfiguration());
        tabFolder.setData("org.eclipse.compare.CompareUI.CompareViewerTitle", (Object)EMFCompareIDEUIMessages.getString("EMFCompareStructureMergeViewer.title"));
        ITheme currentTheme = this.getCurrentTheme();
        boolean leftIsLocal = this.getCompareConfiguration().getBooleanProperty("LEFT_IS_LOCAL", false);
        this.fColors = new EMFCompareColor(control.getDisplay(), leftIsLocal, currentTheme, this.getCompareConfiguration().getEventBus());
        this.treeRuler = new EMFCompareDiffTreeRuler(control, 0, treeViewer, this.dependencyData, (ICompareColor)this.fColors);
        GridData rulerLayoutData = new GridData(4, 4, false, true);
        rulerLayoutData.exclude = true;
        rulerLayoutData.widthHint = 17;
        rulerLayoutData.minimumWidth = 17;
        this.treeRuler.setLayoutData(rulerLayoutData);
        return AbstractStructuredViewerWrapper.ControlAndViewer.create(tabFolder, treeViewer);
    }

    private ITheme getCurrentTheme() {
        IThemeManager themeManager;
        if (PlatformUI.isWorkbenchRunning() && (themeManager = PlatformUI.getWorkbench().getThemeManager()) != null) {
            return themeManager.getCurrentTheme();
        }
        return null;
    }

    public EMFCompareStructureMergeViewerContentProvider getContentProvider() {
        return (EMFCompareStructureMergeViewerContentProvider)super.getContentProvider();
    }

    public DelegatingStyledCellLabelProvider getLabelProvider() {
        return (DelegatingStyledCellLabelProvider)super.getLabelProvider();
    }

    private CTabItem createItem(int index, Control control) {
        CTabItem item = new CTabItem((CTabFolder)control.getParent(), 0, index);
        item.setControl(control);
        return item;
    }

    @Subscribe
    public void handleEditingDomainChange(ICompareEditingDomainChange event) {
        this.editingDomainChange(event.getOldValue(), event.getNewValue());
    }

    private void editingDomainChange(ICompareEditingDomain oldValue, ICompareEditingDomain newValue) {
        if (newValue != oldValue) {
            if (oldValue != null) {
                oldValue.getCommandStack().removeCommandStackListener((CommandStackListener)this);
            }
            if (newValue != null) {
                newValue.getCommandStack().addCommandStackListener((CommandStackListener)this);
            }
            this.undoAction.setEditingDomain(newValue);
            this.redoAction.setEditingDomain(newValue);
        }
    }

    private void refreshTitle() {
        if (((CTabFolder)this.getControl()).isDisposed() || !(((CTabFolder)this.getControl()).getParent() instanceof CompareViewerSwitchingPane)) {
            return;
        }
        if (this.getCompareConfiguration().getComparison() == null) {
            return;
        }
        this.titleBuilderJob.schedule(10L);
    }

    static EObject getDataOfTreeNodeOfAdapter(Object object) {
        Notifier target;
        EObject data = null;
        if (object instanceof Adapter && (target = ((Adapter)object).getTarget()) instanceof TreeNode) {
            data = ((TreeNode)target).getData();
        }
        return data;
    }

    @Subscribe
    public void mergePreviewModeChange(IMergePreviewModeChange event) {
        SWTUtil.safeAsyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                EMFCompareStructureMergeViewer.this.updateHighlightRelatedChanges(EMFCompareStructureMergeViewer.this.getSelection());
            }
        });
    }

    @Subscribe
    public void handleDifferenceFilterChange(IDifferenceFilterChange event) {
        boolean enabled = Iterables.any((Iterable)event.getSelectedDifferenceFilters(), (Predicate)Predicates.instanceOf(CascadingDifferencesFilter.class));
        this.setCascadingDifferencesFilterEnabled(enabled);
        SWTUtil.safeRefresh((Viewer)this, (boolean)false, (boolean)true);
        this.getContentProvider().runWhenReady(EMFCompareStructureMergeViewerContentProvider.CallbackType.IN_UI_ASYNC, new Runnable(){

            @Override
            public void run() {
                if (EMFCompareStructureMergeViewer.this.navigatable != null && (EMFCompareStructureMergeViewer.this.navigatable.getViewer().getSelection() == null || EMFCompareStructureMergeViewer.this.navigatable.getViewer().getSelection().isEmpty())) {
                    EMFCompareStructureMergeViewer.this.selectFirstDiffOrDisplayLabelViewer(EMFCompareStructureMergeViewer.this.getCompareConfiguration().getComparison());
                }
            }
        });
    }

    private void setCascadingDifferencesFilterEnabled(boolean enable) {
        this.cascadingDifferencesFilterEnabled = enable;
        IMerger.Registry mergerRegistry = EMFCompareRCPPlugin.getDefault().getMergerRegistry();
        for (IMergeOptionAware merger : Iterables.filter((Iterable)mergerRegistry.getMergers(null), IMergeOptionAware.class)) {
            Map mergeOptions = merger.getMergeOptions();
            mergeOptions.put("subDiffAwareOption", enable);
        }
    }

    private boolean getCascadingDifferencesFilterEnabled() {
        return this.cascadingDifferencesFilterEnabled;
    }

    @Subscribe
    public void handleDifferenceGroupProviderChange(IDifferenceGroupProviderChange event) {
        SWTUtil.safeRefresh((Viewer)this, (boolean)false, (boolean)true);
        this.getContentProvider().runWhenReady(EMFCompareStructureMergeViewerContentProvider.CallbackType.IN_UI_ASYNC, new Runnable(){

            @Override
            public void run() {
                EMFCompareStructureMergeViewer.this.selectFirstDiffOrDisplayLabelViewer(EMFCompareStructureMergeViewer.this.getCompareConfiguration().getComparison());
            }
        });
    }

    protected void inputChanged(Object input, Object oldInput) {
        if (oldInput instanceof ICompareInput) {
            ICompareInput old = (ICompareInput)oldInput;
            old.removeCompareInputChangeListener(this.fCompareInputChangeListener);
            this.toolBar.dispose();
        }
        if (input instanceof ICompareInput) {
            ICompareInput ci = (ICompareInput)input;
            ci.addCompareInputChangeListener(this.fCompareInputChangeListener);
            this.compareInputChanged(ci);
        }
    }

    @Override
    protected void handleDispose(DisposeEvent event) {
        if (this.fHandlerService != null) {
            this.fHandlerService.dispose();
        }
        this.getCompareConfiguration().getEventBus().unregister((Object)this);
        ((WrappableTreeViewer)this.getViewer()).removeTreeListener(this.fWrappedTreeListener);
        Object input = this.getInput();
        if (input instanceof ICompareInput) {
            ICompareInput ci = (ICompareInput)input;
            ci.removeCompareInputChangeListener(this.fCompareInputChangeListener);
        }
        this.removeSelectionChangedListener(this.selectionChangeListener);
        ((WrappableTreeViewer)this.getViewer()).removeSelectionChangedListener(this.toolBar);
        ((WrappableTreeViewer)this.getViewer()).getTree().removeListener(40, this.fEraseItemListener);
        if (this.preferenceChangeListener != null) {
            this.preferenceStore.removePropertyChangeListener(this.preferenceChangeListener);
        }
        if (this.editingDomainNeedsToBeDisposed) {
            ((IDisposable)this.getCompareConfiguration().getEditingDomain()).dispose();
        }
        this.getCompareConfiguration().getStructureMergeViewerGrouper().uninstall((StructuredViewer)this.getViewer());
        this.compareInputChanged(null);
        this.treeRuler.handleDispose();
        this.fAdapterFactory.dispose();
        this.fDiffRelationshipComputer.invalidate();
        this.toolBar.dispose();
        this.fColors.dispose();
        if (this.fPreferenceChangeListener != null) {
            if (this.fPreferenceStore != null) {
                this.fPreferenceStore.removePropertyChangeListener(this.fPreferenceChangeListener);
            }
            this.fPreferenceChangeListener = null;
        }
        super.handleDispose(event);
    }

    public void commandStackChanged(EventObject event) {
        this.undoAction.update();
        this.redoAction.update();
        Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
        if (mostRecentCommand instanceof ICompareCopyCommand) {
            Collection affectedObjects = mostRecentCommand.getAffectedObjects();
            TreeNode unfilteredNode = null;
            if (!affectedObjects.isEmpty()) {
                Iterator affectedIterator = Iterables.filter((Iterable)affectedObjects, EObject.class).iterator();
                IDifferenceGroupProvider groupProvider = this.getCompareConfiguration().getStructureMergeViewerGrouper().getProvider();
                block0: while (affectedIterator.hasNext() && unfilteredNode == null) {
                    EObject affected = (EObject)affectedIterator.next();
                    List treeNodes = groupProvider.getTreeNodes(affected);
                    for (TreeNode node : treeNodes) {
                        if (JFaceUtil.isFiltered((StructuredViewer)this.getViewer(), node, node.getParent())) continue;
                        unfilteredNode = node;
                        continue block0;
                    }
                }
            }
            if (unfilteredNode != null) {
                final Adapter adaptedAffectedObject = this.fAdapterFactory.adapt(unfilteredNode, ICompareInput.class);
                for (TreeNode node : this.getPath(null, unfilteredNode)) {
                    ((WrappableTreeViewer)this.getViewer()).expandToLevel(this.fAdapterFactory.adapt((Notifier)node, ICompareInput.class), 0);
                }
                SWTUtil.safeSyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        EMFCompareStructureMergeViewer.this.refresh();
                        StructuredSelection selection = new StructuredSelection(adaptedAffectedObject);
                        ((WrappableTreeViewer)EMFCompareStructureMergeViewer.this.getViewer()).setSelection((ISelection)selection);
                    }
                });
                SWTUtil.safeAsyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        EMFCompareStructureMergeViewer.this.navigatable.openSelectedChange();
                    }
                });
            }
        }
    }

    private Iterable<TreeNode> getPath(TreeNode from, TreeNode to) {
        if (to == from) {
            return Collections.emptyList();
        }
        ArrayList<TreeNode> path = new ArrayList<TreeNode>();
        path.add(to);
        TreeNode parent = to.getParent();
        while (parent != null && parent != from) {
            path.add(parent);
            parent = parent.getParent();
        }
        return Lists.reverse(path);
    }

    void compareInputChanged(ICompareInput input) {
        if (input == null) {
            this.compareInputChanged((ICompareInput)null, (IProgressMonitor)new NullProgressMonitor());
            return;
        }
        if (this.getCompareConfiguration() != null) {
            this.updateLayout(true, true);
            this.inputChangedTask.schedule();
        }
    }

    void compareInputChanged(CompareInputAdapter input, IProgressMonitor monitor) {
        this.compareInputChanged(null, (Comparison)input.getComparisonObject(), monitor);
    }

    void compareInputChanged(ComparisonScopeInput input, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        IComparisonScope comparisonScope = input.getComparisonScope();
        EMFCompareConfiguration compareConfiguration = this.getCompareConfiguration();
        EMFCompare comparator = compareConfiguration.getEMFComparator();
        compareConfiguration.setLeftEditable(input.isLeftEditable());
        compareConfiguration.setRightEditable(input.isRightEditable());
        if (input.isLeftEditable() && input.isRightEditable()) {
            compareConfiguration.setMergePreviewMode(MergeMode.RIGHT_TO_LEFT);
        } else {
            compareConfiguration.setMergePreviewMode(MergeMode.ACCEPT);
        }
        if (compareConfiguration.getEditingDomain() == null) {
            ICompareEditingDomain domain = EMFCompareEditingDomain.create((Notifier)comparisonScope.getLeft(), (Notifier)comparisonScope.getRight(), (Notifier)comparisonScope.getOrigin());
            compareConfiguration.setEditingDomain(domain);
        }
        if (comparator == null) {
            EMFCompare.Builder builder = EMFCompare.builder();
            EMFCompareBuilderConfigurator.createDefault().configure(builder);
            comparator = builder.build();
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        Comparison comparison = comparator.compare(comparisonScope, BasicMonitor.toMonitor((IProgressMonitorWithBlocking)subMonitor.newChild(10)));
        this.hookAdapters(input, comparison);
        this.compareInputChanged(input.getComparisonScope(), comparison, monitor);
    }

    void compareInputChanged(IComparisonScope scope, final Comparison comparison, IProgressMonitor monitor) {
        if (!((CTabFolder)this.getControl()).isDisposed() && !monitor.isCanceled()) {
            EMFCompareConfiguration config = this.getCompareConfiguration();
            ComposedAdapterFactory oldAdapterFactory = this.fAdapterFactory;
            this.fAdapterFactory = this.initAdapterFactory(comparison);
            if (this.fDiffRelationshipComputer != null) {
                this.fDiffRelationshipComputer.invalidate();
            }
            config.setAdapterFactory((AdapterFactory)this.fAdapterFactory);
            this.getContentProvider().setAdapterFactory((AdapterFactory)this.fAdapterFactory);
            ((EMFCompareStructureMergeViewerLabelProvider)this.getLabelProvider().getStyledStringProvider()).setAdapterFactory((AdapterFactory)this.fAdapterFactory);
            TreeNode treeNode = TreeFactory.eINSTANCE.createTreeNode();
            treeNode.setData((EObject)comparison);
            final Adapter input = this.fAdapterFactory.adapt((Notifier)treeNode, ICompareInput.class);
            IDifferenceGroupProvider groupProvider = config.getStructureMergeViewerGrouper().getProvider();
            treeNode.eAdapters().add((Object)groupProvider);
            if (!monitor.isCanceled()) {
                SWTUtil.safeAsyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Diagnostic diagnostic = comparison.getDiagnostic();
                        if (diagnostic == null) {
                            EMFCompareStructureMergeViewer.this.updateProblemIndication(Diagnostic.OK_INSTANCE);
                        } else {
                            EMFCompareStructureMergeViewer.this.updateProblemIndication(diagnostic);
                        }
                    }
                });
            }
            if (!monitor.isCanceled()) {
                SWTUtil.safeSyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ((WrappableTreeViewer)EMFCompareStructureMergeViewer.this.getViewer()).setInput(input);
                    }
                });
            }
            config.setComparisonAndScope(comparison, scope);
            SWTUtil.safeAsyncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (!((CTabFolder)EMFCompareStructureMergeViewer.this.getControl()).isDisposed()) {
                        EMFCompareStructureMergeViewer.this.updateLayout(false, true);
                    }
                }
            });
            this.getContentProvider().runWhenReady(EMFCompareStructureMergeViewerContentProvider.CallbackType.IN_UI_ASYNC, new Runnable(){

                @Override
                public void run() {
                    if (!((CTabFolder)EMFCompareStructureMergeViewer.this.getControl()).isDisposed()) {
                        EMFCompareStructureMergeViewer.this.refreshTitle();
                        EMFCompareStructureMergeViewer.this.expandTreeToLevel(EMFCompareStructureMergeViewer.this.getDefaultTreeExpansionLevel());
                        EMFCompareStructureMergeViewer.this.selectFirstDiffOrDisplayLabelViewer(comparison);
                    }
                }
            });
            SWTUtil.safeAsyncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    EMFCompareStructureMergeViewer.this.fHandlerService.updatePaneActionHandlers(new Runnable(){

                        @Override
                        public void run() {
                            EMFCompareStructureMergeViewer.this.fHandlerService.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)EMFCompareStructureMergeViewer.this.undoAction);
                            EMFCompareStructureMergeViewer.this.fHandlerService.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)EMFCompareStructureMergeViewer.this.redoAction);
                        }
                    });
                }
            });
            if (oldAdapterFactory != null) {
                oldAdapterFactory.dispose();
            }
        }
    }

    void compareInputChanged(ICompareInput input, IProgressMonitor monitor) {
        if (input != null && !monitor.isCanceled()) {
            if (input instanceof CompareInputAdapter) {
                this.resourceSetShouldBeDisposed = false;
                this.compareInputChanged((CompareInputAdapter)input, monitor);
                this.initToolbar(monitor);
            } else if (input instanceof ComparisonScopeInput) {
                this.resourceSetShouldBeDisposed = false;
                this.compareInputChanged((ComparisonScopeInput)input, monitor);
                this.initToolbar(monitor);
            } else {
                Object leftStorage;
                ResourceAttributes attributes;
                this.resourceSetShouldBeDisposed = true;
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                ITypedElement left = input.getLeft();
                ITypedElement right = input.getRight();
                ITypedElement origin = input.getAncestor();
                EMFCompareConfiguration compareConfiguration = this.getCompareConfiguration();
                boolean leftEditable = left instanceof ResourceNode && !(input instanceof DiffNode) ? (attributes = ((ResourceNode)left).getResource().getResourceAttributes()) != null && !attributes.isReadOnly() : compareConfiguration.isLeftEditable();
                boolean rightEditable = right instanceof ResourceNode ? (attributes = ((ResourceNode)right).getResource().getResourceAttributes()) != null && !attributes.isReadOnly() : compareConfiguration.isRightEditable();
                compareConfiguration.setLeftEditable(leftEditable);
                compareConfiguration.setRightEditable(rightEditable);
                if (leftEditable && rightEditable) {
                    compareConfiguration.setMergePreviewMode(MergeMode.RIGHT_TO_LEFT);
                } else {
                    compareConfiguration.setMergePreviewMode(MergeMode.ACCEPT);
                }
                BasicDiagnostic diagnostic = new BasicDiagnostic(0, "org.eclipse.emf.compare.ide.ui", 0, null, new Object[0]);
                EmptyComparisonScope scope = null;
                try {
                    scope = ComparisonScopeBuilder.create(compareConfiguration.getContainer(), left, right, origin, (IProgressMonitor)subMonitor.newChild(85));
                }
                catch (OperationCanceledException e) {
                    scope = new EmptyComparisonScope();
                    ((BasicDiagnostic)scope.getDiagnostic()).merge((Diagnostic)new BasicDiagnostic(8, "org.eclipse.emf.compare.ide.ui", 0, EMFCompareIDEUIMessages.getString("EMFCompareStructureMergeViewer.operationCanceled"), new Object[]{e}));
                }
                catch (Exception e) {
                    scope = new EmptyComparisonScope();
                    ((BasicDiagnostic)scope.getDiagnostic()).merge(BasicDiagnostic.toDiagnostic((Throwable)e));
                    EMFCompareIDEUIPlugin.getDefault().log(e);
                }
                if (scope instanceof IDiagnosable && ((IDiagnosable)scope).getDiagnostic() != null) {
                    diagnostic.merge(((IDiagnosable)scope).getDiagnostic());
                }
                EMFCompare.Builder comparisonBuilder = EMFCompare.builder();
                EMFCompareBuilderConfigurator.createDefault().configure(comparisonBuilder);
                SubMonitor subMonitorChild = SubMonitor.convert((IProgressMonitor)subMonitor.newChild(15), (int)10);
                Comparison compareResult = comparisonBuilder.build().compare((IComparisonScope)scope, BasicMonitor.toMonitor((IProgressMonitorWithBlocking)subMonitorChild));
                this.hookAdapters(input, compareResult);
                if (compareResult.getDiagnostic() != null) {
                    diagnostic.merge(compareResult.getDiagnostic());
                }
                compareResult.setDiagnostic((Diagnostic)diagnostic);
                ResourceSet leftResourceSet = (ResourceSet)scope.getLeft();
                ResourceSet rightResourceSet = (ResourceSet)scope.getRight();
                ResourceSet originResourceSet = (ResourceSet)scope.getOrigin();
                ICompareEditingDomain editingDomain = EMFCompareEditingDomain.create((Notifier)leftResourceSet, (Notifier)rightResourceSet, (Notifier)originResourceSet);
                this.editingDomainNeedsToBeDisposed = true;
                compareConfiguration.setEditingDomain(editingDomain);
                if (leftResourceSet instanceof NotLoadingResourceSet) {
                    ((NotLoadingResourceSet)leftResourceSet).setAllowResourceLoad(true);
                }
                if (rightResourceSet instanceof NotLoadingResourceSet) {
                    ((NotLoadingResourceSet)rightResourceSet).setAllowResourceLoad(true);
                }
                if (originResourceSet instanceof NotLoadingResourceSet) {
                    ((NotLoadingResourceSet)originResourceSet).setAllowResourceLoad(true);
                }
                if ((leftStorage = PlatformElementUtil.findFile(left)) == null) {
                    leftStorage = StreamAccessorStorage.fromTypedElement(left);
                }
                this.initToolbar(monitor);
                this.compareInputChanged((IComparisonScope)scope, compareResult, monitor);
            }
            this.enableToolbar(monitor);
        } else {
            this.compareInputChangedToNull();
        }
    }

    private void hookAdapters(ICompareInput input, Comparison compareResult) {
        compareResult.eAdapters().add((Object)new ForwardingCompareInputAdapter(input));
        if (!(input instanceof ResourceDiffCompareInput)) {
            ICompareInputLabelProvider labelProvider = this.getCompareConfiguration().getLabelProvider();
            SideLabelProvider sideLabelProvider = new SideLabelProvider(labelProvider.getAncestorLabel((Object)input), labelProvider.getLeftLabel((Object)input), labelProvider.getRightLabel((Object)input), labelProvider.getAncestorImage((Object)input), labelProvider.getLeftImage((Object)input), labelProvider.getRightImage((Object)input));
            compareResult.eAdapters().add((Object)sideLabelProvider);
        }
        new MatchOfContainmentReferenceChangeProcessor().execute(compareResult);
        MergeDataImpl mergeData = new MergeDataImpl(this.getCompareConfiguration().isLeftEditable(), this.getCompareConfiguration().isRightEditable());
        compareResult.eAdapters().add((Object)mergeData);
    }

    protected boolean isSelectFirstChange() {
        return this.preferenceStore.getBoolean("org.eclipse.emf.compare.ide.ui.preference.editor.tree.selection.firstChange");
    }

    protected int getDefaultTreeExpansionLevel() {
        return this.preferenceStore.getInt("org.eclipse.emf.compare.ide.ui.preference.editor.tree.expand.level");
    }

    protected void expandTreeToLevel(int level) {
        ((WrappableTreeViewer)this.getViewer()).expandToLevel(level);
    }

    protected boolean isHighlightRelatedChanges() {
        return this.preferenceStore.getBoolean("org.eclipse.emf.compare.ide.ui.preference.editor.tree.highlight");
    }

    protected void updateHighlightRelatedChanges(ISelection selection) {
        if (!this.isHighlightRelatedChanges()) {
            return;
        }
        this.dependencyData.updateDependencies(selection, EMFCompareRCPPlugin.getDefault().getMergerRegistry());
        this.internalRedraw();
    }

    protected void clearHighlightRelatedChanges() {
        this.dependencyData.clearDependencies();
        this.internalRedraw();
    }

    private void selectFirstDiffOrDisplayLabelViewer(Comparison comparison) {
        if (comparison != null) {
            EList differences;
            ICompareInput compareInput = (ICompareInput)EcoreUtil.getAdapter((List)comparison.eAdapters(), ICompareInput.class);
            if (compareInput == null) {
                compareInput = new TreeNodeCompareInput((AdapterFactory)new TreeCompareInputAdapterFactory());
            }
            if ((differences = comparison.getDifferences()).isEmpty()) {
                this.navigatable.fireOpen((Object)new NoDifferencesCompareInput(compareInput));
            } else if (!this.navigatable.hasChange(3)) {
                if (this.hasOnlyPseudoConflicts((List<Diff>)differences)) {
                    this.navigatable.fireOpen((Object)new OnlyPseudoConflictsCompareInput(compareInput));
                } else {
                    this.navigatable.fireOpen((Object)new NoVisibleItemCompareInput(compareInput));
                }
            } else if (!this.isSelectFirstChange()) {
                this.navigatable.fireOpen((Object)new NoSelectedItemCompareInput(compareInput));
            } else {
                this.navigatable.selectChange(3);
            }
        }
    }

    private boolean hasOnlyPseudoConflicts(List<Diff> differences) {
        return Iterators.all(differences.iterator(), (Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.PSEUDO}));
    }

    private void updateLayout(boolean displayProgress, boolean doLayout) {
        ((GridData)this.progressInfoItem.getLayoutData()).exclude = !displayProgress;
        this.progressInfoItem.setVisible(displayProgress);
        ((GridData)((WrappableTreeViewer)this.getViewer()).getControl().getLayoutData()).exclude = displayProgress;
        ((WrappableTreeViewer)this.getViewer()).getControl().setVisible(!displayProgress);
        ((GridData)this.treeRuler.getLayoutData()).exclude = displayProgress;
        this.treeRuler.setVisible(!displayProgress);
        if (doLayout) {
            ((CTabFolder)this.getControl()).layout(true, true);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void compareInputChangedToNull() {
        block10: {
            block11: {
                if (!this.inputChangedTask.cancel()) {
                    try {
                        this.inputChangedTask.join();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        Throwables.propagate((Throwable)e);
                    }
                }
                leftResourceSet = null;
                rightResourceSet = null;
                originResourceSet = null;
                comparison = this.getCompareConfiguration().getComparison();
                if (comparison == null) break block10;
                matchIt = comparison.getMatches().iterator();
                if (!comparison.isThreeWay()) ** GOTO lbl31
                while (matchIt.hasNext() && (leftResourceSet == null || rightResourceSet == null || originResourceSet == null)) {
                    match = (Match)matchIt.next();
                    if (leftResourceSet == null) {
                        leftResourceSet = EMFCompareStructureMergeViewer.getResourceSet(match.getLeft());
                    }
                    if (rightResourceSet == null) {
                        rightResourceSet = EMFCompareStructureMergeViewer.getResourceSet(match.getRight());
                    }
                    if (originResourceSet != null) continue;
                    originResourceSet = EMFCompareStructureMergeViewer.getResourceSet(match.getOrigin());
                }
                break block11;
lbl-1000:
                // 1 sources

                {
                    match = (Match)matchIt.next();
                    if (leftResourceSet == null) {
                        leftResourceSet = EMFCompareStructureMergeViewer.getResourceSet(match.getLeft());
                    }
                    if (rightResourceSet != null) continue;
                    rightResourceSet = EMFCompareStructureMergeViewer.getResourceSet(match.getRight());
lbl31:
                    // 3 sources

                    ** while (matchIt.hasNext() && (leftResourceSet == null || rightResourceSet == null))
                }
            }
            comparison.eAdapters().clear();
        }
        this.editingDomainChange(this.getCompareConfiguration().getEditingDomain(), null);
        if (this.resourceSetShouldBeDisposed) {
            finalLeftResourceSet = leftResourceSet;
            finalRightResourceSet = rightResourceSet;
            finalOriginResourceSet = originResourceSet;
            new Job("Resource Disposer"){

                protected IStatus run(IProgressMonitor monitor) {
                    EMFCompareStructureMergeViewer.this.disposeResourceSet(finalLeftResourceSet);
                    EMFCompareStructureMergeViewer.this.disposeResourceSet(finalRightResourceSet);
                    EMFCompareStructureMergeViewer.this.disposeResourceSet(finalOriginResourceSet);
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
        if (this.getCompareConfiguration() != null) {
            this.getCompareConfiguration().dispose();
        }
        ((WrappableTreeViewer)this.getViewer()).setInput(null);
    }

    protected void disposeResourceSet(ResourceSet resourceSet) {
        if (resourceSet instanceof DisposableResourceSet) {
            ((DisposableResourceSet)resourceSet).dispose();
        } else {
            EMFCompareStructureMergeViewer.unload(resourceSet);
        }
    }

    private void handleEraseItemEvent(Event event) {
        TreeItem item = (TreeItem)event.item;
        EObject dataItem = EMFCompareStructureMergeViewer.getDataOfTreeNodeOfAdapter(item.getData());
        if (dataItem != null) {
            Set<Diff> requires = this.dependencyData.getRequires();
            Set<Diff> rejectedDiffs = this.dependencyData.getRejections();
            GC g = event.gc;
            if (requires.contains(dataItem)) {
                this.paintItemBackground(g, item, this.fColors.getRequiredFillColor());
            } else if (rejectedDiffs.contains(dataItem)) {
                this.paintItemBackground(g, item, this.fColors.getUnmergeableFillColor());
            }
        }
    }

    private void paintItemBackground(GC g, TreeItem item, Color color) {
        Rectangle itemBounds = item.getBounds();
        Tree tree = item.getParent();
        Rectangle areaBounds = tree.getClientArea();
        g.setClipping(areaBounds.x, itemBounds.y, areaBounds.width, itemBounds.height);
        g.setBackground(color);
        g.fillRectangle(areaBounds.x, itemBounds.y, areaBounds.width, itemBounds.height);
    }

    private ProblemIndicationComposite getProblemIndication(Diagnostic diagnostic) {
        Assert.isNotNull((Object)diagnostic);
        int lastEditorPage = this.getPageCount() - 1;
        ProblemIndicationComposite problemIndicationComposite = null;
        if (lastEditorPage >= 0 && this.getItemControl(lastEditorPage) instanceof ProblemIndicationComposite) {
            problemIndicationComposite = (ProblemIndicationComposite)this.getItemControl(lastEditorPage);
        } else if (diagnostic.getSeverity() != 0 && !((CTabFolder)this.getControl()).isDisposed()) {
            problemIndicationComposite = new ProblemIndicationComposite((Composite)this.getControl(), 0);
            this.createItem(++lastEditorPage, (Control)problemIndicationComposite);
            ((CTabFolder)this.getControl()).getItem(lastEditorPage).setText(CommonUIPlugin.getPlugin().getString("_UI_Problems_label"));
            this.showTabs();
        }
        return problemIndicationComposite;
    }

    private void updateProblemIndication(Diagnostic diagnostic) {
        ProblemIndicationComposite problemIndicationComposite = this.getProblemIndication(diagnostic);
        if (problemIndicationComposite != null) {
            problemIndicationComposite.setDiagnostic(diagnostic);
            if (diagnostic.getSeverity() != 0 && diagnostic.getSeverity() != 2) {
                int lastEditorPage = this.getPageCount() - 1;
                this.setActivePage(lastEditorPage);
                this.updateLayout(false, true);
            }
        }
    }

    private void showTabs() {
        if (this.getPageCount() > 1) {
            ((CTabFolder)this.getControl()).getItem(0).setText(EMFCompareIDEUIMessages.getString("EMFCompareStructureMergeViewer.tabItem.0.title"));
            ((CTabFolder)this.getControl()).setTabHeight(-1);
            Point point = ((CTabFolder)this.getControl()).getSize();
            ((CTabFolder)this.getControl()).setSize(point.x, point.y - 6);
        }
    }

    private void hideTabs() {
        if (this.getPageCount() <= 1) {
            ((CTabFolder)this.getControl()).getItem(0).setText("");
            ((CTabFolder)this.getControl()).setTabHeight(1);
            Point point = ((CTabFolder)this.getControl()).getSize();
            ((CTabFolder)this.getControl()).setSize(point.x, point.y + 6);
        }
    }

    private void setActivePage(int pageIndex) {
        Assert.isTrue((pageIndex >= 0 && pageIndex < this.getPageCount() ? 1 : 0) != 0);
        ((CTabFolder)this.getControl()).setSelection(pageIndex);
    }

    private int getPageCount() {
        if (this.getControl() != null && !((CTabFolder)this.getControl()).isDisposed()) {
            return ((CTabFolder)this.getControl()).getItemCount();
        }
        return 0;
    }

    private Control getItemControl(int itemIndex) {
        CTabItem item = ((CTabFolder)this.getControl()).getItem(itemIndex);
        if (item != null) {
            return item.getControl();
        }
        return null;
    }

    private static void unload(ResourceSet resourceSet) {
        if (resourceSet != null) {
            for (Resource resource : resourceSet.getResources()) {
                resource.unload();
            }
            resourceSet.getResources().clear();
        }
    }

    private static ResourceSet getResourceSet(EObject eObject) {
        Resource eResource;
        if (eObject != null && (eResource = eObject.eResource()) != null) {
            return eResource.getResourceSet();
        }
        return null;
    }

    protected void internalRefresh(Object element) {
        this.getContentProvider().runWhenReady(EMFCompareStructureMergeViewerContentProvider.CallbackType.IN_UI_SYNC, new Runnable(){

            @Override
            public void run() {
                ((WrappableTreeViewer)EMFCompareStructureMergeViewer.this.getViewer()).refresh();
            }
        });
        this.getContentProvider().runWhenReady(EMFCompareStructureMergeViewerContentProvider.CallbackType.IN_UI_SYNC, new Runnable(){

            @Override
            public void run() {
                EMFCompareStructureMergeViewer.this.updateHighlightRelatedChanges(EMFCompareStructureMergeViewer.this.getSelection());
            }
        });
        this.getContentProvider().runWhenReady(EMFCompareStructureMergeViewerContentProvider.CallbackType.IN_UI_ASYNC, new Runnable(){

            @Override
            public void run() {
                EMFCompareStructureMergeViewer.this.refreshTitle();
            }
        });
    }

    protected void handlePreferenceChangedEvent(PropertyChangeEvent event) {
        if (event.getProperty() == "org.eclipse.emf.compare.ide.ui.preference.editor.tree.highlight") {
            boolean highlightRelatedChanges = Boolean.parseBoolean(event.getNewValue().toString());
            if (highlightRelatedChanges) {
                this.updateHighlightRelatedChanges(this.getSelection());
            } else {
                this.clearHighlightRelatedChanges();
            }
        }
    }

    private void handleSelectionChangedEvent(SelectionChangedEvent event) {
        if (!Objects.equal((Object)this.currentSelection, (Object)event.getSelection())) {
            this.currentSelection = event.getSelection();
            this.updateHighlightRelatedChanges(event.getSelection());
        }
    }

    private void internalRedraw() {
        Tree tree = ((WrappableTreeViewer)this.getViewer()).getTree();
        if (!tree.isDisposed()) {
            tree.redraw();
            if (!this.treeRuler.isDisposed()) {
                this.treeRuler.redraw();
            }
        }
    }

    private final class CompareInputChangedJob
    extends Job {
        private CompareInputChangedJob(String name) {
            super(name);
        }

        public IStatus run(IProgressMonitor monitor) {
            JobProgressMonitorWrapper wrapper = new JobProgressMonitorWrapper(monitor, EMFCompareStructureMergeViewer.this.progressInfoItem);
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)wrapper, (String)EMFCompareIDEUIMessages.getString("EMFCompareStructureMergeViewer.computingModelDifferences"), (int)100);
            try {
                try {
                    EMFCompareStructureMergeViewer.this.compareInputChanged((ICompareInput)EMFCompareStructureMergeViewer.this.getInput(), (IProgressMonitor)subMonitor.newChild(100));
                }
                catch (OperationCanceledException e) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    subMonitor.setWorkRemaining(0);
                    return iStatus;
                }
                catch (Exception e) {
                    EMFCompareIDEUIPlugin.getDefault().log(e);
                    subMonitor.setWorkRemaining(0);
                }
            }
            finally {
                subMonitor.setWorkRemaining(0);
            }
            return Status.OK_STATUS;
        }
    }

    private static class TitleBuilder {
        private final Comparison comparison;
        private final IDifferenceGroupProvider groupProvider;
        private final Predicate<? super EObject> filterPredicate;
        private final Map<Object, Boolean> visited = Maps.newHashMap();
        private int diffsCount;
        private int visibleDiffsCount;
        private int diffsToMergeCount;

        public TitleBuilder(EMFCompareConfiguration configuration) {
            this.comparison = configuration.getComparison();
            this.groupProvider = configuration.getStructureMergeViewerGrouper().getProvider();
            this.filterPredicate = configuration.getStructureMergeViewerFilter().getAggregatedPredicate();
        }

        void visit(TreeNode node, boolean parentApplies) {
            boolean applies = parentApplies && this.filterPredicate.apply((Object)node);
            EObject data = node.getData();
            if (data instanceof Diff) {
                Boolean visitedApplies = this.visited.put(data, applies);
                if (visitedApplies == null) {
                    ++this.diffsCount;
                }
                if (applies) {
                    if (!Boolean.TRUE.equals(visitedApplies)) {
                        ++this.visibleDiffsCount;
                        Diff diff = (Diff)data;
                        if (diff.getState() == DifferenceState.UNRESOLVED) {
                            ++this.diffsToMergeCount;
                        }
                    }
                } else if (Boolean.TRUE.equals(visitedApplies)) {
                    this.visited.put(data, Boolean.TRUE);
                }
            }
            for (TreeNode childNode : node.getChildren()) {
                this.visit(childNode, applies);
            }
        }

        public String toString() {
            for (IDifferenceGroup group : this.groupProvider.getGroups(this.comparison)) {
                for (TreeNode node : group.getChildren()) {
                    this.visit(node, true);
                }
            }
            String titleArgument = EMFCompareIDEUIMessages.getString("EMFCompareStructureMergeViewer.titleDesc", this.diffsToMergeCount, this.visibleDiffsCount, this.diffsCount - this.visibleDiffsCount);
            return titleArgument;
        }
    }

    private final class TitleBuilderJob
    extends Job {
        public TitleBuilderJob() {
            super("EMF Compare Title Builder");
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            final String title = new TitleBuilder(EMFCompareStructureMergeViewer.this.getCompareConfiguration()).toString();
            EMFCompareStructureMergeViewer.this.getContentProvider().runWhenReady(EMFCompareStructureMergeViewerContentProvider.CallbackType.IN_UI_ASYNC, new Runnable(){

                @Override
                public void run() {
                    CTabFolder control = (CTabFolder)EMFCompareStructureMergeViewer.this.getControl();
                    if (!control.isDisposed()) {
                        ((CompareViewerSwitchingPane)control.getParent()).setTitleArgument(title);
                    }
                }
            });
            return Status.OK_STATUS;
        }
    }
}

