/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.test.common.cases;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.client.exceptions.ESServerStartFailedException;
import org.eclipse.emf.emfstore.client.test.common.cases.ESTest;
import org.eclipse.emf.emfstore.client.test.common.mocks.ServerMock;
import org.eclipse.emf.emfstore.client.test.common.util.ServerUtil;
import org.eclipse.emf.emfstore.internal.common.model.util.FileUtil;
import org.eclipse.emf.emfstore.internal.server.EMFStore;
import org.eclipse.emf.emfstore.internal.server.ServerConfiguration;
import org.eclipse.emf.emfstore.internal.server.exceptions.FatalESException;
import org.eclipse.emf.emfstore.internal.server.model.ProjectHistory;
import org.junit.Assert;
import org.junit.Before;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ESTestWithMockServer
extends ESTest {
    private static ServerMock server;

    @Override
    @Before
    public void before() {
        super.before();
    }

    protected static void startEMFStore() {
        ESTestWithMockServer.startEMFStore(Collections.<String, String>emptyMap());
    }

    protected static void startEMFStore(Map<String, String> properties) {
        ESTestWithMockServer.deleteServerHomeDirectory();
        ServerConfiguration.setTesting((boolean)true);
        try {
            server = ServerUtil.startMockServer(properties);
        }
        catch (IllegalArgumentException ex) {
            Assert.fail((String)ex.getMessage());
        }
        catch (ESServerStartFailedException ex) {
            Assert.fail((String)ex.getMessage());
        }
        catch (FatalESException ex) {
            Assert.fail((String)ex.getMessage());
        }
    }

    private static void deleteServerHomeDirectory() {
        try {
            FileUtil.deleteDirectory((File)new File(ServerConfiguration.getServerHome()), (boolean)true);
        }
        catch (IOException ex) {
            Assert.fail((String)ex.getMessage());
        }
    }

    public ProjectHistory getHistory(ESLocalProject localProject) {
        return server.getHistory(localProject);
    }

    public EMFStore getEMFStore() {
        return server.getEMFStore();
    }

    public static void stopEMFStore() {
    }

    public static ServerMock getServerMock() {
        return server;
    }
}

