/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.managedbuild.cross.arm.preferences;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.embedcdt.managedbuild.cross.arm.Activator;
import org.eclipse.embedcdt.managedbuild.cross.arm.ToolchainDefinition;
import org.eclipse.embedcdt.managedbuild.cross.arm.preferences.DefaultPreferences;
import org.eclipse.embedcdt.managedbuild.cross.preferences.PersistentPreferences;
import org.osgi.service.prefs.Preferences;

public class DefaultPreferenceInitializer
extends AbstractPreferenceInitializer {
    DefaultPreferences fDefaultPreferences;
    PersistentPreferences fPersistentPreferences;

    public void initializeDefaultPreferences() {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("arm.DefaultPreferenceInitializer.initializeDefaultPreferences()");
        }
        this.fDefaultPreferences = new DefaultPreferences("org.eclipse.embedcdt.managedbuild.cross.arm");
        this.fPersistentPreferences = new PersistentPreferences("org.eclipse.embedcdt.managedbuild.cross.arm");
        String toolchainName = "xPack GNU Arm Embedded GCC";
        this.fDefaultPreferences.putToolchainName(toolchainName);
        Preferences prefs = Platform.getPreferencesService().getRootNode().node("default");
        if (prefs instanceof IEclipsePreferences) {
            ((IEclipsePreferences)prefs).addNodeChangeListener((IEclipsePreferences.INodeChangeListener)new LateInitializer());
        }
    }

    private class LateInitializer
    implements IEclipsePreferences.INodeChangeListener {
        private LateInitializer() {
        }

        public void added(IEclipsePreferences.NodeChangeEvent event) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("arm.LateInitializer.added() " + event + " " + event.getChild().name());
            }
            if ("org.eclipse.embedcdt.managedbuild.cross.arm".equals(event.getChild().name())) {
                this.finalizeInitializationsDefaultPreferences();
                ((IEclipsePreferences)event.getSource()).removeNodeChangeListener((IEclipsePreferences.INodeChangeListener)this);
            }
        }

        public void removed(IEclipsePreferences.NodeChangeEvent event) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("arm.LateInitializer.removed() " + event);
            }
        }

        public void finalizeInitializationsDefaultPreferences() {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("arm.LateInitializer.finalizeInitializationsDefaultPreferences()");
            }
            DefaultPreferences deprecatedDefaultPreferences = new DefaultPreferences("ilg.gnuarmeclipse.managedbuild.cross");
            for (ToolchainDefinition toolchain : ToolchainDefinition.getList()) {
                int ix;
                String toolchainName = toolchain.getName();
                try {
                    ix = ToolchainDefinition.findToolchainByName(toolchainName);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    ix = ToolchainDefinition.getDefault();
                }
                String executableName = ToolchainDefinition.getToolchain(ix).getFullCmdC();
                String path = DefaultPreferenceInitializer.this.fDefaultPreferences.getToolchainPath(toolchainName);
                if (!DefaultPreferenceInitializer.this.fDefaultPreferences.checkFolderExecutable(path, executableName)) {
                    path = deprecatedDefaultPreferences.getToolchainPath(toolchainName);
                }
                if (!DefaultPreferenceInitializer.this.fDefaultPreferences.checkFolderExecutable(path, executableName)) {
                    path = DefaultPreferenceInitializer.this.fPersistentPreferences.getToolchainPath(toolchainName, null);
                }
                if (!DefaultPreferenceInitializer.this.fDefaultPreferences.checkFolderExecutable(path, executableName)) {
                    path = DefaultPreferenceInitializer.this.fDefaultPreferences.discoverToolchainPath(toolchainName, executableName);
                }
                if (path != null && !path.isEmpty()) {
                    DefaultPreferenceInitializer.this.fDefaultPreferences.putToolchainPath(toolchainName, path);
                }
                if (!Activator.getInstance().isDebugging()) continue;
                System.out.println("arm.LateInitializer.finalizeInitializationsDefaultPreferences() done");
            }
        }
    }
}

