/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.core.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.embedcdt.core.Activator;
import org.osgi.service.prefs.BackingStoreException;

public class PersistentPreferences {
    protected static IScopeContext[] fgContexts = new IScopeContext[]{InstanceScope.INSTANCE, ConfigurationScope.INSTANCE, DefaultScope.INSTANCE};
    protected String fPluginId;

    public static String getPreferenceValueForId(String pluginId, String key, String defaultValue, IScopeContext[] contexts) {
        String pluginCompatId = pluginId.replace("org.eclipse.embedcdt.", "ilg.gnumcueclipse.");
        String value = null;
        String from = null;
        int i = 0;
        while (i < contexts.length) {
            value = null;
            IEclipsePreferences node = contexts[i].getNode(pluginId);
            if (node != null) {
                value = node.get(key, null);
            }
            if (value == null && (node = contexts[i].getNode(pluginCompatId)) != null) {
                value = node.get(key, null);
            }
            if (value != null && !(value = value.trim()).isEmpty()) {
                from = contexts[i].getName();
                break;
            }
            ++i;
        }
        if (value != null) {
            if (Activator.getInstance().isDebugging()) {
                System.out.println("PersistentPreferences.getPreferenceValueForId(\"" + pluginId + "\", \"" + key + "\", \"" + defaultValue + "\") = \"" + value + "\" from " + from);
            }
            return value;
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("PersistentPreferences.getPreferenceValueForId(\"" + pluginId + "\", \"" + key + "\", \"" + defaultValue + "\") = \"" + defaultValue + "\" default");
        }
        return defaultValue;
    }

    public static IScopeContext[] getPreferenceScopeContexts(IProject project) {
        IScopeContext[] contexts = project != null ? new IScopeContext[]{new ProjectScope(project), InstanceScope.INSTANCE, ConfigurationScope.INSTANCE, DefaultScope.INSTANCE} : fgContexts;
        return contexts;
    }

    public static String getPreferenceValueForId(String pluginId, String key, String defaultValue, IProject project) {
        IScopeContext[] contexts = PersistentPreferences.getPreferenceScopeContexts(project);
        return PersistentPreferences.getPreferenceValueForId(pluginId, key, defaultValue, contexts);
    }

    public PersistentPreferences(String pluginId) {
        this.fPluginId = pluginId;
    }

    protected String getString(String key, String defaultValue, IProject project) {
        assert (project != null);
        IScopeContext[] contexts = new IScopeContext[]{new ProjectScope(project), InstanceScope.INSTANCE, ConfigurationScope.INSTANCE, DefaultScope.INSTANCE};
        String value = PersistentPreferences.getPreferenceValueForId(this.fPluginId, key, defaultValue, contexts);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        return defaultValue;
    }

    protected String getString(String key, String defaultValue) {
        String value = PersistentPreferences.getPreferenceValueForId(this.fPluginId, key, defaultValue, fgContexts);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        return defaultValue;
    }

    protected String getEclipseString(String key, String defaultValue) {
        IEclipsePreferences preferences = ConfigurationScope.INSTANCE.getNode(this.fPluginId);
        String value = preferences.get(key, defaultValue);
        if (Activator.getInstance().isDebugging()) {
            System.out.println("PersistentPreferences.getEclipseString(\"" + key + "\", \"" + defaultValue + "\") = \"" + value + "\" id \"" + this.fPluginId + "\"");
        }
        return value;
    }

    private String getWorkspaceString(String key, String defaultValue) {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode(this.fPluginId);
        String value = preferences.get(key, defaultValue);
        if (Activator.getInstance().isDebugging()) {
            System.out.println("PersistentPreferences.getWorkspaceString(\"" + key + "\", \"" + defaultValue + "\") = \"" + value + "\" id \"" + this.fPluginId + "\"");
        }
        return value;
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        boolean value = Platform.getPreferencesService().getBoolean(this.fPluginId, key, defaultValue, fgContexts);
        if (Activator.getInstance().isDebugging()) {
            System.out.println("PersistentPreferences.getBoolean(\"" + key + "\", " + defaultValue + ") = " + value + " id \"" + this.fPluginId + "\"");
        }
        return value;
    }

    protected void putString(String key, String value) {
        String oldValue = this.getWorkspaceString(key, null);
        if (oldValue != null) {
            this.putWorkspaceString(key, value);
        } else {
            this.putEclipseString(key, value);
        }
    }

    private void putEclipseString(String key, String value) {
        value = value.trim();
        if (Activator.getInstance().isDebugging()) {
            System.out.println("putEclipseString(\"" + key + "\", \"" + value + "\") id \"" + this.fPluginId + "\"");
        }
        IEclipsePreferences preferences = ConfigurationScope.INSTANCE.getNode(this.fPluginId);
        preferences.put(key, value);
    }

    protected void putWorkspaceString(String key, String value) {
        value = value.trim();
        if (Activator.getInstance().isDebugging()) {
            System.out.println("putWorkspaceString(\"" + key + "\", \"" + value + "\") id \"" + this.fPluginId + "\"");
        }
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode(this.fPluginId);
        preferences.put(key, value);
    }

    public void flush() {
        try {
            ConfigurationScope.INSTANCE.getNode(this.fPluginId).flush();
            InstanceScope.INSTANCE.getNode(this.fPluginId).flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    protected void putProjectString(String key, String value, IProject project) {
        value = value.trim();
        IEclipsePreferences preferences = new ProjectScope(project).getNode(this.fPluginId);
        preferences.put(key, value);
    }

    public void flush(IProject project) {
        try {
            new ProjectScope(project).getNode(this.fPluginId).flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }
}

