/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.dashboard.ui.model;

import org.eclipse.egerrit.internal.core.utils.Utils;
import org.eclipse.egerrit.internal.dashboard.ui.GerritUi;
import org.eclipse.egerrit.internal.dashboard.ui.model.Messages;
import org.eclipse.egerrit.internal.model.ChangeInfo;
import org.eclipse.egerrit.internal.model.provider.ChangeInfoItemProvider;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ReviewTableLabelProvider
extends ChangeInfoItemProvider {
    private final String EMPTY_STRING = "";
    private int fVerifyState;
    private int fCodeReviewState;
    public static final String CHECKED_IMAGE = "greenCheck.png";
    public static final String NOT_OK_IMAGE = "redNot.png";
    public static final String MINUS_ONE = "minusOne.png";
    public static final String PLUS_ONE = "plusOne.png";
    public static final String STAR_FILLED = "starFilled.gif";
    public static final String STAR_OPEN = "starOpen.gif";
    public static final int NOT_OK_IMAGE_STATE = -2;
    public static final int CHECKED_IMAGE_STATE = 2;
    private static Display fDisplay = Display.getCurrent();
    private static Color DEFAULT_COLOR = fDisplay.getSystemColor(25);
    private static Color DEFAULT_FOREGROUND_COLOR = fDisplay.getSystemColor(16);
    private static Color BOLD_COLOR = fDisplay.getSystemColor(2);
    private static Color INCOMING_COLOR = fDisplay.getSystemColor(1);
    private static Color CLOSED_COLOR = fDisplay.getSystemColor(1);
    private static final String VERIFIED = "Verified";
    private static final String CODE_REVIEW = "Code-Review";
    private static ImageRegistry fImageRegistry = new ImageRegistry();

    static {
        String iconPath = "icons/view16/";
        fImageRegistry.put(CHECKED_IMAGE, GerritUi.getImageDescriptor(String.valueOf(iconPath) + CHECKED_IMAGE));
        fImageRegistry.put(NOT_OK_IMAGE, GerritUi.getImageDescriptor(String.valueOf(iconPath) + NOT_OK_IMAGE));
        fImageRegistry.put(MINUS_ONE, GerritUi.getImageDescriptor(String.valueOf(iconPath) + MINUS_ONE));
        fImageRegistry.put(PLUS_ONE, GerritUi.getImageDescriptor(String.valueOf(iconPath) + PLUS_ONE));
        fImageRegistry.put(STAR_FILLED, GerritUi.getImageDescriptor(String.valueOf(iconPath) + STAR_FILLED));
        fImageRegistry.put(STAR_OPEN, GerritUi.getImageDescriptor(String.valueOf(iconPath) + STAR_OPEN));
    }

    public ReviewTableLabelProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    private Image getReviewStateImage(int aState) {
        switch (aState) {
            case 2: {
                return fImageRegistry.get(CHECKED_IMAGE);
            }
            case 1: {
                return fImageRegistry.get(PLUS_ONE);
            }
            case 0: {
                break;
            }
            case -1: {
                return fImageRegistry.get(MINUS_ONE);
            }
            case -2: {
                return fImageRegistry.get(NOT_OK_IMAGE);
            }
        }
        return null;
    }

    private Image getVerifyStateImage(int aState) {
        switch (aState) {
            case 1: 
            case 2: {
                return fImageRegistry.get(CHECKED_IMAGE);
            }
            case 0: {
                break;
            }
            case -2: 
            case -1: {
                return fImageRegistry.get(NOT_OK_IMAGE);
            }
        }
        return null;
    }

    private Image getReviewId(Boolean aState) {
        if (aState.booleanValue()) {
            return fImageRegistry.get(STAR_FILLED);
        }
        return fImageRegistry.get(STAR_OPEN);
    }

    public String getColumnText(Object aObj, int aIndex) {
        if (aObj instanceof ChangeInfo) {
            ChangeInfo reviewSummary = (ChangeInfo)aObj;
            switch (aIndex) {
                case 0: {
                    Boolean starred = reviewSummary.isStarred();
                    if (starred.booleanValue()) {
                        return Messages.Starred;
                    }
                    return Messages.Not_Starred;
                }
                case 1: {
                    return Integer.toString(reviewSummary.get_number());
                }
                case 2: {
                    return reviewSummary.getSubject();
                }
                case 3: {
                    String attribute = reviewSummary.getStatus().toString();
                    return attribute;
                }
                case 4: {
                    return reviewSummary.getOwner().getName();
                }
                case 5: {
                    return reviewSummary.getProject();
                }
                case 6: {
                    String branch = reviewSummary.getBranch();
                    String topic = reviewSummary.getTopic();
                    if (topic != null && !topic.isEmpty()) {
                        branch = String.valueOf(branch) + " (" + topic + ")";
                    }
                    return branch;
                }
                case 7: {
                    return Utils.prettyPrintDate((String)reviewSummary.getUpdated());
                }
                case 8: {
                    this.fCodeReviewState = reviewSummary.getMostRelevantVote(CODE_REVIEW).getValue();
                    return "";
                }
                case 9: {
                    this.fVerifyState = reviewSummary.getMostRelevantVote(VERIFIED).getValue();
                    return "";
                }
            }
            return "";
        }
        return "";
    }

    public Image getColumnImage(Object aObj, int aIndex) {
        Image image = null;
        String value = null;
        if (aObj instanceof ChangeInfo) {
            ChangeInfo reviewSummary = (ChangeInfo)aObj;
            switch (aIndex) {
                case 0: {
                    Boolean starred = reviewSummary.isStarred();
                    value = starred.toString();
                    if (value == null || value.equals("")) break;
                    return this.getReviewId(Boolean.valueOf(value.toLowerCase()));
                }
                case 1: {
                    return image;
                }
                case 2: {
                    return image;
                }
                case 3: {
                    return image;
                }
                case 4: {
                    return image;
                }
                case 5: {
                    return image;
                }
                case 6: {
                    return image;
                }
                case 7: {
                    return image;
                }
                case 8: {
                    return this.getReviewStateImage(this.fCodeReviewState);
                }
                case 9: {
                    return this.getVerifyStateImage(this.fVerifyState);
                }
                default: {
                    return image;
                }
            }
        }
        return image;
    }

    public Object getForeground(Object aElement, int aColumnIndex) {
        if (aElement instanceof ChangeInfo) {
            switch (aColumnIndex) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ChangeInfo changeInfo = (ChangeInfo)aElement;
                    if (changeInfo.isReviewed()) {
                        return DEFAULT_FOREGROUND_COLOR;
                    }
                    return BOLD_COLOR;
                }
            }
        }
        return null;
    }

    public Object getBackground(Object aElement, int aColumnIndex) {
        ChangeInfo item;
        String state;
        if (aElement instanceof ChangeInfo && (state = new Boolean((item = (ChangeInfo)aElement).isStarred()).toString()) != null) {
            if (state.equals(Boolean.toString(true))) {
                return INCOMING_COLOR;
            }
            if (state.equals(Boolean.toString(false))) {
                return CLOSED_COLOR;
            }
        }
        return DEFAULT_COLOR;
    }
}

