/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.core;

import org.eclipse.egerrit.internal.core.GerritRepository;
import org.eclipse.egerrit.internal.core.command.AbandonCommand;
import org.eclipse.egerrit.internal.core.command.AddReviewerCommand;
import org.eclipse.egerrit.internal.core.command.ChangeCommitMsgCommand;
import org.eclipse.egerrit.internal.core.command.CherryPickRevisionCommand;
import org.eclipse.egerrit.internal.core.command.CreateDraftCommand;
import org.eclipse.egerrit.internal.core.command.DeleteDraftChangeCommand;
import org.eclipse.egerrit.internal.core.command.DeleteDraftCommand;
import org.eclipse.egerrit.internal.core.command.DeleteDraftRevisionCommand;
import org.eclipse.egerrit.internal.core.command.DeleteReviewedCommand;
import org.eclipse.egerrit.internal.core.command.DeleteReviewerCommand;
import org.eclipse.egerrit.internal.core.command.GetChangeCommand;
import org.eclipse.egerrit.internal.core.command.GetCommitMsgCommand;
import org.eclipse.egerrit.internal.core.command.GetContentCommand;
import org.eclipse.egerrit.internal.core.command.GetContentFromCommitCommand;
import org.eclipse.egerrit.internal.core.command.GetFilesCommand;
import org.eclipse.egerrit.internal.core.command.GetIncludedInCommand;
import org.eclipse.egerrit.internal.core.command.GetMergeableCommand;
import org.eclipse.egerrit.internal.core.command.GetModifiedFilesCommand;
import org.eclipse.egerrit.internal.core.command.GetRelatedChangesCommand;
import org.eclipse.egerrit.internal.core.command.GetReviewedFilesCommand;
import org.eclipse.egerrit.internal.core.command.GetRevisionActionsCommand;
import org.eclipse.egerrit.internal.core.command.ListBranchesCommand;
import org.eclipse.egerrit.internal.core.command.ListCommentsCommand;
import org.eclipse.egerrit.internal.core.command.ListDraftsCommand;
import org.eclipse.egerrit.internal.core.command.ListProjectsCommand;
import org.eclipse.egerrit.internal.core.command.ListReviewersCommand;
import org.eclipse.egerrit.internal.core.command.PublishChangeEditCommand;
import org.eclipse.egerrit.internal.core.command.PublishDraftChangeCommand;
import org.eclipse.egerrit.internal.core.command.QueryChangesCommand;
import org.eclipse.egerrit.internal.core.command.RebaseCommand;
import org.eclipse.egerrit.internal.core.command.RebaseRevisionCommand;
import org.eclipse.egerrit.internal.core.command.RestoreCommand;
import org.eclipse.egerrit.internal.core.command.RevertCommand;
import org.eclipse.egerrit.internal.core.command.SetReviewCommand;
import org.eclipse.egerrit.internal.core.command.SetReviewedCommand;
import org.eclipse.egerrit.internal.core.command.SetTopicCommand;
import org.eclipse.egerrit.internal.core.command.StarChangeCommand;
import org.eclipse.egerrit.internal.core.command.SubmitCommand;
import org.eclipse.egerrit.internal.core.command.SuggestAccountCommand;
import org.eclipse.egerrit.internal.core.command.SuggestReviewersCommand;
import org.eclipse.egerrit.internal.core.command.UnstarChangeCommand;
import org.eclipse.egerrit.internal.core.command.UpdateDraftCommand;
import org.eclipse.egerrit.internal.core.exception.EGerritException;
import org.eclipse.egerrit.internal.model.ChangeInfo;

public abstract class GerritClient {
    private final GerritRepository fGerritRepository;

    protected GerritClient(GerritRepository gerritRepository) throws EGerritException {
        if (gerritRepository == null) {
            throw new EGerritException("Invalid gerrit repository");
        }
        this.fGerritRepository = gerritRepository;
    }

    public GerritRepository getRepository() {
        return this.fGerritRepository;
    }

    public QueryChangesCommand queryChanges() {
        return new QueryChangesCommand(this.fGerritRepository);
    }

    public GetChangeCommand getChange(String id) {
        return new GetChangeCommand(this.fGerritRepository, id);
    }

    public GetContentCommand getContent(String id, String revision, String file) {
        return new GetContentCommand(this.fGerritRepository, id, revision, file);
    }

    public GetCommitMsgCommand getCommitMsg(String change_id, String commit_id) {
        return new GetCommitMsgCommand(this.fGerritRepository, change_id, commit_id);
    }

    public GetMergeableCommand getMergeable(ChangeInfo change) {
        return new GetMergeableCommand(this.fGerritRepository, change, null);
    }

    public ListReviewersCommand getReviewers(String change_id) {
        return new ListReviewersCommand(this.fGerritRepository, change_id);
    }

    public SuggestReviewersCommand suggestReviewers(String change_id) {
        return new SuggestReviewersCommand(this.fGerritRepository, change_id);
    }

    public SuggestAccountCommand suggestAccount() {
        return new SuggestAccountCommand(this.fGerritRepository);
    }

    public GetIncludedInCommand getIncludedIn(String change_id) {
        return new GetIncludedInCommand(this.fGerritRepository, change_id);
    }

    public GetRelatedChangesCommand getRelatedChanges(String id, String revision) {
        return new GetRelatedChangesCommand(this.fGerritRepository, id, revision);
    }

    public ListCommentsCommand getListComments(String change_id, String revision_id) {
        return new ListCommentsCommand(this.fGerritRepository, change_id, revision_id);
    }

    public CreateDraftCommand createDraftComments(String change_id, String revision_id) {
        return new CreateDraftCommand(this.fGerritRepository, change_id, revision_id);
    }

    public SetReviewCommand setReview(String change_id, String revision_id) {
        return new SetReviewCommand(this.fGerritRepository, change_id, revision_id);
    }

    public ListDraftsCommand listDraftsComments(String change_id, String revision_id) {
        return new ListDraftsCommand(this.fGerritRepository, change_id, revision_id);
    }

    public ListProjectsCommand listProjects() {
        return new ListProjectsCommand(this.fGerritRepository);
    }

    public SubmitCommand submit(String change_id) {
        return new SubmitCommand(this.fGerritRepository, change_id);
    }

    public AbandonCommand abandon(String change_id) {
        return new AbandonCommand(this.fGerritRepository, change_id);
    }

    public RestoreCommand restore(String change_id) {
        return new RestoreCommand(this.fGerritRepository, change_id);
    }

    public AddReviewerCommand addReviewer(String change_id) {
        return new AddReviewerCommand(this.fGerritRepository, change_id);
    }

    public DeleteReviewerCommand deleteReviewer(String change_id, String accountId) {
        return new DeleteReviewerCommand(this.fGerritRepository, change_id, accountId);
    }

    public DeleteDraftCommand deleteDraft(String change_id, String revisionId, String draftId) {
        return new DeleteDraftCommand(this.fGerritRepository, change_id, revisionId, draftId);
    }

    public UpdateDraftCommand updateDraftComments(String change_id, String revisionId, String draftId) {
        return new UpdateDraftCommand(this.fGerritRepository, change_id, revisionId, draftId);
    }

    public RebaseCommand rebase(String change_id) {
        return new RebaseCommand(this.fGerritRepository, change_id);
    }

    public GetContentFromCommitCommand getContentFromCommit(String project, String commit_id, String file_id) {
        return new GetContentFromCommitCommand(this.fGerritRepository, project, commit_id, file_id);
    }

    public GetRevisionActionsCommand getRevisionActions(String change_id, String currentRevision) {
        return new GetRevisionActionsCommand(this.fGerritRepository, change_id, currentRevision);
    }

    public ListBranchesCommand listBranches(String project) {
        return new ListBranchesCommand(this.fGerritRepository, project);
    }

    public CherryPickRevisionCommand cherryPickRevision(String change_id, String revision_id) {
        return new CherryPickRevisionCommand(this.fGerritRepository, change_id, revision_id);
    }

    public ChangeCommitMsgCommand editMessage(String change_id) {
        return new ChangeCommitMsgCommand(this.fGerritRepository, change_id);
    }

    public PublishChangeEditCommand publishChangeEdit(String change_id) {
        return new PublishChangeEditCommand(this.fGerritRepository, change_id);
    }

    public SetReviewedCommand setReviewed(String change_id, String revision_id, String fileName) {
        return new SetReviewedCommand(this.fGerritRepository, change_id, revision_id, fileName);
    }

    public DeleteReviewedCommand deleteReviewed(String change_id, String revision_id, String fileName) {
        return new DeleteReviewedCommand(this.fGerritRepository, change_id, revision_id, fileName);
    }

    public GetReviewedFilesCommand getReviewed(String change_id, String revision_id) {
        return new GetReviewedFilesCommand(this.fGerritRepository, change_id, revision_id);
    }

    public SetTopicCommand setTopic(String change_id) {
        return new SetTopicCommand(this.fGerritRepository, change_id);
    }

    public RevertCommand revert(String change_id) {
        return new RevertCommand(this.fGerritRepository, change_id);
    }

    public DeleteDraftChangeCommand deleteDraftChange(String change_id) {
        return new DeleteDraftChangeCommand(this.fGerritRepository, change_id);
    }

    public PublishDraftChangeCommand publishDraftChange(String change_id) {
        return new PublishDraftChangeCommand(this.fGerritRepository, change_id);
    }

    public DeleteDraftRevisionCommand deleteDraftRevision(String change_id, String commit_id) {
        return new DeleteDraftRevisionCommand(this.fGerritRepository, change_id, commit_id);
    }

    public GetModifiedFilesCommand getFilesModifiedSince(String change_id, String revision_id, String compareAgainst) {
        return new GetModifiedFilesCommand(this.fGerritRepository, change_id, revision_id, compareAgainst);
    }

    public GetFilesCommand getFiles(String change_id, String revision_id) {
        return new GetFilesCommand(this.fGerritRepository, change_id, revision_id);
    }

    public StarChangeCommand starChange(int numericChangeId) {
        return new StarChangeCommand(this.fGerritRepository, numericChangeId);
    }

    public UnstarChangeCommand unstarChange(int numericChangeId) {
        return new UnstarChangeCommand(this.fGerritRepository, numericChangeId);
    }

    public RebaseRevisionCommand rebase(String change_id, String revision_id) {
        return new RebaseRevisionCommand(this.fGerritRepository, change_id, revision_id);
    }
}

