/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.formatting.IElementMatcherProvider;
import org.eclipse.xtext.parsetree.reconstr.IHiddenTokenHelper;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

public abstract class AbstractFormattingConfig {
    protected IGrammarAccess grammarAccess;
    protected IHiddenTokenHelper hiddenTokenHelper;
    protected Map<EObject, List<ElementLocator>> locatorsCommentAfter = Maps.newHashMap();
    protected Map<EObject, List<ElementLocator>> locatorsCommentBefore = Maps.newHashMap();
    protected List<ElementPattern> locatorsSemantic = Lists.newArrayList();

    public AbstractFormattingConfig(IGrammarAccess grammarAccess, IHiddenTokenHelper hiddenTokenHelper) {
        this.grammarAccess = grammarAccess;
        this.hiddenTokenHelper = hiddenTokenHelper;
    }

    protected void addLocator(ElementLocator locator) {
        if (locator.before instanceof AbstractRule && this.hiddenTokenHelper.isComment((AbstractRule)locator.before) || locator.after instanceof AbstractRule && this.hiddenTokenHelper.isComment((AbstractRule)locator.after)) {
            this.addLocatorComment(locator);
        } else {
            this.addLocatorSemantic(locator);
        }
    }

    protected void addLocatorComment(ElementLocator locator) {
        List<Object> loc;
        if (locator.before != null) {
            loc = this.locatorsCommentBefore.get(locator.before);
            if (loc == null) {
                loc = Lists.newArrayList();
                this.locatorsCommentBefore.put(locator.before, loc);
            }
            loc.add(locator);
        }
        if (locator.after != null) {
            loc = this.locatorsCommentAfter.get(locator.after);
            if (loc == null) {
                loc = Lists.newArrayList();
                this.locatorsCommentAfter.put(locator.after, loc);
            }
            loc.add(locator);
        }
    }

    protected void addLocatorSemantic(ElementLocator locator) {
        block5: {
            List<AbstractElement> after;
            block6: {
                List<AbstractElement> before;
                block4: {
                    before = this.getAbstractElements(locator.before);
                    after = this.getAbstractElements(locator.after);
                    if (before == null || after == null) break block4;
                    for (AbstractElement b : before) {
                        for (AbstractElement a : after) {
                            this.addLocatorSemantic(locator, b, a);
                        }
                    }
                    break block5;
                }
                if (before == null) break block6;
                for (AbstractElement b : before) {
                    this.addLocatorSemantic(locator, b, null);
                }
                break block5;
            }
            if (after == null) break block5;
            for (AbstractElement a : after) {
                this.addLocatorSemantic(locator, null, a);
            }
        }
    }

    protected void addLocatorSemantic(ElementLocator locator, AbstractElement before, AbstractElement after) {
        if (locator.type == LocatorType.BETWEEN) {
            this.locatorsSemantic.add(new ElementBetweenPattern(locator, before, after));
        } else {
            this.locatorsSemantic.add(new ElementBeforeAfterPattern(locator, before, after));
        }
    }

    protected List<AbstractElement> getAbstractElements(EObject obj) {
        if (obj instanceof AbstractElement) {
            return Collections.singletonList((AbstractElement)obj);
        }
        if (obj instanceof AbstractRule) {
            AbstractRule rule = (AbstractRule)obj;
            if (rule.getType().getClassifier() instanceof EClass) {
                return Collections.singletonList(rule.getAlternatives());
            }
            ArrayList result = Lists.newArrayList();
            for (RuleCall rc : this.grammarAccess.findRuleCalls(rule)) {
                CrossReference cr = GrammarUtil.containingCrossReference(rc);
                result.add(cr == null ? rc : cr);
            }
            return result;
        }
        return null;
    }

    public List<ElementLocator> getLocatorsForCommentTokensAfter(EObject ctx) {
        List<ElementLocator> result = this.locatorsCommentAfter.get(ctx);
        return result != null ? result : Collections.emptyList();
    }

    public List<ElementLocator> getLocatorsForCommentTokensBefore(EObject ctx) {
        List<ElementLocator> result = this.locatorsCommentBefore.get(ctx);
        return result != null ? result : Collections.emptyList();
    }

    public List<ElementPattern> getLocatorsForSemanticTokens() {
        return this.locatorsSemantic;
    }

    public static class ElementBeforeAfterPattern
    extends ElementPattern
    implements IElementMatcherProvider.IAfterElement,
    IElementMatcherProvider.IBeforeElement {
        public ElementBeforeAfterPattern(ElementLocator locator, AbstractElement before, AbstractElement after) {
            super(locator, before, after);
        }

        @Override
        public AbstractElement matchAfter() {
            return this.after;
        }

        @Override
        public AbstractElement matchBefore() {
            return this.before;
        }
    }

    public static class ElementBetweenPattern
    extends ElementPattern
    implements IElementMatcherProvider.IBetweenElements {
        public ElementBetweenPattern(ElementLocator locator, AbstractElement before, AbstractElement after) {
            super(locator, before, after);
        }

        @Override
        public Pair<AbstractElement, AbstractElement> matchBetween() {
            return Tuples.create((Object)this.after, (Object)this.before);
        }
    }

    public class ElementLocator {
        protected EObject after;
        protected EObject before;
        protected LocatorType type;

        public void after(EObject after) {
            this.type = LocatorType.AFTER;
            this.after = after;
            this.before = null;
            AbstractFormattingConfig.this.addLocator(this);
        }

        public void around(EObject ele) {
            this.type = LocatorType.AROUND;
            this.after = ele;
            this.before = ele;
            AbstractFormattingConfig.this.addLocator(this);
        }

        public void before(EObject right) {
            this.type = LocatorType.BEFORE;
            this.before = right;
            this.after = null;
            AbstractFormattingConfig.this.addLocator(this);
        }

        public void between(EObject left, EObject right) {
            this.type = LocatorType.BETWEEN;
            this.after = left;
            this.before = right;
            AbstractFormattingConfig.this.addLocator(this);
        }

        public void bounds(EObject left, EObject right) {
            this.type = LocatorType.BOUNDS;
            this.after = left;
            this.before = right;
            AbstractFormattingConfig.this.addLocator(this);
        }

        public EObject getLeft() {
            return this.after;
        }

        public EObject getRight() {
            return this.before;
        }

        public LocatorType getType() {
            return this.type;
        }

        public void range(EObject left, EObject right) {
            this.type = LocatorType.RANGE;
            this.after = left;
            this.before = right;
            AbstractFormattingConfig.this.addLocator(this);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "-" + this.type.name();
        }
    }

    public static class ElementPattern
    implements IElementMatcherProvider.IElementPattern {
        protected AbstractElement after;
        protected AbstractElement before;
        protected ElementLocator locator;

        public ElementPattern(ElementLocator locator, AbstractElement before, AbstractElement after) {
            this.locator = locator;
            this.before = before;
            this.after = after;
        }

        public ElementLocator getLocator() {
            return this.locator;
        }

        public String toString() {
            return this.locator.toString();
        }
    }

    public static enum LocatorType {
        AFTER,
        AROUND,
        BEFORE,
        BETWEEN,
        BOUNDS,
        RANGE;

    }
}

