/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator.serializer;

import com.google.common.base.Throwables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.serializer.analysis.IContextPDAProvider;
import org.eclipse.xtext.serializer.analysis.IContextTypePDAProvider;
import org.eclipse.xtext.serializer.analysis.ISemanticSequencerNfaProvider;
import org.eclipse.xtext.serializer.analysis.ISyntacticSequencerPDAProvider;
import org.eclipse.xtext.util.GraphvizDotBuilder;
import org.eclipse.xtext.util.formallang.NfaToDot;
import org.eclipse.xtext.util.formallang.PdaToDot;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xtext.generator.XtextGeneratorNaming;
import org.eclipse.xtext.xtext.generator.serializer.EqualAmbiguousTransitions;
import org.eclipse.xtext.xtext.generator.serializer.NamedSerializationContextProvider;
import org.eclipse.xtext.xtext.generator.serializer.NamedSerializationContexts;
import org.eclipse.xtext.xtext.generator.serializer.SyntacticSequencerExtensions;
import org.eclipse.xtext.xtext.generator.serializer.SyntacticSequencerPDA2ExtendedDot;

public class DebugGraphGenerator {
    @Inject
    private Grammar grammar;
    @Inject
    @Extension
    private XtextGeneratorNaming _xtextGeneratorNaming;
    @Inject
    private IContextPDAProvider contextPDAProvider;
    @Inject
    private IContextTypePDAProvider contextTypePDAProvider;
    @Inject
    private ISyntacticSequencerPDAProvider syntacticSequencerPDAProvider;
    @Inject
    private ISemanticSequencerNfaProvider semanticSequencerNFAProvider;
    @Inject
    private SyntacticSequencerPDA2ExtendedDot syntacticSequencerPDA2Dot;
    @Inject
    private SyntacticSequencerExtensions syntacticSequencerUtil;
    @Inject
    private PdaToDot<?, ?> pdaToDot;
    @Inject
    private NfaToDot<?> nfaToDot;

    /*
     * WARNING - void declaration
     */
    public Iterable<Pair<String, String>> generateDebugGraphs() {
        ArrayList result = CollectionLiterals.newArrayList();
        NamedSerializationContextProvider names = new NamedSerializationContextProvider(this.grammar);
        String dir_context = this.directory("context");
        String dir_context_type = this.directory("context_type");
        String dir_syntactic_sequencer = this.directory("syntactic_sequencer");
        String dir_semantic_sequencer = this.directory("semantic_sequencer");
        List _namedContexts = names.getNamedContexts(this.contextPDAProvider.getContextPDAs(this.grammar));
        for (NamedSerializationContexts e : _namedContexts) {
            String string = e.getName();
            String string2 = dir_context + string;
            String _plus_1 = string2 + ".dot";
            String _drawSafe = this.drawSafe((GraphvizDotBuilder)this.pdaToDot, e.getValue());
            Pair _mappedTo = Pair.of((Object)_plus_1, (Object)_drawSafe);
            result.add(_mappedTo);
            String _name_1 = e.getName();
            String _plus_2 = dir_context + _name_1;
            String _plus_3 = _plus_2 + ".txt";
            String _join = IterableExtensions.join(e.getContexts(), (CharSequence)"\n");
            Pair _mappedTo_1 = Pair.of((Object)_plus_3, (Object)_join);
            result.add(_mappedTo_1);
        }
        List _namedContexts_1 = names.getNamedContexts(this.contextTypePDAProvider.getContextTypePDAs(this.grammar));
        for (NamedSerializationContexts namedSerializationContexts : _namedContexts_1) {
            String string = namedSerializationContexts.getName();
            String _plus = dir_context_type + string;
            String _plus_1 = _plus + ".dot";
            String _drawSafe = this.drawSafe((GraphvizDotBuilder)this.pdaToDot, namedSerializationContexts.getValue());
            Pair _mappedTo = Pair.of((Object)_plus_1, (Object)_drawSafe);
            result.add(_mappedTo);
            String _name_1 = namedSerializationContexts.getName();
            String _plus_2 = dir_context_type + _name_1;
            String _plus_3 = _plus_2 + ".txt";
            String _join = IterableExtensions.join(namedSerializationContexts.getContexts(), (CharSequence)"\n");
            Pair _mappedTo_1 = Pair.of((Object)_plus_3, (Object)_join);
            result.add(_mappedTo_1);
        }
        List list = names.getNamedContexts(this.syntacticSequencerPDAProvider.getSyntacticSequencerPDAs(this.grammar));
        for (NamedSerializationContexts namedSerializationContexts : list) {
            String _name = namedSerializationContexts.getName();
            String _plus = dir_syntactic_sequencer + (String)_name;
            String _plus_1 = _plus + ".dot";
            String _drawSafe = this.drawSafe(this.syntacticSequencerPDA2Dot, namedSerializationContexts.getValue());
            Pair _mappedTo = Pair.of((Object)_plus_1, (Object)_drawSafe);
            result.add(_mappedTo);
            String _name_1 = namedSerializationContexts.getName();
            String _plus_2 = dir_syntactic_sequencer + _name_1;
            String _plus_3 = _plus_2 + ".txt";
            String _join = IterableExtensions.join(namedSerializationContexts.getContexts(), (CharSequence)"\n");
            Pair _mappedTo_1 = Pair.of((Object)_plus_3, (Object)_join);
            result.add(_mappedTo_1);
        }
        List list2 = names.getNamedContexts(this.semanticSequencerNFAProvider.getSemanticSequencerNFAs(this.grammar));
        for (NamedSerializationContexts namedSerializationContexts : list2) {
            String _name = namedSerializationContexts.getName();
            String _plus = dir_semantic_sequencer + _name;
            String _plus_1 = _plus + ".dot";
            String _drawSafe = this.drawSafe((GraphvizDotBuilder)this.nfaToDot, namedSerializationContexts.getValue());
            Pair _mappedTo = Pair.of((Object)_plus_1, (Object)_drawSafe);
            result.add(_mappedTo);
            String _name_1 = namedSerializationContexts.getName();
            String _plus_2 = dir_semantic_sequencer + _name_1;
            String _plus_3 = _plus_2 + ".txt";
            String _join = IterableExtensions.join(namedSerializationContexts.getContexts(), (CharSequence)"\n");
            Pair _mappedTo_1 = Pair.of((Object)_plus_3, (Object)_join);
            result.add(_mappedTo_1);
        }
        try {
            boolean bl = false;
            HashMap trans2id = CollectionLiterals.newHashMap();
            Set<ISyntacticSequencerPDAProvider.ISynTransition> _allAmbiguousTransitions = this.syntacticSequencerUtil.getAllAmbiguousTransitions();
            for (ISyntacticSequencerPDAProvider.ISynTransition transition : _allAmbiguousTransitions) {
                void var11_25;
                String name = "ambiguity_" + String.valueOf((Object)((int)var11_25));
                String _directory = this.directory("syntactic_sequencer");
                String _plus = (String)_directory + name;
                String _plus_1 = _plus + ".dot";
                String _draw = this.nfaToDot.draw((Object)transition.getAmbiguousNfa());
                Pair _mappedTo = Pair.of((Object)_plus_1, (Object)_draw);
                result.add(_mappedTo);
                trans2id.put(transition, name);
                ++var11_25;
            }
            StringBuffer ambiguities = new StringBuffer();
            List<EqualAmbiguousTransitions> _allAmbiguousTransitionsBySyntax = this.syntacticSequencerUtil.getAllAmbiguousTransitionsBySyntax();
            for (EqualAmbiguousTransitions group : _allAmbiguousTransitionsBySyntax) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("id: ");
                String _identifier = group.getIdentifier();
                _builder.append(_identifier);
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("Ambiguous syntax:\u00bb:");
                _builder.newLine();
                _builder.append("        ");
                String _replace = group.getElementAlias().toString().replace("\n", "\n        ");
                _builder.append(_replace, "        ");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("This ambiguous syntax occurs at:");
                _builder.newLine();
                List<ISyntacticSequencerPDAProvider.ISynTransition> _transitions = group.getTransitions();
                for (ISyntacticSequencerPDAProvider.ISynTransition trans : _transitions) {
                    _builder.append("\t");
                    String _get = (String)trans2id.get(trans);
                    _builder.append(_get, "\t");
                    _builder.append(":");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("    ");
                    String _replace_1 = group.ambiguityInsideTransition(trans).replace("\n", "\n        ");
                    _builder.append(_replace_1, "\t    ");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t");
                _builder.newLine();
                _builder.newLine();
                ambiguities.append((CharSequence)_builder);
            }
            String _directory = this.directory("syntactic_sequencer");
            String _plus = _directory + "ambiguities.txt";
            String _string = ambiguities.toString();
            Pair _mappedTo = Pair.of((Object)_plus, (Object)_string);
            result.add(_mappedTo);
        }
        catch (Throwable throwable) {
            if (throwable instanceof Exception) {
                Exception e_4 = (Exception)throwable;
                e_4.printStackTrace();
            }
            throw Exceptions.sneakyThrow((Throwable)throwable);
        }
        return result;
    }

    private String drawSafe(GraphvizDotBuilder builder, Object graph) {
        String _xtrycatchfinallyexpression = null;
        try {
            _xtrycatchfinallyexpression = builder.draw(graph);
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                InputOutput.println((Object)"Error rendering");
                e.printStackTrace();
                return Throwables.getStackTraceAsString((Throwable)e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return _xtrycatchfinallyexpression;
    }

    private String directory(String name) {
        String _replace = this._xtextGeneratorNaming.getRuntimeBasePackage(this.grammar).replace(".", "/");
        String _plus = _replace + "/serializer/";
        String _lowerCase = GrammarUtil.getSimpleName((Grammar)this.grammar).toLowerCase();
        String _plus_1 = _plus + _lowerCase;
        String _plus_2 = _plus_1 + "_";
        String _plus_3 = _plus_2 + name;
        return _plus_3 + "/";
    }
}

