/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.fx;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SplitMenuButton;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolItem;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fx.ui.workbench.renderers.base.BaseMenuRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WMenu;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WMenuElement;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WToolItem;
import org.eclipse.fx.ui.workbench.renderers.fx.widget.ToolItemMenu;
import org.eclipse.fx.ui.workbench.renderers.fx.widget.WWidgetImpl;

public class DefToolItemMenuRenderer
extends BaseMenuRenderer<ToolItemMenu> {
    protected Class<? extends WMenu<ToolItemMenu>> getWidgetClass(MMenu item) {
        return WMenuImpl.class;
    }

    public static class WMenuImpl
    extends WWidgetImpl<ToolItemMenu, MMenu>
    implements WMenu<ToolItemMenu> {
        private ToggleGroup group;
        private SplitMenuButton button;
        Runnable showingCallback;
        Runnable hidingCallback;

        @Inject
        public WMenuImpl(@Named(value="fx.rendering.domElement") MMenu domElement) {
            MToolItem item = (MToolItem)((EObject)domElement).eContainer();
            WToolItem w = (WToolItem)item.getWidget();
            this.button = (SplitMenuButton)w.getWidget();
            this.button.showingProperty().addListener(this::handleShowingProperty);
        }

        void handleShowingProperty(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            if (newValue.booleanValue()) {
                if (this.showingCallback != null) {
                    this.showingCallback.run();
                }
            } else if (this.hidingCallback != null) {
                this.hidingCallback.run();
            }
        }

        public void addStyleClasses(List<String> classnames) {
            ((ToolItemMenu)this.getWidget()).getStyleClass().addAll(classnames);
        }

        public void addStyleClasses(String ... classnames) {
            ((ToolItemMenu)this.getWidget()).getStyleClass().addAll((Object[])classnames);
        }

        public void removeStyleClasses(List<String> classnames) {
            ((ToolItemMenu)this.getWidget()).getStyleClass().removeAll(classnames);
        }

        public void removeStyleClasses(String ... classnames) {
            ((ToolItemMenu)this.getWidget()).getStyleClass().removeAll((Object[])classnames);
        }

        public void setStyleId(String id) {
            ((ToolItemMenu)this.getWidget()).setId(id);
        }

        @Override
        protected ToolItemMenu createWidget() {
            return new ToolItemMenu(this.button);
        }

        @Override
        protected void setUserData(WWidgetImpl<ToolItemMenu, MMenu> widget) {
            ((ToolItemMenu)this.getWidget()).setUserData(widget);
        }

        @Inject
        public void setLabel(@Named(value="localizedLabel") String label) {
            ((ToolItemMenu)this.getWidget()).setText(label);
        }

        public void addElement(WMenuElement<MMenuElement> widget) {
            if (widget.getWidget() instanceof Toggle) {
                if (this.group == null) {
                    this.group = new ToggleGroup();
                }
                ((Toggle)widget.getWidget()).setToggleGroup(this.group);
            }
            ((ToolItemMenu)this.getWidget()).getItems().add((Object)((MenuItem)widget.getWidget()));
        }

        public void addElement(int idx, WMenuElement<MMenuElement> widget) {
            if (widget.getWidget() instanceof Toggle) {
                if (this.group == null) {
                    this.group = new ToggleGroup();
                }
                ((Toggle)widget.getWidget()).setToggleGroup(this.group);
            }
            ((ToolItemMenu)this.getWidget()).getItems().add(idx, (Object)((MenuItem)widget.getWidget()));
        }

        public void removeElement(WMenuElement<MMenuElement> widget) {
            ((ToolItemMenu)this.getWidget()).getItems().remove(widget.getWidget());
        }

        public void setShowingCallback(Runnable showingCallback) {
            this.showingCallback = showingCallback;
        }

        public void setHidingCallback(Runnable hidingCallback) {
            this.hidingCallback = hidingCallback;
        }
    }
}

