/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.dtree;

import org.eclipse.core.internal.dtree.AbstractDataTreeNode;
import org.eclipse.core.internal.dtree.DataTreeLookup;
import org.eclipse.core.internal.dtree.ObjectNotFoundException;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractDataTree {
    private volatile boolean immutable;
    protected static final IPath[] NO_CHILDREN = new IPath[0];
    private static final IPath[] ROOT_PATHS = new IPath[]{AbstractDataTree.rootKey()};

    public abstract AbstractDataTreeNode copyCompleteSubtree(IPath var1);

    public abstract void createChild(IPath var1, String var2);

    public abstract void createChild(IPath var1, String var2, Object var3);

    public abstract void createSubtree(IPath var1, AbstractDataTreeNode var2);

    public abstract void deleteChild(IPath var1, String var2);

    public IPath getChild(IPath parentKey, int index) {
        String child = this.getNameOfChild(parentKey, index);
        return parentKey.append(child);
    }

    abstract int getChildCount(IPath var1);

    abstract IPath[] getChildren(IPath var1);

    public abstract Object getData(IPath var1);

    abstract String getNameOfChild(IPath var1, int var2);

    public abstract String[] getNamesOfChildren(IPath var1);

    void handleImmutableTree() {
        String message = NLS.bind((String)Messages.dtree_immutable, (Object)(String.valueOf(this) + " #" + System.identityHashCode(this)));
        RuntimeException exception = new RuntimeException(message);
        if (Policy.DEBUG_TREE_IMMUTABLE) {
            Policy.debug(exception);
        }
        throw exception;
    }

    static void handleNotFound(IPath key) {
        throw new ObjectNotFoundException(NLS.bind((String)Messages.dtree_notFound, (Object)key));
    }

    public void immutable() {
        this.immutable = true;
        if (Policy.DEBUG_TREE_IMMUTABLE) {
            this.traceImmutable();
        }
    }

    private void traceImmutable() {
        String message = "immutable() called for " + String.valueOf(this) + " #" + System.identityHashCode(this);
        message = message + " (rule: " + String.valueOf(Job.getJobManager().currentRule()) + ")";
        if (Policy.DEBUG_TREE_IMMUTABLE_STACK) {
            Job currentJob = Job.getJobManager().currentJob();
            if (currentJob == null) {
                Policy.debug(new RuntimeException(message + " (not from a job)"));
            } else if (currentJob.getClass().getSimpleName().contains("AutoBuildJob")) {
                Policy.debug(message);
            } else {
                Policy.debug(new RuntimeException(message));
            }
        } else {
            Policy.debug(message);
        }
    }

    public abstract boolean includes(IPath var1);

    public boolean isImmutable() {
        return this.immutable;
    }

    public abstract DataTreeLookup lookup(IPath var1);

    public static final IPath rootKey() {
        return IPath.ROOT;
    }

    public boolean isRoot(IPath key) {
        return key == AbstractDataTree.rootKey();
    }

    public IPath[] rootPaths() {
        return ROOT_PATHS;
    }

    public abstract void setData(IPath var1, Object var2);

    void setRootNode(AbstractDataTreeNode node) {
        throw new Error(Messages.dtree_subclassImplement);
    }
}

