/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.fx;

import java.util.List;
import javafx.event.EventHandler;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Polygon;
import javafx.stage.WindowEvent;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.fx.ui.workbench.renderers.base.BasePartMenuRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WMenu;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WMenuElement;
import org.eclipse.fx.ui.workbench.renderers.fx.widget.WWidgetImpl;

public class DefPartMenuRenderer
extends BasePartMenuRenderer<Control> {
    private static final String CSS_CLASS_VIEW_MENU_BUTTON_ICON = "view-menu-button-icon";

    protected Class<? extends WMenu<Control>> getWidgetClass(MMenu element) {
        return MenuImpl.class;
    }

    public static class MenuImpl
    extends WWidgetImpl<Control, MMenu>
    implements WMenu<Control> {
        ContextMenu menu;
        private ToggleGroup group;
        Runnable showingCallback;
        Runnable hidingCallback;

        public void addStyleClasses(List<String> classnames) {
            ((Control)this.getWidget()).getStyleClass().addAll(classnames);
        }

        public void addStyleClasses(String ... classnames) {
            ((Control)this.getWidget()).getStyleClass().addAll((Object[])classnames);
        }

        public void removeStyleClasses(List<String> classnames) {
            ((Control)this.getWidget()).getStyleClass().removeAll(classnames);
        }

        public void removeStyleClasses(String ... classnames) {
            ((Control)this.getWidget()).getStyleClass().removeAll((Object[])classnames);
        }

        public void setStyleId(String id) {
            ((Control)this.getWidget()).setId(id);
        }

        @Override
        protected void setUserData(WWidgetImpl<Control, MMenu> widget) {
            ((Control)this.getWidget()).setUserData(widget);
        }

        public void addElement(WMenuElement<MMenuElement> widget) {
            if (widget.getWidget() instanceof Toggle) {
                if (this.group == null) {
                    this.group = new ToggleGroup();
                }
                ((Toggle)widget.getWidget()).setToggleGroup(this.group);
            }
            ((Control)this.getWidget()).getContextMenu().getItems().add((Object)((MenuItem)widget.getWidget()));
        }

        public void addElement(int idx, WMenuElement<MMenuElement> widget) {
            if (widget.getWidget() instanceof Toggle) {
                if (this.group == null) {
                    this.group = new ToggleGroup();
                }
                ((Toggle)widget.getWidget()).setToggleGroup(this.group);
            }
            ((Control)this.getWidget()).getContextMenu().getItems().add(idx, (Object)((MenuItem)widget.getWidget()));
        }

        public void setShowingCallback(Runnable showingCallback) {
            this.showingCallback = showingCallback;
        }

        public void removeElement(WMenuElement<MMenuElement> widget) {
            if (widget.getWidget() instanceof Toggle) {
                ((Toggle)widget.getWidget()).setToggleGroup(null);
            }
            ((Control)this.getWidget()).getContextMenu().getItems().remove(widget.getWidget());
        }

        @Override
        protected Control createWidget() {
            final Label b = new Label();
            Polygon p = new Polygon(new double[]{6.0, 1.0, 15.0, 1.0, 11.0, 5.0, 10.0, 5.0});
            p.getStyleClass().add((Object)DefPartMenuRenderer.CSS_CLASS_VIEW_MENU_BUTTON_ICON);
            p.setFill((Paint)Color.WHITE);
            p.setStroke((Paint)Color.BLACK);
            b.setGraphic((Node)p);
            b.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    menu.show((Node)b, Side.BOTTOM, 0.0, 0.0);
                }
            });
            this.menu = new ContextMenu();
            this.menu.setOnShowing((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent event) {
                    if (showingCallback != null) {
                        showingCallback.run();
                    }
                }
            });
            this.menu.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent arg0) {
                    if (hidingCallback != null) {
                        hidingCallback.run();
                    }
                }
            });
            b.setContextMenu(this.menu);
            return b;
        }

        public void setHidingCallback(Runnable hidingCallback) {
            this.hidingCallback = hidingCallback;
        }
    }
}

