/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.websocketmessage;

import com.sun.ts.tests.websocket.common.util.IOUtil;
import jakarta.websocket.OnError;
import jakarta.websocket.OnMessage;
import jakarta.websocket.Session;
import jakarta.websocket.server.ServerEndpoint;
import java.io.IOException;
import java.lang.reflect.Method;

@ServerEndpoint(value="/defaultmaxlen")
public class WSDefaultMaxLengthServer {
    private static final System.Logger logger = System.getLogger(WSDefaultMaxLengthServer.class.getName());

    @OnMessage
    public String echo(String echo) {
        try {
            Method m = this.getClass().getMethod("echo", String.class);
            OnMessage onm = m.getAnnotation(OnMessage.class);
            long size = onm.maxMessageSize();
            return String.valueOf(size);
        }
        catch (Exception e) {
            return IOUtil.printStackTrace((Throwable)e);
        }
    }

    @OnError
    public void onError(Session session, Throwable t) throws IOException {
        logger.log(System.Logger.Level.INFO, "@OnError in " + this.getClass().getName());
        t.printStackTrace();
        String message = IOUtil.printStackTrace((Throwable)t);
        session.getBasicRemote().sendText(message);
    }
}

