/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.server.serverendpointconfig;

import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.common.util.StringUtil;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.Extension;
import jakarta.websocket.OnError;
import jakarta.websocket.OnMessage;
import jakarta.websocket.OnOpen;
import jakarta.websocket.Session;
import jakarta.websocket.server.ServerEndpoint;
import jakarta.websocket.server.ServerEndpointConfig;
import java.io.IOException;

@ServerEndpoint(value="/annotated/subprotocols", subprotocols={"abc", "def"})
public class WSAnnotatedSubprotocolsServer {
    Session session;
    ServerEndpointConfig config;

    @OnMessage
    public void onMessage(String msg) {
        try {
            if (msg.equals("subprotocols")) {
                this.session.getBasicRemote().sendText(StringUtil.objectsToString((Object[])new Object[]{this.config.getSubprotocols()}));
            } else if (msg.equals("path")) {
                this.session.getBasicRemote().sendText(this.config.getPath());
            } else if (msg.equals("endpoint")) {
                this.session.getBasicRemote().sendText(this.config.getEndpointClass().getName());
            } else if (msg.equals("configurator")) {
                this.session.getBasicRemote().sendText(this.config.getConfigurator().getClass().getName());
            } else if (msg.equals("extensions")) {
                Extension[] ext;
                StringBuilder sb = new StringBuilder().append("[");
                for (Extension e : ext = this.config.getExtensions().toArray(new Extension[0])) {
                    sb.append(e.getName()).append(" ");
                }
                sb.append("]");
                this.session.getBasicRemote().sendText(sb.toString());
            } else {
                this.session.getBasicRemote().sendText(this.session.getNegotiatedSubprotocol());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            try {
                this.session.getBasicRemote().sendText(IOUtil.printStackTrace((Throwable)e));
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    @OnOpen
    public void onOpen(Session session, EndpointConfig config) {
        this.session = session;
        this.config = (ServerEndpointConfig)config;
    }

    @OnError
    public void onError(Session session, Throwable thr) throws IOException {
        thr.printStackTrace();
        String message = IOUtil.printStackTrace((Throwable)thr);
        session.getBasicRemote().sendText(message);
    }
}

