/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.spec.i18n;

import ee.jakarta.tck.pages.common.client.AbstractUrlClient;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class URLClientIT
extends AbstractUrlClient {
    public URLClientIT() throws Exception {
        this.setGeneralURI("/jsp/spec/i18n");
        this.setContextRoot("/jsp_config_encode_web");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        String packagePath = URLClientIT.class.getPackageName().replace(".", "/");
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jsp_i18n_web.war");
        archive.setWebXML(URLClientIT.class.getClassLoader().getResource(packagePath + "/jsp_i18n_web.xml"));
        archive.addAsWebInfResource(URLClientIT.class.getPackage(), "WEB-INF/tags/BadTagPageEncoding.tag", "tags/BadTagPageEncoding.tag");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/inclusion_utf-16LE.jspx")), "inclusion_utf-16LE.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/inclusion_iso.txt")), "inclusion_iso.txt");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/I18NXmlPrologNonMatchingPropertyGroupTest.jspx")), "I18NXmlPrologNonMatchingPropertyGroupTest.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/I18NXmlPrologNonMatchingDirectiveTest.jspx")), "I18NXmlPrologNonMatchingDirectiveTest.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/I18NUnsupportedEncodingTest.jspx")), "I18NUnsupportedEncodingTest.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/I18NUnsupportedEncodingTest.jsp")), "I18NUnsupportedEncodingTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/I18NPageEncTest.jsp")), "I18NPageEncTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/I18NPageEncContTypeTest.jsp")), "I18NPageEncContTypeTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/I18NNoPageEncNoContTypeTest.jsp")), "I18NNoPageEncNoContTypeTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/I18NIncludedContentTest.jspx")), "I18NIncludedContentTest.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/I18NIncludedContentTest.jsp")), "I18NIncludedContentTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/I18NContTypeTest.jsp")), "I18NContTypeTest.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/I18NBadTagPageEncoding.jsp")), "I18NBadTagPageEncoding.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/prolog/I18NPageEncTest.jspx")), "prolog/I18NPageEncTest.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/prolog/I18NPageEncContTypeTest.jspx")), "prolog/I18NPageEncContTypeTest.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/prolog/I18NNoPageEncNoContTypeTest.jspx")), "prolog/I18NNoPageEncNoContTypeTest.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/prolog/I18NContTypeTest.jspx")), "prolog/I18NContTypeTest.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/noprolog/I18NPageEncTest.jspx")), "noprolog/I18NPageEncTest.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/noprolog/I18NPageEncContTypeTest.jspx")), "noprolog/I18NPageEncContTypeTest.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/noprolog/I18NNoPageEncNoContTypeTest.jspx")), "noprolog/I18NNoPageEncNoContTypeTest.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/noprolog/I18NContTypeTest.jspx")), "noprolog/I18NContTypeTest.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/bom/UTF16PageEncodingAttribute.jsp")), "bom/UTF16PageEncodingAttribute.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/bom/UTF16LE.jsp")), "bom/UTF16LE.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/bom/UTF16ConfigElement.jsp")), "bom/UTF16ConfigElement.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/bom/UTF16BE.jsp")), "bom/UTF16BE.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/bom/UTF16BadPageEncodingAttribute.jsp")), "bom/UTF16BadPageEncodingAttribute.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/bom/UTF8ConfigElement.jsp")), "bom/UTF8ConfigElement.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/bom/UTF8.jsp")), "bom/UTF8.jsp");
        return archive;
    }

    @Test
    public void i18nStandardPageResponseEncodingTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_i18n_web/I18NNoPageEncNoContTypeTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("expected_headers", "Content-Type:text/html;charset=ISO-8859-1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        TEST_PROPS.setProperty("unexpected_response_match", "${testPassed}");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_i18n_web/I18NPageEncTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("expected_headers", "Content-Type:text/html;charset=ISO-8859-15");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        TEST_PROPS.setProperty("unexpected_response_match", "${testPassed}");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_i18n_web/I18NContTypeTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("expected_headers", "Content-Type:text/plain;charset=ISO-8859-15");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        TEST_PROPS.setProperty("unexpected_response_match", "${testPassed}");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_i18n_web/I18NPageEncContTypeTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("expected_headers", "Content-Type:text/plain;charset=ISO-8859-1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        TEST_PROPS.setProperty("unexpected_response_match", "${testPassed}");
        this.invoke();
    }

    @Test
    public void i18nXmlPageResponseEncodingTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_i18n_web/prolog/I18NNoPageEncNoContTypeTest.jspx HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        TEST_PROPS.setProperty("expected_headers", "Content-Type: text/xml; charset=UTF-8");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_i18n_web/prolog/I18NPageEncTest.jspx HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        TEST_PROPS.setProperty("expected_headers", "Content-Type: text/xml; charset=UTF-8");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_i18n_web/prolog/I18NContTypeTest.jspx HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        TEST_PROPS.setProperty("expected_headers", "Content-Type: text/plain; charset=ISO-8859-1");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_i18n_web/prolog/I18NPageEncContTypeTest.jspx HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        TEST_PROPS.setProperty("expected_headers", "Content-Type: text/plain; charset=ISO-8859-1");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_i18n_web/noprolog/I18NNoPageEncNoContTypeTest.jspx HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        TEST_PROPS.setProperty("expected_headers", "Content-Type: text/xml; charset=UTF-8");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_i18n_web/noprolog/I18NPageEncTest.jspx HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        TEST_PROPS.setProperty("expected_headers", "Content-Type: text/xml; charset=UTF-8");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_i18n_web/noprolog/I18NContTypeTest.jspx HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        TEST_PROPS.setProperty("expected_headers", "Content-Type: text/plain; charset=ISO-8859-1");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_i18n_web/noprolog/I18NPageEncContTypeTest.jspx HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Test PASSED");
        TEST_PROPS.setProperty("expected_headers", "Content-Type: text/plain; charset=ISO-8859-1");
        this.invoke();
    }

    @Test
    public void i18nEncodingMismatchTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_i18n_web/I18NXmlPrologNonMatchingDirectiveTest.jspx HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_i18n_web/I18NXmlPrologNonMatchingPropertyGroupTest.jspx HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void i18nUnsupportedEncodingTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_i18n_web/I18NUnsupportedEncodingTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_i18n_web/I18NUnsupportedEncodingTest.jspx HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void i18nIncludedContentTest() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_i18n_web/I18NIncludedContentTest.jsp HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Included Content|Test PASSED");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_i18n_web/I18NIncludedContentTest.jspx HTTP/1.1");
        TEST_PROPS.setProperty("search_string", "Included Content|Test PASSED");
        this.invoke();
    }

    @Test
    public void i18nBomByteSequencesUTF8Test() throws Exception {
        String searchStr = "this is a test";
        TEST_PROPS.setProperty("expected_headers", "Content-Type:text/html;charset=UTF-8");
        TEST_PROPS.setProperty("search_string", searchStr);
        TEST_PROPS.setProperty("request", "GET /jsp_i18n_web/bom/UTF8.jsp HTTP/1.1");
        this.invoke();
    }

    @Test
    public void i18nBomByteSequencesUTF16BETest() throws Exception {
        String searchStr = "this is a test";
        TEST_PROPS.setProperty("expected_headers", "Content-Type:text/html;charset=UTF-16BE");
        TEST_PROPS.setProperty("search_string", searchStr);
        TEST_PROPS.setProperty("request", "GET /jsp_i18n_web/bom/UTF16BE.jsp HTTP/1.1");
        this.invoke();
    }

    @Test
    public void i18nBomByteSequencesUTF16LETest() throws Exception {
        String searchStr = "this is a test";
        TEST_PROPS.setProperty("expected_headers", "Content-Type:text/html;charset=UTF-16LE");
        TEST_PROPS.setProperty("search_string", searchStr);
        TEST_PROPS.setProperty("request", "GET /jsp_i18n_web/bom/UTF16LE.jsp HTTP/1.1");
        this.invoke();
    }

    @Test
    public void i18nBomLegalCharacterEncodingTest1() throws Exception {
        String searchStr = "this is a test";
        TEST_PROPS.setProperty("expected_headers", "Content-Type:text/html;charset=UTF-16BE");
        TEST_PROPS.setProperty("search_string", searchStr);
        TEST_PROPS.setProperty("request", "GET /jsp_i18n_web/bom/UTF16ConfigElement.jsp HTTP/1.1");
        this.invoke();
    }

    @Test
    public void i18nBomLegalCharacterEncodingTest2() throws Exception {
        String searchStr = "this is a test";
        TEST_PROPS.setProperty("expected_headers", "Content-Type:text/html;charset=UTF-16LE");
        TEST_PROPS.setProperty("search_string", searchStr);
        TEST_PROPS.setProperty("request", "GET /jsp_i18n_web/bom/UTF16PageEncodingAttribute.jsp HTTP/1.1");
        this.invoke();
    }

    @Test
    public void i18nBomErrorReportingTest1() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_i18n_web/bom/UTF8ConfigElement.jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void i18nBomErrorReportingTest2() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_i18n_web/bom/UTF16BadPageEncodingAttribute.jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void i18nBomErrorReportingTest3() throws Exception {
        TEST_PROPS.setProperty("request", "GET /jsp_i18n_web/I18NBadTagPageEncoding.jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }
}

