/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.signaturetest.jsp;

import com.sun.ts.tests.signaturetest.SigTest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.junit.jupiter.api.Test;

public class JSPSigTestIT
extends SigTest {
    private static final System.Logger logger = System.getLogger(JSPSigTestIT.class.getName());

    public JSPSigTestIT() {
        this.setup();
    }

    protected String[] getPackages() {
        return new String[]{"jakarta.servlet.jsp", "jakarta.servlet.jsp.el", "jakarta.servlet.jsp.tagext"};
    }

    @Test
    public void signatureTest() throws Exception {
        logger.log(System.Logger.Level.INFO, "$$$ SigTestIT.signatureTest() called");
        String mapFile = null;
        String packageFile = null;
        Object repositoryDir = null;
        Properties mapFileAsProps = null;
        String[] packages = this.getPackages();
        String apiPackage = "jakarta.servlet.jsp";
        try {
            InputStream inStreamMapfile = JSPSigTestIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/pages/signaturetest/jsp/sig-test.map");
            File mFile = this.writeStreamToTempFile(inStreamMapfile, "sig-test", ".map");
            mapFile = mFile.getCanonicalPath();
            logger.log(System.Logger.Level.INFO, "mapFile location is :" + mapFile);
            InputStream inStreamPackageFile = JSPSigTestIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/pages/signaturetest/jsp/sig-test-pkg-list.txt");
            File pFile = this.writeStreamToTempFile(inStreamPackageFile, "sig-test-pkg-list", ".txt");
            packageFile = pFile.getCanonicalPath();
            logger.log(System.Logger.Level.INFO, "packageFile location is :" + packageFile);
            mapFileAsProps = this.getSigTestDriver().loadMapFile(mapFile);
            String packageVersion = mapFileAsProps.getProperty(apiPackage);
            logger.log(System.Logger.Level.INFO, "Package version from mapfile :" + packageVersion);
            InputStream inStreamSigFile = JSPSigTestIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/pages/signaturetest/jsp/jakarta.servlet.jsp.sig_" + packageVersion);
            File sigFile = this.writeStreamToSigFile(inStreamSigFile, apiPackage, packageVersion);
            logger.log(System.Logger.Level.INFO, "signature File location is :" + sigFile.getCanonicalPath());
        }
        catch (IOException ex) {
            logger.log(System.Logger.Level.ERROR, "Exception while creating temp files :" + ex);
        }
        super.signatureTest(mapFile, packageFile, mapFileAsProps, packages);
    }
}

