/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: WSBinaryDecoderAndSessionServer.java 70232 2013-02-25 18:41:32Z supol $
 */

package com.sun.ts.tests.websocket.ee.javax.websocket.websocketmessage;

import java.io.IOException;

import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;

import com.sun.ts.tests.websocket.common.stringbean.StringBean;
import com.sun.ts.tests.websocket.common.stringbean.StringBeanBinaryDecoder;
import com.sun.ts.tests.websocket.common.util.IOUtil;

@ServerEndpoint(value="/binarydecodersession", decoders={StringBeanBinaryDecoder.class})
public class WSBinaryDecoderAndSessionServer {

	@OnMessage
	public String echo(StringBean bean, Session session){
		return bean.get();
	}
	
    @OnError
    public void onError(Session session, Throwable t) throws IOException {
    	t.printStackTrace(); //Write to error log, too
    	String message = "Exception: " + IOUtil.printStackTrace(t);
    	session.getBasicRemote().sendText(message);
    }	
		
}
